////////////////////////////////////////////////////////////////
// If this code works, it was written by Alexander Nazarenko.
// If not, I don't know who wrote it.

#include "winmem.h"
#include "FARIntf.h"

struct PluginStartupInfo Info;
struct FarStandardFunctions FSF;
char PluginRootKey[80];

void InitDialogItems(InitDialogItem *Init, FarDialogItem *Item, int ItemsNumber)
{
  for (int I = 0 ; I < ItemsNumber ; I++ )
  {
    Item[I].Type = Init[I].Type;
    Item[I].X1 = Init[I].X1;
    Item[I].Y1 = Init[I].Y1;
    Item[I].X2 = Init[I].X2;
    Item[I].Selected = Init[I].Selected;
    Item[I].Flags = Init[I].Flags;
    Item[I].Focus = Item[I].DefaultButton = 0;
    if ( Init[I].Y2 == 255 )
    {
      Item[I].Y2 = *Item[I].Data = 0;
      Item[I].Flags = DIF_BOXCOLOR|DIF_SEPARATOR;
    }
    else
    {
      Item[I].Y2 = Init[I].Y2;
      if ( (unsigned int)Init[I].Data < 2000 )
        lstrcpy(Item[I].Data, GetMsg((unsigned int)Init[I].Data));
      else
        lstrcpy(Item[I].Data, Init[I].Data);
    }
  }
}

static void SaveDialogItems(FarDialogItem *Item, InitDialogItem *Init, int ItemsNumber)
{
  for (int I = 0 ; I < ItemsNumber ; I++ )
  {
    Init[I].Selected = Item[I].Selected;
    if ( (unsigned int)Init[I].Data >= 2000 && Init[I].Y2 != 255 )
      lstrcpy(Init[I].Data, Item[I].Data);
  }
}

int ExecDialogEx(InitDialogItem *Init, unsigned int size, int focus, int def, char *helpTopic, FARWINDOWPROC Proc, long Param)
{
  FarDialogItem *Item = new FarDialogItem[size];
  InitDialogItems(Init, Item, size);
  Item[focus].Focus = Item[def].DefaultButton = 1;
  int Result = Info.DialogEx(Info.ModuleNumber,-1,-1,Item[0].X2+4,Item[0].Y2+2,helpTopic,Item,size, 0, 0, Proc, Param);
  if ( Result == def )
    SaveDialogItems(Item, Init, size);
  delete [] Item;
  return Result;
}

HKEY CreateRegKey(HKEY hRoot,char *Key)
{
  HKEY hKey;
  DWORD Disposition;
  char FullKeyName[512];
  FSF.sprintf(FullKeyName,"%s%s%s",PluginRootKey,*Key ? "\\":"",Key);
  RegCreateKeyEx(hRoot,FullKeyName,0,NULL,0,KEY_WRITE,NULL,&hKey,&Disposition);
  return hKey;
}

HKEY OpenRegKey(HKEY hRoot,char *Key)
{
  HKEY hKey;
  char FullKeyName[512];
  FSF.sprintf(FullKeyName,"%s%s%s",PluginRootKey,(*Key && *PluginRootKey) ? "\\" : "",Key);
  if ( RegOpenKeyEx(hRoot,FullKeyName,0,KEY_QUERY_VALUE,&hKey) != ERROR_SUCCESS )
    return NULL;
  return hKey;
}

int GetRegKey(HKEY hRoot,char *Key,char *ValueName,int &ValueData,DWORD Default)
{
  HKEY hKey=OpenRegKey(hRoot,Key);
  DWORD Type,Size=sizeof(ValueData);
  int ExitCode=RegQueryValueEx(hKey,ValueName,0,&Type,(BYTE *)&ValueData,&Size);
  RegCloseKey(hKey);
  if ( hKey == NULL || ExitCode != ERROR_SUCCESS )
  {
    ValueData = Default;
    return false;
  }
  return true;
}

int GetRegKey(HKEY hRoot,char *Key,char *ValueName,DWORD Default)
{
  int ValueData;
  GetRegKey(hRoot,Key,ValueName,ValueData,Default);
  return ValueData;
}

int GetRegKey(HKEY hRoot,char *Key,char *ValueName,char *ValueData,char *Default,DWORD DataSize)
{
  HKEY hKey = OpenRegKey(hRoot,Key);
  DWORD Type;
  int ExitCode = RegQueryValueEx(hKey,ValueName,0,&Type,(BYTE*)ValueData,&DataSize);
  RegCloseKey(hKey);
  if ( hKey == NULL || ExitCode != ERROR_SUCCESS )
  {
    lstrcpy(ValueData,Default);
    return false;
  }
  return true;
}

void SetRegKey(HKEY hRoot,char *Key,char *ValueName,DWORD ValueData)
{
  HKEY hKey=CreateRegKey(hRoot,Key);
  RegSetValueEx(hKey,ValueName,0,REG_DWORD,(BYTE *)&ValueData,sizeof(ValueData));
  RegCloseKey(hKey);
}

void SetRegKey(HKEY hRoot,char *Key,char *ValueName,char *ValueData)
{
  HKEY hKey=CreateRegKey(hRoot,Key);
  RegSetValueEx(hKey,ValueName,0,REG_SZ,(BYTE*)ValueData,lstrlen(ValueData)+1);
  RegCloseKey(hKey);
}

void DeleteRegKey(HKEY hRoot,char *Key)
{
  char FullKeyName[512];
  FSF.sprintf(FullKeyName,"%s%s%s",PluginRootKey,*Key ? "\\":"",Key);
  RegDeleteKey(hRoot,FullKeyName);
}
