#include "FARIntf.h"
#include "FARLang.h"
#include "Config.h"
#include "winmem.h"

TOpt Opt;

char NotWordChars[256];

int Config(void)
{
  struct InitDialogItem InitItems[] =
  {
    {         DI_DOUBLEBOX,   3, 1,47, 18,0,0,              (char*)MPluginConfigString            },
    { /* 1*/  DI_CHECKBOX,    5, 2, 0,  0,0,0,              (char*)MConfigPluginEnabled           },
    {         DI_TEXT,        2, 3, 0,255,0,0,              NULL                                  },
    {         DI_TEXT,        5, 4, 0,  0,0,0,              (char*)MConfigDrugNDrop               },
    { /* 4*/  DI_RADIOBUTTON, 5, 5, 0,  0,0,DIF_GROUP,      (char*)MConfigDrugNDropCtrl           },
    { /* 5*/  DI_RADIOBUTTON, 5, 6, 0,  0,0,0,              (char*)MConfigDrugNDropRight          },
    {         DI_TEXT,        5, 7, 0,  0,0,0,              (char*)MConfigCopy                    },
    { /* 7*/  DI_RADIOBUTTON, 5, 8, 0,  0,0,DIF_GROUP,      (char*)MConfigCopyCtrl                },
    { /* 8*/  DI_RADIOBUTTON, 5, 9, 0,  0,0,0,              (char*)MConfigCopyAlways              },
    {         DI_TEXT,        5,10, 0,  0,0,0,              (char*)MConfigPaste                   },
    { /*10*/  DI_RADIOBUTTON, 5,11, 0,  0,0,DIF_GROUP,      (char*)MConfigPasteAltDoubleClick     },
    { /*11*/  DI_RADIOBUTTON, 5,12, 0,  0,0,0,              (char*)MConfigPasteAltRightClick      },
    {         DI_TEXT,        5,13, 0,  0,0,0,              (char*)MConfigKeepBlockAfter          },
    { /*13*/  DI_CHECKBOX,    5,14, 0,  0,0,0,              (char*)MConfigKeepBlockAfterPaste     },
    { /*14*/  DI_CHECKBOX,    5,15, 0,  0,0,0,              (char*)MConfigKeepBlockAfterDrugNDrop },
    {         DI_TEXT,        2,16, 0,255,0,0,              NULL                                  },
    { /*16*/  DI_BUTTON,      0,17, 0,  0,0,DIF_CENTERGROUP,(char*)MOK                            },
    {         DI_BUTTON,      0,17, 0,  0,0,DIF_CENTERGROUP,(char*)MCancel                        }
  };
  InitItems[1].Selected = Opt.PluginEnabled;
  InitItems[4+Opt.Method].Selected = InitItems[7+Opt.CopyMethod].Selected = InitItems[10+Opt.PasteMethod].Selected = 1;
  InitItems[13].Selected = Opt.KeepAfterPaste;
  InitItems[14].Selected = Opt.KeepAfterDrugNDrop;
  if ( 16 == ExecDialogEx(InitItems, sizeof(InitItems)/sizeof(InitItems[0]), 2, 16, "Configure", NULL, NULL) )
  {
    for ( int i = 0 ; i < 2 ; i++ )
    {
      if ( InitItems[4+i].Selected )
        Opt.Method = i;
      if ( InitItems[7+i].Selected )
        Opt.CopyMethod = i;
      if ( InitItems[10+i].Selected )
        Opt.PasteMethod = i;
    }
    Opt.PluginEnabled = InitItems[1].Selected;
    Opt.KeepAfterPaste = InitItems[13].Selected;
    Opt.KeepAfterDrugNDrop = InitItems[14].Selected;
    SetRegKey(HKEY_CURRENT_USER, "", "Method",            Opt.Method);
    SetRegKey(HKEY_CURRENT_USER, "", "CopyMethod",        Opt.CopyMethod);
    SetRegKey(HKEY_CURRENT_USER, "", "PasteMethod",       Opt.PasteMethod);
    SetRegKey(HKEY_CURRENT_USER, "", "PluginEnabled",     Opt.PluginEnabled);
    SetRegKey(HKEY_CURRENT_USER, "", "KeepAfterPaste",    Opt.KeepAfterPaste);
    SetRegKey(HKEY_CURRENT_USER, "", "KeepAfterDrugNDrop",Opt.KeepAfterDrugNDrop);
    return true;
  }
  return false;
}