#include "FARIntf.h"
#include "FARLang.h"
#include "Config.h"
#include "winmem.h"

#include "syslog.h"

DWORD TRIPLE_CLICK;

bool IsOldFar = true;
bool IsFarB4 = true;

#define VerticalBlock "FAR_VerticalBlock"

int CopyFormatToClipboard(char *Format, char *Data)
{
  int FormatType = RegisterClipboardFormat(Format);
  if ( FormatType == 0 )
    return false;
  long DataSize;
  if ( Data != NULL && ( DataSize = strlen(Data) ) != 0 )
  {
    HGLOBAL hData;
    void *GData;
    if ( !OpenClipboard(NULL) )
      return false;
    int BufferSize = DataSize+1;
    if ( ( hData = GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE, BufferSize) ) != NULL )
      if ( (GData = GlobalLock(hData) ) != NULL )
      {
        memcpy(GData, Data, BufferSize);
        GlobalUnlock(hData);
        SetClipboardData(FormatType, (HANDLE)hData);
      }
    CloseClipboard();
  }
  return true;
}

char* PasteFormatFromClipboard(char *Format)
{
  int FormatType = RegisterClipboardFormat(Format);
  if ( FormatType == 0 )
    return NULL;
  if ( !OpenClipboard(NULL) )
    return NULL;
  HANDLE hClipData;
  char *ClipText = NULL;
  if ( ( hClipData = GetClipboardData(FormatType) ) != NULL )
  {
    char *ClipAddr = (char*)GlobalLock(hClipData);
    int BufferSize = strlen(ClipAddr)+1;
    ClipText = new char[BufferSize];
    if ( ClipText != NULL )
      strcpy(ClipText, ClipAddr);
    GlobalUnlock(hClipData);
  }
  CloseClipboard();
  return ClipText;
}

void WINAPI _export GetPluginInfo(struct PluginInfo *Info)
{
  if ( !IsOldFar )
  {
    static char *PluginMenuStrings[1];
    static char *PluginCfgStrings[1];
    Info->StructSize = sizeof(*Info);
    Info->Flags = PF_EDITOR|PF_DISABLEPANELS;
    Info->DiskMenuStringsNumber = 0;
    PluginMenuStrings[0] = (char*)GetMsg(MPluginString);
    Info->PluginMenuStrings = PluginMenuStrings;
    Info->PluginMenuStringsNumber = 1;
    PluginCfgStrings[0] = (char*)GetMsg(MPluginConfigString);
    Info->PluginConfigStrings=PluginCfgStrings;
    Info->PluginConfigStringsNumber = 1;
    Info->CommandPrefix = NULL;
  }
}

static struct EditorSelect es;
static struct EditorInfo ei;
static struct EditorSetPosition esp;
static struct EditorGetString egs;
static struct EditorConvertText ect;

static DWORD LastClick = 0;

struct TSelectionBound
{
  EDITOR_BLOCK_TYPES bt;
  int X1, X2, Y1, Y2;
};

static void SelectLine(bool selectStream)
{
  Info.EditorControl(ECTL_GETINFO, &ei);
  if ( selectStream )
  {
    es.BlockType = BTYPE_STREAM;
    es.BlockStartPos = 0;
    es.BlockStartLine = ei.CurLine;
    es.BlockWidth = 0;
    es.BlockHeight = 2;
    Info.EditorControl(ECTL_SELECT, &es);
    esp.CurLine = ei.CurLine+1;
    esp.CurPos = 0;
    esp.CurTabPos = -1;
    esp.TopScreenLine = -1;
    esp.LeftPos = 0;
    esp.Overtype = -1;
    Info.EditorControl(ECTL_SETPOSITION, &esp);
  }
  else
  {
    es.BlockType = BTYPE_COLUMN;
    egs.StringNumber = -1;
    Info.EditorControl(ECTL_GETSTRING, &egs);
    esp.CurLine = ei.CurLine;
    esp.CurPos = egs.StringLength;
    esp.CurTabPos = -1;
    esp.TopScreenLine = -1;
    esp.LeftPos = -1;
    esp.Overtype = -1;
    Info.EditorControl(ECTL_SETPOSITION, &esp);
    Info.EditorControl(ECTL_GETINFO, &ei);
    es.BlockStartPos = 0;
    es.BlockStartLine = ei.CurLine;
    es.BlockWidth = ei.CurTabPos;
    es.BlockHeight = 1;
    Info.EditorControl(ECTL_SELECT, &es);
  }
  Info.EditorControl(ECTL_REDRAW, NULL);
  LastClick = 0;
}

static void ResizeString(char*& T, int& X, int delta, const char *s, bool addCRLF = false)
{
  if ( T )
  {
    if ( delta < 0 )
      delta = 0;
    if ( X >= 0 )
    {
      int newX = X+delta+(addCRLF ? 2 : 0);
      if ( newX >= 0 )
      {
        char *Save = T;
        T = new char[newX+1];
        if ( X )
          memcpy(T, Save, X);
        delete [] Save;
      }
      else
        newX = 0;
      if ( delta > 0 )
      {
        if ( s )
          memcpy(T+X, s, delta);
        else
          memset(T+X, ' ', delta);
      }
      if ( addCRLF )
      {
        T[newX-2] = '\r';
        T[newX-1] = '\n';
      }
      T[X = newX] = 0;
    }
  }
}

static void GetSelectionBounds(TSelectionBound& Cpy)
{
  Info.EditorControl(ECTL_GETINFO, &ei);
  int Y = ei.BlockStartLine;
  Cpy.bt = (EDITOR_BLOCK_TYPES)ei.BlockType;
  Cpy.X1 = Cpy.Y1 = Cpy.X2 = Cpy.Y2 = -1;
  if ( Cpy.bt == BTYPE_STREAM )
  {
    while ( Y < ei.TotalLines )
    {
      egs.StringNumber = Y++;
      Info.EditorControl(ECTL_GETSTRING, &egs);
      if ( egs.SelStart == -1 )
        break;
      if ( Cpy.X1 == -1 )
      {
        Cpy.X1 = egs.SelStart;
        Cpy.Y1 = egs.StringNumber;
      }
      if ( egs.SelEnd == -1 )
      {
        Cpy.X2 = 0;
        Cpy.Y2 = Y;
      }
      else
      {
        Cpy.X2 = egs.SelEnd;
        Cpy.Y2 = egs.StringNumber;
      }
    }
  }
  else if ( Cpy.bt == BTYPE_COLUMN )
  {
    while ( Y < ei.TotalLines )
    {
      egs.StringNumber = Y++;
      Info.EditorControl(ECTL_GETSTRING, &egs);
      if ( egs.SelStart == -1 )
        break;
      if ( Cpy.X1 == -1 )
      {
        Cpy.Y1 = egs.StringNumber;
        Cpy.X1 = egs.SelStart;
      }
      Cpy.Y2 = egs.StringNumber;
      Cpy.X2 = egs.SelEnd;
    }
  }
}

static char *GetSelection(int& Len, EDITOR_BLOCK_TYPES& bt)
{
  Info.EditorControl(ECTL_GETINFO, &ei);
  char *T = new char[1];
  if ( T )
  {
    int X = 0;
    int Y = ei.BlockStartLine;
    int delta;
    bt = (EDITOR_BLOCK_TYPES)ei.BlockType;
    if ( bt == BTYPE_STREAM )
    {
      while ( Y < ei.TotalLines )
      {
        egs.StringNumber = Y++;
        Info.EditorControl(ECTL_GETSTRING, &egs);
        if ( egs.SelStart < 0 )
          break;
        const char *addData = egs.StringText+egs.SelStart;
        if ( egs.SelEnd < 0 )
          delta = egs.StringLength-egs.SelStart;
        else
          delta = egs.SelEnd-egs.SelStart;
        if ( delta < 0 )
          delta = 0;
        ResizeString(T, X, delta, addData, true);
      }
    }
    else if ( bt == BTYPE_COLUMN )
    {
      while ( Y < ei.TotalLines )
      {
        egs.StringNumber = Y++;
        Info.EditorControl(ECTL_GETSTRING, &egs);
        if ( egs.SelStart < 0 )
          break;
        int OldX = X;
        delta = egs.SelEnd-egs.SelStart;
        if ( delta < 0 )
          delta = 0;
        ResizeString(T, X, delta, NULL, true);
        if ( egs.SelStart >= egs.StringLength || egs.SelEnd > egs.StringLength )
          delta = 0;
        if ( delta )
          memcpy(T+OldX, egs.StringText+egs.SelStart, delta);
      }
    }
    T[Len = X] = 0;
  }
  return T;
}

static void Copy2Buffer(void)
{
  int X = 0;
  EDITOR_BLOCK_TYPES bt;
  char *T = GetSelection(X, bt);
  if ( T )
  {
    ect.Text = T;
    ect.TextLength = X;
    Info.EditorControl(ECTL_EDITORTOOEM, &ect);
    if ( bt == BTYPE_STREAM )
      FSF.CopyToClipboard(T);
    else if ( bt == BTYPE_COLUMN )
      CopyFormatToClipboard(VerticalBlock, T);
    delete [] T;
  }
}

static void DeleteSelectionB4(void)
{
  struct EditorSetString ess;
  TSelectionBound Cpy;
  GetSelectionBounds(Cpy);
  if ( Cpy.bt == BTYPE_STREAM )
  {
    esp.CurLine = Cpy.Y1+1;
    esp.CurPos = -1;
    esp.CurTabPos = -1;
    esp.TopScreenLine = -1;
    esp.LeftPos = -1;
    esp.Overtype = -1;
    if ( Cpy.Y1 < Cpy.Y2 )
    {
      Info.EditorControl(ECTL_SETPOSITION, &esp);
      for ( int i = Cpy.Y1+1 ; i < Cpy.Y2 ; i++ )
        Info.EditorControl(ECTL_DELETESTRING, NULL);
      Cpy.Y2 = Cpy.Y1+1;
    }
    egs.StringNumber = Cpy.Y1;
    Info.EditorControl(ECTL_GETSTRING, &egs);
    char *T = new char[Cpy.X1];
    memcpy(T, egs.StringText, Cpy.X1);
    egs.StringNumber = Cpy.Y2;
    Info.EditorControl(ECTL_GETSTRING, &egs);
    int X = Cpy.X1;
    ResizeString(T, X, egs.StringLength-Cpy.X2, egs.StringText+egs.SelEnd);
    ess.StringNumber = Cpy.Y1;
    ess.StringText = T;
    ess.StringEOL = NULL;
    ess.StringLength = X;
    Info.EditorControl(ECTL_SETSTRING, &ess);
    delete [] T;
    if ( Cpy.Y1 < Cpy.Y2 )
    {
      Info.EditorControl(ECTL_GETINFO, &ei);
      int i = ei.TotalLines;
      Info.EditorControl(ECTL_DELETESTRING, NULL);
      Info.EditorControl(ECTL_GETINFO, &ei);
      if ( ei.TotalLines == i )
      {
        esp.CurLine = ei.CurLine-1;
        esp.CurPos = Cpy.X1;
        Info.EditorControl(ECTL_SETPOSITION, &esp);
        Info.EditorControl(ECTL_DELETECHAR, NULL);
      }
    }
    esp.CurLine = Cpy.Y1;
    esp.CurPos = Cpy.X1;
    Info.EditorControl(ECTL_SETPOSITION, &esp);
    es.BlockType = BTYPE_NONE;
    Info.EditorControl(ECTL_SELECT, &es);
    Info.EditorControl(ECTL_REDRAW, NULL);
  }
  else if ( Cpy.bt == BTYPE_COLUMN )
  {
    for ( int i = Cpy.Y1 ; i <= Cpy.Y2 ; i++ )
    {
      egs.StringNumber = i;
      Info.EditorControl(ECTL_GETSTRING, &egs);
      if ( egs.SelStart >= egs.StringLength )
        continue;
      if ( egs.SelEnd > egs.StringLength )
        egs.SelEnd = egs.StringLength;
      char *T = new char[egs.StringLength-egs.SelEnd+egs.SelStart];
      memcpy(T, egs.StringText, egs.SelStart);
      memcpy(T+egs.SelStart, egs.StringText+egs.SelEnd, egs.StringLength-egs.SelEnd);
      ess.StringNumber = i;
      ess.StringText = T;
      ess.StringEOL = NULL;
      ess.StringLength = egs.StringLength-egs.SelEnd+egs.SelStart;
      Info.EditorControl(ECTL_SETSTRING, &ess);
      delete [] T;
    }
    esp.CurLine = Cpy.Y1;
    esp.CurPos = Cpy.X1;
    esp.CurTabPos = -1;
    esp.TopScreenLine = -1;
    esp.LeftPos = -1;
    esp.Overtype = -1;
    Info.EditorControl(ECTL_SETPOSITION, &esp);
    es.BlockType = BTYPE_NONE;
    Info.EditorControl(ECTL_SELECT, &es);
    Info.EditorControl(ECTL_REDRAW, NULL);
  }
}

static inline void DeleteSelection(void)
{
  if ( IsFarB4 )
    DeleteSelectionB4();
  else
    Info.EditorControl(ECTL_DELETEBLOCK, NULL);
}

static inline void Cut2Buffer(void)
{
  Copy2Buffer();
  DeleteSelection();
}

static int insertColumnBlock(char *T)
{
  int l1 = 0, Y = ei.CurLine;
  esp.CurTabPos = ei.CurTabPos;
  esp.CurPos = -1;
  esp.TopScreenLine = -1;
  esp.LeftPos = -1;
  esp.Overtype = -1;
  while ( *T )
  {
    char *CRPos = strchr(T, '\r');
    if ( !CRPos )
      break;
    l1 = CRPos-T;
    char *Cur = T+l1+2;
    T[l1] = 0;
    Info.EditorControl(ECTL_INSERTTEXT, T);
    T = Cur;
    if ( ( esp.CurLine = ++Y ) >= ei.TotalLines )
      Info.EditorControl(ECTL_INSERTSTRING, NULL);
    Info.EditorControl(ECTL_SETPOSITION, &esp);
  }
  return l1;
}

static void insertStreamBlock(char *Buffer)
{
  int l = strlen(Buffer);
  char *T = new char[l+1];
  if ( T && l > 2 )
  {
    char *p = strcpy(T, Buffer);
    char *p1 = strchr(p, 0)-2;
    if ( !strcmp(p1, "\r\n") )
      *p1 = 0;
    while ( ( p1 = strstr(p, "\r\n") ) != NULL )
    {
      p = ++p1;
      strcpy(p, p+1);
    }
    Info.EditorControl(ECTL_INSERTTEXT, T);
    delete [] T;
  }
}

static void InsertBlock(bool insertStream, char *Buffer, int KeepBlock)
{
  Info.EditorControl(ECTL_GETINFO, &ei);
  int Sx = ei.CurPos, Sy = ei.CurLine;
  if ( insertStream )
  {
    insertStreamBlock(Buffer);
    if ( KeepBlock || ( ei.Options & EOPT_PERSISTENTBLOCKS ) )
    {
      Info.EditorControl(ECTL_GETINFO, &ei);
      es.BlockType = BTYPE_STREAM;
      es.BlockStartLine = Sy;
      es.BlockHeight = ei.CurLine+1-Sy;
      es.BlockStartPos = Sx;
      es.BlockWidth = ei.CurPos-Sx;
      Info.EditorControl(ECTL_SELECT, &es);
    }
  }
  else
  {
    int X = ei.CurTabPos;
    int l1 = insertColumnBlock(Buffer);
    if ( KeepBlock || ( ei.Options & EOPT_PERSISTENTBLOCKS ) )
    {
      Info.EditorControl(ECTL_GETINFO, &ei);
      es.BlockType = BTYPE_COLUMN;
      es.BlockStartLine = Sy;
      es.BlockHeight = ei.CurLine-Sy;
      es.BlockStartPos = X;
      es.BlockWidth = l1;
      Info.EditorControl(ECTL_SELECT, &es);
    }
    esp.CurLine = Sy;
    Info.EditorControl(ECTL_SETPOSITION, &esp);
  }
}

static void Paste4Buffer(void)
{
  char *Buffer = PasteFormatFromClipboard(VerticalBlock);
  if ( Buffer == NULL )
  {
    Buffer = FSF.PasteFromClipboard();
    if ( Buffer )
    {
      if ( *Buffer )
        InsertBlock(true, Buffer, Opt.KeepAfterPaste);
      FSF.DeleteBuffer(Buffer);
    }
  }
  else
  {
    if ( *Buffer )
      InsertBlock(false, Buffer, Opt.KeepAfterPaste);
    delete [] Buffer;
  }
  Info.EditorControl(ECTL_REDRAW, NULL);
}

static bool MoveMouse(MOUSE_EVENT_RECORD *MRec, EDITOR_BLOCK_TYPES bt, int Sx, int Sy)
{
  bool Result = false;
  Info.EditorControl(ECTL_GETINFO, &ei);
  if ( MRec->dwMousePosition.Y == 0 )
  {
    esp.CurLine = ei.TopScreenLine-1;
    esp.TopScreenLine = ei.TopScreenLine-1;
  }
  else if ( MRec->dwMousePosition.Y > ei.WindowSizeY )
  {
    esp.CurLine = ei.TopScreenLine+ei.WindowSizeY;
    esp.TopScreenLine = ei.TopScreenLine+1;
  }
  else
  {
    esp.CurLine = MRec->dwMousePosition.Y+ei.TopScreenLine-1;
    esp.TopScreenLine = -1;
    Result = true;
  }
  if ( MRec->dwMousePosition.X == 0 )
    esp.LeftPos = ei.LeftPos-1;
  else if ( MRec->dwMousePosition.X == ei.WindowSizeX-1 )
    esp.LeftPos = ei.LeftPos+1;
  else
    esp.LeftPos = -1;
  esp.CurPos = -1;
  esp.CurTabPos = MRec->dwMousePosition.X+ei.LeftPos;
  if ( esp.CurTabPos < 0 )
    esp.CurTabPos = 0;
  esp.Overtype = -1;
  Info.EditorControl(ECTL_SETPOSITION, &esp);
  Info.EditorControl(ECTL_GETINFO, &ei);
  int X = ( bt == BTYPE_STREAM ) ? ei.CurPos : ei.CurTabPos;
  int Y = ei.CurLine;
  if ( ( Y >= ei.TotalLines) && ( bt == BTYPE_STREAM ) )
    Result = true;
  es.BlockType = bt;
  if ( Y > Sy )
  {
    es.BlockStartLine = Sy;
    es.BlockHeight = Y+1-Sy;
    if ( ( bt == BTYPE_STREAM ) || ( X > Sx ) )
    {
      es.BlockStartPos = Sx;
      es.BlockWidth = X-Sx;
    }
    else
    {
      es.BlockStartPos = X;
      es.BlockWidth = Sx-X;
    }
  }
  else if ( Y < Sy )
  {
    es.BlockStartLine = Y;
    es.BlockHeight = Sy+1-Y;
    if ( ( bt == BTYPE_STREAM ) || ( Sx > X ) )
    {
      es.BlockStartPos = X;
      es.BlockWidth = Sx-X;
    }
    else
    {
      es.BlockStartPos = Sx;
      es.BlockWidth = X-Sx;
    }
  }
  else
  {
    es.BlockStartLine = Y;
    es.BlockHeight = 1;
    if ( X > Sx )
    {
      es.BlockStartPos = Sx;
      es.BlockWidth = X-Sx;
    }
    else if ( X < Sx )
    {
      es.BlockStartPos = X;
      es.BlockWidth = Sx-X;
    }
    else
      es.BlockType = BTYPE_NONE;
  }
  if ( ( bt == BTYPE_COLUMN ) && ( X == Sx ) )
    es.BlockType = BTYPE_NONE;
  Info.EditorControl(ECTL_REDRAW, NULL);
  Info.EditorControl(ECTL_SELECT, &es);
  Info.EditorControl(ECTL_REDRAW, NULL);
  return Result;
}

static void SelectWord(bool markStream)
{
  egs.StringNumber = -1;
  Info.EditorControl(ECTL_GETSTRING, &egs);
  char *T = new char[egs.StringLength+1];
  if ( T )
  {
    memcpy(T, egs.StringText, egs.StringLength);
    T[egs.StringLength] = 0;
    ect.Text = T;
    ect.TextLength = egs.StringLength;
    Info.EditorControl(ECTL_EDITORTOOEM, &ect);
    int X, Y = ei.CurPos;
    if ( Y > egs.StringLength-1 )
      Y = egs.StringLength-1;
    while ( (Y >= 0) && strchr(NotWordChars, T[Y]) )
      Y--;
    if ( Y < 0 )
    {
      X = ei.CurPos+1;
      if ( X > egs.StringLength )
        X = egs.StringLength;
      while ( ( X < egs.StringLength) && strchr(NotWordChars, T[X]) )
        X++;
      if ( X == egs.StringLength )
      {
        X = 0;
        Y = egs.StringLength;
      }
      else
      {
        Y = X+1;
        while ( ( Y < egs.StringLength ) && !strchr(NotWordChars, T[Y]) )
          Y++;
      }
    }
    else
    {
      X = Y-1;
      while ( (X >= 0) && !strchr(NotWordChars, T[X]) )
        X--;
      X++;
      if ( Y == ei.CurPos )
        while ( ( Y < egs.StringLength) && !strchr(NotWordChars, T[Y]) )
          Y++;
      else
        Y++;
    }
    delete [] T;
    if ( markStream )
    {
      es.BlockType = BTYPE_STREAM;
      es.BlockStartPos = X;
    }
    else
    {
      es.BlockType = BTYPE_COLUMN;
      es.BlockStartPos = ei.CurTabPos-ei.CurPos+X;
    }
    es.BlockStartLine = ei.CurLine;
    es.BlockWidth = Y-X;
    es.BlockHeight = 1;
    Info.EditorControl(ECTL_SELECT, &es);
    esp.CurLine = -1;
    esp.CurPos = Y;
    esp.CurTabPos = -1;
    esp.TopScreenLine = -1;
    esp.LeftPos = -1;
    esp.Overtype = -1;
    Info.EditorControl(ECTL_SETPOSITION, &esp);
  }
}

static bool ClickInBlock(int X, int Y)
{
  TSelectionBound Cpy;
  GetSelectionBounds(Cpy);
  if ( Cpy.bt == BTYPE_STREAM )
  {
    if ( ( Y > Cpy.Y1 ) && ( Y < Cpy.Y2 ) )
      return true;
    if ( ( Y == Cpy.Y1 ) && ( Y == Cpy.Y2  ) )
      return ( X >= Cpy.X1 ) && ( X <= Cpy.X2 );
    if ( Y == Cpy.Y1 )
      return X >= Cpy.X1;
    if ( Y == Cpy.Y1 )
      return X <= Cpy.X2;
  }
  else if ( Cpy.bt == BTYPE_COLUMN )
    return ( X >= Cpy.X1 ) && ( X <= Cpy.X2 ) && ( Y >= Cpy.Y1 ) && ( Y <= Cpy.Y2 );
  return false;
}

static int saved = 0;
static struct EditorSelect ES2Save;

static void SaveSelection(EditorSelect& SavedES)
{
  Info.EditorControl(ECTL_GETINFO, &ei);
  int Y = ei.BlockStartLine;
  SavedES.BlockType = ei.BlockType;
  SavedES.BlockStartLine = SavedES.BlockHeight = SavedES.BlockStartPos = SavedES.BlockWidth = -1;
  if ( SavedES.BlockType != BTYPE_NONE )
  {
    while ( Y < ei.TotalLines )
    {
      egs.StringNumber = Y++;
      Info.EditorControl(ECTL_GETSTRING, &egs);
      if ( egs.SelStart == -1 )
        break;
      if ( SavedES.BlockStartLine == -1 )
      {
        SavedES.BlockStartPos = egs.SelStart;
        SavedES.BlockStartLine = egs.StringNumber;
      }
      if ( egs.SelEnd != -1 )
      {
        SavedES.BlockHeight = egs.StringNumber+1-SavedES.BlockStartLine;
        SavedES.BlockWidth = egs.SelEnd-SavedES.BlockStartPos;
      }
    }
  }
  saved = 1;
}

static void RestoreSelection(EditorSelect& SavedES)
{
  if ( saved )
    Info.EditorControl(ECTL_SELECT, &SavedES);
}

int WINAPI _export ProcessEditorInput(const INPUT_RECORD *Rec)
{
  bool Result = false;
  if ( Opt.PluginEnabled && Rec->EventType == MOUSE_EVENT )
  {
    enum ButtonState { MBS_NONE, MBS_LEFT, MBS_RIGHT };
    static EDITOR_BLOCK_TYPES bt = BTYPE_NONE;
    static bool WinSel = false, InBlock = false, dnd = false;
    static int Sx = -1, Sy = -1;

    static EditorSelect es4dnd;

    MOUSE_EVENT_RECORD *MRec = (MOUSE_EVENT_RECORD*)(&Rec->Event.MouseEvent);
    bool CtrlPressed  = ( MRec->dwControlKeyState & (RIGHT_CTRL_PRESSED|LEFT_CTRL_PRESSED) ) != 0;
    bool ShiftPressed = ( MRec->dwControlKeyState & SHIFT_PRESSED ) != 0;
    bool AltPressed   = ( MRec->dwControlKeyState & (RIGHT_ALT_PRESSED|LEFT_ALT_PRESSED) ) != 0;
    static ButtonState oldState = MBS_NONE;
    ButtonState curState = MBS_NONE;
    if ( MRec->dwButtonState )
      curState = ( MRec->dwButtonState == FROM_LEFT_1ST_BUTTON_PRESSED ) ? MBS_LEFT : MBS_RIGHT;
    if ( MRec->dwEventFlags == MOUSE_MOVED )
    {
      bt = ( curState == MBS_LEFT ) ? BTYPE_STREAM : BTYPE_COLUMN;
      if ( ( curState != MBS_NONE ) && ( oldState != MBS_NONE ) )
      {
        if ( !InBlock )
          Result = MoveMouse(MRec, bt, Sx, Sy);
      }
      else
        oldState = MBS_NONE;
    }
    else if ( MRec->dwEventFlags == DOUBLE_CLICK )
    {
      if ( GetTickCount()-LastClick <= TRIPLE_CLICK )
      {
        SelectLine(curState == MBS_LEFT);
        Result = true;
      }
      else if ( Opt.PasteMethod == 0 && AltPressed )
      {
        Paste4Buffer();
        Result = true;
      }
      else
      {
        Info.EditorControl(ECTL_GETINFO, &ei);
        if ( ( ei.CurLine == MRec->dwMousePosition.Y+ei.TopScreenLine-1 ) && ( ei.CurTabPos == MRec->dwMousePosition.X+ei.LeftPos ) )
        {
          SelectWord(curState == MBS_LEFT);
          Info.EditorControl(ECTL_REDRAW, NULL);
          LastClick = GetTickCount();
          Result = true;
        }
      }
    }
    else if ( curState != MBS_NONE )
    {
      if ( GetTickCount()-LastClick <= TRIPLE_CLICK )
      {
        SelectLine(curState == MBS_LEFT);
        Result = true;
      }
      else
      {
        Info.EditorControl(ECTL_GETINFO, &ei);
        if ( ( MRec->dwMousePosition.Y > 0 ) && ( MRec->dwMousePosition.Y <= ei.WindowSizeY) )
        {
          oldState = curState;
          bt = ( curState == MBS_LEFT ) ? BTYPE_STREAM : BTYPE_COLUMN;
          if ( ShiftPressed )
          {
            Info.EditorControl(ECTL_GETINFO, &ei);
            Sx = ( curState == MBS_LEFT ) ? ei.CurPos : ei.CurTabPos;
            Sy = ei.CurLine;
            WinSel = true;
            Result = MoveMouse(MRec, bt, Sx, Sy);
          }
          else
          {
            WinSel = false;
            esp.CurLine = MRec->dwMousePosition.Y+ei.TopScreenLine-1;
            esp.CurPos = -1;
            esp.CurTabPos = MRec->dwMousePosition.X+ei.LeftPos;
            esp.TopScreenLine = -1;
            esp.LeftPos = -1;
            esp.Overtype = -1;
            Info.EditorControl(ECTL_SETPOSITION, &esp);
            Info.EditorControl(ECTL_GETINFO, &ei);
            Sx = ( curState == MBS_LEFT ) ? ei.CurPos : ei.CurTabPos;
            Sy = ei.CurLine;
            if ( ClickInBlock(Sx, Sy) )
            {
              InBlock = true;
              if ( ( ei.Options & EOPT_PERSISTENTBLOCKS ) == 0 )
              {
                SaveSelection(es4dnd);
                dnd = true;
              }
            }
            else if ( ( ei.Options & EOPT_PERSISTENTBLOCKS ) == 0 )
            {
              es.BlockType = BTYPE_NONE;
              Info.EditorControl(ECTL_SELECT, &es);
            }
            Info.EditorControl(ECTL_REDRAW, NULL);
            Result = true;
          }
        }
      }
    }
    else if ( curState == MBS_NONE )
    {
      Info.EditorControl(ECTL_GETINFO, &ei);
      if ( AltPressed && Opt.PasteMethod == 1 && oldState == MBS_RIGHT )
      {
        Paste4Buffer();
        Result = true;
      }
      else if ( ( ei.BlockType != BTYPE_NONE ) || ( dnd && ( ei.Options & EOPT_PERSISTENTBLOCKS ) == 0 ) )
      {
        if ( InBlock )
        {
          int Cx = ( ei.BlockType == BTYPE_STREAM ) ? ei.CurPos : ei.CurTabPos;
          int Cy = ei.CurLine;
          if ( !ClickInBlock(Cx, Cy) )
          {
            int X = 0;
            EDITOR_BLOCK_TYPES bt;
            if ( ( ei.Options & EOPT_PERSISTENTBLOCKS ) == 0 )
            {
              RestoreSelection(es4dnd);
              dnd = false;
            }
            char *T = GetSelection(X, bt);
            if ( T )
            {
              if ( *T )
              {
                if ( ( Opt.Method == 0 && !CtrlPressed ) || ( Opt.Method == 1 && oldState == MBS_LEFT ) )
                {
                  struct EditorSetPosition esp2;
                  TSelectionBound Cpy;
                  GetSelectionBounds(Cpy);
                  if ( Cpy.bt == BTYPE_STREAM )
                  {
                    if ( Cy >= Cpy.Y2 )
                    {
                      Cy -= (Cpy.Y2-Cpy.Y1);
                      if ( ( Cy == Cpy.Y2 ) && ( Cx > Cpy.X2 ) )
                        Cx -= (Cpy.X2-Cpy.X1);
                    }
                  }
                  else
                  {
                    if ( ( Cy >= Cpy.Y1 ) && ( Cy <= Cpy.Y2 ) && ( Cx > Cpy.X2 ) )
                      Cx -= (Cpy.X2-Cpy.X1);
                  }
                  esp2.CurLine = Cy;
                  esp2.CurPos = esp2.CurTabPos = -1;
                  ( ( bt == BTYPE_STREAM ) ? esp2.CurPos : esp2.CurTabPos ) = Cx;
                  esp2.TopScreenLine = -1;
                  esp2.LeftPos = -1;
                  esp2.Overtype = -1;
                  DeleteSelection();
                  Info.EditorControl(ECTL_REDRAW, NULL);
                  Info.EditorControl(ECTL_SETPOSITION, &esp2);
                  Info.EditorControl(ECTL_REDRAW, NULL);
                }
                ect.Text = T;
                ect.TextLength = strlen(T);
                Info.EditorControl(ECTL_EDITORTOOEM, &ect);
                InsertBlock(bt == BTYPE_STREAM, T, Opt.KeepAfterDrugNDrop);
                Info.EditorControl(ECTL_REDRAW, NULL);
              }
              delete [] T;
              Result = true;
            }
          }
          InBlock = false;
        }
        else if ( ShiftPressed )
        {
          if ( !WinSel )
          {
            Cut2Buffer();
            Result = true;
          }
        }
        else if ( Opt.CopyMethod == 1 || CtrlPressed )
        {
          Copy2Buffer();
          Result = true;
        }
      }
      oldState = MBS_NONE;
    }
  }
  return Result;
}

HANDLE WINAPI _export OpenPlugin(int, int)
{
  if ( !IsOldFar )
  {
    char top[80];
    struct FarMenuItem MainMenu[12];
    struct TSelectionBound Cpy;
    int i, count = sizeof(MainMenu)/sizeof(*MainMenu);
    for ( i = 0 ; i < count ; i++ )
      MainMenu[i].Selected = MainMenu[i].Checked = MainMenu[i].Separator = false;
    strcpy(top,GetMsg(MPluginString));
    strcpy(MainMenu[0].Text, GetMsg(MMenuSave));
    strcpy(MainMenu[1].Text, GetMsg(MMenuRestore));
    strcpy(MainMenu[2].Text, GetMsg(MMenuToggle));
    strcpy(MainMenu[3].Text, "");
    MainMenu[3].Separator = true;
    strcpy(MainMenu[4].Text, GetMsg(MMenuGoStart));
    strcpy(MainMenu[5].Text, GetMsg(MMenuGoEnd));
    strcpy(MainMenu[6].Text, "");
    MainMenu[6].Separator = true;
    strcpy(MainMenu[7].Text, GetMsg(MMenuCut));
    strcpy(MainMenu[8].Text, GetMsg(MMenuCopy));
    strcpy(MainMenu[9].Text, GetMsg(MMenuPaste));
    strcpy(MainMenu[10].Text, "");
    MainMenu[10].Separator = true;
    strcpy(MainMenu[11].Text, GetMsg(MMenuConfig));
    switch ( Info.Menu(Info.ModuleNumber,-1,-1,0,FMENU_WRAPMODE,top,NULL,NULL,NULL,NULL,MainMenu,count) )
    {
      case 0:
        SaveSelection(ES2Save);
        break;
      case 1:
        RestoreSelection(ES2Save);
        break;
      case 2:
        SaveSelection(ES2Save);
        switch ( ES2Save.BlockType )
        {
          case BTYPE_STREAM: ES2Save.BlockType = BTYPE_COLUMN; break;
          case BTYPE_COLUMN: ES2Save.BlockType = BTYPE_STREAM; break;
        }
        RestoreSelection(ES2Save);
        break;
      case 4:
        GetSelectionBounds(Cpy);
        esp.CurLine = Cpy.Y1;
        esp.CurPos = Cpy.X1;
        esp.CurTabPos = esp.TopScreenLine = esp.LeftPos = esp.Overtype = -1;
        Info.EditorControl(ECTL_SETPOSITION, &esp);
        Info.EditorControl(ECTL_REDRAW, NULL);
        break;
      case 5:
        GetSelectionBounds(Cpy);
        esp.CurLine = Cpy.Y2;
        esp.CurPos = Cpy.X2;
        esp.CurTabPos = esp.TopScreenLine = esp.LeftPos = esp.Overtype = -1;
        Info.EditorControl(ECTL_SETPOSITION, &esp);
        Info.EditorControl(ECTL_REDRAW, NULL);
        break;
      case 7:
        Cut2Buffer();
        break;
      case 8:
        Copy2Buffer();
        break;
      case 9:
        Paste4Buffer();
        break;
      case 11:
        Config();
        break;
    }
  }
  return INVALID_HANDLE_VALUE;
}

int WINAPI _export Configure(int)
{
  return Config();
}

int WINAPI _export GetMinFarVersion(void)
{
  /*return FARMANAGERVERSION;*/
  return MAKEFARVERSION(1,70,1282);
}

void WINAPI _export SetStartupInfo(const PluginStartupInfo *Info)
{
  ::Info = *Info;
  IsOldFar = true;
  if ( Info->StructSize >= sizeof(PluginStartupInfo) )
  {
    ::FSF = *Info->FSF;
    ::Info.FSF = &::FSF;
    IsOldFar = false;
    *PluginRootKey = 0;
    TRIPLE_CLICK = GetRegKey(HKEY_CURRENT_USER, "Control Panel\\Mouse", "DoubleClickSpeed", 500);
    if ( TRIPLE_CLICK <= 0 || TRIPLE_CLICK > 5000 )
      TRIPLE_CLICK = 500;
    GetRegKey(HKEY_CURRENT_USER, "Software\\Far\\Editor", "WordDiv", NotWordChars, "!%^&*()+|{}:\"<>?`-=\\[];',./", 255);
    strcat(NotWordChars, " \t");
    wsprintf(PluginRootKey,"%s\\MouseSelect", Info->RootKey);
    GetRegKey(HKEY_CURRENT_USER, "", "PluginEnabled",     Opt.PluginEnabled,      1);
    GetRegKey(HKEY_CURRENT_USER, "", "Method",            Opt.Method,             0);
    GetRegKey(HKEY_CURRENT_USER, "", "CopyMethod",        Opt.CopyMethod,         0);
    GetRegKey(HKEY_CURRENT_USER, "", "PasteMethod",       Opt.PasteMethod,        0);
    GetRegKey(HKEY_CURRENT_USER, "", "KeepAfterPaste",    Opt.KeepAfterPaste,     0);
    GetRegKey(HKEY_CURRENT_USER, "", "KeepAfterDrugNDrop",Opt.KeepAfterDrugNDrop, 0);
    DWORD ver = 0;
    ::Info.AdvControl(::Info.ModuleNumber, ACTL_GETFARVERSION, (void*)&ver);
    if ( ver >= MAKEFARVERSION(1,70,1581)  )
      IsFarB4 = false;
  }
}
