struct InitDialogItem {
  unsigned char Type;
  unsigned char X1,Y1,X2,Y2;
  unsigned char Focus;
  char *History;
  unsigned int Flags;
  unsigned char DefaultButton;
  char *Data;
};

static struct PluginStartupInfo Info;
BOOL IsOldFar;
BOOL IsInterrupted;

#define GetMsg(MsgId) (Info.GetMsg(Info.ModuleNumber,MsgId))

//------------------------------------------------------------------------------

void InitDialogItems(const struct InitDialogItem *Init,struct FarDialogItem *Item,
                    int ItemsNumber) {
  for (int I=0;I<ItemsNumber;I++,Item++,Init++) {
    Item->Type = Init->Type;
    Item->X1 = Init->X1;
    Item->Y1 = Init->Y1;
    Item->X2 = Init->X2;
    Item->Y2 = Init->Y2;
    Item->Focus = Init->Focus;
    Item->Param.History = Init->History;
    Item->Flags = Init->Flags;
    Item->DefaultButton = Init->DefaultButton;
    strcpy(Item->Data.Data,((unsigned int)Init->Data<2000)?
           GetMsg((unsigned int)Init->Data):Init->Data);
  }
}

//------------------------------------------------------------------------------

BOOL CheckForKey(const WORD vKey) // (c) V. Moshninov
{
  INPUT_RECORD *InputRec;
  DWORD NumberOfEvents, ReadCnt;
  BOOL result = FALSE;
  const HANDLE Console = GetStdHandle(STD_INPUT_HANDLE);

  if(GetNumberOfConsoleInputEvents(Console,&NumberOfEvents)) {
    if((InputRec=(INPUT_RECORD *)GlobalAlloc(GPTR,
                             NumberOfEvents*sizeof(INPUT_RECORD))) != NULL) {
      if(PeekConsoleInput(Console,InputRec,NumberOfEvents,&ReadCnt))
        if(ReadCnt <= NumberOfEvents)
          for(DWORD i=0; i < NumberOfEvents; ++i) {
            if (InputRec[i].EventType == KEY_EVENT &&
                InputRec[i].Event.KeyEvent.bKeyDown &&
                InputRec[i].Event.KeyEvent.wVirtualKeyCode == vKey) {
              result = TRUE;
              if(i > 0)
                ReadConsoleInput(Console,InputRec,i,&ReadCnt);
              break;
            }
          }
      GlobalFree((HGLOBAL)InputRec);
    }
  }
  return result;
}

//------------------------------------------------------------------------------

enum
{
  MMD5Plugin,

  MUseFile,

  MVerify,
  MGenerate,
  MOk,
  MCancel,

  MError,

  MMD5Progress,

  MGenerating,
  MVerifying,

  MNoMismatches,

};

#define MD5PlugHistory  "MD5plug"
#define MSG_GENERATED   "; Generated by MD5plug (c) Wesha, 2003\n"

static char *PluginPrefix = "md5";

void DisplayError(const char * const filename) {
  const char *MsgItems[]={GetMsg(MError), filename, GetMsg(MOk)};
  Info.Message(Info.ModuleNumber,FMSG_ERRORTYPE|FMSG_WARNING,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
}

void GetString(FILE * const fp, char *buf,int bufsize) {
  while (--bufsize && !feof(fp) && ((*buf = fgetc(fp)) != '\n' )) buf++; 
  *buf = '\0';
  while (!bufsize && !feof(fp) && (fgetc(fp) != '\n' ));
}
