#undef _UNICODE

#include <windows.h>
#include <stdio.h>

#define _FAR_NO_NAMELESS_UNIONS
#define _FAR_USE_FARFINDDATA
#include "plugin.hpp"
#include "farkeys.hpp"
#include "MD5plug.hpp"
#include "md5.h"

//------------------------------------------------------------------------------

int CalculateMD5(const char * const path, char * const buf, const int buflen) {
  md5_t md5_temp;
  char md5_sig_raw[MD5_SIZE];
  char md5_data_buf[2048];
  FILE *fp;
	
  if((fp = fopen(path,"rb")) == NULL) {
    DisplayError(path);
    return(-1);
    }

  md5_init(&md5_temp);

  while (!feof(fp)) {
    if(IsInterrupted = CheckForKey(KEY_ESC)) {
      break;
      }

  int numread = fread(md5_data_buf, sizeof(char), sizeof(md5_data_buf), fp);
    
    if (ferror(fp)) {
      DisplayError(path);
      fclose(fp);
      return(-1);
      }

  if (numread) {
    md5_process(&md5_temp, md5_data_buf, numread);
	}
  }

  fclose(fp);
  md5_finish(&md5_temp,md5_sig_raw);
  md5_sig_to_string(md5_sig_raw,buf,buflen);

  return(0);
}

//------------------------------------------------------------------------------

void ProcessOneFile(struct PanelInfo * const PInfo, int I, FILE * const sigfile, HANDLE hScreen) {
  char md5_sig_text[MD5_SIZE * 2 + 1];

  if (((PInfo->PanelItems[I].FindData.dwFileAttributes) & FILE_ATTRIBUTE_DIRECTORY) == 0) {
    HANDLE hScreen = Info.SaveScreen(0,0,-1,-1);
    const char *MsgItems[] = {GetMsg(MMD5Progress),GetMsg(MGenerating),PInfo->PanelItems[I].FindData.cFileName};
    Info.Message(Info.ModuleNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),0);

    if (CalculateMD5(PInfo->PanelItems[I].FindData.cFileName,md5_sig_text,sizeof(md5_sig_text)) == 0) {
      if(!IsInterrupted) {
        fprintf(sigfile,"%s *%s\n",md5_sig_text,PInfo->PanelItems[I].FindData.cFileName);
        }
      } // CalculateMD5
    Info.RestoreScreen(hScreen);
    } // process file
}

//------------------------------------------------------------------------------

void GenerateMD5File(const char * const sigfilepath) {
  FILE *sigfile;

  struct PanelInfo PInfo;
  Info.Control(INVALID_HANDLE_VALUE,FCTL_GETPANELINFO,&PInfo);

  HANDLE hScreen = Info.SaveScreen(0,0,-1,-1);

  if ((sigfile = fopen(sigfilepath,"w")) != NULL) {
    fprintf(sigfile,MSG_GENERATED);
    int NumSelected = 0;

    for (int I=0;I < PInfo.ItemsNumber; I++) {
      if (PInfo.PanelItems[I].Flags & PPIF_SELECTED) {
        NumSelected++;
        if (IsInterrupted) break;
        ProcessOneFile(&PInfo,I,sigfile,hScreen);
        PInfo.PanelItems[I].Flags &= ~PPIF_SELECTED;
        } // PPIF_SELECTED
      } // loop

    if ((NumSelected==0) && !IsInterrupted) { // No selection, proccess the file under cursor
      if (strcmp(PInfo.PanelItems[PInfo.CurrentItem].FindData.cFileName,"..")) { 
        ProcessOneFile(&PInfo,PInfo.CurrentItem,sigfile,hScreen);
        }
      else { // ".." is selected, process everything on the panel
        for (int I=0;I < PInfo.ItemsNumber; I++) {
          if (IsInterrupted) break;
          ProcessOneFile(&PInfo,I,sigfile,hScreen);
          } // loop
        } // ".."
      } // no selection

    fclose(sigfile);

    Info.Control(INVALID_HANDLE_VALUE,FCTL_SETSELECTION,&PInfo);
    }
  else {
    DisplayError(sigfilepath);
    } // fopen

  Info.Control(INVALID_HANDLE_VALUE,FCTL_UPDATEPANEL,&PInfo);
  Info.Control(INVALID_HANDLE_VALUE,FCTL_REDRAWPANEL,NULL);
}

//------------------------------------------------------------------------------

bool ParseLine(const char * const buf, const char **ptr_path, const char **ptr_md5) {
  char *path = strchr(buf,'*');
  
  // Try Windows scheme
  if (path) {
    *path++ = '\0';
	*ptr_path = path;
	*ptr_md5 = buf;
	return(true);
	}

  // Try UNIX scheme
  if(!strncmp(buf,"MD5 (",5)) {
	*ptr_path = buf + 5;
	
	path = strrchr(buf,')');
	if (!path) return(false);
	if(strncmp(path,") = ",4)) return(false);

	*path = '\0';
	*ptr_md5 = path + 4;

	return(true);
	}

  return false;

}

//------------------------------------------------------------------------------

void VerifyMD5File(const char * const sigfilepath) {
  FILE *sigfile;
  char md5_sig_text[2*MD5_SIZE+1];
  char buf[sizeof(md5_sig_text) + 2 + MAX_PATH + 1];
  BOOL NoMismatches = true;

  if ((sigfile = fopen(sigfilepath,"r")) != NULL) {

  	struct PanelInfo PInfo;
    Info.Control(INVALID_HANDLE_VALUE,FCTL_UPDATEPANEL,NULL); // Reset selection
    Info.Control(INVALID_HANDLE_VALUE,FCTL_GETPANELINFO,&PInfo);

    while(!feof(sigfile)) {
      GetString(sigfile,buf,sizeof(buf));
      if (ferror(sigfile)) {
        DisplayError(sigfilepath);
        fclose(sigfile);
        return;
        }

      if (!*buf || (*buf == ';') || (*buf == '#')) continue; // skip comments

	  const char *path, *md5;
		
      if (!ParseLine(buf, &path, &md5)) continue ;

      HANDLE hScreen = Info.SaveScreen(0,0,-1,-1);
      const char *MsgItems[] = {GetMsg(MMD5Progress),GetMsg(MVerifying),path};
      Info.Message(Info.ModuleNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),0);

      if (CalculateMD5(path,md5_sig_text,sizeof(md5_sig_text)) == 0) {
        if(strncmp(md5_sig_text,md5,sizeof(md5_sig_text)-1)) { // digest doesn't match
          for (int I=0;I < PInfo.ItemsNumber; I++) { // find that item on the panel
            if (!strncmp(path,PInfo.PanelItems[I].FindData.cFileName,sizeof(PInfo.PanelItems[I].FindData.cFileName))) {
              PInfo.PanelItems[I].Flags |= PPIF_SELECTED;
              NoMismatches = false;
              break;
              } // strncmp
            } // loop
          } // strncmp
        } // CalculateMD5

      Info.RestoreScreen(hScreen);
      if(IsInterrupted) break;
      } // loop

    fclose(sigfile);

    Info.Control(INVALID_HANDLE_VALUE,FCTL_SETSELECTION,&PInfo);
    Info.Control(INVALID_HANDLE_VALUE,FCTL_REDRAWPANEL,NULL);

    if (!IsInterrupted && NoMismatches) {
      const char * const MsgItems[] = {GetMsg(MMD5Plugin),GetMsg(MNoMismatches)};
      Info.Message(Info.ModuleNumber,FMSG_MB_OK,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),0);
      }
    }
  else {
    DisplayError(sigfilepath);
    } // fopen
  return;
}

//------------------------------------------------------------------------------

void WINAPI _export SetStartupInfo(const struct PluginStartupInfo *PInfo) {
  Info = *PInfo;
  IsOldFar = (PInfo->StructSize < sizeof(struct PluginStartupInfo));
}

//------------------------------------------------------------------------------

void WINAPI _export GetPluginInfo(struct PluginInfo *PInfo) {
  if(IsOldFar) return;

  PInfo->StructSize=sizeof(*PInfo);
  static char *PluginMenuStrings[1];
  PluginMenuStrings[0]=(char*)GetMsg(MMD5Plugin);
  PInfo->PluginMenuStrings=PluginMenuStrings;
  PInfo->PluginMenuStringsNumber=sizeof(PluginMenuStrings)/sizeof(PluginMenuStrings[0]);
  PInfo->CommandPrefix = PluginPrefix;
}

//------------------------------------------------------------------------------

HANDLE WINAPI _export OpenPlugin(int OpenFrom,int Item) {

  if(IsOldFar) return(INVALID_HANDLE_VALUE);

  IsInterrupted = false;

  if (OpenFrom == OPEN_COMMANDLINE) {
    VerifyMD5File((char*)Item);

    return(INVALID_HANDLE_VALUE);
    }
  
  struct InitDialogItem InitItems[] = {
    /* 00 */DI_DOUBLEBOX,3,1 ,62,6 ,0,NULL,0,0,(char *)MMD5Plugin,
    /* 01 */DI_TEXT     ,5,2 ,0 ,0 ,0,NULL,DIF_GROUP,0,(char*)MUseFile,
    /* 02 */DI_EDIT     ,5,3 ,60,0 ,0,MD5PlugHistory,DIF_HISTORY|DIF_USELASTHISTORY,0,"sigfile.md5",
    /* 03 */DI_TEXT     ,5,4 ,0 ,0 ,0,NULL,DIF_BOXCOLOR|DIF_SEPARATOR,0,"",
    /* 04 */DI_BUTTON   ,0,5 ,0 ,0 ,0,NULL,DIF_CENTERGROUP,1,(char *)MVerify,
    /* 05 */DI_BUTTON   ,0,5 ,0 ,0 ,0,NULL,DIF_CENTERGROUP,0,(char *)MGenerate,
    /* 06 */DI_BUTTON   ,0,5 ,0 ,0 ,0,NULL,DIF_CENTERGROUP,0,(char *)MCancel
    };
  const int NumItems = sizeof(InitItems)/sizeof(InitItems[0]);
  static struct FarDialogItem DialogItems[NumItems];
  InitDialogItems(InitItems,DialogItems,NumItems);

  int ExitCode = Info.Dialog(Info.ModuleNumber,-1,-1,66,8,
				              "Contents",DialogItems,NumItems);
  switch(ExitCode) {
    case 4:
            VerifyMD5File(DialogItems[2].Data.Data);
            break; 
    case 5:
            GenerateMD5File(DialogItems[2].Data.Data);
            break;
    }
  return(INVALID_HANDLE_VALUE);
}
