#include "db_use.h"

extern FARSTANDARDFUNCTIONS FSF;
extern HANDLE LookHeap;

void * operator new(size_t size)
{
return HeapAlloc(LookHeap,HEAP_ZERO_MEMORY, size);
}
void operator delete(void *block)
{
if(block)HeapFree(LookHeap,0,block);
}
void *operator new[](size_t size) {return ::operator new(size);}
void *operator new(size_t size, void *p) {return p;}
void operator delete[](void *ptr) {::operator delete(ptr);}

void _pure_error_ () {};

BYTE Upper(BYTE c)
{       
if(c<97)return c;
if(c<123)return c-32;
if(c<224)return c;
return c-32;
}

char *Upper(char *text)
{
BYTE *a=(BYTE *)text;
while(*a){ *a=Upper(*a); a++; }
return text;
}

//---------    ---------------

Link *Link::Head(void)
{
Link *c=this;
if(c)while(c->prev)c=c->prev;
return c;
}

Link *Link::Tail(void)
{
Link *c=this;
if(c)while(c->next)c=c->next;
return c;
}

Link *Link::Find(int num)
{
Link *c=(Link *)Head();
while(c && num) { num--; c=c->next; }
return c;
}

void Link::After(Link *m)
{
if(!m)return;
Link *c=next;
next=m;
m->prev=this;
m->next=c;
if(c)c->prev=m;
}

void Link::Before(Link *m)
{
if(!m)return;
Link *c=prev;
prev=m;
m->prev=c;
m->next=this;
if(c)c->next=m;
}

Link *Link::Add(Link *m)
{
if(this) { Link *c=Tail(); c->After(m); }
else m->prev=NULL;
m->next=NULL;
return m;
}

void Link::Extract(void)
{
if(prev)prev->next=next;
if(next)next->prev=prev;
}

Link *Link::Step(char &dir)
{
Link *after;
if(dir=='n'||dir=='N') {
  if(next) after=next;
  else { dir=0; after=this; }
  }
else {
  if(prev) after=prev;
  else { dir=0; after=this; }
  }
return after;
}

Link *Link::Destroy(char &dir)
{
Link *after;
if(dir=='n'||dir=='N') {
  if(next) after=next;
  else { dir=0; after=prev; }
  }
else {
  if(prev) after=prev;
  else { dir=0; after=next; }
  }
if(prev)prev->next=next;
if(next)next->prev=prev;
delete this;
return after;
}

Link *Link::DestroyAll(void)
{
Link *c;
char flag='N';
c=Head();
while(flag)c=c->Destroy(flag);
return NULL;
}

//==================   ==================

__int64 a_i64(char *s,__int64 def, char dec)
{
__int64 rez=0;
int z,sign=1;
char *c, first=1,dot=0;
if(dec<0) dec=0;
for(c=s;*c;c++) {
  if(first) {
    if(*c==' ') continue;
    first=0; if(*c=='+') continue;
    if(*c=='-') { sign=-1; continue; }
    if(*c=='.') { dot=1; continue; }
    }
  if(*c=='.') {
    if(dot) break;
    dot=1; continue;
    }
  z=*c-'0';  if(z<0 ||z>9) break;
  if(dot) {
    if(!dec)return rez*sign;
    --dec;
    }
  rez=rez*10+z;
  }
if(first) return def;
for(z=0;z<dec;z++)rez*=10;
return rez*sign;
}

char *i64_a(char *s, __int64 val, char mins, char dec)
{
int i;
char f[12]="%Ld",t[40],sign=0,fil=' ';

if(val<0) { sign='-'; val=-val; }
if(dec>0) {
__int64 a,b=1;
  for(i=0; i<dec; i++)b*=10;
  a=val/b; b=val%b;
  FSF.sprintf(f+3,".%c0%dLd",'%',dec);
  FSF.sprintf(t,f,a,b);
  }
else FSF.sprintf(t,f,val);
if(mins<0) { fil='0'; mins=-mins; }
s[0]=s[1]=0; i=lstrlen(t);
if(i>=mins) { s[0]=sign; lstrcat(s,t); return s; }
mins-=i; i=0; if(sign && fil=='0') { s[0]=sign; i=1; }
for(;i<mins;i++) s[i]=fil;
if(sign && fil==' ') s[mins-1]=sign;
s[mins]=0; lstrcat(s,t); return s;
}

__int64 ah_i64(char *s,__int64 def)
{
long z;
char *c;
__int64 rez=0;
for(c=s;*c;c++) {
  if(*c<'0') return def;
  z=*c-'0';  if(z<10) goto STORE;
  if(*c<'A') return def;
  z=*c-'A'+10;  if(z<16) goto STORE;
  if(*c<'a') return def;
  z=*c-'a'+10;  if(z>15) return def;
STORE:
  rez<<=4; rez|=z;
  }
return rez;
}

//==================      ==================

char DatePoint='/';
BYTE Mon[12]={31,28,31,30,31,30,31,31,30,31,30,31};

BYTE BadDate(BYTE day, BYTE month, WORD year)
{
if(!month||month>12)return 1;
Mon[1]=(year%4)? 28 : 29;
if(!day||day>Mon[month-1])return 1;
return 0;
}

BYTE UnpackDate(__int32 d, BYTE &day, BYTE &month, WORD &year)
{
WORD da;
__int32 l=d; l<<=2;
year=l/1461;
da=d-365u*year-year/4;
if(da)year++; else da=366;
Mon[1]=(year%4)? 28 : 29;
for(month=0; da>Mon[month]; da-=Mon[month++]);
month++;
day=da;
return BadDate(day,month,year);
}

char *DateDigit(__int32 d, char *buf)
{
BYTE day,month;
WORD year;
for(day=0;day<10;day++)buf[day]=' ';
buf[2]=buf[5]=DatePoint; buf[10]=0;
if(!d)return buf;
if(UnpackDate(d,day,month,year))return buf;
buf[0]=day/10+'0';
buf[1]=day%10+'0';
buf[3]=month/10+'0';
buf[4]=month%10+'0';
buf[6]=year/1000+'0';
buf[7]=(year%1000)/100+'0';
buf[8]=(year%100)/10+'0';
buf[9]=year%10+'0';
return buf;
}

__int32 Date4(char *s)
{
if(!(*s))return 0;
while(*s==' ')s++;
if(NotNum(*s))return 0;
int i=0; while(s[i])i++;
if(i!=10) return 0;
BYTE d,m; WORD y;
d=*s-'0'; ++s; if(NotNum(*s))return 0;
d=(*s-'0')+d*10;
s+=2; if(NotNum(*s))return 0;
m=*s-'0'; ++s; if(NotNum(*s))return 0;
m=(*s-'0')+m*10; ++s; y=0;
for(i=0;i<4;i++) {
  ++s; if(NotNum(*s))return 0;
  y=(*s-'0')+y*10;
  }
if(BadDate(d,m,y)) return 0;
__int32 sum; --m; --y;
sum=y*365+y/4+d;
for(i=0; i<m; i++)sum+=Mon[i];
return sum;
}

//==================  ==================

bool NotNum(char c)
{
if(c<'0' || c>'9') return true;
return false;
}

BYTE MyWrite(HANDLE h, BYTE *buf, DWORD len)
{
DWORD nbr;
if(!len)len=lstrlen(buf);
if(!WriteFile(h,buf,len,&nbr,NULL) || nbr<len) return 1;
return 0;
}

//---------      DBF ---------------

void dbBase::SaveHeader(void)
{
if(f==INVALID_HANDLE_VALUE) return;
DWORD nbr;
if(upd) {
  SetFilePointer(f,0,NULL,FILE_BEGIN);
  if(!WriteFile(f,&dbH,32,&nbr,NULL)) return;
  if(nbr<32) return;
  if(upd&0xfe) {
    dbField *d;
    for(d=dbF; d; d=(dbField*)(d->Next())) {
      if(d->type=='#') continue;
      if(!WriteFile(f,d->name,32,&nbr,NULL)) return;
      if(nbr<32) return;
      }
    if(!WriteFile(f,"\x0d",1,&nbr,NULL)) return;
    }
  }
upd=0;
}
//-----------------------------------

void dbBase::Close(void)
{
if(f!=INVALID_HANDLE_VALUE) { SaveHeader(); CloseHandle(f); }
if(m!=INVALID_HANDLE_VALUE) CloseHandle(m);
f=m=INVALID_HANDLE_VALUE;
if(dbF)dbF->DestroyAll();
if(rec)delete rec;
ZeroMemory(this,sizeof(dbBase));
}
//-----------------------------------

void dbBase::OpenMemo(char *file)
{
if(m!=INVALID_HANDLE_VALUE) return;
switch(dbH.type) {
  case 0x83: // ---> dBaseIII memo
    tmem=0; break;
  case 0x8b: // ---> dBaseIV memo
    tmem=1; break;
  case 0xf5: case 0x30: // ---> FoxPro memo
    tmem=2; break;
  default: return;  // ---> No memo or unknown
  }
BYTE b[512];
WORD n,r;
DWORD nbr;
for(n=r=0; file[n]; n++) {
  b[n]=file[n]; if(file[n]=='.')r=n+1;
  if(file[n]=='\\')r=0;
  }
if(!r) { b[n]='.'; r=n+1; }
if(tmem==2) { b[r++]='F'; b[r++]='P'; }
else        { b[r++]='D'; b[r++]='B'; }
b[r++]='T'; b[r]=0;
m=CreateFile(b,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,
  OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL|FILE_FLAG_RANDOM_ACCESS,NULL);
if(m==INVALID_HANDLE_VALUE) return;
if(!ReadFile(m,b,512,&nbr,NULL) || nbr<512) {
  CloseHandle(m); m=INVALID_HANDLE_VALUE;
  return;
  }
switch(tmem) {
  case 0: // --------------------------------> dBaseIII memo
    lmem=512; break;
  case 1: // --------------------------------> dBaseIV memo
    lmem=b[21]; lmem<<=8; lmem|=b[20]; break;
  case 2: // --------------------------------> FoxPro memo
    lmem=b[6]; lmem<<=8; lmem|=b[7]; break;
  default: // -------------------------------> No memo or unknown
    CloseHandle(m); m=INVALID_HANDLE_VALUE;
  }
}
//-----------------------------------

BYTE dbBase::Open(char *file, BYTE ronly)
{
WORD k,n,rl;
BYTE ret;
DWORD nbr;
ret=0;
if(f!=INVALID_HANDLE_VALUE) return ret;
if(!ronly) {
  f=CreateFile(file,GENERIC_READ|GENERIC_WRITE,FILE_SHARE_READ,NULL,
    OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL|FILE_FLAG_RANDOM_ACCESS,NULL);
  if(f==INVALID_HANDLE_VALUE) ronly=1;
  }
if(ronly)  {
  f=CreateFile(file,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,
    OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL|FILE_FLAG_RANDOM_ACCESS,NULL);
  if(f==INVALID_HANDLE_VALUE) return 1;
  ret=0x10;
  }
if(!ReadFile(f,&dbH,32,&nbr,NULL) || nbr<32) return 2;
if(dbH.reclen==0||dbH.start<64||dbH.nrec<0) return 2;
dbField *d, *h;
rl=1; h=NULL;
for(nfil=0;;) {
  if((nfil+1)*32+33 > dbH.start) break;
  d=new dbField;
  ZeroMemory(d,sizeof(dbField));
  if(!ReadFile(f,d->name,32,&nbr,NULL)) {
    DB_ERROR:
    delete d; nfil=0; return 2;
    }
  if(d->name[0]==0x0d) { delete d; break; }
  if(nbr<32) goto DB_ERROR;
  rl+=d->filen;
  h=(dbField*)(h->Add(d));
  nfil++;
  }
if(rl > dbH.reclen) return 2;
k=0;
while(rl < dbH.reclen) {
  n=dbH.reclen-rl; if(n>255)n=255;
  d=new dbField; ZeroMemory(d,sizeof(dbField));
  FSF.sprintf(d->name,"#%d#",++k);
  d->type='#'; d->filen=n;
  rl+=d->filen;
  h=(dbField*)(h->Add(d));
  nfil++;
  }
dbF=(dbField*)(h->Head());
rec=new char[rl+2];
if(!rec) return 4;
OpenMemo(file);
pos=dbH.start;
if(!dbH.nrec) return ret;
if(SetFilePointer(f,pos,NULL,FILE_BEGIN)==0xFFFFFFFF) return 2;
if(!ReadFile(f,rec,dbH.reclen,&nbr,NULL) || nbr<dbH.reclen) return 2;
pos+=dbH.reclen;
cur=1;
return ret;
}
//-----------------------------------

BYTE dbBase::Create(char *file, BYTE t)
{
WORD n;
dbField *d;
DWORD nbr;
if(f!=INVALID_HANDLE_VALUE) return 1;
dbH.nrec=0;
dbH.type=t;
dbH.start=33;
dbH.reclen=1;
dbH.ind=0;
for(d=dbF; d; d=(dbField*)(d->Next())) {
  dbH.reclen+=d->filen;
  dbH.start+=32;
  }
if(dbH.reclen==1)return 3;
rec=new char[dbH.reclen+2]; if(!rec) return 4;

f=CreateFile(file,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,
             FILE_ATTRIBUTE_NORMAL|FILE_FLAG_RANDOM_ACCESS,NULL);
if(f==INVALID_HANDLE_VALUE) return 2;
if(!WriteFile(f,&dbH,32,&nbr,NULL) || nbr<32) goto BAD_WRITE;
for(d=dbF; d; d=(dbField*)(d->Next()))
  if(!WriteFile(f,d->name,32,&nbr,NULL) || nbr<32) goto BAD_WRITE;
if(!WriteFile(f,"\x0d",1,&nbr,NULL) || nbr<1) goto BAD_WRITE;
rec[0]=' ';//Clear();
cur=0;
pos=dbH.start;
return 0;

BAD_WRITE:
CloseHandle(f);
f=INVALID_HANDLE_VALUE;
return 2;
}
//-----------------------------------

void dbBase::Add(char *fname, char ftype, BYTE flen, BYTE fdec)
{
dbField *d;
d=new dbField;
ZeroMemory(d,sizeof(dbField));
lstrcpy(d->name,fname);
d->type=ftype;
d->filen=flen;
d->dec=fdec;
if(dbF) (dbF->Tail())->After(d);
else dbF=d;
nfil++;
}
//-----------------------------------

BYTE dbBase::Read(DWORD rn)
{
DWORD nbr;
if(rn>dbH.nrec)return 1;
if(cur==rn)return 0;
pos=dbH.start+(rn-1)*dbH.reclen;
if(SetFilePointer(f,pos,NULL,FILE_BEGIN)==0xFFFFFFFF) return 2;
if(!ReadFile(f,rec,dbH.reclen,&nbr,NULL) || nbr<dbH.reclen) return 2;
cur=rn;
pos+=dbH.reclen;
return 0;
}
//-----------------------------------

BYTE dbBase::GetMemo(char *file, DWORD *blocknum)
{
DWORD nb,nbr;
WORD i;
if(cf->type!='M') return 1;
if(m==INVALID_HANDLE_VALUE)return 11;
nb=(cf->filen<10)? GetBinary() : Get64();
if(blocknum)*blocknum=nb;
if(!nb) return 2;
BYTE *b=new BYTE[lmem];
if(!b) return 12;
HANDLE mf;
mf=CreateFile(file,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,
             FILE_ATTRIBUTE_NORMAL|FILE_FLAG_SEQUENTIAL_SCAN,NULL);
if(mf==INVALID_HANDLE_VALUE) { delete b; return 13; }
nb*=lmem;
if(SetFilePointer(m,nb,NULL,FILE_BEGIN)==0xFFFFFFFF) goto BAD_MEMO;
if(!ReadFile(m,b,lmem,&nbr,NULL)) goto BAD_MEMO;
switch(tmem) {
  case 0: // --------------------------------> dBaseIII memo
    for(;;) {
      for(i=0; i<lmem; i++) if(b[i]==0x1a) break;
      if(!i) break;
      if(!WriteFile(mf,b,i,&nbr,NULL) || nbr<i) goto BAD_MEMO;
      if(i<lmem) break;
      if(!ReadFile(m,b,lmem,&nbr,NULL) || nbr<lmem) goto BAD_MEMO;
      }
    break;
  case 1: // --------------------------------> dBaseIV memo
    if(b[0]!=0xff) goto BAD_MEMO;
    if(b[1]!=0xff) goto BAD_MEMO;
    if(b[2]!=0x08) goto BAD_MEMO;
    if(b[3]) goto BAD_MEMO;
    nb=*((DWORD *)(b+4))-8;
    goto READ_MEMO;
  case 2: // --------------------------------> FoxPro memo
    nb=b[4]; nb<<=8; nb|=b[5]; nb<<=8; nb|=b[6]; nb<<=8; nb|=b[7];
  READ_MEMO:
    if(nbr<lmem) { // first block is last and it is not full
      i=nbr-8;
      if(!WriteFile(mf,b+8,i,&nbr,NULL) || nbr<i) goto BAD_MEMO;
      break;
      }
    i=lmem-8; if(nb<i)i=nb;
    if(!WriteFile(mf,b+8,i,&nbr,NULL) || nbr<i) goto BAD_MEMO;
    nb-=i; i=lmem;
    while(nb) {
      if(!ReadFile(m,b,lmem,&nbr,NULL)) goto BAD_MEMO;
      if(nbr<lmem) { // last block is not full
        i=nbr;
        if(!WriteFile(mf,b,i,&nbr,NULL) || nbr<i) goto BAD_MEMO;
        break;
        }
      if(nb<i)i=nb;
      if(!WriteFile(mf,b,i,&nbr,NULL) || nbr<i) goto BAD_MEMO;
      nb-=i;
      }
    break;
  default: goto BAD_MEMO;  // ---------------> No memo or unknown
  }
CloseHandle(mf);
delete b;
return 0;
BAD_MEMO:
CloseHandle(mf);
DeleteFile(file);
delete b; return 14;
}
//-----------------------------------

BYTE dbBase::NextRec(void)
{
DWORD nbr;
if(cur>=dbH.nrec)return 1;
if(!ReadFile(f,rec,dbH.reclen,&nbr,NULL) || nbr<dbH.reclen) return 2;
pos+=dbH.reclen;
cur++;
return 0;
}
//-------------------------------

dbField *dbBase::FiNum(WORD n)
{
fpos=1;
for(cf=dbF;n&&cf;n--) {
  fpos+=cf->filen;
  cf=(dbField*)(cf->Next());
  }
if(!cf)fpos=0;
return cf;
}
//===========================================================================
WORD dbBase::FiWidth(void)
{
WORD i=cf->filen;
switch(cf->type) {
  case 'D': i=10; break;
  case 'L': i=1; break;
  case 'M': case 'G': case 'P': i=4; break;
  case 'T': i=19; break;
  case '0': i=11; break;
  case 'I': i=11; break;
  case 'B': case 'Y': i=21; break;
  }
return i;
}
//===========================================================================

char *dbBase::FiType(void)
{
char *c;
switch(cf->type) {
  case 'C': c="C Character"; break;
  case 'N': c="N Number"; break;
  case 'D': c="D Date"; break;
  case 'L': c="L Logical"; break;
  case 'M': c="M Memo"; break;
  case 'T': c="T DateTime"; break;
  case '0': c="0 System"; break;
  case 'I': c="I Integer"; break;
  case 'F': c="F Float"; break;
  case 'B': c="B Double"; break;
  case 'Y': c="Y Currency"; break;
  case 'G': c="G General"; break;
  case 'P': c="P Picture"; break;
  case '#': c="# Dummy"; break;
  default : c="  Unknown"; if(cf->type)c[0]=cf->type;  break;
  }
return c;
}
//-----------------------------------

WORD dbBase::FiDisp(char *s)
{
WORD n;
BYTE *c;

if(!cf)return 0;
c=rec+fpos;
switch(cf->type) {
 case 'T': // DateTime
           if(cf->filen == 8) { // Binary format
             union { DWORD w; BYTE c[4]; } u,v;
             __int32 d,ho,mi,se;
             for(n=0;n<4;n++)u.c[n]=c[n];
             for(n=4;n<8;n++)v.c[n-4]=c[n];
             v.w+=500L;
             ho=v.w/3600000L; v.w-=ho*3600000L;
             mi=v.w/60000L;   se=(v.w-mi*60000L)/1000L;
             d=(u.w>1721410)? u.w-1721410 : 0;  DateDigit(d,s);
             s[10]='-'; s[11]=0; n=lstrlen(s);
             FSF.sprintf(s+n,"%02u:%02u:%02u",ho,mi,se);
             }
           else { // Character format
             s[ 0]=c[ 6]; s[ 1]=c[ 7]; s[ 2]='/';
             s[ 3]=c[ 4]; s[ 4]=c[ 5]; s[ 5]='/';
             s[ 6]=c[ 0]; s[ 7]=c[ 1]; s[ 8]=c[2]; s[ 9]=c[3]; s[ 10]='-';
             s[11]=c[ 8]; s[12]=c[ 9]; s[13]=':';
             s[14]=c[10]; s[15]=c[11]; s[16]=':';
             s[17]=c[12]; s[18]=c[13]; s[19]=0;
             }
           break;
 case 'I': { // Integer
             union { __int32 w; BYTE c[4]; } u;
             for(n=0;n<4;n++)u.c[n]=c[n];
             FSF.sprintf(s,"%11ld",u.w);
             }
           break;
 case 'B': { // Double
             union { double w; BYTE c[8]; } u;
             for(n=0;n<8;n++)u.c[n]=c[n];
             FSF.sprintf(s,"%21.*f",cf->dec,u.w);
             }
           break;
 case 'Y': { // Currency
             union { __int64 w; BYTE c[8]; } u;
             for(n=0;n<8;n++)u.c[n]=c[n];
             i64_a(s,u.w,21,4);
             }
           break;
 case 'G': /*{ // General
             union { WORD w; BYTE c[2]; } u,v;
             for(n=0;n<2;n++)v.c[n]=c[n];
             for(n=2;n<4;n++)u.c[n-2]=c[n];
             FSF.sprintf(s,"%04X:%04X",u.w,v.w);
             } */
           lstrcpy(s,"Gnrl");
           break;
 case 'P':  // Picture
           lstrcpy(s,"Pict");
           break;
 case 'D': // ASCII Date
           s[0]=c[6]; s[1]=c[7]; s[2]='/';
           s[3]=c[4]; s[4]=c[5]; s[5]='/';
           s[6]=c[0]; s[7]=c[1]; s[8]=c[2]; s[9]=c[3]; s[10]=0;
           break;
 case 'M': {// Memo
             __int64 w=(cf->filen<10)? GetBinary(): Get64();
             if(w)lstrcpy(s,"Memo");
//             FSF.sprintf(s,"m%10Ld",w);
             }
           break;
 default : for(n=0;n<cf->filen;n++) {
             s[n]=c[n];
             if(!s[n])s[n]=' ';
             }
           s[n]=0;
 }
n=lstrlen(s);
return n;
}
//-----------------------------------

WORD dbBase::FiDispE(char *s)
{
if(!cf)return 0;
WORD i,n;
n = FiDisp(s);
if(cf->type=='C' || cf->type=='#') {
  FSF.RTrim(s); return lstrlen(s);
  }
if(cf->type!='I' && cf->type!='B' && cf->type!='Y' &&
   cf->type!='N' && cf->type!='F') return n;
for(i=0; s[i] && s[i]==' '; i++);
if(!i) return n;
MoveMemory(s,s+i,n+1);
return n;
}
//-----------------------------------

void dbBase::Accum(dbVal *V)
{
if(!cf)return;
int n;
BYTE *c=rec+fpos;
switch(cf->type) {
  case 'I': { // Integer
           union {__int32 w; BYTE c[4]; } u;
           for(n=0;n<4;n++)u.c[n]=c[n];
           V->I+=u.w; return; }
  case 'B': { // Double
           union { double w; BYTE c[8]; } u;
           for(n=0;n<8;n++)u.c[n]=c[n];
           V->D+=u.w; return; }
  case 'Y': { // Currency
           union {__int64 w; BYTE c[8]; } u;
           for(n=0;n<8;n++)u.c[n]=c[n];
           V->I+=u.w; return; }
  case 'N': // Number
  case 'F': // Float
           if(cf->filen<21) V->I+=Get64();
           else V->D+=GetDouble();
  }
}
//-----------------------------------

__int64 dbBase::Get64(void)
{
if(!cf) return 0;
if(cf->type!='N' && cf->type!='F' && cf->type!='M')return 0;
char *c=rec+fpos;
int i, sign=1,j=0;
__int64 q=0;
for(i=0;i<cf->filen;c++,i++) {
  if((*c==' ')||(*c=='+'))continue;
  if(*c=='-') {sign=-1; continue;}
  if(*c=='.') {j=cf->dec-cf->filen+i+1; continue;}// Legal size overflow detected
  if((*c<'0')||(*c>'9')) break;
  q=q*10+(*c-'0');
  }
if(j>0) for(;j;j--)q*=10;
q*=sign;
return q;
}
//-----------------------------------

__int64 dbBase::GetBinary(void)
{
if(!cf)return 0;
int n;
BYTE *c=rec+fpos;
if(cf->filen<8) {
 union { __int32 w; BYTE c[4]; } u;
 for(n=0;n<4;n++)u.c[n]=c[n];
 return u.w;
 }
union {__int64 w; BYTE c[8]; } u;
for(n=0;n<8;n++)u.c[n]=c[n];
return u.w;
}
//-----------------------------------

BYTE *dbBase::GetByte(BYTE *s)
{
CopyMemory(s,rec+fpos,cf->filen);
s[cf->filen]=0;
return s;
}
//-----------------------------------

void dbBase::SetByte(BYTE *s)
{
CopyMemory(rec+fpos,s,cf->filen);
}
//-----------------------------------

double dbBase::GetDouble(void)
{
if(!cf) return 0;
if(cf->type!='N' && cf->type!='F' && cf->type!='C')return 0;
char *c;
int i,sign,j;
double q,qq;
sign=1; j=0;
c=rec+fpos;
q=0;
for(i=0;i<cf->filen;c++,i++) {
  if((*c==' ')||(*c=='+')) { if(j)break; continue; }
  if(*c=='-') { if(j)break; sign=-1; continue; }
  if(*c=='.') { if(j)break; j=10; continue; }
  if((*c<'0')||(*c>'9')) break;
  if(j) { qq=(*c-'0'); q+=qq/j; j*=10; }
  else q=q*10+(*c-'0');
  }
q*=sign;
return q;
}
//-----------------------------------

BYTE dbBase::Numeric(void)
{
if(!cf) return 0;
if(cf->type=='N'||cf->type=='F'||cf->type=='I'
                ||cf->type=='B'||cf->type=='Y')return 1;
return 0;
}
//-----------------------------------

BYTE dbBase::Write(void)
{
DWORD nbr;
if(!WriteFile(f,rec,dbH.reclen,&nbr,NULL) || nbr<dbH.reclen) return 2;
pos+=dbH.reclen;
upd|=1;
cur++;
if(cur>dbH.nrec)dbH.nrec++;
return 0;
}
//-----------------------------------

BYTE dbBase::Append(void)
{
DWORD nbr;
pos=dbH.start+dbH.nrec*dbH.reclen;
if(SetFilePointer(f,pos,NULL,FILE_BEGIN)==0xFFFFFFFF) return 2;
if(!WriteFile(f,rec,dbH.reclen,&nbr,NULL) || nbr<dbH.reclen) return 2;
pos+=dbH.reclen; upd|=1; dbH.nrec++;
cur=dbH.nrec;
return 0;
}
//-------------------------------

BYTE dbBase::ReWrite(void)
{
if(!cur) return 1;
DWORD p;
p=pos-dbH.reclen;
if(SetFilePointer(f,p,NULL,FILE_BEGIN)==0xFFFFFFFF) return 2;
if(!WriteFile(f,rec,dbH.reclen,&p,NULL) || p<dbH.reclen) return 2;
if(SetFilePointer(f,pos,NULL,FILE_BEGIN)==0xFFFFFFFF) return 2;
return 0;
}
//-------------------------------

void dbBase::SetLeft(char *fval)
{
WORD i;
for(i=0; i<cf->filen; i++) {
  if(!fval[i]) break;
  rec[fpos+i]=fval[i];
  }
}
//-------------------------------

void dbBase::SetRight(char *fval)
{
int l=lstrlen(fval);
if(!l) return;
l--;
int i;
for(i=fpos+cf->filen-1; i>=fpos&&l>=0; i--,l--) rec[i]=fval[l];
}
//-------------------------------

void dbBase::SetEmpty(void)
{
BYTE filler=0x20;
if(!cf)return;
if(cf->type=='M'||cf->type=='0'||cf->type=='I'
                ||cf->type=='B'||cf->type=='Y'||cf->type=='G')filler=0;
if(cf->type=='T'&&cf->filen==8)filler=0;
for(WORD i=0; i<cf->filen; i++) rec[fpos+i]=filler;
}
//-------------------------------

BYTE dbBase::IsEmpty(void)
{
if(!cf)return 1;
BYTE filler=0x20;
if(cf->type=='M'||cf->type=='0'||cf->type=='I'
                ||cf->type=='B'||cf->type=='Y'||cf->type=='G')filler=0;
if(cf->type=='T'&&cf->filen==8)filler=0;
for(WORD i=0; i<cf->filen; i++) if(rec[fpos+i]!=filler) return 0;
return 1;
}
//-------------------------------
/*
void DBG(char *ttt, int idbg)
{
FILE *dbg=fopen("lookdbf.dbg","at");
if(!dbg) return;
fprintf(dbg,"%10d %s\n",idbg,ttt);
fclose(dbg);
}
*/
void dbBase::SetField(char *s)
{
WORD n,i;
BYTE *c;
if(!cf)return;
if(!(*s)) { SetEmpty(); return; }
for(i=0; s[i] && i<FiWidth(); i++) if(s[i]!=' ') goto NON_ZERO;
SetEmpty(); return;
NON_ZERO:
c=rec+fpos;
switch(cf->type) {
 case 'T': // DateTime
           if(i) { SetEmpty(); break; }
           if(cf->filen == 8) { // Binary format
             union { DWORD w; BYTE c[4]; } u,v;
             __int32 d,ho,mi,se;
             char r[32];
             for(n=0;n<19;n++)r[n]=s[n]; r[19]=r[10]=r[13]=r[16]=0;
             ho=a_i64(r+11,0); mi=a_i64(r+14,0); se=a_i64(r+17,0);
             v.w=ho*3600000L+mi*60000L+se*1000L;
             d=Date4(r); u.w=d? d+1721410L : 0;
             for(n=0;n<4;n++)c[n]=u.c[n];
             for(n=4;n<8;n++)c[n]=v.c[n-4];
             }
           else { // Character format s=dd/mm/yyyy-hh:mm:ss -> yyyymmddhhmmss=c
                  //                    0123456789012345678    01234567890123
             c[0]=s[6]; c[1]=s[7]; c[2]=s[8]; c[3]=s[9];
             c[4]=s[3]; c[5]=s[4]; c[6]=s[0]; c[7]=s[1];
             c[8]=s[11]; c[9]=s[12]; c[10]=s[14]; c[11]=s[15];
             c[12]=s[17]; c[13]=s[18];
             }
           break;
 case 'I': { // Integer
           union { long w; BYTE c[4]; } u;
           u.w=a_i64(s+i,0);
           for(n=0;n<4;n++)c[n]=u.c[n];
           }
           break;
 case 'B': { // Double
           union { double w; BYTE c[8]; } u;
           u.w=1; for(n=0;n<cf->dec;n++)u.w*=10;
           u.w=a_i64(s+i,0,cf->dec)/u.w;
           for(n=0;n<8;n++)c[n]=u.c[n];
           }
           break;
 case 'Y': { // Currency
           union {__int64 w; BYTE c[8]; } u;
           u.w=a_i64(s+i,0,4);
           for(n=0;n<8;n++)c[n]=u.c[n];
           }
           break;
 case 'G': // General
 case 'M': // Memo
           break;
 case 'D': // ASCII Date s=dd/mm/yyyy -> yyyymmdd=c
                  //       0123456789    01234567
           if(i) { SetEmpty(); break; }
           c[0]=s[6]; c[1]=s[7]; c[2]=s[8]; c[3]=s[9];
           c[4]=s[3]; c[5]=s[4]; c[6]=s[0]; c[7]=s[1];
           break;
 case 'N': case 'F': {
             char r[32];
             __int64 q=a_i64(s+i,0,cf->dec);
             i64_a(r,q,cf->filen,cf->dec);
             SetEmpty(); SetRight(r);
             }
           break;
 default : SetEmpty(); SetLeft(s);
 }
return;
}

//-----------------------------------

