#include "..\plugin.hpp"
#include "launcher.hpp"

#define COUNT(Msg) (sizeof(Msg)/sizeof(*Msg))

#define FSD_FOCUSED  0x80
#define FSD_SELECTED 0x40
#define FSD_DEFAULT  0x20

//#pragma pack(1)
struct InitDialogItem
{
  union
  {
    BYTE Type;
    BYTE FSDFlags;
  };
  //BYTE Reserved;
  BYTE X1,Y1,X2,Y2;
  DWORD Flags;
  char *Data;
};

// ⪫祭 樨 startup-  GCC
#ifdef __GNUC__
#ifdef __cplusplus
extern "C"
#endif
BOOL WINAPI DllMainCRTStartup(HANDLE hDll, DWORD dwReason, LPVOID lpReserved)
{
  return TRUE;
}
#endif

inline void InitDialogItems(InitDialogItem *Init,
                            FarDialogItem *Item, int Count)
{
  while(Count--)
  {
    Item->Type=Init->Type&0x1F;
    Item->X1=Init->X1;
    Item->Y1=Init->Y1;
    Item->X2=Init->X2;
    Item->Y2=Init->Y2;
    Item->Focus=Init->FSDFlags&FSD_FOCUSED;
    Item->Selected=Init->FSDFlags&FSD_SELECTED;
    Item->Flags=Init->Flags;
    Item->DefaultButton=Init->FSDFlags&FSD_DEFAULT;
    lstrcpy(Item->Data, Init->Data);

    Item++;
    Init++;
  }
}

inline BYTE Seek(BYTE *Str, BYTE c)
{
  while(*Str && *Str!=c)
    Str++;
  return *Str;
}

//
//  ஫ ͻ
//ۺ                                                    
//ۺ   ஫ (1-511)    
//ۺ                                                    
//ۺ  [x] 㪢 孥 ॣ (⨭)            
//ۺ  [x] 㪢   ॣ (⨭)            
//ۺ  [x]                                          
//ۺ      
//ۺ                                                    
//ۺ  ஫     
//ۺ                                                    
//ۺ                                                    
//ۺ                [  ]  [  ]                  
//ͼ
//۱
//

int WINAPI _export FarMain(PluginStartupInfo *Info, int argc, char *argv[], DWORD Reserved)
{
  FarStandardFunctions *FSF=Info->FSF;

  InitDialogItem InitItem[]=
  {
/* 0*/{DI_DOUBLEBOX,              0, 0,43,13, 0, " ஫"},
/* 1*/{DI_TEXT,                   3, 2, 0, 0, 0, " ஫ (1-511)"},
/* 2*/{DI_EDIT,                  25, 2,40, 0, 0, "8"},
/* 3*/{DI_CHECKBOX|FSD_SELECTED,  3, 4, 0, 0, 0, "㪢 孥 ॣ (⨭)"},
/* 4*/{DI_CHECKBOX|FSD_SELECTED,  3, 5, 0, 0, 0, "㪢   ॣ (⨭)"},
/* 5*/{DI_CHECKBOX|FSD_SELECTED,  3, 6, 0, 0, 0, ""},
/* 6*/{DI_TEXT,                   3, 7, 0, 0, 0, ""},
/* 7*/{DI_EDIT,                  12, 7,40, 0, 0, ""},
/* 8*/{DI_TEXT,                   3, 9, 0, 0, 0, "஫"},
/* 9*/{DI_EDIT|FSD_FOCUSED,      12, 9,40, 0, DIF_SELECTONENTRY, ""},
/*10*/{DI_BUTTON|FSD_DEFAULT,     0,12, 0, 0, DIF_CENTERGROUP, ""},
/*11*/{DI_BUTTON,                 0,12, 0, 0, DIF_CENTERGROUP, ""},
  };

  struct FarDialogItem Item[COUNT(InitItem)];
  InitDialogItems(InitItem, Item, COUNT(InitItem));

//  FarDialogItem Item[]=
//  {
//    /* 0*/{DI_DOUBLEBOX,   0, 0, 53,16, 0,0,0,0, " ஫"},
//    /* 1*/{DI_TEXT,        3, 2, 0, 0,  0,0,0,0, " ஫ (1-511)"},
//    /* 2*/{DI_EDIT,        24,2, 50,0,  0,0,0,0, ""},
//    /* 3*/{DI_CHECKBOX,    3, 4, 0, 0,  0,1,0,0, "㪢 (⨭)"},
//    /* 4*/{DI_RADIOBUTTON, 7, 5, 0, 0,  0,0, DIF_GROUP, 0, "孨 ॣ"},
//    /* 5*/{DI_RADIOBUTTON, 7, 6, 0, 0,  0,0, 0, 0, " ॣ"},
//    /* 6*/{DI_RADIOBUTTON, 7, 7, 0, 0,  0,1, 0, 0, " ॣ"},
//    /* 7*/{DI_CHECKBOX,    3, 8, 0, 0,  0,1,0,0, ""},
//    /* 8*/{DI_TEXT,        3, 9, 0, 0,  0,0,0,0, ""},
//    /* 9*/{DI_EDIT,        12,9, 50,0,  0,0,0,0, ""},
//    /*10*/{DI_TEXT,        3, 12, 0, 0,  0,0,0,0, "஫"},
//    /*11*/{DI_EDIT,        12,12, 50,0,  1,0,0,0, ""},
//    /*12*/{DI_BUTTON,      0, 15,0, 0,  0,1, DIF_CENTERGROUP, 1, ""},
//    /*13*/{DI_BUTTON,      0, 15,0, 0,  0,0, DIF_CENTERGROUP, 0, ""},
//  };

  //Info->FSF->itoa(8, Item[2].Data, 10);

  int Ret;
  BYTE Byte;
  DWORD Rand=GetTickCount();
  
  do
  {
    if(Item[3].Selected || Item[4].Selected || Item[5].Selected || *Item[7].Data)
    {
      int i;
      int MaxI=max(min(FSF->atoi(Item[2].Data), 511), 1);
      FSF->itoa(MaxI, Item[2].Data, 10);
      for(i=0; i<MaxI/*FSF->atoi(Item[2].Data)*/; i++)
      {
        while(1)
        {
          Rand=(1664525L*Rand+1013904223L);
          Byte=Rand&0xFF;

          if(Byte<0x80)
            if((Item[3].Selected && /*FSF->LIsUpper(Byte)*/IsCharUpper(Byte)) || 
               (Item[4].Selected && /*FSF->LIsLower(Byte)*/IsCharLower(Byte)))
              break;
          
          if(Item[5].Selected && Byte>='0' && Byte<='9')
            break;
          
          if(Seek((BYTE *)Item[7].Data, Byte))
            break;
        }
        Item[9].Data[i]=Byte;
      }
      Item[9].Data[i]=0;
    }

    Ret=Info->Dialog(Info->ModuleNumber, -1,-1, 44, 14, NULL, Item, COUNT(Item));
  }
  while(Ret!=-1 && Ret!=COUNT(Item)-1);
  
  return 0;
}
