#define _FAR_USE_FARFINDDATA
#include "..\plugin.hpp"

typedef int (WINAPI *FARMAIN)(struct PluginStartupInfo *Info, int argc, char *argv[], DWORD Reserved);

static struct PluginStartupInfo Info;
static struct FarStandardFunctions FSF;

#ifdef __GNUC__
/*inline void *malloc(size_t Size)
{ 
  return HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, Size);
}
inline void free(void *Block)
{ 
  HeapFree(GetProcessHeap(), 0, Block);
}*/
#define malloc(Size) HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, Size)
#define free(Block) HeapFree(GetProcessHeap(), 0, Block)

// ⪫祭 樨 startup-  GCC
#ifdef __cplusplus
extern "C"
#endif
BOOL WINAPI DllMainCRTStartup(HANDLE hDll, DWORD dwReason, LPVOID lpReserved)
{
  return TRUE;
}
#endif

void WINAPI _export SetStartupInfo(const struct PluginStartupInfo *Info)
{
  ::Info=*Info;
  FSF=*Info->FSF;
  ::Info.FSF=&FSF;
}

void WINAPI _export GetPluginInfo(struct PluginInfo *Info)
{
  Info->StructSize=sizeof(struct PluginInfo);
  
  Info->CommandPrefix="go\x0";
  //Info->CommandPrefix="run";
  //static char *CommandPrefix="run";
  //Info->CommandPrefix=CommandPrefix;
}

HANDLE WINAPI _export OpenPlugin(int OpenFrom, int Item)
{
  char *CmdLine=(char *)malloc(lstrlen((char *)Item)+1);
  if(CmdLine)
  {
    lstrcpy(CmdLine, (char *)Item);
    
    char f, *c;
    int Count;
    for(Count=0, c=CmdLine; ; Count++)
    {
      while(*c==' ' /*|| *c=='\t'*/) //c=delwhite(c)
        *c++=0; 
      if(!*c)
        break;
      if((f=*c)=='"')
        *c++=0;
      else 
        f=' ';
      while(*c && *c!=f) //c=strchr(c, f)
        c++;
      if(*c)
        *c++=0;
    }

    if(Count)
    {
      char **argv=(char **)malloc(sizeof(char *)*Count);
      if(argv)
      {
        c=CmdLine;
        for(int i=0; i<Count; i++)
        {
          while(!*c) c++;
          argv[i]=c;
          while(*c) c++;
        }
        char Module[MAX_PATH], *FileName;
        GetFullPathName(*argv, sizeof(Module), Module, &FileName);
        *argv=Module;
        //for(int i=0; i<Count; i++)
        //  MessageBox(0, argv[i], "", MB_OK);
        OpenFilePlugin(*argv, (const unsigned char *)argv, -Count);
        free(argv);
      }
    }

    free(CmdLine);
  }
  return INVALID_HANDLE_VALUE;
}


HANDLE WINAPI _export OpenFilePlugin(char *Name, const BYTE *Data, int DataSize)
{
  HANDLE Ret=INVALID_HANDLE_VALUE;
  if(Name)
  {  
    HINSTANCE hModule=LoadLibrary(Name);
    if(hModule)
    {
      FARMAIN FarMain=(FARMAIN)GetProcAddress(hModule, "FarMain");
      if(FarMain)
      {
        if(DataSize<0)
          FarMain(&Info, -DataSize, (char **)Data, 0);
        else
          FarMain(&Info, 1, &Name, 0);
        Ret=(HANDLE)-2; 
      }
      FreeLibrary(hModule);
    }
  }
  return Ret;
}


int WINAPI _export GetMinFarVersion(void)
{
  return MAKEFARVERSION(1, 70, 1282);
}
