//#define _FAR_NO_NAMELESS_UNIONS
#define _FAR_USE_FARFINDDATA
#include "..\plugin.hpp"
#include "launcher.hpp"

#define COUNT(Msg) (sizeof(Msg)/sizeof(*Msg))

#define FSD_FOCUSED  0x80
#define FSD_SELECTED 0x40
#define FSD_DEFAULT  0x20

#define START_INDEX  1

#define ROUND(a, b) ( ((DWORD)((a)/(b)))*(b) )

//#pragma pack(1)
struct InitDialogItem
{
  union
  {
    BYTE Type;
    BYTE FSDFlags;
  };
  //BYTE Reserved;
  BYTE X1,Y1,X2,Y2;
  DWORD Flags;
  char *Data;
};

PluginStartupInfo *Info;
FarStandardFunctions *FSF;

#ifdef __GNUC__
//ॣ ஢  離  MSVCRT.DLL  㬥襭 ࠧ 
HANDLE heapNEW=GetProcessHeap();
void *operator new(size_t size){ return HeapAlloc(heapNEW, HEAP_ZERO_MEMORY, size); }
void operator delete(void *block){ HeapFree(heapNEW, 0, block); }

//⪫祭 樨 startup-  㬥襭 ࠧ 
extern "C" BOOL WINAPI DllMainCRTStartup(HANDLE hDll, DWORD dwReason, LPVOID lpReserved)
{
  return TRUE;
}
#endif


inline int FileExists(char* Name)
{
  return GetFileAttributes(Name)!=0xFFFFFFFF;
}


//////////////////////////////////////////////////////////////////////////////
//ᮧ 㡮  ⠫ 

inline void CreateDir(char *Path)
{
  if(!FileExists(Path))
    for(char *c=Path; *c; c++)
    {
      if(*c!=' ')
      {
        for(; *c; c++)
          if(*c=='\\')
          {
            *c=0;
            CreateDirectory(Path, NULL);
            *c='\\';
          }
        CreateDirectory(Path, NULL);
        break;
      }
    }
}

inline void InitDialogItems(InitDialogItem *Init,
                            FarDialogItem *Item, int Count)
{
  while(Count--)
  {
    Item->Type=Init->Type&0x1F;
    Item->X1=Init->X1;
    Item->Y1=Init->Y1;
    Item->X2=Init->X2;
    Item->Y2=Init->Y2;
    Item->Focus=Init->FSDFlags&FSD_FOCUSED;
    Item->Selected=Init->FSDFlags&FSD_SELECTED;
    Item->Flags=Init->Flags;
    Item->DefaultButton=Init->FSDFlags&FSD_DEFAULT;
    lstrcpy(Item->Data, Init->Data);

    Item++;
    Init++;
  }
}


//
//                                                                            
//     ͻ   
//    १ 뤥 :                                                
//    C:\TEMP\   
//   Ķ   
//                                            
//    [x]  ⭨  ᪫                                       
//   Ķ   
//                            [ OK ]  [  ]                             
//   ͼ   
//                                                                            
//۱
//

int Dialog(char* DestPath, int* Size, int* CreateBat)
{
  InitDialogItem InitItem[]=
  {
/* 0*/{DI_DOUBLEBOX,              3, 1,72, 9, 0, ""},
/* 1*/{DI_TEXT,                   5, 2, 0, 0, 0, "१ 뤥 :"},
/* 2*/{DI_EDIT,                   5, 3,70, 0, DIF_HISTORY|DIF_VAREDIT|DIF_EDITEXPAND, },
/* 3*/{DI_TEXT,                   5, 4, 0, 0, DIF_SEPARATOR, ""},
/* 4*/{DI_TEXT,                   5, 5, 0, 0, 0, ""},
/* 5*/{DI_EDIT,                  12, 5,35, 0, 0, ""},
//* 6*/{DI_TEXT,                   5, 6, 0, 0, 0, "⮢ "},
//* 7*/{DI_EDIT,                  23, 6,35, 0, 0, "1"},
/* 6*/{DI_CHECKBOX|FSD_SELECTED,  5, 6, 0, 0, 0, " ⭨  ᪫"},
/* 7*/{DI_TEXT,                   5, 7, 0, 0, DIF_SEPARATOR, ""},
/* 8*/{DI_BUTTON|FSD_DEFAULT,     0, 8, 0, 0, DIF_CENTERGROUP, "OK"},
/* 9*/{DI_BUTTON,                 0, 8, 0, 0, DIF_CENTERGROUP, ""},
  };

  FarDialogItem Item[COUNT(InitItem)];
  InitDialogItems(InitItem, Item, COUNT(InitItem));

  Item[2]/*.Param*/.Mask="Copy";
  //lstrcpy(Item[2].Data, DestPath);
  Item[2].Ptr.PtrFlags=0;
  Item[2].Ptr.PtrData=DestPath;
  Item[2].Ptr.PtrLength=MAX_PATH;
  FSF->itoa(*Size, Item[5].Data, 10);

  do
  {
    int Code=Info->Dialog(Info->ModuleNumber, -1,-1, 76, 11, NULL, Item, COUNT(Item));
    if(Code==-1 || Code==COUNT(Item)-1)
      return FALSE;
    *Size=FSF->atoi(Item[5].Data);
  }while(!*Size);

  //lstrcpy(DestPath, Item[2].Data);
  if(*DestPath)
    FSF->AddEndSlash(DestPath);
  *CreateBat=Item[6].Selected;
  return TRUE;
}

inline void ClearSelect(PanelInfo* pi, int Index)
{
  for(int i=0; i<pi->ItemsNumber; i++)
    if(!lstrcmp(pi->SelectedItems[Index].FindData.cFileName, pi->PanelItems[i].FindData.cFileName))
    {
      pi->PanelItems[i].Flags&=~PPIF_SELECTED;
//MessageBox(NULL, pi->PanelItems[i].FindData.cFileName, "", MB_OK);
      return;
    }
}


//////////////////////////////////////////////////////////////////////////////
//㯮 䠩-ਥ.    ᥡ ᮪   ப 

class TOutFile
{
private:
  HANDLE Handle;
public:
  int WriteBuf(BYTE* Buf, DWORD Len);
  int WriteStr(char* Str){ return WriteBuf((BYTE*)Str, lstrlen(Str)); }
  TOutFile(char* FilePath, char* FileName);
  ~TOutFile(){ if(Handle!=INVALID_HANDLE_VALUE) CloseHandle(Handle); }
};

int TOutFile::WriteBuf(BYTE* Buf, DWORD Len)
{
  if(Handle!=INVALID_HANDLE_VALUE)
  {
    DWORD WriteLen;
    WriteFile(Handle, Buf, Len, &WriteLen, NULL);
    return WriteLen==Len;
  }
  return 0;
}

TOutFile::TOutFile(char* FilePath, char* FileName)
{
  CreateDir(FilePath);
  char FullName[MAX_PATH];
  //MakeFullName(FullName, FilePath, FileName);
  wsprintf(FullName, "%s%s", FilePath, FileName);
  Handle=CreateFile(FullName, GENERIC_WRITE, 0, /*&sa*/NULL, CREATE_ALWAYS, 0, NULL);
}


//////////////////////////////////////////////////////////////////////////////
//㯮 䠩-筨. 㬥 뤠  ᥡ   ᪠ 

class TInFile
{
private:
  HANDLE Handle, MapHandle;
  LPVOID Buf;
  DWORD dwAllocationGranularity;
public:
  DWORD Size(){ return (Handle!=INVALID_HANDLE_VALUE)?GetFileSize(Handle, NULL):0; }
  BYTE* GetBuf(DWORD Disp, DWORD Len);
  void FreeBuf(){ if(Buf){ UnmapViewOfFile(Buf); Buf=NULL; } }
  TInFile(char* FileName);
  ~TInFile();
};
  
BYTE* TInFile::GetBuf(DWORD Disp, DWORD Len)
{
  FreeBuf(); //??   ⮣, ᫨ ॡ  ᮪
  if(Handle!=INVALID_HANDLE_VALUE && MapHandle)
  {
    DWORD RoundDisp=ROUND(Disp, dwAllocationGranularity);
    DWORD RoundLen=ROUND(Disp+Len+dwAllocationGranularity, dwAllocationGranularity);
    //??  墠뢠 譨 ᥣ

//char Buf64[64];
//wsprintf(Buf64, "%d %d", RoundDisp, RoundLen);
//MessageBox(NULL, Buf64, "", MB_OK);
    Buf=MapViewOfFile(MapHandle, FILE_MAP_READ, 0, RoundDisp, min(RoundLen, Size()-RoundDisp));
    if(Buf)
      return (BYTE*)Buf+(Disp-RoundDisp);
  }
  return NULL;
}

TInFile::TInFile(char* FileName)
{
  SYSTEM_INFO si;
  GetSystemInfo(&si);
  dwAllocationGranularity=si.dwAllocationGranularity; //=64kb*//dwAllocationGranularity=0x10000;

  Buf=NULL;
  Handle=CreateFile(FileName, GENERIC_READ, FILE_SHARE_READ, /*&sa*/NULL, OPEN_EXISTING, 0, NULL);
  if(Handle!=INVALID_HANDLE_VALUE)
    MapHandle=CreateFileMapping(Handle, NULL, PAGE_READONLY, 0, 0, NULL);
  else
    MapHandle=NULL;
}

TInFile::~TInFile()
{
  FreeBuf();
  if(MapHandle)
    CloseHandle(MapHandle);
  CloseHandle(Handle);
}


//////////////////////////////////////////////////////////////////////////////
// ⭨  ப ⨯:
//copy /b file.001+file.002+file.003 file

inline void CreateBat(char* Path, char* FileName, int Start, int End)
{
  char Buf[MAX_PATH];
  wsprintf(Buf, "%s.bat", FileName);

  TOutFile BatFile(Path, Buf);

  wsprintf(Buf, "copy /b \"%s.%03d\"", FileName, Start);
  BatFile.WriteStr(Buf);
  for(int i=Start+1; i<End; i++)
  {
    wsprintf(Buf, "+\"%s.%03d\"", FileName, i);
    BatFile.WriteStr(Buf);
  }
  wsprintf(Buf, " \"%s\"", FileName);
  BatFile.WriteStr(Buf);
}


//////////////////////////////////////////////////////////////////////////////
//०  䠩

inline int Cut(char* InFileName, char* DestPath, int Size, int CreateBatFlag)
{
  TInFile InFile(InFileName);
  
  DWORD InFileSize=InFile.Size();
  //?? ᫨ InFileSize<=Size 䠩  १,   ᪮஢
  DWORD Disp=0;
  int i=START_INDEX;
  Size=min(Size, InFileSize);

  for(; Disp<InFileSize; i++, Disp+=Size, Size=min(Size, InFileSize-Disp))
  {  
    if(BYTE* Buf=InFile.GetBuf(Disp, Size))
    {
      char OutFileName[MAX_PATH];
      wsprintf(OutFileName, "%s.%03d", FSF->PointToName(InFileName), i);
      TOutFile OutFile(DestPath, OutFileName);
      if(!OutFile.WriteBuf(Buf, Size))
        break;
    }
  }
  if(CreateBatFlag)
    CreateBat(DestPath, FSF->PointToName(InFileName), START_INDEX, i);

  return TRUE;
}


//////////////////////////////////////////////////////////////////////////////
// 㭪 १ 䠩

int WINAPI _export FarMain(PluginStartupInfo *Info, int argc, char *argv[], DWORD Reserved)
{
  ::Info=Info;
  FSF=Info->FSF;
  PanelInfo pi;

  Info->Control(INVALID_HANDLE_VALUE, FCTL_GETANOTHERPANELINFO, &pi);
//  Info->Control(INVALID_HANDLE_VALUE, FCTL_GETANOTHERPANELSHORTINFO, &pi);

  if(!pi.Plugin)
  {
    char DestPath[MAX_PATH];
    lstrcpy(DestPath, pi.CurDir);
    Info->Control(INVALID_HANDLE_VALUE, FCTL_GETPANELINFO, &pi);
    if(!pi.Plugin)
    {
      int CreateBat;
      int Size=//(argc>=2)?FSF->atoi(argv[1]):
               1457664;
      if(Dialog(DestPath, &Size, &CreateBat))
        for(int i=0; i<pi.SelectedItemsNumber; i++)
          if(Cut(pi.SelectedItems[i].FindData.cFileName, DestPath, Size, CreateBat))
            ClearSelect(&pi, i);
          {
//MessageBeep(0xFFFFFFFF);
//char Buf[64];
//wsprintf(Buf, "%x\xd%x", pi.SelectedItems[i].Flags, pi.SelectedItems[i].Flags&(~PPIF_SELECTED));
//MessageBox(NULL, Buf, "", MB_OK);
//            pi.PanelItems[i].Flags&=~PPIF_SELECTED;
//MessageBox(NULL, pi.PanelItems[0].FindData.cFileName, "", MB_OK);
//            pi.SelectedItems[i].Flags&=~PPIF_SELECTED; //!!  ᭨!
          }
    }
  }
}

