//====================
//
//      
//  Simple "Hello world" plugin written using Delphi 4 with SOURCES
//    PlugRinG'
//          
//
//       Delphi 3   2002

unit FARIntf;

interface

{$ALIGN OFF}
{$MINENUMSIZE 4}

uses
  Windows,

  Langs;

const
  NM                           = 260;

  //  OPENPLUGININFO_FLAGS
  OPIF_USEFILTER               = $0001;
  OPIF_USESORTGROUPS           = $0002;
  OPIF_USEHIGHLIGHTING         = $0004;
  OPIF_ADDDOTS                 = $0008;
  OPIF_RAWSELECTION            = $0010;
  OPIF_REALNAMES               = $0020;
  OPIF_SHOWNAMESONLY           = $0040;
  OPIF_SHOWRIGHTALIGNNAMES     = $0080;
  OPIF_SHOWPRESERVECASE        = $0100;
  OPIF_FINDFOLDERS             = $0200;
  OPIF_COMPAREFATTIME          = $0400;
  OPIF_EXTERNALGET             = $0800;
  OPIF_EXTERNALPUT             = $1000;
  OPIF_EXTERNALDELETE          = $2000;
  OPIF_EXTERNALMKDIR           = $4000;
  OPIF_USEATTRHIGHLIGHTING     = $8000;

  //  TPluginPanelItem.Flags
  PPIF_PROCESSDESCR = $80000000;
  PPIF_SELECTED     = $40000000;
  PPIF_USERDATA     = $20000000;
  PPIF_CREATEDBYPLUGIN = 1; 

type
  OPENPLUGININFO_SORTMODES = (
    SM_DEFAULT,SM_UNSORTED,SM_NAME,SM_EXT,SM_MTIME,SM_CTIME,
    SM_ATIME,SM_SIZE,SM_DESCR,SM_OWNER,SM_COMPRESSEDSIZE,SM_NUMLINKS);

  FCTL = (
    FCTL_CLOSEPLUGIN, FCTL_GETPANELINFO, FCTL_GETANOTHERPANELINFO,
    FCTL_UPDATEPANEL, FCTL_UPDATEANOTHERPANEL,
    FCTL_REDRAWPANEL, FCTL_REDRAWANOTHERPANEL,
    FCTL_SETANOTHERPANELDIR, FCTL_GETCMDLINE, FCTL_SETCMDLINE,
    FCTL_SETSELECTION, FCTL_SETANOTHERSELECTION,
    FCTL_SETVIEWMODE, FCTL_SETANOTHERVIEWMODE, FCTL_INSERTCMDLINE,
    FCTL_SETUSERSCREEN, FCTL_SETPANELDIR, FCTL_SETCMDLINEPOS);

  FE = (
    FE_CHANGEVIEWMODE,
    FE_REDRAW,
    FE_IDLE,
    FE_CLOSE,
    FE_BREAK,
    FE_COMMAND);
    
const
    PF_0              = 0;
    PF_PRELOAD        = 1;
    PF_DISABLEPANELS  = 2;
    PF_EDITOR         = 4;
    PF_VIEWER         = 8;

type
  OPEN = (
    OPEN_DISKMENU,
    OPEN_PLUGINSMENU,
    OPEN_FINDLIST,
    OPEN_SHORTCUT,
    OPEN_COMMANDLINE,
    OPEN_EDITOR,
    OPEN_VIEWER);

const
    PKF_NONE    = 0;
    PKF_CONTROL = 1;
    PKF_ALT     = 2;
    PKF_SHIFT   = 4;

const //OPERATION_MODES
    OPM_NORMAL   =  0;
    OPM_SILENT   =  1;
    OPM_FIND     =  2;
    OPM_VIEW     =  4;
    OPM_EDIT     =  8;
    OPM_TOPLEVEL = 16;
    OPM_DESCR    = 32;

type
  PPCharArray = ^TPCharArray;
  TPCharArray = array[0..0] of PChar;
  
  TIntegerArray = array[0..0] of Integer;

  TWin32FindData = record
    dwFileAttributes: DWORD;
    ftCreationTime: TFileTime;
    ftLastAccessTime: TFileTime;
    ftLastWriteTime: TFileTime;
    nFileSizeHigh: DWORD;
    nFileSizeLow: DWORD;
    dwReserved0: DWORD;
    dwReserved1: DWORD;
    cFileName: array[0..MAX_PATH - 1] of AnsiChar;
    cAlternateFileName: array[0..13] of AnsiChar;
  end;

  TPluginInfo = record
    StructSize: Integer;
    Flags: DWORD;
    DiskMenuStrings: PPCharArray;
    DiskMenuNumbers: ^TIntegerArray;
    DiskMenuStringsNumber: Integer;
    PluginMenuStrings: PPCharArray;
    PluginMenuStringsNumber: Integer;
    PluginConfigStrings: PPCharArray;
    PluginConfigStringsNumber: Integer;
    CommandPrefix: PChar;
  end;

const
  DIF_NONE            =      0;
  DIF_COLORMASK       =    $ff;
  DIF_SETCOLOR        =   $100;
  DIF_BOXCOLOR        =   $200;
  DIF_GROUP           =   $400;
  DIF_LEFTTEXT        =   $800;
  DIF_MOVESELECT      =  $1000;
  DIF_SHOWAMPERSAND   =  $2000;
  DIF_CENTERGROUP     =  $4000;
  DIF_NOBRACKETS      =  $8000;
  DIF_SEPARATOR       = $10000;
  DIF_EDITOR          = $20000;
  DIF_HISTORY         = $40000;

  FMENU_SHOWAMPERSAND        = 1;
  FMENU_WRAPMODE             = 2;
  FMENU_AUTOHIGHLIGHT        = 4;
  FMENU_REVERSEAUTOHIGHLIGHT = 8;

type
  PFarDialogItem = ^TFarDialogItem;
  TFarDialogItem = record
    Typ: (
      DI_TEXT,
      DI_VTEXT,
      DI_SINGLEBOX,
      DI_DOUBLEBOX,
      DI_EDIT,
      DI_PSWEDIT,
      DI_FIXEDIT,
      DI_BUTTON,
      DI_CHECKBOX,
      DI_RADIOBUTTON);
    X1, Y1,
    X2, Y2: Integer;
    Focus: LongBool;
    Selected: Integer;
    Flags: Cardinal;
    DefaultButton: LongBool;
    Data: array[0..Pred(512)] of Char;
  end;
  PFarDialogItemsArray = ^TFarDialogItemsArray;
  TFarDialogItemsArray = array[0..0] of TFarDialogItem;

  TFarMenuItem = record
    Text: array[0..Pred(128)] of Char;
    Selected, Checked, Separator: LongBool;
  end;
  PFarMenuItemsArray = ^TFarMenuItemsArray;
  TFarMenuItemsArray = array[0..0] of TFarMenuItem;

  PPluginPanelItem = ^TPluginPanelItem;
  TPluginPanelItem = record
    FindData: TWin32FindData;
    PackSizeHigh: DWORD;
    PackSize: DWORD;
    Flags: DWORD;
    NumberOfLinks: DWORD;
    Description: PChar;
    Owner: PChar;
    CustomColumnData: PPCharArray;
    CustomColumnNumber: Integer;
    UserData : DWORD;
    Reserved: array[0..Pred(3)] of DWORD;
  end;

  PPluginPanelItemsArray = ^TPluginPanelItemsArray;
  TPluginPanelItemsArray = array[0..0] of TPluginPanelItem;

  FARAPIGETMSG = function(
    PluginNumber: Integer;
    MsgId: Integer): PChar;
    stdcall export;

  FARAPICONTROL = function(
    hPlugin: THandle;
    Command: FCTL;
    Param: Pointer): LongBool;
    stdcall export;

  FARAPIDIALOG = function(
    PluginNumber: Integer;
    X1, Y1,
    X2, Y2: Integer;
    HelpTopic: PChar;
    Item: PFarDialogItemsArray;
    ItemsNumber: Integer): Integer;
    stdcall export;

  FARAPIMENU = function(
    PluginNumber: Integer;
    X, Y: Integer;
    MaxHeight: Integer;
    Flags: Cardinal;
    Title, Bottom: PChar;
    HelpTopic: PChar;
    BreakKeys, BreakCode: PInteger;
    Item: PFarMenuItemsArray;
    ItemsNumber: Integer): Integer;
    stdcall export;

const
  FCT_DETECT = $40000000;

type
  PCharTableSet = ^TCharTableSet;
  TCharTableSet = record
    DecodeTable,
    EncodeTable,
    UpperTable,
    LowerTable : Array[0..Pred(256)] of Char;
    TableName : Array[0..Pred(128)] of Char;
  end;

  FARAPICHARTABLE = function(
    Command : Integer;
    Buffer : PChar;
    BufferSize : Integer): Integer;
    stdcall export;

const
  FMSG_NORMAL         =  0;
  FMSG_WARNING        =  1;
  FMSG_ERRORTYPE      =  2;
  FMSG_KEEPBACKGROUND =  4;
  FMSG_DOWN           =  8;
  FMSG_LEFTALIGN      = 16;

type
  FARAPIMESSAGE = function(
    PluginNumber: Integer;
    Flags: Cardinal;
    HelpTopic: PChar;
    Items: PPCharArray;
    ItemsNumber: Integer;
    ButtonsNumber: Integer): Integer;
    stdcall export;

  FARAPISAVESCREEN = function(
    X1, Y1,
    X2, Y2: Integer): THandle;
    stdcall export;

  FARAPIRESTORESCREEN = procedure(
    hScreen: THandle);
    stdcall export;

  FARAPIGETDIRLIST = function(
    Dir : PChar;
    pPanelItem : PPluginPanelItemsArray;
    pItemsNumber : PInteger): LongBool;
    stdcall export;

  FARAPIGETPLUGINDIRLIST = function(
    PluginNumber : Integer;
    hPlugin : THandle;
    Dir : PChar;
    pPanelItem : PPluginPanelItemsArray;
    pItemsNumber : PInteger): LongBool;
    stdcall export;

  FARAPIFREEDIRLIST = procedure(
    PanelItem : PPluginPanelItem);
    stdcall export;

  FARAPIVIEWER = function(
    FileName: PChar;
    Title: PChar;
    X1, Y1, X2, Y2: Integer;
    Flags: DWORD): LongBool;
    stdcall export;

  FARAPIEDITOR = function(
    FileName: PChar;
    Title: PChar;
    X1, Y1, X2, Y2: Integer;
    Flags: DWORD;
    StartLine, StartChar : Integer): Integer;
    stdcall export;

  FARAPICMPNAME = function(
    Pattern : PChar;
    Str : PChar;
    SkipPath : LongBool): LongBool;
    stdcall export;

  FARAPITEXT = procedure(
    X, Y, Color: Integer;
    Str: PChar);
    stdcall export;

  EEVENT = (EE_READ, EE_SAVE, EE_REDRAW);

  ECTL = (ECTL_GETSTRING, ECTL_SETSTRING, ECTL_INSERTSTRING, ECTL_DELETESTRING,
          ECTL_DELETECHAR, ECTL_INSERTTEXT, ECTL_GETINFO, ECTL_SETPOSITION,
          ECTL_SELECT, ECTL_REDRAW, ECTL_EDITORTOOEM, ECTL_OEMTOEDITOR,
          ECTL_TABTOREAL, ECTL_REALTOTAB, ECTL_EXPANDTABS, ECTL_SETTITLE,
          ECTL_READINPUT, ECTL_PROCESSINPUT, ECTL_ADDCOLOR, ECTL_GETCOLOR);

  FARAPIEDITORCONTROL = function(
    Command : ECTL;
    Param : Pointer): LongBool;
    stdcall export;

  PEditorGetString = ^TEditorGetString;
  TEditorGetString = record
    StringNumber : Integer;
    StringText : PChar;
    StringEOL : PChar;
    StringLength : Integer;
    SelStart, SelEnd : Integer;
  end;

  PEditorSetString = ^TEditorSetString;
  TEditorSetString = record
    StringNumber : Integer;
    StringText : PChar;
    StringEOL : PChar;
    StringLength : Integer;
  end;

  PEditorColor = ^TEditorColor;
  TEditorColor = record
    StringNumber,
    ColorItem,
    StartPos,
    EndPos,
    Color: Integer;
  end;

const
  EOPT_NORMAL           =  0;
  EOPT_EXPANDTABS       =  1;
  EOPT_PERSISTENTBLOCKS =  2;
  EOPT_DELREMOVESBLOCKS =  4;
  EOPT_AUTOINDENT       =  8;
  EOPT_SAVEFILEPOSITION = 16;
  EOPT_AUTODETECTTABLE  = 32;
  EOPT_CURSORBEYONDEOL  = 64;

type
  BTYPE = (BTYPE_NONE, BTYPE_STREAM, BTYPE_COLUMN);

  PEditorInfo = ^TEditorInfo;
  TEditorInfo = record
    EditorID : Integer;
    FileName : PChar;
    WindowSizeX,
    WindowSizeY : Integer;
    TotalLines,
    CurLine,
    CurPos,
    CurTabPos,
    TopScreenLine,
    LeftPos : Integer;
    Overtype : LongBool;
    BlockType : BTYPE;
    BlockStartLine,
    AnsiMode,
    TableNum : Integer;
    Options : DWORD;
    TabSize : Integer;
    Reserved : Array[0..Pred(8)] of DWORD;
  end;

  PEditorSetPosition = ^TEditorSetPosition;
  TEditorSetPosition = record
    CurLine,
    CurPos,
    CurTabPos,
    TopScreenLine,
    LeftPos: Integer;
    Overtype: LongBool;
  end;

  PEditorSelect = ^TEditorSelect;
  TEditorSelect = record
    BlockType : BTYPE;
    BlockStartLine,
    BlockStartPos,
    BlockWidth,
    BlockHeight : Integer;
  end;

  PEditorConvertText = ^TEditorConvertText;
  TEditorConvertText = record
    Text : PChar;
    TextLength : Integer;
  end;

  PEditorConvertPos = ^TEditorConvertPos;
  TEditorConvertPos = record
    StringNumber,
    SrcPos,
    DestPos : Integer;
  end;

  TPluginStartupInfo = record
    StructSize: Integer;
    ModuleName: array[0..Pred(NM)] of Char;
    ModuleNumber: Integer;
    RootKey: PChar;
    Menu: FARAPIMENU;
    Dialog: FARAPIDIALOG; 
    Message: FARAPIMESSAGE;
    GetMsg: FARAPIGETMSG;
    Control: FARAPICONTROL;
    SaveScreen: FARAPISAVESCREEN;
    RestoreScreen: FARAPIRESTORESCREEN;
    GetDirList: FARAPIGETDIRLIST;
    GetPluginDirList: FARAPIGETPLUGINDIRLIST;
    FreeDirList: FARAPIFREEDIRLIST;
    Viewer: FARAPIVIEWER;
    Editor: FARAPIEDITOR;
    CmpName: FARAPICMPNAME;
    CharTable: FARAPICHARTABLE;
    Text: FARAPITEXT;
    EditorControl: FARAPIEDITORCONTROL;
  end;

  TInfoPanelLine = record
    Text: array[0..Pred(80)] of Char;
    Data: array[0..Pred(80)] of Char;
    Separator: LongBool;
  end;
  TInfoPanelLinesArray = array[0..0] of TInfoPanelLine;

  TPanelMode = record
    ColumnTypes: PChar;
    ColumnWidths: PChar;
    ColumnTitles: PPCharArray;
    FullScreen: LongBool;
    DetailedStatus: LongBool;
    AlignExtensions: LongBool;
    CaseConversion: LongBool;
    StatusColumnTypes : PChar;
    StartusColumnWidth :  PChar;
    Reserved: array[0..Pred(2)] of DWORD;
  end;
  TPanelModesArray = array[0..0] of TPanelMode;

  TKeyBarTitles = record
    Titles,
    CtrlTitles,
    AltTitles,
    ShiftTitles: array[0..Pred(12)] of PChar;
  end;

  TOpenPluginInfo = record
    StructSize: Integer;
    Flags: DWORD;
    HostFile: PChar;
    CurDir: PChar;
    Format: PChar;
    PanelTitle: PChar;
    InfoLines: ^TInfoPanelLinesArray;
    InfoLinesNumber: Integer;
    DescrFiles: PPCharArray;
    DescrFilesNumber: Integer;
    PanelModesArray: ^TPanelModesArray;
    PanelModesNumber: Integer;
    StartPanelMode: Integer;
    StartSortMode: OPENPLUGININFO_SORTMODES;
    StartSortOrder: Integer;
    KeyBar: ^TKeyBarTitles;
    ShortcutData: PChar;
  end;

  TPanelInfo = record
    PanelType: (PTYPE_FILEPANEL, PTYPE_TREEPANEL, PTYPE_QVIEWPANEL, PTYPE_INFOPANEL);
    Plugin: LongBool;
    PanelRect: TRect;
    PanelItems: PPluginPanelItemsArray;
    ItemsNumber: Integer;
    SelectedItems: PPluginPanelItemsArray;
    SelectedItemsNumber: Integer;
    CurrentItem: Integer;
    TopPanelItem: Integer;
    Visible: LongBool;
    Focus: LongBool;
    ViewMode: Integer;
    ColumnTypes: array[0..Pred(80)] of Char;
    ColumnWidths: array[0..Pred(80)] of Char;
    CurDir: array[0..Pred(NM)] of Char;
    ShortNames: LongBool;
    SortMode: OPENPLUGININFO_SORTMODES;
    Reserved: array[0..Pred(2)] of DWORD;
  end;

  TPanelRedrawInfo = record
    CurrentItem : Integer;
    TopPanelItem : Integer;
  end;

var
  Info: TPluginStartupInfo;
  OnStartupInfoLoad: procedure;

function GetMsg(MsgId: TMessageNumber): PChar;
function Message(
  Flags: DWORD;
  HelpTopic: PChar;
  AItems: array of const;
  ButtonsNumber: Integer): Integer;

function Dialog(
  HelpTopic: PChar;
  AItems: array of const): Integer;

function StrLen(Str: PChar): Cardinal; assembler;
function StrCat(Dest, Source: PChar): PChar;


procedure SetRegKey(hRoot: HKEY; Key, ValueName: string; var ValueData; ValueSize: integer);
function GetRegKey(hRoot: HKEY; Key, ValueName: string; var ValueData; ValueSize: integer): Boolean; //overload;
function GetRegKeyI(hRoot: HKEY; Key, ValueName: string; Def: integer): integer; //overload;


var PluginRootKey: String;

implementation

procedure SetStartupInfo(var AInfo: TPluginStartupInfo)
  stdcall export;
begin
  Info := AInfo;

  if Assigned(OnStartupInfoLoad) then
    OnStartupInfoLoad;
end;


function GetMsg; 
begin
  with Info do
    Result := GetMsg(ModuleNumber, Integer(MsgId));
end;

function Message;
var
  Items: PPCharArray;
  ItemsNumber: Integer;
  I: Integer;
begin
  ItemsNumber := High(AItems)+1;
  GetMem(Items, SizeOf(PChar)*ItemsNumber);

  for I := 0 to High(AItems) do
    with AItems[I] do
      case VType of
        vtInteger: Items^[I] := GetMsg(TMessageNumber(VInteger));
        vtPChar: Items^[I] := VPChar;
        vtAnsiString: Items^[I] := VAnsiString;
        else{nil} Items^[I] := ' ';
      end;


  with Info do
    Result := Message(ModuleNumber,
      Flags,
      HelpTopic,
      Items,
      ItemsNumber,
      ButtonsNumber);

  FreeMem(Items);
end;

function StrLen(Str: PChar): Cardinal; assembler;
asm
        MOV     EDX,EDI
        MOV     EDI,EAX
        MOV     ECX,0FFFFFFFFH
        XOR     AL,AL
        REPNE   SCASB
        MOV     EAX,0FFFFFFFEH
        SUB     EAX,ECX
        MOV     EDI,EDX
end;

function StrCopy(Dest, Source: PChar): PChar; assembler;
asm
        PUSH    EDI
        PUSH    ESI
        MOV     ESI,EAX
        MOV     EDI,EDX
        MOV     ECX,0FFFFFFFFH
        XOR     AL,AL
        REPNE   SCASB
        NOT     ECX
        MOV     EDI,ESI
        MOV     ESI,EDX
        MOV     EDX,ECX
        MOV     EAX,EDI
        SHR     ECX,2
        REP     MOVSD
        MOV     ECX,EDX
        AND     ECX,3
        REP     MOVSB
        POP     ESI
        POP     EDI
end;

function StrEnd(Str: PChar): PChar; assembler;
asm
        MOV     EDX,EDI
        MOV     EDI,EAX
        MOV     ECX,0FFFFFFFFH
        XOR     AL,AL
        REPNE   SCASB
        LEA     EAX,[EDI-1]
        MOV     EDI,EDX
end;

function StrCat(Dest, Source: PChar): PChar;
begin
  StrCopy(StrEnd(Dest), Source);
  Result := Dest;
end;

function Dialog;
var
  Items: PFarDialogItemsArray;
  ItemsNumber: Integer;
var
  CurrentItem: Integer;

  function Next: TVarRec;
  begin
    Result := AItems[CurrentItem];
    Inc(CurrentItem);
  end;

  procedure SetData;
  const
    ElementsPerItem = 8;
  var
    I: Integer;
    TotalElements: Integer;
    DefaultButtonNotAssigned: Boolean;
  begin
    TotalElements := High(AItems)+1;
    ItemsNumber := TotalElements div ElementsPerItem;
    GetMem(Items, SizeOf(TFarDialogItem)*ItemsNumber);

    CurrentItem := 0;
    DefaultButtonNotAssigned := True;
    for I := 0 to Pred(ItemsNumber) do
      with Items^[I] do
      begin
        Integer(Typ) := Next.VInteger;
        X1 := Next.VInteger; Y1 := Next.VInteger;
        X2 := Next.VInteger; Y2 := 0;
        Focus := Next.VBoolean;
        with Next do
          case VType of
            vtBoolean: Selected := Integer(VBoolean);  // 1
            vtPointer: Selected := Integer(Boolean(VPointer^)); //2  1,2  checkbox
            vtPChar: Selected := Integer(VPChar); // history
          end;
        Flags := Next.VInteger;
        DefaultButton := False;
        if Typ = DI_BUTTON then
        begin
          DefaultButton := DefaultButtonNotAssigned;
          DefaultButtonNotAssigned := False;
        end;
        with Next do
        begin
          FillChar(Data, SizeOf(Data), 0);
          case VType of
            vtInteger: StrCopy(Data, GetMsg(TMessageNumber(VInteger)));
//            vtPChar: StrCopy(Data, VPChar);
//            vtAnsiString: StrCopy(Data, VAnsiString);
            vtPointer: if Assigned(VPointer) then StrCopy(Data, PChar(PString(VPointer)^));
          end;
        end;
      end;
  end;

  procedure GetData;
  var
    I: Integer;
  begin
    CurrentItem := 0;
    for I := 0 to Pred(ItemsNumber) do
      with Items^[I] do
      begin
        {Integer(Typ) := }Next{.VInteger};
        {X1 := }Next{.VInteger}; {Y1 := }Next{.VInteger};
        {X2 := }Next{.VInteger}; {Y2 := 0;}
        {Focus := }Next{.VBoolean};
        with Next do
          case VType of
{            vtBoolean: Selected := VBoolean;}
            vtPointer: Boolean(VPointer^) := Boolean(Selected);
          end;
        {Flags := }Next{.VInteger};
        with Next do
          case VType of
//            vtInteger: StrCopy(Data, GetMsg(TMessageNumber(VInteger)));
//            vtPChar: StrCopy(Data, VPChar);
//            vtAnsiString: StrCopy(Data, VAnsiString);
            vtPointer: if Assigned(VPointer) then PString(VPointer)^ := Data;
//            else{nil} FillChar(Data, SizeOf(Data), 0);
          end;
      end;

    FreeMem(Items);
  end;

  function FirstButtonIndex: Integer;
  var
    I: Integer;
  begin
    for I := 0 to Pred(ItemsNumber) do
      if Items[I].Typ = DI_BUTTON then
      begin
        FirstButtonIndex := I;
        Exit;
      end;
    Result := 0;
  end;

var
  FirstX,
  LastY: Integer;
begin
  SetData;

  FirstX := Items^[0].X2;
  LastY := Items^[Pred(ItemsNumber)].Y1;

  with Items^[0] do
  begin
    Y1 := 1;
    Y2 := LastY+1;
  end;
  with Info do
    Result := Dialog(ModuleNumber,
      -1, -1,
      FirstX+2*2, LastY+3,
      HelpTopic,
      Items,
      ItemsNumber);

  if Result <> -1 then
    GetData;
end;

function StrLCopy(Dest, Source: PChar; MaxLen: Cardinal): PChar; assembler;
asm
        PUSH    EDI
        PUSH    ESI
        PUSH    EBX
        MOV     ESI,EAX
        MOV     EDI,EDX
        MOV     EBX,ECX
        XOR     AL,AL
        TEST    ECX,ECX
        JZ      @@1
        REPNE   SCASB
        JNE     @@1
        INC     ECX
@@1:    SUB     EBX,ECX
        MOV     EDI,ESI
        MOV     ESI,EDX
        MOV     EDX,EDI
        MOV     ECX,EBX
        SHR     ECX,2
        REP     MOVSD
        MOV     ECX,EBX
        AND     ECX,3
        REP     MOVSB
        STOSB
        MOV     EAX,EDX
        POP     EBX
        POP     ESI
        POP     EDI
end;

function StrPCopy(Dest: PChar; const Source: string): PChar;
begin
  Result := StrLCopy(Dest, PChar(Source), Length(Source));
end;

function CreateRegKey(hRoot: HKEY; const Key: string): HKEY;
var nKey: HKEY;
    Disposition: DWORD;
    FullKeyName: array[0..79] of Char;
begin
  if Key <> '' then RegCreateKeyEx(hRoot, StrPCopy(FullKeyName, PluginRootKey+'\Key'), 0, Nil, 0, KEY_WRITE, Nil, nKey, @Disposition)
    else RegCreateKeyEx(hRoot, StrPCopy(FullKeyName, PluginRootKey), 0, Nil, 0, KEY_WRITE, Nil, nKey, @Disposition);
  Result:=nKey;
end;

function OpenRegKey(hRoot: HKEY; Key: string): HKEY;
var nKey: HKEY;
    FullKeyName: array[0..79] of Char;
begin
  if Key <> '' then
    begin
      if RegOpenKeyEx(hRoot, StrPCopy(FullKeyName, PluginRootKey+'\Key'), 0, KEY_QUERY_VALUE, nKey) <> ERROR_SUCCESS then
        Result:=0
      else Result:=nKey;
    end
  else
    begin
      if RegOpenKeyEx(hRoot, StrPCopy(FullKeyName, PluginRootKey), 0, KEY_QUERY_VALUE, nKey) <> ERROR_SUCCESS then
        Result:=0
      else Result:=nKey;
    end;
end;

procedure SetRegKey(hRoot: HKEY; Key, ValueName: string; var ValueData; ValueSize: integer);
var nKey: HKEY;
    Name: array[0..80] of Char;
begin
  nKey:=CreateRegKey(hRoot, Key);
  RegSetValueEx(nKey, StrPCopy(Name, ValueName), 0, REG_DWORD, @ValueData, ValueSize);
  RegCloseKey(nKey);
end;

function GetRegKey(hRoot: HKEY; Key, ValueName: string; var ValueData; ValueSize: integer): Boolean; //overload;
var nKey: HKEY;
    Name: array[0..80] of Char;
    Typ: DWORD;
    ExitCode: Integer;
begin
  nKey:=OpenRegKey(hRoot, Key);
  ExitCode:=RegQueryValueEx(nKey, StrPCopy(Name, ValueName), Nil, @Typ, @ValueData, @ValueSize);
  RegCloseKey(nKey);
  if (nKey = 0) or (ExitCode <> ERROR_SUCCESS) then Result:=False
    else Result:=True;
end;

function GetRegKeyI(hRoot: HKEY; Key, ValueName: string; Def: integer): integer; //overload;
var ValueData: Integer;
begin
  if GetRegKey(hRoot, Key, ValueName, ValueData, SizeOf(ValueData)) then Result:=ValueData
    else Result:=Def;
end;

exports
  SetStartupInfo;

end.
