{
 Program: KD.PAS  ver 2.4
  Author: Eric E. A. Schreiber
    Date: April 11, 1998
Function: Kill Directory
   Notes: Includes DOD filewipe option and
          expanded features on command line
}

Program KD;

Uses Crt, Dos;

Const
  TotalDir   : Integer = 0;      { * Total directories removed counter   * }
  TotalFiles : Integer = 0;      { * Total files deleted counter         * }
  DiskSpace  : LongInt = 0;      { * Original space free before running  * }
  AskFirst   : Boolean = True;   { * Ask for verification before killdir * }
  DODWipe    : Boolean = False;  { * Dept of Defense file wipe flag      * }
  QuietMode  : Boolean = False;  { * Supress screen output if true       * }
  LF         = #13#10;           { * Carriage return & line feed         * }

Var
  KillDir,                       { * Directory to kill specified by user * }
  StartDir,                      { * Starting directory to return to     * }
  LastDir  : String;             { * Last directory stepped back out of  * }
  Response : Char;               { * Y/N response to continue question   * }


{ **** Return to start directory and halt **** }
procedure Stop;
begin

  Writeln;
  {$I-} ChDir (StartDir); {$I+}  { * Return to original directory * }
  if IOResult <> 0
    then Halt                    { * Handle StartDir = KillDir    * }
    else Halt;

end;


{ **** Help/Info screen **** }
procedure HelpScreen;
begin

  Write(LF + 'KD - Kobayashi Kill Directory version 2.4' + LF +
        '     Copyright (c) 1992, 1998 by Eric Schreiber.' + LF +
        '     All rights reserved.' + LF);
  Write('     KD removes specified directory and all its subdirectories' + LF +
        '     and files, including hidden, system, and read-only files.' + LF + LF);
  Write('Usage:' + LF +
        '     KD <directory> [/W] [/Q] [/D]' + LF + LF +
        '     <directory> is the name of the directory to kill' + LF +
        '     [/W] turns on DOD security wipe - files are overwritten' + LF +
        '     [/Q] enables quiet mode - screen output is turned off' + LF);
  Write('     [/D] don''t require verification before deleting directory'+ LF);
  Stop;

end;


{ **** Comma string from any integer **** }
function IntToCommaStr (N : Longint) : String;
var
  W: String[14];
  I: Byte;
  D: Byte;

begin

  Str(N,W);
  D := Length (W);
  For I := 3 to (D - 1) do
    If I mod 3 = 0 then Insert (',', W, (D - I + 1));
  IntToCommaStr := W;

end;


{ **** Extract drive from path string **** }
function File_Drive (Full: string): string;
var
  P : Byte;

begin

  P := Pos(':', Full);
  if P <> 2
    then File_Drive := ''
    else File_Drive := (Full[1]);

end;


{ **** Finds and returns current directory **** }
function CurrentDir: String;
var
  CurrDir: String;

begin

  GetDir (0, CurrDir);
  CurrentDir := CurrDir;

end;


{ **** Convert string to uppercase **** }
function UpperCase (S: String): String;
var
  I : Integer;

begin

  for I := 1 to Length (S) do S[I] := UpCase (S[I]);
  UpperCase := S;

end;


{ **** Dept. Of Defense file wipe routine **** }
procedure FileWipe (Var F : File; C : Char);
var
  I : Integer;
  R : Word;

begin

  Reset (F, 1);
  For I := 1 to FileSize (F) do BlockWrite (F, C, FileSize (F), R);
  Close (F);

end;


{ **** Deletes files in current directory **** }
procedure DeleteFiles;
var
  I        : LongInt;
  Pass     : Byte;
  FileInfo : SearchRec;
  FileRef  : File;
  R,
  OldAttr,
  NewAttr  : Word;
  Ch       : Byte;

begin

  FindFirst ('*.*', (AnyFile - Directory), FileInfo);
  While DosError = 0 do
  Begin

    Assign (FileRef, FileInfo.Name);

    { *** Assure no problematic attributes *** }
    GetFAttr (FileRef, OldAttr);
    if OldAttr and ReadOnly <> 0 then
    begin

      if not QuietMode
      then Writeln ('Changing Attribute: ' + CurrentDir + '\' + FileInfo.Name);

      NewAttr := OldAttr and $FE;
      SetFAttr (FileRef, NewAttr);

    end;

    { *** Overwrite and erase files if paramStr(2) = /W *** }
    if DODWipe then
    begin

      if not QuietMode then
        Writeln ('       Wiping File: ' + CurrentDir + '\' + FileInfo.Name);
      for Pass := 1 to 3 do
      begin

        FileWipe (FileRef, #0);
        FileWipe (FileRef, #1);

      end;

      Randomize;
      Reset (FileRef, 1);

      for I := 1 to FileSize (FileRef) do
      begin

        Ch := Random(74) + 48; { ** Alphanumeric only ** }
        BlockWrite (FileRef, Ch, 1, R);

      end;

      Close (FileRef);

    end;

    if not QuietMode
    then Writeln ('     Deleting File: ' + CurrentDir + '\' + FileInfo.Name);

    Erase (FileRef);
    TotalFiles := TotalFiles + 1;
    FindNext (FileInfo);

  end;

end;


{ **** Recurse to bottom of directory structure **** }
procedure GoBottom;
var
  FileInfo : SearchRec;
  FileRef  : File;

begin

  FindFirst ('*.*', Directory, FileInfo);

  While DosError = 0 do
  begin

    if ((FileInfo.Attr = 16) and (FileInfo.Name[1] <> '.')) then
    begin

      ChDir (FileInfo.Name);
      GoBottom;

    end
    else FindNext (FileInfo);

  end;

end;


{ **** Tests for root specified as KillDir **** }
procedure Test (KillDir: String);
begin

  if (Length (KillDir) = 3) and (KillDir[3] = '\') then
  begin

    if not QuietMode
    then Writeln ('Cannot kill root directory ', KillDir);
    Stop;

  end;

end;


{ **** Set options from command line switches **** }
procedure ParseCommandLine;
var
  Q       : Word;   { ** Parameter counter ** }
  TestStr : String; { ** Working parameter string ** }

begin

  if ParamCount = 0
  then HelpScreen;

  TestStr := UpperCase (ParamStr(1));

  if TestStr[1] in ['?', '/', '-']
  then HelpScreen
  else KillDir := TestStr;

  if ParamCount > 1 then
  for Q := 2 to ParamCount do
  begin
    TestStr := UpperCase (ParamStr(Q));
    if TestStr[1] in ['/', '-'] then
      case TestStr[2] of
        'W' : DODWipe   := True;
        'Q' : QuietMode := True;
        'D' : AskFirst  := False;
      end; { case }

  end;

end;


{ **** Main Line **** }
begin

  StartDir := CurrentDir;
  ParseCommandLine;
  if not QuietMode
  then Writeln;

  { *** Assign and test KillDir variable *** }
  {$I-} Chdir (KillDir); {$I+}
  if IOResult <> 0 then
  begin

    if not QuietMode
    then Write ('Directory ', KillDir, ' not found');
    Stop;

  end;

  { *** Verify with user before continuing *** }
  if AskFirst then
  begin

    Writeln ('Are you SURE you want to delete this directory?');
    Write   ('Press ''Y'' to continue, any other key to abort: ');
    Response := Upcase (ReadKey);
    Writeln (Response);

    if Response <> 'Y'
    then Stop;

  end;

  if not QuietMode
  then Writeln;

  { *** Get Current Disk Space *** }
  DiskSpace := DiskFree (0);
  KillDir := CurrentDir;

  { *** Verify KillDir is not Root Dir *** }
  Test (KillDir);

  { *** Main loop *** }
  repeat

    GoBottom;
    DeleteFiles;
    LastDir := CurrentDir;
    ChDir ('..');
    if not QuietMode
    then Writeln ('Removing Directory: ', LastDir);

    {$I-}  RmDir (LastDir);  {$I+}
    if IOResult <> 0 then
    begin

      if not QuietMode
      then Write ('Error removing directory ' + LastDir +
               '.  Look for Hidden Directory attributes');
      Stop;

    end
    else TotalDir := TotalDir + 1;

  until (LastDir = KillDir);
  { *** End main loop *** }

  { *** Totals Output *** }
  if not QuietMode then
  begin

    Writeln (LF +'Total Directories Removed: ', TotalDir);
    Writeln (    '      Total Files Deleted: ', TotalFiles);
    Writeln (    '    Total Space Recovered: ', +
      IntToCommaStr (DiskFree(0)-DiskSpace),' bytes');

  end;

  { *** Return to starting directory or nearest *** }
  Stop;

end.
