        PAGE    60,132
NAME    IsWin
        TITLE   IsWin Version 1.2
COMMENT 

IsWin C:MyProg.Exe
Detect if program is a Windows GUI program.
  IsWin C:MyProg.Exe
  If ErrorLevel 2 GoTo Problem
  If ErrorLevel 1 GoTo IsForWindows
  Goto IsDosProg

This code is based EXE header layouts documented in Volume 4 of
the Microsoft Windows Development kit.

A Windows GUI program has the following characteristics:
1. "MZ" at offset 0.  (also true of MS DOS EXE files.)
2. word at offset 18h is 40h or greater.
   This points to the first relocation item.
3. The word at offset 3Ch is the offset to the windows header.
4. At offset 0 of the windows header is the signature "NE".


Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


Version 1.1 1996 October 25
- embed POB 707 Quathiaski Cove address

Futures
- echo result to screen
- display syntax info if user enters a blank command line.

       ; end of comment

;======
stack   segment stack           ; keep MS link happy by providing null stack
stack   ends

;==============================================================

CODE    SEGMENT PARA            ; start off in code.

;==============================================================

data    segment word            ; provide a separate DATA segment
                                ; Even though it appears in the source
                                ; before the code, it the COM file it


;=============================================
;       E R R O R   M E S S A G E S
;=============================================

Buffer  DW      0

CopyrightMsg    label   byte
        db 13,10
        db      ' IsWin 1.2 ۲',13,10
        db      'Determines if the specified program is a Windows GUI program.',13,10
        DB      'Copyright 1993-1999 Roedy Green Canadian Mind Products 1993,1996.',13,10
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        db      'May be freely distributed and used for any purpose except military.',13,10
        db      13,10
 db 'Error in command line.  Try:',13,10
 db '  IsWin C:MyProg.Exe',13,10
 db '  If ErrorLevel 2 GoTo Problem',13,10
 db '  If ErrorLevel 1 GoTo IsForWindows',13,10
 db '  Goto IsDosProg',13,10,'$'


data    endS

;==============================================================

com     group   code,data

        ASSUME  CS:COM,DS:COM,ES:NOTHING
        ORG     100H
Start:
        Call    Parse           ; prepare the command line
        jcxz    Failed

        Call    TestIsWin

        mov     ah,4ch          ; exit back to DOS
        int     21h


Failed:
        lea     dx,Copyrightmsg
        call    say
        mov     ax,4c02h        ; exit back to DOS with error code 2
        int     21h

;==============================================================

TestIswin       proc    Near
;       ES:bx cx points to ASCIIZ filename.
;       an exit ax=0 -- ordinary file, poss com, exe
;                  1 -- windows file
;                  2 -- no such prog
        mov     dx,bx           ; DS:dx points to filename
        mov     ax,3d40h        ; open 0 100 0 000 mode deny none, readonly
        int     21h
        jc      NoSuchProg

; ------------------------------ READ THE MZ
        mov     bx,ax           ; handle
        mov     cx,2            ; read two bytes
        lea     dx,Buffer
        mov     ah,3fh          ; read operation
        int     21h
        cmp     ax,cx
        jne     OrdinaryProg

        cmp     Buffer,5A4Dh    ; is it MZ signature?
        jne     OrdinaryProg

; ------------------------------ READ POINTER AT 18H

        mov     ax,4200h        ; lseek from start
        mov     dx,18h          ; offset CX:DX
        mov     cx,0
        int     21h
        jc      OrdinaryProg

        mov     cx,2            ; read two bytes
        lea     dx,Buffer
        mov     ah,3fh          ; read operation
        int     21h
        cmp     ax,cx
        jne     OrdinaryProg
        cmp     Buffer,40h      ; should be >= 40h
        jb      OrdinaryProg

; ------------------------------ READ POINTER AT 3Ch

        mov     ax,4200h        ; lseek from start
        mov     dx,3ch          ; offset CX:DX
        mov     cx,0
        int     21h
        jc      OrdinaryProg

        mov     cx,2            ; read two bytes
        lea     dx,Buffer
        mov     ah,3fh          ; read operation
        int     21h
        cmp     ax,cx
        jne     OrdinaryProg    ; Will point to Windows header.

; ------------------------------ READ POINTER NE SIGNATURE usually at 400h


        mov     ax,4200h        ; lseek from start
        mov     dx,Buffer       ; offset CX:DX
        mov     cx,0
        int     21h
        jc      OrdinaryProg

        mov     cx,2            ; read two bytes
        lea     dx,Buffer
        mov     ah,3fh          ; read operation
        int     21h
        cmp     ax,cx
        jne     OrdinaryProg

        cmp     buffer,454Eh    ; is in 'NE' signature
        jne     OrdinaryProg

WindowsProg:
        mov     ax,1
        ret

OrdinaryProg:
        mov     ax,0
        ret

NoSuchProg:
        mov     ax,2
        ret

TestIswin       EndP

;=============================================
;       C O M M A N D   L I N E   P A R S I N G   R O U T I N E S
;=============================================

MLeading        PROC    Near

;       Remove leading blanks
;       on entry ES:BX is addr of string, CX its length
;       trims off any leading blanks, leaving result in ES:BX CX
;       length may also be 0 or 1, but not -ve
;       If the entire string is blank the result is the null string

        mov     di,bx
        mov     al,20H          ; AL = blank  -- the search char
        jcxz    mleading2       ; jump if null string
        repe    scasb           ; scan ES:DI forwards till hit non blank
                                ; DI points just after it (wrap ok)
                                ; cx IS ONE TOO SMALL, OR 0 IF NONE FOUND
        je      mleading1       ; jump if entire string was blank
        inc     cx              ; CX is length of remainder of string
mleading1:
        dec     di              ; DI points to non-blank
mleading2:
        mov     bx,di           ; put address back
        ret

MLeading        ENDP

;========================================

MTrailing       PROC    Near

;       Remove trailing blanks.
;       on entry ES:BX is addr of string, CX its length
;       trims off any trailing blanks, leaving result in BX CX
;       length may also be 0 or 1, but not -ve
;       If the entire string is blank the result is the null string

        mov     di,bx
        add     di,cx           ; calc addr last char in string
        dec     di
        mov     al,20H          ; AL = blank  -- the search char
        jcxz    mtrailing1      ; jump if null string
        std
        repe    scasb           ; scan ES:DI backwards till hit non blank
                                ; DI points just ahead of it (wrap ok)
                                ; CX is one too small, or 0 if none found
        cld
        je      mtrailing1      ; jump if whole string was blank
        inc     cx
mtrailing1:
        ret

MTrailing       ENDP

;========================================

Parse           PROC    NEAR
;       Parse the command line to remove lead/trail blanks from
;       the single drive parameter and terminate it by 2 nulls.
;       sample inputs
;       IsWin A:MyFile.exe
;       IsWin   C:MyFile.exe
;       IsWin
;       ES: points to PSP
;       When Done ES:BX points to start of string.
;       String will be terminated by 2 nulls
;       CX counts bytes in string exclusive of nulls
                                ; counted string at HEX 80 PSP
                                ; contains command line.
                                ; Preceeded by unwanted spaces.
                                ; possibly followed by unwanted spaces.
                                ; currently missing a trailing null.
        xor     ch,ch
        mov     cl,es:[80H]
        mov     bx,81H
        call    Mleading        ; get rid of leading blanks
        call    MTrailing       ; get rid of trailing blanks
        mov     di,bx           ; calc addr of byte just past end
        add     di,cx
        mov     word ptr ES:[di],0 ; plop in pair of nulls after string
        ret

Parse           ENDP

;======================================

Say             Proc    Near
;       on entry DX points to a string to display on screen
        MOV     AH,9
        Int     21h
        ret
Say             EndP

;=======================================

CODE ends
end start
