/*

   CDIRENT.H

   (c) 1996 Oliver Kraus

   UNIX compatible directory/file access

*/

#ifndef _CDIRENT_H
#define _CDIRENT_H

struct c_dirent
{
   unsigned long  d_size;     /* file-size */
   unsigned long  d_ino;      /* directory file number */
   unsigned long  d_off;      /* offset of the next non empty directory */
   unsigned short d_reclen;   /* size of the current dirent record */
   short          d_is_dir;
   char           d_short_name[14];  /* old MSDOS 8.3 filenames */
   char           d_name[1];  /* at most MAXNAMLEN characters */
};

struct _CDIR_struct
{
   char *path;
   char *pat;
   char *ptr;
   size_t pos;
   size_t max;
   size_t cnt;
   int (*patmat_fn)(char *, char *);
   int options;
};
typedef struct _CDIR_struct CDIR;

#define CDIR_MATCH_CASE (0x0001)
#define CDIR_MATCH_ALL   (0x0002)

char *c_strupr(char *s);
CDIR *c_opendir(const char *path, const char *pat, int options);
int c_closedir(CDIR *dirp);
struct c_dirent *c_readdir(CDIR *dirp);
void c_rewinddir(CDIR *dirp);
long c_telldir(CDIR *dirp);
void c_seekdir(CDIR *dirp, long pos);

#define c_is_dir(dirent) ((dirent)->d_is_dir)
#define c_get_name(dirent) ((dirent)->d_name)
#define c_get_short_name(dirent) ((dirent)->d_short_name)

char *c_strupr(char *s);
int patmat(char *raw, char *pat);
int upatmat(char *raw, char *pat);


#endif
