class TMenu
{
protected:
  HANDLE hDlg;
  long Param;
  char *Title, *Bottom;
  int Count/*, MaxItemWidth*/;
  COORD Console;

  BYTE ColorDlgList[10];
  BYTE ColorDialog;

  static long WINAPI DlgProc(HANDLE hDlg, int Msg, int Param1, long Param2);
  void ResizeConsole();
  void InsItem(int Index, char *Text);
  void DelItem(int Index);

  virtual void Init();
  //GCC    㠫 㭪権 (+7Kb  ࠧ )
  virtual long KeyPress(long Key, int Pos)/*=0;*/{ return FALSE; }
  virtual int Close(int Index)/*=0;*/{ return FALSE; }
public:
  int Run(char *Title, char *Bottom, long Param);
};

long WINAPI TMenu::DlgProc(HANDLE hDlg, int Msg, int Param1, long Param2)
{
  static TMenu *This;
  switch(Msg)
  {
    case DN_INITDIALOG:
      This=(TMenu *)Param2;
      This->hDlg=hDlg;
      This->Init();
      return TRUE;
    case DN_CTLCOLORDIALOG:
      return This->ColorDialog;
#if FARMANAGERVERSION>MAKEFARVERSION(1,70,1282)
    case DN_CTLCOLORDLGLIST:
      if(FarVersion!=MAKEFARVERSION(1, 70, 1282))
      {
        FarListColors *flc=(FarListColors *)Param2;
        flc->Flags=flc->Reserved=0;
        flc->ColorCount=sizeof(This->ColorDlgList);
        flc->Colors=This->ColorDlgList;
        return TRUE;
      }
      return FALSE;
#endif
    case DN_KEY:
    {
      FarListPos flp;
      Info.SendDlgMessage(hDlg, DM_LISTGETCURPOS, 0, (long)&flp);
      return This->KeyPress(Param2, flp.SelectPos);
    }
    case DN_RESIZECONSOLE:
      This->Console=*((COORD *)Param2);
      This->ResizeConsole();
      return TRUE;
  }
  return Info.DefDlgProc(hDlg, Msg, Param1,Param2);  
}

void TMenu::ResizeConsole()
{
  int MaxItemWidth=max(lstrlen(Title), lstrlen(Bottom));
  if(MaxItemWidth)
    MaxItemWidth--;
  FarListGetItem List;
  for(List.ItemIndex=0; List.ItemIndex<Count; List.ItemIndex++)
  {
    Info.SendDlgMessage(hDlg, DM_LISTGETITEM, 0, (long)&List);
    MaxItemWidth=max(lstrlen(List.Item.Text), MaxItemWidth);
  }
    
  int Height=min(Console.Y-2-4, Count);
  int Width=min(Console.X-3-6, MaxItemWidth);
  FarDialogItem Item;
  Info.SendDlgMessage(hDlg, DM_GETDLGITEM, 0, (long)&Item);
  Item.X2=Width+3+3;
  Item.Y2=Height+2;
  //⪫ DIF_LISTWRAPMODE   ᯨ᪮
  Info.SendDlgMessage(hDlg, DM_SETDLGITEM, 0, (long)&Item);
  COORD c;
  c.X=Width+3+6;
  c.Y=Height+4;
  Info.SendDlgMessage(hDlg, DM_RESIZEDIALOG, 0, (long)&c);
  c.X=c.Y=-1;
  Info.SendDlgMessage(hDlg, DM_MOVEDIALOG, TRUE, (long)&c);
}

void TMenu::InsItem(int Index, char *Text)
{
  FarListInsert fli/*={Index, {0, "", 0,0,0}}*/;
  fli.Index=Index;
  FarListItem& Item=fli.Item;
  Item.Flags=*Item.Reserved=Item.Reserved[1]=Item.Reserved[2]=0;

  FSF.TruncPathStr(Text, min(Console.X-8, 127));
  lstrcpy(fli.Item.Text, Text);
/*if(*Text && Index<10)
wsprintf(fli.Item.Text, "&%d  %s", Index, Text);
else
wsprintf(fli.Item.Text, "   %s", Text);*/
  Info.SendDlgMessage(hDlg, DM_LISTINSERT, 0, (long)&fli);
  Count++;
}

void TMenu::DelItem(int Index)
{
  FarListDelete fld={Index, 1};
  Info.SendDlgMessage(hDlg, DM_LISTDELETE, 0, (long)&fld);
  Count--;
}

int TMenu::Run(char *Title, char *Bottom, long Param/*char *Param*/)
{
  this->Param=Param;
  this->Title=Title;
  this->Bottom=Bottom;
  Count=0;

  //??  ࠧ ᮫쭮 
  Console.X=80;
  Console.Y=25;
  
  InitDialogItem InitItems[]=
  {
    {DI_LISTBOX, 2,1,0,0, DIF_LISTWRAPMODE/*|DIF_LISTAUTOHIGHLIGHT*//*|DIF_LISTNOAMPERSAND*/, ""},
  };
  FarDialogItem Items[COUNT(InitItems)];
  InitDialogItems(InitItems, Items, COUNT(InitItems));

  int Ret=Info.DialogEx(Info.ModuleNumber, -1,-1, 0,0, NULL, Items, COUNT(Items), 0, 0, DlgProc, (long)this);
  if(Ret!=-1)
  {
    Ret=Items[0].ListPos;
    Close(Ret);
  }
  return Ret;
}

void TMenu::Init()
{
  FarListTitles flt;
  flt.Title=Title;
  flt.Bottom=Bottom;
  //FarListTitles flt={0, Title, 0, Bottom};
//MessageBox(0, Bottom, Title, MB_OK);
  Info.SendDlgMessage(hDlg, DM_LISTSETTITLES, 0, (long)&flt);

  //if(FarVersion!=MAKEFARVERSION(1, 70, 1282))
  {
    BYTE ColorIndex[]=
    { 
      COL_MENUBOX,          
      COL_MENUBOX,               
      COL_MENUTITLE, 
      COL_MENUTEXT,         
      COL_MENUHIGHLIGHT,         
      COL_MENUBOX, 
      COL_MENUSELECTEDTEXT, 
      COL_MENUSELECTEDHIGHLIGHT, 
      COL_MENUSCROLLBAR,
      COL_MENUDISABLEDTEXT
    };
    for(int i=0; i<min(COUNT(ColorIndex), COUNT(ColorDlgList)); i++)
      ColorDlgList[i]=Info.AdvControl(Info.ModuleNumber, ACTL_GETCOLOR, (void *)ColorIndex[i]);
  }

  // ᨬ 梥⮬ ࠬ 
  ColorDialog=ColorDlgList[1];

  ResizeConsole();
}
