#define NUM
#define DISKMENU
#define _FAR_USE_FARFINDDATA
#include "../plugin.hpp"
#include "../farkeys.hpp"
#include "../farcolor.hpp"
//#include "plugin.hpp"
//#include "farkeys.hpp"
//#include "farcolor.hpp"


#define COUNT(Msg) (sizeof(Msg)/sizeof(*Msg))
#define EXT(FileName) *((DWORD *)(FileName+lstrlen(FileName)-3))
#define MK_ID(a, b, c, d) ((a)|((b)<<8)|((c)<<16)|((d)<<24))
#define malloc(Size) HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, Size)
#define free(Block) HeapFree(GetProcessHeap(), 0, Block)

PluginStartupInfo Info;
FarStandardFunctions FSF;
char IniFile[MAX_PATH];
//char Section[MAX_PATH];
//char PluginRootKey[MAX_PATH];
DWORD FarVersion;

#ifdef DISKMENU
  static char DiscMenuStringsBuf[4096];
#endif //DISKMENU

#define FSD_FOCUSED  0x80
#define FSD_SELECTED 0x40
#define FSD_DEFAULT  0x20

struct InitDialogItem
{
  union
  {
    BYTE Type;
    BYTE FSDFlags;
  };
  BYTE X1,Y1,X2,Y2;
  DWORD Flags;
  //BYTE Data;
  char *Data;
};

void InitDialogItems(InitDialogItem *Init, FarDialogItem *Item, int Count)
{
  while(Count--)
  {
    Item->Type=Init->Type&0x1F;
    Item->X1=Init->X1;
    Item->Y1=Init->Y1;
    Item->X2=Init->X2;
    Item->Y2=Init->Y2;
    Item->Focus=Init->FSDFlags&FSD_FOCUSED;
    Item->Selected=Init->FSDFlags&FSD_SELECTED;
    Item->Flags=Init->Flags;
    Item->DefaultButton=Init->FSDFlags&FSD_DEFAULT;
    lstrcpy(Item->Data, Init->Data/*GetMsg(Init->Data)*/);

    Init++;
    Item++;
  }
}

char *GetSection(int Index, char *Buf)
{
  char *Section=Buf;
  while(*Section)
  {
    if(!Index)
      return Section;
    Index--;
    while(*Section++);
  }
  return NULL;
}

char *ITOA(int i)
{
  static char a[32];
  FSF.itoa(i, a, 10);
  return a;
}

//#include "REG.CPP"
//#include "MACRO.CPP"
#include "MENU.CPP"
#include "HKMENU.CPP"
#include "DMENU.CPP"

#ifdef __GNUC__
// ⪫祭 樨 startup-  GCC
#ifdef __cplusplus
extern "C"
#endif
BOOL WINAPI DllMainCRTStartup(HANDLE hDll, DWORD dwReason, LPVOID lpReserved)
{
  return TRUE;
}
#endif

void WINAPI _export GetPluginInfo(PluginInfo *Info)
{
  Info->StructSize=sizeof(PluginInfo);
  Info->Flags=PF_PRELOAD;
  static const char *PluginMenuStrings[1];
  *PluginMenuStrings="HotDir";
  Info->PluginMenuStrings=PluginMenuStrings;
  Info->PluginMenuStringsNumber=COUNT(PluginMenuStrings);

  #ifdef DISKMENU
  {
    static const char *DiskMenuStrings[32];
    //static const int DiskMenuNumbers[]={'K'-'0', 0,1,2,3,4};
    GetPrivateProfileString("AltF1", NULL, "", DiscMenuStringsBuf, sizeof(DiscMenuStringsBuf), IniFile);
    int& i=Info->DiskMenuStringsNumber;
    char* c=DiscMenuStringsBuf;
    for(i=0; *c && i<COUNT(DiskMenuStrings); i++)
    {
      DiskMenuStrings[i]=c;
      while(*c++);// c+=lstrlen(c)+1;
    }
    Info->DiskMenuStrings=DiskMenuStrings;
  }
  #endif //DISKMENU
}

HANDLE WINAPI _export OpenPlugin(int OpenFrom, int Item)
{
  #ifdef DISKMENU
    if(OpenFrom==OPEN_DISKMENU)
    {
      char *Key=DiscMenuStringsBuf;
      while(Item-- >0 && *Key)
        while(*Key++); //Key+=lstrlen(Key)+1;
      static char Path[MAX_PATH];
      GetPrivateProfileString("AltF1", Key, "", Path, sizeof(Path), IniFile);
      FSF.ExpandEnvironmentStr(Path, Path, sizeof(Path));
      return (HANDLE)Path;
      /*PanelInfo pi;
      Info.Control(INVALID_HANDLE_VALUE, FCTL_GETPANELSHORTINFO, &pi);
      Info.Control(INVALID_HANDLE_VALUE, pi.Focus?FCTL_SETPANELDIR:FCTL_SETANOTHERPANELDIR, Path);
      return INVALID_HANDLE_VALUE;*/
    }
  #endif //DISKMENU

  char Section[128];
  THotKeyMenu HotKeyMenu;
  int Code;
  while((Code=HotKeyMenu.Run("HotDir", /*"Ins,Del,F4"*/"", (long)Section))!=-1)
  {
    while(1)
    {
      long Key=0;
      TDirMenu DirMenu;
      DirMenu.Run(Section, "Ins,Del,F4", (long)&Key);
      if(!Key)
        return INVALID_HANDLE_VALUE;
      if(Key==KEY_BS)
        break;
      //else //Key==KEY_LEFT || Key==KEY_RIGHT
        Code=HotKeyMenu.Close(Code+Key-KEY_UP);
    }
  } 
  return INVALID_HANDLE_VALUE;
}

#ifdef DISKMENU
  int WINAPI _export GetFindData(HANDLE hPlugin, PluginPanelItem **pPanelItem, int *pItemsNumber, int OpMode)
  {
    *pItemsNumber=0;
    return TRUE;
  }

  void WINAPI _export FreeFindData(HANDLE hPlugin, PluginPanelItem *PanelItem, int ItemsNumber)
  {
    PanelInfo pi;
    if(Info.Control(INVALID_HANDLE_VALUE, (FarVersion==MAKEFARVERSION(1, 70, 1282))?FCTL_GETPANELINFO:FCTL_GETPANELSHORTINFO, &pi))
      Info.Control(INVALID_HANDLE_VALUE, pi.Focus?FCTL_SETANOTHERPANELDIR:FCTL_SETPANELDIR, (void *)hPlugin);
  }
#endif //DISKMENU

void WINAPI _export SetStartupInfo(const struct PluginStartupInfo *Info)
{
  ::Info=*Info;
  FSF=*Info->FSF;
  ::Info.FSF=&FSF;

  lstrcpy(IniFile, Info->ModuleName);
  EXT(IniFile)=MK_ID('I', 'N', 'I', 0);
  Info->AdvControl(Info->ModuleNumber, ACTL_GETFARVERSION, &FarVersion);

  //FSF.sprintf(PluginRootKey, "SOFTWARE\\Far\\KeyMacros\\Shell");
  /*char Macro[256];
  GetRegKey("Ctrl=", "Sequence", Macro, "", sizeof(Macro));
  MessageBox(0, Macro, 0, MB_OK);*/
}

int WINAPI _export GetMinFarVersion(void)
{
  return MAKEFARVERSION(1, 70, 1282);
}