class TDirMenu:public TMenu
{
  void GetIniString(int i, char *Dest);
  void SetIniString(int i, char *Src);
  inline int GetDirUnderCursor(int BufLen, char *Buf);

  void Init();
  long KeyPress(long Key, int Pos);
  //int Close(int Index);
};

void TDirMenu::GetIniString(int i, char *Dest)
{
  GetPrivateProfileString(/*(char *)Param*/Title, ITOA(i), "", Dest, /*sizeof(Dest)*/MAX_PATH, IniFile);
}

void TDirMenu::SetIniString(int i, char *Src)
{
  WritePrivateProfileString(/*(char *)Param*/Title, ITOA(i), Src, IniFile);
}

int TDirMenu::GetDirUnderCursor(int BufLen, char *Buf)
{
  PanelInfo pi;
  Info.Control(INVALID_HANDLE_VALUE, FCTL_GETPANELINFO, &pi);
  FAR_FIND_DATA &FindData=pi.PanelItems[pi.CurrentItem].FindData;
  wsprintf(Buf, "%s\\%s", pi.CurDir, FindData.cFileName);
//lstrcpy(Buf, FindData.cFileName);
  /*if(FarVersion!=MAKEFARVERSION(1, 70, 1282)) //᢮ 
    Info.Control(INVALID_HANDLE_VALUE, FCTL_GETPANELSHORTINFO, &pi);*/
  return FindData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY;
}

void TDirMenu::Init()
{
  char Path[MAX_PATH];
  do
  {
    GetIniString(Count, Path);
    InsItem(Count, Path);
  }while(*Path);
  TMenu::Init();
}

long TDirMenu::KeyPress(long Key, int Pos)
{
  //char *Section=/*(char *)Param*/Title;

  #ifdef NUM
    DWORD k=Key&0xFFFFFF;
    if(k>='0' && k<='9')
    {
      Pos=((k=='0')?9:k-'1');
      Key=(Key&0xFF000000)|KEY_ENTER;
    }
  #endif //NUM

  Info.SendDlgMessage(hDlg, DM_ENABLEREDRAW, FALSE, 0);

  switch(Key)
  {
    case KEY_CTRL|KEY_INS:
    case KEY_RCTRL|KEY_INS:
    case KEY_INS:
    {
      char Path[MAX_PATH], Temp[MAX_PATH];
      if(Key==KEY_INS)
        GetCurrentDirectory(sizeof(Path), Path);
      else
        if(!GetDirUnderCursor(sizeof(Path), Path))
          break;
      if(Info.InputBox("Input Path", "Input Path", NULL, (const char *)Path, Path, sizeof(Path), NULL, 0))
      {
        for(int i=Count-1; i>Pos; i--)
        {
          GetIniString(i-1, Temp);
          SetIniString(i, Temp);
        }
        SetIniString(Pos, Path);
        InsItem(Pos, Path);
      }
      break;
    }
    case KEY_F4:
    {
      if(Pos<Count-1)
      {
        char Path[MAX_PATH];
        GetIniString(Pos, Path);
        if(Info.InputBox("Input Path", "Input Path", NULL, (const char *)Path, Path, sizeof(Path), NULL, 0))
        {
          SetIniString(Pos, Path);
          DelItem(Pos);
          InsItem(Pos, Path/*, 0*/);
        }
      }
      break;
    }
    case KEY_DEL:
      if(Pos<Count-1)
      {
        /*FarListDelete fld={Pos, 1};
        Info.SendDlgMessage(hDlg, DM_LISTDELETE, 0, (long)&fld);
        Count--;*/
        DelItem(Pos);
  
        char Path[MAX_PATH];
        do
        {
          GetIniString(Pos+1, Path);
          SetIniString(Pos, *Path?Path:NULL);
          Pos++;
        }while(*Path);
      }  
      break;
    case KEY_LEFT:
    case KEY_RIGHT:
    case KEY_BS:
      *((long *)Param)=Key;
      Info.SendDlgMessage(hDlg, DM_CLOSE, 0, 0);
      return TRUE;
    case KEY_ENTER:
    case KEY_CTRL|KEY_ENTER:
    case KEY_RCTRL|KEY_ENTER:
    {
      char Path[MAX_PATH];
      GetIniString(Pos, Path);
      FSF.ExpandEnvironmentStr(Path, Path, sizeof(Path));
      Info.Control(INVALID_HANDLE_VALUE, (Key==KEY_ENTER)?FCTL_SETPANELDIR:FCTL_SETANOTHERPANELDIR, (void *)Path);
      Info.SendDlgMessage(hDlg, DM_CLOSE, 0, 0);
      return TRUE;
    }
    default:
      Info.SendDlgMessage(hDlg, DM_ENABLEREDRAW, TRUE, 0);
      return FALSE;
  }
  ResizeConsole();
  Info.SendDlgMessage(hDlg, DM_ENABLEREDRAW, TRUE, 0);
  Info.SendDlgMessage(hDlg, DM_REDRAW, 0, 0);
  return TRUE;
}

/*int TDirMenu::Close(int Index)
{
  long &Key=*((long *)Param);

  #ifdef NUM
    if(Key>='0' && Key<='9')
    {
      Index=Key-'0';
      Key=0;
    }
  #endif //NUM
  
  if(!Key)
  {
//MessageBeep(0xFFFFFFFF);
    char Path[MAX_PATH];
    GetIniString(Index, Path);
//char Buf32[32]; wsprintf(Buf32, "%d", Index); MessageBox(0, Path, Buf32, MB_OK);
    FSF.ExpandEnvironmentStr(Path, Path, sizeof(Path));
    Info.Control(INVALID_HANDLE_VALUE, FCTL_SETPANELDIR, (void *)Path);
    //Info.Control(INVALID_HANDLE_VALUE, FCTL_UPDATEPANEL, NULL);
    //Info.Control(INVALID_HANDLE_VALUE, FCTL_REDRAWPANEL, NULL);
  }
  return Index;
}*/
