/* WildSam2.C version 1.1  Sample Use of Wildcard Processor */
/* used in form:   WildSam2  C:\*.C/S  D:\*.exe  E:*.* -*.exe */
/*
Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com
*/

/* I N C L U D E S */

#include <stdlib.h> /* toupper */
#include <stdio.h>  /* fopen fread  */
#include <string.h> /* strcmp strcpy */
#include "wild.h"   /* Wildcard processing code */

/* ************************************** */

local int     Compare(const void *A, const void *B)
/* qsort wants a callback item compare routine */
{
    return (stricmp(*(char **) A, *(char **) B));
}

/* ************************************** */

local void  ProcessWilds(WORD argc, char **argv)
/* process list of expanded wildcards. This routine mimics the
 * way you would process individual filenames on the command
 * line in a mainline routine. You can do pretty well what you
 * like with the pointers and strings passed you.  You can
 * sort them. You can set some to null.  You can free the
 * pointers and or strings. */

{
    WORD             i, j, k, rows;

    printf("\nSorted directory of Readonly, system, hidden files in columns");
    /* sort files alphabetically by path, file, extension */
    qsort((void *) argv, (size_t) argc, sizeof(char *), Compare);

    /* display in 2 columns, in column major order, rather than
     * usual row major */
    /* indent 5 columns */
    rows = (argc + 1) / 2;
    for (i = 0; i < rows; i++)
        {
        printf("\n%-5s", " ");
        for (j = i, k = 0; (k < 2) && (j < argc); k++, j += rows)
            printf("%-35s", argv[j]);
        }
    printf("\n");

    Wild_Free();
    /* Free up the pointers and strings to the expanded
     * Wildcards */
    /* You can keep them around longer if you like */
}

/* ************************************** */

local BOOL WeirdFilesOnly(ATTRIB Attrib)
/* TRUE if attribute describes a weird file file -- not Dir Vol,
 * possibly Archive must be one or more of hidden, system or
 * read-only */
{
    return (Wild_AttribPatternMatch("?00+++", /* ADVSHR */
        Attrib));
}

/* ************************************** */

/* M A I N */

int main(int argc, char **argv)

/* Ask Wild to process all parms but not 0, the progname.  We
 * give it two callback functions -- one to filter attribs and
 * one to process the wildcards. ProcessWilds is our user
 * routine that does all the work. The list of wildcards could
 * come from anywhere, not just argv. */
{
    Wild(WeirdFilesOnly, ProcessWilds, (unsigned int) (argc - 1), argv + 1);
    return (0) /* DOS ERRORLEVEL */;
}

/* ************************************** */

/* -30- */
