/* WildSam1.C version 1.1  Sample Use of Wildcard Processor */
/* like DIR with positive and negative wildcards e.g. */
/* WildSam1  C:\*.* -autoexec.* C:\*.C/S */

/*
Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com
*/


/* I N C L U D E S */

#include <stdlib.h> /* toupper */
#include <stdio.h>  /* fopen fread  */
#include <dos.h>    /* _dos_findnext */
#include "wild.h"   /* Wildcard processing code */

#include "wildfilt.h" /* optional sample attribute
                       * filters */

/* ************************************** */

local void ProcessWilds(WORD argc, char **argv)
/* process list of expanded wildcards This routine mimics the
 * way you would process individual filenames on the command
 * line in a mainline routine. You can do pretty well what you
 * like with the pointers and strings passed you.  You can
 * sort them. You can set some to null.  You can free the
 * pointers and or strings. */

{
  WORD             i;

  /* display directory of files */
  printf("\nUnsorted Directory list of %d files\n", argc);
  for ( i = 0; i < argc; i++ )
    printf("%-40s", argv[i]);
  printf("\n");

  Wild_Free();
  /* Free up the pointers and strings to the expanded
   * Wildcards. You can keep them around longer if you like */
}

/* ************************************** */

/* M A I N */

int main(int argc, char **argv)

/* Ask Wild to process all parms but not argv[0] -- the progname. We give it
 * two callback functions -- one to filter attribs and one to
 * process the wildcards. ProcessWilds is our user routine that
 * does all the work. The list of wildcards could come from
 * anywhere, not just argv. */
{
  Wild(NormsOnly, ProcessWilds, (unsigned int) (argc - 1), argv + 1);
  return (0) /* DOS ERRORLEVEL */;
}

/* ************************************** */

/* -30- */
