/* Wild.H version 1.1 */
/* types and protypes to use the Wild Wildcard expander. */

/*
Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com
*/

/* E N U M E R A T I O N S   A N D   T Y P E S */

#ifndef WORD
#define WORD unsigned int
#endif

#ifndef BYTE
#define BYTE unsigned char
#endif

typedef enum BOOL
{
  FALSE, TRUE
} BOOL;

#define   local static
/* Using define allows local variables to be made public or local easily
 * while debugging.  Further, I object to C using the term "static" to
 * mean "local". */

typedef unsigned short ATTRIB;

/* P R O T O T Y P E S */

extern BOOL     Wild_AttribPatternMatch(char Wanted[6], ATTRIB Attrib);
/* Used in Attribute callback routines.
 * returns true if Attrib matches the given string pattern.. CHARACTER Want string
 * is of form: "ADVHSR"   "?00+1-"
 * 1=must be 1
 * 0=must be 0
 * +=must have some 1s in + spots (i.e. can't have all + spots 0)
 * -=must have some 0s
 * ADVSHR A-archive D-directory V-volume S-system H-hidden R-read-only */

extern void     Wild_Free(void);
/* free up the dynamic storage allocated for WildCard expansions -- fargv[] */

extern void     Wild(    BOOL CallBackAttr(ATTRIB Attrib),
                         void CallBackProcess(WORD fargc, char **fargv),
                         WORD wargc,
                         char **wargv);

/* Provide this routine with a call back Attribute function to define
 * the attributes you like, and a array of pointers argv, to a list of
 * wildcards. wargc counts how many wildcards there are. Wild will call
 * the CallBackProcess routine ONCE with a list of pointers to the
 * expanded filenames.  fargc tells CallBackProcess how many expanded
 * filenames there are. CallBackProcess is free to nullify or sort the
 * pointers in anyway it wants. It could even set up a pointer to them
 * so the mainline routine could access them after it exits.  When you
 * are done, call Wild_Free() to return the storage of the pointers and
 * the strings. */

/* -30- end Wild.H */
