/* HIDE.C 1.1 turns on HIDDEN attribute in given set of
 * positive and negative wildcards e.g.
 * HIDE  C:\*.* -autoexec.* C:\*.C/S
 *
 * Acts like DOS ATTRIB +H
 *
 * Companion to REVEAL.C
 *
 * Requires freeware CMP WILD C source package
 * compile with COMPACT model.
 * copyright 1993, 1998 by Roedy Green
 */

/*
Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com

version 1.1 1998 November 8
- embed Barker address

*/

/* I N C L U D E S */

#define __MSC 1     /* use extra _ on _find_t */

#include <stdlib.h> /* toupper */
#include <stdio.h>  /* fopen fread  */
#include <dos.h>    /* _dos_findnext */
#include "wild.h"   /* Wildcard processing code */

/* ************************************** */

void Banner(void)
{
  /* copyright banner, not displayed, just embedded. */
  printf("\n HIDE 1.1 ۲\n\n"
         "Freeware to turn on HIDDEN file attribute bits in +ve or -ve wildcards. \n"
         "Copyright (c) 1993, 1998 Canadian Mind Products\n"
         "\n" "#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9"
         "\n" "tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com"
         "\n" "May be used freely for non-military use only"
         "\n\n");
} /* Banner */

/* ************************************** */

local void ProcessWilds(WORD argc, char **argv)
/* process list of expanded wildcards turning on HIDDEN attributes. */
{
  WORD             i;
  ATTRIB           Attrib;
  for ( i = 0; i < argc; i++ )
    {
    /* turn on the HIDDEN attribute in each file in the list */
    (void) _dos_getfileattr(argv[i],&Attrib);
    (void) _dos_setfileattr(argv[i],Attrib | _A_HIDDEN);
    }

  printf("%u files hidden\n", argc);

  Wild_Free();
  /* Free up the pointers and strings to the expanded
   * Wildcards. You can keep them around longer if you like */
}

/* ************************************** */

BOOL VisFilesOnly(ATTRIB Attrib)
/* TRUE if attribute describes a visible file -- not
 * Dir Vol.  Possibly Archive, system, Readonly.
 * No need to process files already marked hidden. */
{
  return (Wild_AttribPatternMatch("?00?0?", /* ADVSHR */
                                  Attrib));
}
/* ************************************** */

/* M A I N */

int main(int argc, char **argv)

/* Ask Wild to process all parms but not argv[0] -- the progname. We give it
 * two callback functions -- one to filter attribs and one to
 * process the wildcards. ProcessWilds is our user routine that
 * does all the work. The list of wildcards could come from
 * anywhere, not just argv. */
{
  Wild(VisFilesOnly, ProcessWilds, (unsigned int) (argc - 1), argv + 1);
  return (0) /* DOS ERRORLEVEL */;
}

/* ************************************** */

/* -30- */
