#include "..\plugin.hpp"
#include "htmlhelp.h"

#define COUNT(Msg) (sizeof(Msg)/sizeof(*Msg))
#define GetKey(i, j) GetSection(i, j)
#define IS_ALPHA(c) (((c)>='A' && (c)<='Z') || ((c)>='a' && (c)<='z') || (c)=='_' || ((char)(c))<0)
#define EXT(FileName) *((DWORD *)(FileName+lstrlen(FileName)-4))
#define MK_ID(a, b, c, d) ((a)|((b)<<8)|((c)<<16)|((d)<<24))
#define MALLOC(Size) HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, Size)
#define FREE(Block) HeapFree(GetProcessHeap(), 0, Block)

#define MAX_SECTION_LEN 256
#define MAX_KEYWORD_LEN 256
#define BUF_LEN         0x2000

#define OPEN_CTRLF1 (-1)
#define OPEN_ALTF1  (-2)

typedef HWND (WINAPI* HTMLHELP)(HWND, LPCSTR, UINT, DWORD);

static PluginStartupInfo Info;
static FarStandardFunctions FSF;
/*static*/ HTMLHELP htmlHelp;
HINSTANCE HtmlHelpInst;
char IniFile[MAX_PATH];
char HelpFile[MAX_PATH];
char KeyWord[MAX_KEYWORD_LEN];
int HotKey[2];


#ifdef __cplusplus
extern "C"
#endif
BOOL WINAPI DllMainCRTStartup(HANDLE hDll, DWORD dwReason, LPVOID lpReserved)
{
  if(dwReason==DLL_PROCESS_DETACH && HtmlHelpInst)
    FreeLibrary(HtmlHelpInst);
  return TRUE;
}

char* GetSection(int Index, char* Buf)
{
  char* Section=Buf;
  while(*Section)
  {
    if(!Index)
      return Section;
    Index--;
    while(*Section++); //Section=Section+lstrlen(Section)+1;
  }
  return NULL;
}

inline int GetCount(char* Buf)
{
  int Count=0;
  while(*Buf)
  {
    while(*Buf++);
    Count++;
  }
  return Count;
}


//////////////////////////////////////////////////////////////////////////////
//뤨ࠥ 祢 ᫮  ।
//祢 ᫮ = ࢠ ப 뤥 
// ⢨ 뤥 = ᫮  ஬

inline void GetKeyWord(char* KeyWord)
{
  EditorInfo ei;
  Info.EditorControl(ECTL_GETINFO, &ei);

  char* StartKeyWord=KeyWord; //??!
  EditorGetString egs;
  egs.StringNumber=(ei.BlockType==BTYPE_NONE)?-1:ei.BlockStartLine;
  Info.EditorControl(ECTL_GETSTRING, &egs);

  //!!   ९ KeyWord
  if(ei.BlockType==BTYPE_NONE) // 뤥
  {
    int CurPos=ei.CurPos;
    char* Str=(char*)egs.StringText;
    
    if(IS_ALPHA(Str[CurPos]))
    {
      while(CurPos && IS_ALPHA(Str[CurPos-1]))
        CurPos--;
      while(CurPos<egs.StringLength && IS_ALPHA(Str[CurPos]))
        *KeyWord++=Str[CurPos++];
    }
  }
  else
  {
    char* Str=(char*)egs.StringText+egs.SelStart;
    int Len=((egs.SelEnd==-1)?egs.StringLength:egs.SelEnd)-egs.SelStart;         
    while(Len--)
      *KeyWord++=*Str++;
  }
  *KeyWord=0;
  KeyWord=StartKeyWord;

  //  OEM
  struct EditorConvertText ect;
  ect.Text=KeyWord;
  ect.TextLength=lstrlen(KeyWord);
  Info.EditorControl(ECTL_EDITORTOOEM, &ect);

  //  ANSI
  OemToCharBuffA(KeyWord, KeyWord, ect.TextLength); //??  㤥 ࠡ  NT?

//MessageBox(0, KeyWord, "KeyWord", MB_OK);
}


//////////////////////////////////////////////////////////////////////////////
//뢠   ப  "Item1\x0Item2\x0 ... ItemN\x0\x0"
//頥  ப 㭪  NULL  ⬥ 롮
//᫨    ப -   뢠

char* Menu(char* Buf)
{
  char* Ret=NULL;
  int Index=0;
  if(int Count=GetCount(Buf))
  {
    if(Count>1)
    {
      FarMenuItemEx* MenuItems;
      MenuItems=(FarMenuItemEx* )MALLOC(sizeof(FarMenuItemEx)*Count);
      if(!MenuItems)
        return FALSE;
      for(int j=0; j<Count; j++)
      {
        FarMenuItemEx &MenuItem=MenuItems[j];
        MenuItem.UserData=(DWORD)(MenuItem.Text.TextPtr=GetKey(j, Buf));
        MenuItem.Flags=MIF_USETEXTPTR;
        MenuItem.AccelKey=MenuItem.Reserved=0;
      }
      Index=Info.Menu(Info.ModuleNumber, -1, -1, 0, 
                      FMENU_WRAPMODE|FMENU_AUTOHIGHLIGHT|FMENU_USEEXT, 
                      "Help", NULL, NULL, NULL, NULL, 
                      (FarMenuItem* )MenuItems, Count);
      if(Index>=0)
        Ret=(char*)MenuItems[Index].UserData;
      FREE(MenuItems);
    }
    else
      Ret=Buf;
  }
  return Ret;
}


inline int GetHelp()
{
  HWND hFarWnd=(HWND)Info.AdvControl(Info.ModuleNumber, ACTL_GETFARHWND, 0);
  if(Info.CmpName("*.hlp", HelpFile, 1))
    WinHelp(hFarWnd, HelpFile, HELP_PARTIALKEY, (DWORD)KeyWord);
  else
  {
    if(!HtmlHelpInst)
    {
      HtmlHelpInst = LoadLibrary("HHCTRL.OCX");
      if(HtmlHelpInst)
        htmlHelp=(HTMLHELP)GetProcAddress(HtmlHelpInst, "HtmlHelpA");
    }

    //!!  㧨襩 HHCTRL.OCX  HtmlHelpA
    HH_AKLINK link={sizeof(HH_AKLINK), FALSE, NULL/*KeyWord*/, NULL, NULL, NULL, NULL, TRUE};
    link.pszKeywords=KeyWord;

    HWND hHelpWnd=htmlHelp(/*hFarWnd*/0, HelpFile, HH_KEYWORD_LOOKUP, (DWORD)&link);
    ShowWindow(hHelpWnd, SW_SHOWNORMAL);

    /*if(HtmlHelpInst)
    {
      FreeLibrary(HtmlHelpInst);
      HtmlHelpInst=NULL;
    }*/
  }
  return TRUE;                    
}


//////////////////////////////////////////////////////////////////////////////
//ᯮ㥬 㭪樨

void WINAPI _export SetStartupInfo(const PluginStartupInfo* Info)
{
  ::Info=*Info;
  FSF=*Info->FSF;
  ::Info.FSF=&FSF;
  HtmlHelpInst=NULL;
  //htmlHelp=NULL;
  lstrcpy(IniFile, Info->ModuleName);
  EXT(IniFile)=MK_ID('.', 'I', 'N', 'I');
  HotKey[0]=FSF.FarNameToKey("CtrlF1");
  HotKey[1]=FSF.FarNameToKey("AltF1");
  *HelpFile=*KeyWord=0;
}

void WINAPI _export GetPluginInfo(PluginInfo* Info)
{
  Info->StructSize=sizeof(*Info);
  Info->Flags=PF_EDITOR|PF_VIEWER;
  static const char* PluginMenuStrings[1];
  *PluginMenuStrings=/*GetMsg(MHelp)*/"Help";
  Info->PluginMenuStrings=PluginMenuStrings;
  Info->PluginMenuStringsNumber=COUNT(PluginMenuStrings);
}

int WINAPI ProcessEditorInput(const INPUT_RECORD* Rec)
{
  if(Rec->EventType==KEY_EVENT && Rec->Event.KeyEvent.bKeyDown)
  {
    int Key=FSF.FarInputRecordToKey(Rec);
    if(Key==*HotKey || Key==HotKey[1])
    {
      OpenPlugin((Key==*HotKey)?OPEN_CTRLF1:OPEN_ALTF1, 0);
      return 1;
    }
  }
  return 0;
}

HANDLE WINAPI _export OpenPlugin(int OpenFrom, int Item)
{
  if(OpenFrom!=OPEN_ALTF1)
  {
    char Buf[BUF_LEN];
    *KeyWord=*HelpFile=0;
    GetPrivateProfileString(NULL, NULL, "", Buf, sizeof(Buf), IniFile);
    
    char* Sect;
    if(OpenFrom<0) //CtrlF1 | AltF1
    {
      EditorInfo ei;
      Info.EditorControl(ECTL_GETINFO, &ei);
      for(int i=0; Sect=GetSection(i, Buf); i++)
        if(FSF.ProcessName((const char* )Sect, (char* )ei.FileName, PN_CMPNAMELIST))
          break;
    }
    else
      Sect=Menu(Buf);

    if(!Sect)
      return INVALID_HANDLE_VALUE;
  
    if(*Sect)
    {
      if(OpenFrom==OPEN_EDITOR || OpenFrom<0)
        GetKeyWord(KeyWord);
      else
        *KeyWord=0;

      char Section[MAX_SECTION_LEN];
      lstrcpy(Section, Sect);
      GetPrivateProfileString(Section, NULL, "", Buf, sizeof(Buf), IniFile);
 
      char* Key=Menu(Buf);
      if(!Key)
        return INVALID_HANDLE_VALUE;
      GetPrivateProfileString(Section, Key, "", HelpFile, sizeof(HelpFile), IniFile);
    }
  }

  GetHelp();
  return INVALID_HANDLE_VALUE;
}
