{******************************************************}
{ fowner v1.1                                          }
{ Copyright (c) 1997-1999 Magnus Bck                  }
{ baeck@swipnet.se                                     }
{ http://www.jpl.nu/~magnus/fowner.html                }
{******************************************************}
{ This software may be distributed and modified freely }
{ as long as the original copyright is not removed and }
{ no profit is made from it.                           }
{******************************************************}

program fowner;

uses
  Classes,
  SysUtils,
  Windows,
  Win32pas in 'Win32pas.pas',
  Security in 'Security.pas',
  StrFuncs in 'StrFuncs.pas';

{$APPTYPE CONSOLE}

const
	FullAppName              = 'fowner';
	Version                  = 'v1.1';
	Copyright                = 'Copyright (c) 1997-1999 Magnus Bck';
	ERROR_NO_USERS           = 1;
	ERROR_NOT_WINDOWS_NT     = 2;

var
	Users, Files: TStringList;
	SaveDir, InName, TempS: string;
	I: Integer;
	Verbose, ShortNames, DoRecurse: Boolean;
	FileCount, MatchCount: Integer;

procedure Shutdown(ErrorCode: Integer);
begin
	if SaveDir <> '' then
		ChDir(SaveDir);
	Halt(ErrorCode);
end;

procedure Error(Msg: string; ErrorCode: Integer);
begin
	Writeln(Format('%s: %s', [FullAppName, Msg]));
	if ErrorCode <> 0 then
		Shutdown(ErrorCode);
end;

procedure Process(FileSpec: string; Owners: TStringList;
	ShortNames, DoSubDirs: Boolean);
var
	FileInfo: TSearchRec;
	FindError: Integer;
	TempS, FileName, Domain, Owner, FileMask, PathName: string;

function Match(const Owner: string): Boolean;
var
	I: Integer;
	HasTilde: Boolean;
begin
	Match := True;
	HasTilde := False;
	for I := 0 to Owners.Count - 1 do
	begin
		if CompareText(Owners[I], ToOem(Owner)) = 0 then
			Exit;
		HasTilde := Owners[I][1] = '~';
		if HasTilde and (CompareText(Copy(Owners[I], 2, 254),
			ToOem(Owner)) = 0) then
		begin
			Match := False;
			Exit;
		end;
	end;
	Match := HasTilde;
end;

begin
	FileMask := '*.*';
	try
		ChDir(FileSpec);
	except
		if ExtractFilePath(FileSpec) <> '' then
		begin
			try
				ChDir(ExtractFilePath(FileSpec));
			except
				Error(ExtractFilePath(FileSpec) + ': Directory not found', 0);
			end;
		end;
		FileMask := ExtractFileName(FileSpec);
	end;
	GetDir(0, PathName);
	if DoSubDirs then
	begin
		FindError := FindFirst('*.*', faDirectory, FileInfo);
		try
			while FindError = 0 do
			begin
				if (FileInfo.Name[1] <> '.') and ((FileInfo.Attr and faDirectory) <> 0) then
				begin
					Process(TrailingBackslash(PathName) +
						TrailingBackslash(FileInfo.Name) +	FileMask,
						Owners, ShortNames, DoSubDirs);
					ChDir(PathName);
				end;
				FindError := FindNext(FileInfo);
			end;
		finally
			SysUtils.FindClose(FileInfo);
		end;
	end;
	FindError := FindFirst(FileMask, faAnyFile - faVolumeID, FileInfo);
	try
		while FindError = 0 do
		begin
			FileName := FileInfo.Name;
			if FileName[1] <> '.' then
			begin
				GetFileOwner(FileName, Domain, Owner);
				Owner := ToChar(Owner);
				Inc(FileCount);
				if Match(Owner) then
				begin
					Inc(MatchCount);
					if DoSubDirs then
						TempS := TrailingBackslash(PathName)
					else
						TempS := '';
					TempS := Concat(TempS, FileName);
					if ShortNames then
						TempS := GetShortFileName(TempS);
					TempS := ToOem(TempS);
					if (FileInfo.Attr and faDirectory) <> 0 then
						TempS := TrailingBackslash(TempS);
					Writeln(TempS);
				end;
			end;
			FindError := FindNext(FileInfo);
		end;
	finally
		SysUtils.FindClose(FileInfo);
	end;
end;

begin
	SaveDir := '';
	if ParamStr(1) = '/?' then
	begin
		Writeln(Format('%s %s %s', [FullAppName, Version, Copyright]));
		Writeln;
		Writeln(Format('Syntax:  %s [/SHORT] [/S] [/V] /O:[~]<user> ... [<files>] ... [-]',
			[ExtractFileName(ParamStr(0))]));
		Writeln;
		Writeln('Purpose: Lists all files in <files> being owned by <user>.');
		Writeln;
		Writeln('/S     Recurses subdirectories');
		Writeln('/SHORT Prints the 8+3 filename aliases instead of the full names');
		Writeln('/V     Produce a short summary at the end');
		Writeln;
		Writeln('Tilde (~) in front of a user shows all files not belonging to that user.');
		Writeln('Giving the filename "-" will read filenames from stdin.');
		if not IsWindowsNT then
		begin
			Writeln;
			Writeln('*** Note: This program requires Windows NT and cannot ' +
				'be run on this system.');
			Halt(ERROR_NOT_WINDOWS_NT);
		end;
		Halt(0);
	end;
	if not IsWindowsNT then
		Error('Windows NT is required to run.', ERROR_NOT_WINDOWS_NT);
	GetDir(0, SaveDir);
	Users := TStringList.Create;
	Files := TStringList.Create;
	try
		DoRecurse := False;
		ShortNames := False;
		for I := 1 to ParamCount do
		begin
			TempS := AnsiLowerCase(ParamStr(I));
			if Copy(TempS, 1, 3) = '/o:' then
			begin
				Delete(TempS, 1, 3);
				Users.Add(TempS);
			end
			else if TempS = '/s' then
				DoRecurse := True
			else if TempS = '/-s' then
				DoRecurse := False
			else if TempS = '/v' then
				Verbose := True
			else if TempS = '/-v' then
				Verbose := False
			else if TempS = '/short' then
				ShortNames := True
			else if TempS = '/-short' then
				ShortNames := False
			else if TempS = '-' then
			begin
				while not Eof(Input) do
				begin
					Readln(InName);
					Files.Add(InName);
				end;
			end
			else
				Files.Add(ParamStr(I));
		 end;
		 if Files.Count = 0 then
			Files.Add('*.*');
		 if Users.Count = 0 then
			Error('No users specified on the command-line, use /? for help',
				ERROR_NO_USERS);
		 for I := 0 to Files.Count - 1 do
			Process(Files[I], Users, ShortNames, DoRecurse);
		 if Verbose then
			Writeln(Format('%d files and directories scanned, %d matches (%d%%)',
				[FileCount, MatchCount, Round(100 * MatchCount / FileCount)]));
	finally
		Users.Free;
		Files.Free;
	end;
	Shutdown(0);
end.
