{******************************************************}
{ Win32pas unit                                        }
{ Copyright (c) 1998-1999 Magnus Bck                  }
{ baeck@swipnet.se                                     }
{******************************************************}
{ This software may be distributed and modified freely }
{ as long as the original copyright is not removed and }
{ no profit is made from it.                           }
{******************************************************}

unit Win32pas;

interface

uses Windows, SysUtils, Graphics, Registry, StrFuncs, ShellAPI;

type
	TVolumeInformation = record
		VolumeName:          string;
		SerialNumber:        DWORD;
		MaxFileNameLen:      DWORD;
		FileSystemFlags:     DWORD;
		FileSystemName:      string;
		SectorsPerCluster:	 Integer;
		BytesPerSector:      Integer;
		ClusterSize:         Integer;
		PhysicalClusterSize: Integer;
		FreeClusters:        Integer;
		TotalClusters:       Integer;
	end;

function ToOem(S: string): string;

function ToChar(S: string): string;

function GetShortFileName(S: string): string;

//function GetLongFileName(S: string): string;

function IsWindowsNT: Boolean;

function GetEnv(S: string): string;

function GetVolumeInfo(RootDir: string; var VolumeInfo: TVolumeInformation): Boolean;

function GetVersionInfoValue(FileName, BlockName: string; var ReturnValue: string): Boolean;

function GetIconForType(FileType: string): TIcon;

function GetThisComputerName: string;

implementation

function ToOem(S: string): string;
var
	TempS: PChar;
begin
	GetMem(TempS, Length(S) + 1);
	StrCopy(TempS, '');
	try
		CharToOem(PChar(S), TempS);
		ToOem := StrPas(TempS);
	finally
		FreeMem(TempS);
	end;
end;

function ToChar(S: string): string;
var
	TempS: PChar;
begin
	GetMem(TempS, Length(S) + 1);
	StrCopy(TempS, '');
	try
		OemToChar(PChar(S), TempS);
		ToChar := StrPas(TempS);
	finally
		FreeMem(TempS);
	end;
end;

function GetShortFileName(S: string): string;
var
	ShortName: PChar;
begin
	GetMem(ShortName, 500);
	StrCopy(ShortName, '');
	try
		GetShortPathName(PChar(S), ShortName, 500);
		GetShortFileName := StrPas(ShortName);
	finally
		FreeMem(ShortName);
	end;
end;

{function GetLongFileName(S: string): string;
var
	NamePart, LongName: PChar;
begin
	GetMem(LongName, 500);
	GetMem(NamePart, 500);
	StrCopy(LongName, '');
	StrCopy(NamePart, '');
	try
		GetFullPathName(PChar(S), 500, LongName, NamePart);
		GetLongFileName := StrPas(LongName);
	finally
		FreeMem(LongName);
		FreeMem(NamePart);
	end;
end;}

function IsWindowsNT: Boolean;
var
	OSInfo: TOSVersionInfo;
begin
	OSInfo.dwOSVersionInfoSize := SizeOf(OSInfo);
	GetVersionEx(OSInfo);
	IsWindowsNT := OSInfo.dwPlatformID = VER_PLATFORM_WIN32_NT;
end;

function GetEnv(S: string): string;
var
	Env: PChar;
begin
	GetMem(Env, 500);
	StrCopy(Env, '');
	try
		GetEnvironmentVariable(PChar(S), Env, 500);
		GetEnv := StrPas(Env);
	finally
		FreeMem(Env);
	end;
end;

function GetVolumeInfo(RootDir: string; var VolumeInfo: TVolumeInformation): Boolean;
var
	PVolumeName, PFileSysName: PChar;
begin
	GetVolumeInfo := False;
	if not GetDiskFreeSpace(PChar(RootDir), VolumeInfo.SectorsPerCluster, VolumeInfo.BytesPerSector, 
		VolumeInfo.FreeClusters, VolumeInfo.TotalClusters) then
		Exit;
	GetMem(PVolumeName, 500);
	GetMem(PFileSysName, 500);
	try
		if not GetVolumeInformation(PChar(RootDir), PVolumeName, 500, @VolumeInfo.SerialNumber, 
			VolumeInfo.MaxFileNameLen, VolumeInfo.FileSystemFlags, PFileSysName, 500) then
			Exit;
		VolumeInfo.VolumeName := StrPas(PVolumeName);
		VolumeInfo.FileSystemName := StrPas(PFileSysName);
	finally
		FreeMem(PVolumeName);
		FreeMem(PFileSysName);
	end;
	VolumeInfo.PhysicalClusterSize := VolumeInfo.BytesPerSector * VolumeInfo.SectorsPerCluster;
	if ((VolumeInfo.FileSystemFlags and FS_VOL_IS_COMPRESSED) <> 0) and
		((VolumeInfo.FileSystemName = 'FAT') or (VolumeInfo.FileSystemName = 'FAT32')) then
		VolumeInfo.ClusterSize := 512
	else
		VolumeInfo.ClusterSize := VolumeInfo.PhysicalClusterSize;
	GetVolumeInfo := True;
end;

function GetVersionInfoValue(FileName, BlockName: string; var ReturnValue: string): Boolean;
type
	TTranslationPair = packed record
		Lang:	Word;
		CharSet:	Word;
	end;
	PTranslationIDList = ^TTranslationIDList;
	TTranslationIDList = array [0..MAXINT div SizeOf(TTranslationPair) - 1] of TTranslationPair;
var
	Size, DataSize, Trash: Integer;
	Data: Pointer;
	VerData: Pointer;
	IDs: PTranslationIDList;
	TempS: string;
begin
	Result := False;
	ReturnValue := '';
	Size := GetFileVersionInfoSize(PChar(FileName), Trash);
	if Size = 0 then
		Exit;
	GetMem(Data, Size);
	try
		if not GetFileVersionInfo(PChar(FileName), 0, Size, Data) then
			Exit;
		if not VerQueryValue(Data, '\VarFileInfo\Translation', Pointer(IDs), DataSize) then
			Exit;
		TempS := Format('\StringFileInfo\%.4x%.4x\%s', [IDs^[0].Lang, IDs^[0].CharSet, BlockName]);
		if not VerQueryValue(Data, PChar(TempS), VerData, DataSize) then
			Exit;
		ReturnValue := StrPas(PChar(VerData));
	finally
		FreeMem(Data);
	end;
	Result := True;
end;

function GetIconForType(FileType: string): TIcon;
var
	Reg: TRegistry;
	Index, TempS: string;
	Icon: TIcon;
begin
	Result := nil;
	Reg := TRegistry.Create;
	try
		Reg.RootKey := HKEY_CLASSES_ROOT;
		try
			Reg.OpenKey(FileType + '\DefaultIcon', False);
			TempS := Reg.ReadString('');
			if TempS = '' then
			begin
				Reg.CloseKey;
				Reg.OpenKey(FileType, False);
				Result := GetIconForType(Reg.ReadString(''));
				Exit;
			end
			else if TempS = '%1' then
				Exit;
			Index := '';
			while TempS[Length(TempS)] <> ', ' do
			begin
				Index := TempS[Length(TempS)] + Index;
				TempS := Chop(TempS);
			end;
			Icon := TIcon.Create;
			Icon.Handle := ExtractIcon(HInstance, PChar(TempS), StrToInt(Index));
		except
			Exit;
		end;
	finally
		Reg.Free;
	end;
end;

function GetThisComputerName: string;
var
	ComputerName: array [0..MAX_PATH] of Char;
	Size: DWORD;
begin
	FillChar(ComputerName, SizeOf(ComputerName), #0);
	Size := SizeOf(ComputerName);
	GetComputerName(ComputerName, Size);
	Result := StrPas(ComputerName);
end;


end.
