{******************************************************}
{ Security unit                                        }
{ Copyright (c) 1997-1999 Magnus Bck                  }
{ baeck@swipnet.se                                     }
{******************************************************}
{ This software may be distributed and modified freely }
{ as long as the original copyright is not removed and }
{ no profit is made from it.                           }
{******************************************************}

unit Security;

interface

uses Windows;

function GetFileOwner(FileName: string; var Domain, Username: string): Boolean;

implementation

function GetFileOwner(FileName: string; var Domain, Username: string): Boolean;
var
	SecDescr: PSecurityDescriptor;
	SizeNeeded, SizeNeeded2: DWORD;
	OwnerSID: PSID;
	OwnerDefault: BOOL;
	OwnerName, DomainName: PChar;
	OwnerType: SID_NAME_USE;
begin
	GetFileOwner := False;
	GetMem(SecDescr, 1024);
	GetMem(OwnerSID, SizeOf(PSID));
	GetMem(OwnerName, 1024);
	GetMem(DomainName, 1024);
	try
		if not GetFileSecurity(PChar(FileName), OWNER_SECURITY_INFORMATION,
			SecDescr, 1024, SizeNeeded) then
			Exit;
		if not GetSecurityDescriptorOwner(SecDescr, OwnerSID, OwnerDefault) then
			Exit;
		SizeNeeded := 1024;
		SizeNeeded2 := 1024;
		if not LookupAccountSid(nil, OwnerSID, OwnerName, SizeNeeded, DomainName,
			SizeNeeded2, OwnerType) then
			Exit;
		Domain := DomainName;
		Username := OwnerName;
	finally
		FreeMem(SecDescr);
		FreeMem(OwnerName);
		FreeMem(DomainName);
{ The line below causes a small memory leak, but can't be uncommented without 
  causing an exception. }
//		FreeMem(OwnerSID);
	end;
	GetFileOwner := True;
end;

end.
