{ FLOCATE.PAS : Locate File(s) through directories

  Title   : FLOCATE
  Language: Borland Turbo Pascal v5.0 or higher
  Version : 2.1
  Date    : Feb 14,2000
  Author  : J R Ferguson
  Usage   : refer procedure Help
  Download: http://hello.to/ferguson
  E-mail  : j.r.ferguson@iname.com

This program and its source may be used and copied freely without charge,
but only for non-commercial purposes. The author is not responsible for
any damage or loss of data that may be caused by using it.

To compile this source file, you wil need some units from the JRFPAS
Pascal routine library by the same author, which can be downloaded from the
Internet address mentioned above. You will also need Borland's Turbo Vision.
}

{$V-}
{$R+}

program FLOCATE;


uses DefLib, ArgLib, DirLib, StpLib, ChrLib, Dos;


const
  { Option defaults: }
  DflFmask  = '*.*';
  DflFattr  = Archive or ReadOnly;
  DflNattr  = true;

  MAXFNAME  = 79;
  IOBUFSIZ  = 4096;

  { Error codes and messages: }
  ERROK     = 0;
  ERRARG    = 1;
  ERROUT    = 2;

  ERRMSG    : array[ERROUT..ERROUT] of StpTyp =
 ('Can''t open output : '
 );


var
  OutFname  : StpTyp;
  OutFvar   : Text;
  OutBuf    : array[1..IOBUFSIZ] of char;
  OutOpen   : boolean;

  ErrCod    : integer;
  Fpath,
  Fmask     : StpTyp;
  FcbMask   : DirFcbTyp;
  Fattr     : byte;
  Nattr     : boolean;
  Sattr     : boolean;


{--- Command line parsing routines ---}


procedure Help;
begin
  writeln('FLOCATE v2.1');
  writeln('usage   : FLOCATE filemask [>out] [/option[...] [...] ]');
  writeln('options : /A         = Show attributes');
  writeln('          /Ix[...]   = Include specified attribute(s)');
  writeln('          with x : A = archive       R = read only');
  writeln('                   D = directory     S = system file');
  writeln('                   H = hidden        V = volume id');
  writeln('                   N = no attribute  * = any attribute');
  writeln('default : /iANR');
end;


procedure ReadAttr(var arg: StpTyp);
var ok: boolean;
begin
  ok:= true;
  Fattr:= $00; NAttr:= false;
  while ok and not StpEmpty(arg) do begin
    case ToUpper(StpcRet(arg,1)) of
      'A': Fattr:= Fattr or Archive;
      'D': Fattr:= Fattr or Directory;
      'H': Fattr:= Fattr or Hidden;
      'R': Fattr:= Fattr or ReadOnly;
      'S': Fattr:= Fattr or SysFile;
      'V': Fattr:= Fattr or VolumeID;
      'N': Nattr:= true;
      '*': begin Fattr:= Fattr or AnyFile; Nattr:= true end;
      else ok:= false;
    end;
    if ok then StpDel(arg,1,1);
  end;
end;


procedure ReadOpt(arg: StpTyp);
begin
  StpDel(arg,1,1);
  while (ErrCod=ERROK) and not StpEmpty(arg) do case ToUpper(StpcGet(arg)) of
    'A' : Sattr:= true;
    'I' : ReadAttr(arg);
    '/' : StpDel(arg,1,1);
    else ErrCod:= ERRARG;
  end;
end;


procedure ReadArgs;
var i   : ArgInd;
    arg : StpTyp;
begin
  StpCreate(OutFname); { Standard output }
  Fmask:= DflFmask;
  GetArgs;
  i:= 0;
  while (i < ArgC) and (ErrCod = ERROK) do begin
    Inc(i); StpCpy(arg,ArgV[i]); StpUpp(arg);
    case StpcRet(arg,1) of
      '/' : ReadOpt(arg);
      '<' : ErrCod:= ERRARG;
      '>' : StpSub(OutFname,arg,2,MAXFNAME);
      else  StpCpy(Fmask,arg);
    end;
  end;
end;


{--- Tools ---}


procedure SplitMask( var Fmask   : StpTyp;       { in/out }
                     var Fpath   : StpTyp;       { out    }
                     var FcbMask : DirFcbTyp);   { out    }
var Name: NameStr; Ext: ExtStr;
begin
  FSplit(FExpand(Fmask), Fpath, Name, Ext);
  Fmask:= Name+Ext;
  DirMakeFcb(Fmask,FcbMask);
end;


function MatchAttr(attr: byte): boolean;
begin
  MatchAttr:= ( (attr=$00) and Nattr ) or ( (attr and Fattr) <> 0 );
end;


function MatchMask(fsp: StpTyp): boolean;
var fcb: DirFcbTyp; var i: 0..DirMaxFcb; match: boolean;
begin
  DirMakeFcb(fsp,fcb);
  Match:= true; i:= 1;
  while match and (i<=11) do begin
    match:= (FcbMask.kar[i]='?') or (FcbMask.kar[i]=fcb.kar[i]);
    inc(i);
  end;
  MatchMask:= match;
end;


procedure OpenOut;
begin
  StpNCpy(OutFname,OutFname,MAXFNAME);
  {$I-} Assign(OutFvar,OutFname); SetTextBuf(OutFvar,OutBuf); rewrite(OutFvar);
  {$I+} if IOresult <> 0 then ErrCod:= ERROUT else OutOpen:= true;
end;


function AttrStp(attr: byte): StpTyp;
var s: StpTyp;
begin
  s:= '      ';
  if (attr and ReadOnly ) <> 0 then s[1]:= 'R';
  if (attr and Hidden   ) <> 0 then s[2]:= 'H';
  if (attr and SysFile  ) <> 0 then s[3]:= 'S';
  if (attr and VolumeID ) <> 0 then s[4]:= 'V';
  if (attr and Directory) <> 0 then s[5]:= 'D';
  if (attr and Archive  ) <> 0 then s[6]:= 'A';
  AttrStp:= s;
end;


procedure Output(Dir: StpTyp; Srec: SearchRec);
begin with Srec do begin
  if Sattr then write(OutFvar,AttrStp(Attr),'':2);
  writeln(OutFvar,Dir,Name);
end end;


{--- Main line ---}


procedure Process(path: StpTyp);
var
  Srec: SearchRec;
  rc  : integer;
begin
  FindFirst(path+'*.*',AnyFile,Srec); rc:= DosError;
  while rc = 0 do with Srec do begin
    if (StpcRet(Name,1) <> '.') then begin
      if MatchAttr(Attr) and MatchMask(Name) then
        Output(path,Srec);
      if (Attr and Directory) <> 0 then
        Process(path+Name+'\');
    end;
    FindNext(Srec); rc:= DosError;
  end;
end;


procedure MainInit;
begin
  ErrCod:= ERROK; OutOpen:= false;
  Fmask:= DflFmask; Fattr:= DflFattr; Nattr:= DflNattr;
  Sattr:= false;
  ReadArgs; SplitMask(Fmask,Fpath,FcbMask);
  if ErrCod = ERROK then OpenOut;
end;


procedure MainTerm;
begin
  if OutOpen then Close(OutFvar);
  if ErrCod <> ERROK then begin
    if ErrCod=ERRARG then Help
    else begin
      write(ERRMSG[ErrCod]);
      if ErrCod = ERROUT then write(OutFname);
      writeln;
    end;
  end;
end;


begin { Main program }
  MainInit;
  if ErrCod = ERROK then Process(Fpath);
  MainTerm;
end.
