(********************************************************
* PLUGIN.PAS
* Plugin API for FAR Manager 1.70
* $Revision: 1.70 16.12.2000 $
*
* Copyright (c) 1996-2000 Eugene Roshal
* Copyrigth (c) 2000 [ FAR group ]
* Translated by Vasily V. Moshninov
*********************************************************)

{$ALIGN OFF}
{$MINENUMSIZE 4}

{$IFNDEF VER80}           { Delphi 1.0     }
 {$IFNDEF VER90}          { Delphi 2.0     }
  {$IFNDEF VER93}         { C++Builder 1.0 }
    {$IFNDEF VER100}
      {$IFNDEF VER110}
        {$DEFINE USE_DELPHI4}   { Delphi 4.0 or higher }
      {$ENDIF}
    {$ENDIF}
  {$ENDIF}
 {$ENDIF}
{$ENDIF}

unit plugin;

interface
uses windows;

const

  FARMANAGERVERSION = $01410146;

  NM = 260;

type

  size_t = DWORD;

  TPCharArr = packed array[0..Pred(MaxInt div SizeOf(PChar))] of PChar;
  PPCharArr = ^TPCharArr;

  TIntArr = packed array[0..Pred(MaxInt div SizeOf(integer))] of integer;
  PIntArr = ^TIntArr;

  TWin32FindDataEx = packed record
    dwFileAttributes: DWORD;
    ftCreationTime: TFileTime;
    ftLastAccessTime: TFileTime;
    ftLastWriteTime: TFileTime;
    nFileSizeHigh: DWORD;
    nFileSizeLow: DWORD;
    dwReserved0: DWORD;
    dwReserved1: DWORD;
    cFileName: packed array[0..Pred(MAX_PATH)] of AnsiChar;
    cAlternateFileName: packed array[0..13] of AnsiChar;
  end; { TWin32FindDataEx record }

 TPluginPanelItem = packed record
   FindData: TWin32FindDataEx;
   PackSizeHigh: DWORD;
   PackSize: DWORD;
   Flags: DWORD;
   NumberOfLinks: DWORD;
   Description: PChar;
   Owner: PChar;
   CustomColumnData: PPCharArr;
   CustomColumnNumber: integer;
   UserData: DWORD;
   Reserved: packed array[0..2] of DWORD;
  end; { TPluginPanelItem record }
  PPluginPanelItem = ^TPluginPanelItem;
  TPluginPanelItemArr = packed array[0..Pred(MaxInt div SizeOf(TPluginPanelItem))] of TPluginPanelItem;
  PPluginPanelItemArr = ^TPluginPanelItemArr;

const
// PluginPanelItem flags
  PPIF_PROCESSDESCR = $80000000;
  PPIF_SELECTED     = $40000000;
  PPIF_USERDATA     = $20000000;

// FarMenu flags
  FMENU_SHOWAMPERSAND        = 01;
  FMENU_WRAPMODE             = 02;
  FMENU_AUTOHIGHLIGHT        = 04;
  FMENU_REVERSEAUTOHIGHLIGHT = 08;

type

  TFarMenuItem = packed record
    Text: packed array[0..127] of char;
    Selected: integer;
    Checked: integer;
    Separator: integer;
  end; { TFarMenuItem record }
  PFarMenuItem = ^TFarMenuItem;
  TFarMenuItemArr = packed array[0..Pred(MaxInt div SizeOf(TFarMenuItem))] of TFarMenuItem;
  PFarMenuItemArr = ^TFarMenuItemArr;

  TFarApiMenu = function(
    PluginNumber: integer;
    X, Y: integer;
    MaxHeight: integer;
    Flags: DWORD;
    Title: PChar;
    Bottom: PChar;
    HelpTopic: PChar;
    BreakKeys: PIntArr;
    BreakCode: PInteger;
    Items: PFarMenuItemArr;
    ItemsNumber: integer): integer; stdcall;

//  -  
  TFarApiWndProc = function(
    hDlg: THandle;
    Msg: integer;
    Param1: integer;
    Param2: integer): integer; stdcall;

//     
  TFarApiSendDlgMessage = function(
    hDlg: THandle;
    Msg: integer;
    Param1: integer;
    Param2: integer): integer; stdcall;

  TFarApiDefDlgProc = function(
    hDlg: THandle;
    Msg: integer;
    Param1: integer;
    Param2: integer): integer; stdcall;

const
// ListItem flags
  LIF_SELECTED  = $00000001;
  LIF_CHECKED   = $00000002;
  LIF_SEPARATOR = $00000004;
  LIF_DISABLE   = $80000000;

type
//    Items  DI_COMBOBOX & DI_LISTBOX
  TFarListItem = packed record
    Flags: DWORD;
    Text: packed array[0..123] of char;
  end; { TFarListItem record }
  PFarListItem = ^TFarListItem;
  TFarListItemArr = packed array[0..Pred(MaxInt div SizeOf(TFarListItem))] of TFarListItem;
  PFarListItemArr = ^TFarListItemArr;

//    
  TFarList = packed record
    ItemsNumber: integer;
    Items: PFarListItemArr;
  end; { TFarList record }
  PFarList = ^TFarList;

type

  TFarDialogItem = packed record
    ItemType: integer;
    X1: integer;
    Y1: integer;
    X2: integer;
    Y2: integer;
    Focus: integer;
    Selected: integer;
    Flags: DWORD;
    DefaultButton: integer;
    Data: packed array[0..511] of char;
  end; { TFarDialogItem record }
  PFarDialogItem = ^TFarDialogItem;
  TFarDialogItemArr = packed array[0..Pred(MaxInt div SizeOf(TFarDialogItem))] of TFarDialogItem;
  PFarDialogItemArr = ^TFarDialogItemArr;

  TFarDialogItemData = packed record
    DataLength: integer;
    DataPtr: PChar;
  end; { TFarDialogItemData record }
  PFarDialogItemData = ^TFarDialogItemData;
  TFarDialogItemDataArr = packed array[0..Pred(MaxInt div SizeOf(TFarDialogItemData))] of TFarDialogItemData;
  PFarDialogItemDataArr = ^TFarDialogItemDataArr;

  TFarApiDialog = function(
    PluginNumber: integer;
    X1, Y1: integer;
    X2, Y2: integer;
    HelpTopic: PChar;
    Items: PFarDialogItemArr;
    ItemsNumber: integer): integer; stdcall;

//     Param,   
//       WM_INITDIALOG
  TFarApiDialogEx = function(
    PluginNumber: integer;
    X1, Y1: integer;
    X2, Y2: integer;
    HelpTopic: PChar;
    Items: PFarDialogItemArr;
    ItemsNumber: integer;
    Reserved: DWORD;
    Flags: DWORD;
    DlgProc: TFarApiWndProc;
    Param: integer): integer; stdcall;

const
// FarMessage constants
  FMSG_WARNING        = 01;
  FMSG_ERRORTYPE      = 02;
  FMSG_KEEPBACKGROUND = 04;
  FMSG_DOWN           = 08;
  FMSG_LEFTALIGN      = 16;

type

  TFarApiMessage = function(
    PluginNumber: integer;
    Flags: DWORD;
    HelpTopic: PChar;
    Items: PPCharArr;
    ItemsNumber: integer;
    ButtonsNumber: integer): integer; stdcall;

  TFarApiGetMsg = function(
    PluginNumber: integer;
    MsgId: integer): PChar; stdcall;

const
  DI_TEXT        = 00;
  DI_VTEXT       = 01;
  DI_SINGLEBOX   = 02;
  DI_DOUBLEBOX   = 03;
  DI_EDIT        = 04;
  DI_PSWEDIT     = 05;
  DI_FIXEDIT     = 06;
  DI_BUTTON      = 07;
  DI_CHECKBOX    = 08;
  DI_RADIOBUTTON = 09;
  DI_COMBOBOX    = 10;
  DI_LISTBOX     = 11;
  DI_USERCONTROL = 255;

const
// FarDialogItem flags
  DIF_COLORMASK       = $000000ff;
  DIF_SETCOLOR        = $00000100;
  DIF_BOXCOLOR        = $00000200;
  DIF_GROUP           = $00000400;
  DIF_LEFTTEXT        = $00000800;
  DIF_MOVESELECT      = $00001000;
  DIF_SHOWAMPERSAND   = $00002000;
  DIF_CENTERGROUP     = $00004000;
  DIF_NOBRACKETS      = $00008000;
  DIF_SEPARATOR       = $00010000;
  DIF_EDITOR          = $00020000;
  DIF_HISTORY         = $00040000;
  DIF_EDITEXPAND      = $00080000;
  DIF_DROPDOWNLIST    = $00100000;
  DIF_USELASTHISTORY  = $00200000;
  DIF_BTNNOCLOSE      = $00040000;
  DIF_SELECTONENTRY   = $00800000;
  DIF_NOFOCUS         = $40000000;
  DIF_MASKEDIT        = $00400000;
  DIF_DISABLE         = $80000000;
  DIF_LISTNOAMPERSAND = $00020000;
  DIF_READONLY        = $20000000;
  DIF_3STATE          = $00800000;


const
  DM_FIRST             = 00;
  DM_CLOSE             = DM_FIRST + 01;
  DM_ENABLE            = DM_FIRST + 02;
  DM_ENABLEREDRAW      = DM_FIRST + 03;
  DM_GETDLGDATA        = DM_FIRST + 04;
  DM_GETDLGITEM        = DM_FIRST + 05;
  DM_GETDLGRECT        = DM_FIRST + 06;
  DM_GETTEXT           = DM_FIRST + 07;
  DM_GETTEXTLENGTH     = DM_FIRST + 08;
  DM_KEY               = DM_FIRST + 09;
  DM_MOVEDIALOG        = DM_FIRST + 10;
  DM_SETDLGDATA        = DM_FIRST + 11;
  DM_SETDLGITEM        = DM_FIRST + 12;
  DM_SETFOCUS          = DM_FIRST + 13;
  DM_SETREDRAW         = DM_FIRST + 14;
  DM_SETTEXT           = DM_FIRST + 15;
  DM_SETTEXTLENGTH     = DM_FIRST + 16;
  DM_SHOWDIALOG        = DM_FIRST + 17;
  DM_GETFOCUS          = DM_FIRST + 18;
  DM_GETCURSORPOS      = DM_FIRST + 19;
  DM_SETCURSORPOS      = DM_FIRST + 20;

  DN_FIRST             = $1000;
  DN_BTNCLICK          = DN_FIRST + 01;
  DN_CTLCOLORDIALOG    = DN_FIRST + 02;
  DN_CTLCOLORDLGITEM   = DN_FIRST + 03;
  DN_CTLCOLORDLGLIST   = DN_FIRST + 04;
  DN_DRAWDIALOG        = DN_FIRST + 05;
  DN_DRAWDLGITEM       = DN_FIRST + 06;
  DN_EDITCHANGE        = DN_FIRST + 07;
  DN_ENTERIDLE         = DN_FIRST + 08;
  DN_GOTFOCUS          = DN_FIRST + 09;
  DN_HELP              = DN_FIRST + 10;
  DN_HOTKEY            = DN_FIRST + 11;
  DN_INITDIALOG        = DN_FIRST + 12;
  DN_KILLFOCUS         = DN_FIRST + 13;
  DN_LISTCHANGE        = DN_FIRST + 14;
  DN_MOUSECLICK        = DN_FIRST + 15;

  DM_USER              = $4000;

const
// FarControl commands
  FCTL_CLOSEPLUGIN         = 00;
  FCTL_GETPANELINFO        = 01;
  FCTL_GETANOTHERPANELINFO = 02;
  FCTL_UPDATEPANEL         = 03;
  FCTL_UPDATEANOTHERPANEL  = 04;
  FCTL_REDRAWPANEL         = 05;
  FCTL_REDRAWANOTHERPANEL  = 06;
  FCTL_SETANOTHERPANELDIR  = 07;
  FCTL_GETCMDLINE          = 08;
  FCTL_SETCMDLINE          = 09;
  FCTL_SETSELECTION        = 10;
  FCTL_SETANOTHERSELECTION = 11;
  FCTL_SETVIEWMODE         = 12;
  FCTL_SETANOTHERVIEWMODE  = 13;
  FCTL_INSERTCMDLINE       = 14;
  FCTL_SETUSERSCREEN       = 15;
  FCTL_SETPANELDIR         = 16;
  FCTL_SETCMDLINEPOS       = 17;
  FCTL_GETCMDLINEPOS       = 18;
  FCTL_SETSORTMODE         = 19;
  FCTL_SETANOTHERSORTMODE  = 20;
  FCTL_SETSORTORDER        = 21;
  FCTL_SETANOTHERSORTORDER = 22;

// FarAdvancedControl commands
  ACTL_GETFARVERSION = 00;
  ACTL_CONSOLEMODE   = 01;
  ACTL_GETSYSWORDDIV = 02;
  ACTL_WAITKEY       = 03;
  ACTL_GETCOLOR      = 04;
  ACTL_GETARRAYCOLOR = 05;

//   ACTL_CONSOLEMODE
  CONSOLE_GET_MODE       = -2;
  CONSOLE_TRIGGER        = -1;
  CONSOLE_SET_WINDOWED   = 00;
  CONSOLE_SET_FULLSCREEN = 01;
  CONSOLE_WINDOWED       = 00;
  CONSOLE_FULLSCREEN     = 01;

const

// Panel types
  PTYPE_FILEPANEL    = 00;
  PTYPE_TREEPANEL    = 01;
  PTYPE_QVIEWPANEL   = 02;
  PTYPE_INFOPANEL    = 03;

type

  TPanelInfo = packed record
    PanelType: integer;
    Plugin: integer;
    PanelRect: TRect;
    PanelItems: PPluginPanelItemArr;
    ItemsNumber: integer;
    SelectedItems: PPluginPanelItemArr;
    SelectedItemsNumber: integer;
    CurrentItem: integer;
    TopPanelItem: integer;
    Visible: integer;
    Focus: integer;
    ViewMode: integer;
    ColumnTypes: packed array[0..79] of char;
    ColumnWidths: packed array[0..79] of char;
    CurDir: packed array[0..Pred(NM)] of char;
    ShortNames: integer;
    SortMode: integer;
    Reserved: packed array[0..1] of DWORD;
  end; { TPanelInfo record }
  PPanelInfo = ^TPanelInfo;

  TPanelRedrawInfo = packed record
    CurrentItem: integer;
    TopPanelItem: integer;
  end; { TPanelRedrawInfo record }
  PPanelRedrawInfo = ^TPanelRedrawInfo;

type

  TFarApiControl = function(
    hPlugin: THandle;
    Command: integer;
    Param: pointer): integer; stdcall;

  TFarApiSaveScreen = function(
    X1, Y1: integer;
    X2, Y2: integer): THandle; stdcall;

  TFarApiRestoreScreen = procedure(
    hScreen: THandle); stdcall;

  TFarApiGetDirList = function(
    Dir: PChar;
    var PanelItems: PPluginPanelItemArr;
    var ItemsNumber: integer): integer; stdcall;

  TFarApiGetPluginDirList = function(
    PluginNumber: integer;
    hPlugin: THandle;
    Dir: PChar;
    var PanelItems: PPluginPanelItemArr;
    var ItemsNumber: integer): integer; stdcall;

  TFarApiFreeDirList = procedure(
    PanelItems: PPluginPanelItemArr); stdcall;

const
// Viewer flags
  VF_NONMODAL      = 01;
  VF_DELETEONCLOSE = 02;

// Editor flags
  EF_NONMODAL      = 01;

type

  TFarApiViewer = function(
    FileName: PChar;
    Title: PChar;
    X1, Y1: integer;
    X2, Y2: integer;
    Flags: DWORD): integer; stdcall;

  TFarApiEditor = function(
    FileName: PChar;
    Title: PChar;
    X1, Y1: integer;
    X2, Y2: integer;
    Flags: DWORD;
    StartLine: integer;
    StartChar: integer): integer; stdcall;

  TFarApiCmpName = function(
    Pattern: PChar;
    FileName: PChar;
    SkipPath: integer): integer; stdcall;

const

  FCT_DETECT = $40000000;

type

  TCharTableSet = packed record
    DecodeTable: packed array[0..255] of char;
    EncodeTable: packed array[0..255] of char;
    UpperTable: packed array[0..255] of char;
    LowerTable: packed array[0..255] of char;
    TableName: packed array[0..127] of char;
  end; { TCharTableSet record }
  PCharTableSet = ^TCharTableSet;

type

  TFarApiCharTable = function(
    Command: integer;
    Buffer: PChar;
    BufferSize: integer): integer; stdcall;

  TFarApiText = procedure(
    X, Y: integer;
    Color: integer;
    Str: PChar); stdcall;

  TFarApiEditorControl = function(
    Command: integer;
    Param: pointer): integer; stdcall;

  TFarApiViewerControl = function(
    Command: integer;
    Param: pointer): integer; stdcall;

const
//   FHELP_*   ShowHelp
  FHELP_SELFHELP   = $0000;
  FHELP_FARHELP    = $0001;
  FHELP_CUSTOMFILE = $0002;
  FHELP_CUSTOMPATH = $0004;

type

//   
  TFarApiShowHelp = function(
    ModuleName: PChar;
    HelpTopic: PChar;
    Flags: DWORD): BOOL; stdcall;

  TFarApiAdvControl = function(
    ModuleNumber: integer;
    Command: integer;
    Param: pointer): integer; stdcall;

const

  EE_READ   = 00;
  EE_SAVE   = 01;
  EE_REDRAW = 02;
  EE_CLOSE  = 03;

  _EEREDRAW_ALL    : DWORD = 0;
  _EEREDRAW_CHANGE : DWORD = 1;
  _EEREDRAW_LINE   : DWORD = 2;

  EEREDRAW_ALL    : pointer = @_EEREDRAW_ALL;
  EEREDRAW_CHANGE : pointer = @_EEREDRAW_CHANGE;
  EEREDRAW_LINE   : pointer = @_EEREDRAW_LINE;

const

// EditorControl commands
  ECTL_GETSTRING    = 00;
  ECTL_SETSTRING    = 01;
  ECTL_INSERTSTRING = 02;
  ECTL_DELETESTRING = 03;
  ECTL_DELETECHAR   = 04;
  ECTL_INSERTTEXT   = 05;
  ECTL_GETINFO      = 06;
  ECTL_SETPOSITION  = 07;
  ECTL_SELECT       = 08;
  ECTL_REDRAW       = 09;
  ECTL_EDITORTOOEM  = 10;
  ECTL_OEMTOEDITOR  = 11;
  ECTL_TABTOREAL    = 12;
  ECTL_REALTOTAB    = 13;
  ECTL_EXPANDTABS   = 14;
  ECTL_SETTITLE     = 15;
  ECTL_READINPUT    = 16;
  ECTL_PROCESSINPUT = 17;
  ECTL_ADDCOLOR     = 18;
  ECTL_GETCOLOR     = 19;
  ECTL_SAVEFILE     = 20;
  ECTL_QUIT         = 21;
  ECTL_SETKEYBAR    = 22;
  ECTL_PROCESSKEY   = 23;

// ViewerControl commands
  VCTL_GETINFO      = 00;
  VCTL_SETPOS       = 01;
  VCTL_REDRAW       = 02;
  VCTL_SETKEYBAR    = 03;
  VCTL_QUIT         = 04;

type

  TViewerMode = packed record
    UseDecodeTable: integer;
    TableNum: integer;
    AnsiText: integer;
    Unicode: integer;
    Wrap: integer;
    TypeWrap: integer;
    Hex: integer;
    Reserved: array[0..3] of DWORD;
  end;
  PViewerMode = ^TViewerMode;

  TViewerInfo = packed record
    StructSize: integer;
    ViewerID: integer;
    FileName: PChar;
    FileSize: DWORD;
    Reserved1: DWORD;
    FilePos: DWORD;
    Reserved2: DWORD;
    WindowSizeX: integer;
    WindowSizeY: integer;
    Options: DWORD;
    TabSize: integer;
    CurMode: TViewerMode;
  end;
  PViewerInfo = ^TViewerInfo;

type

  TEditorGetString = packed record
    StringNumber: integer;
    StringText: PChar;
    StringEOL: PChar;
    StringLength: integer;
    SelStart: integer;
    SelEnd: integer;
  end; { TEditorGetString record }
  PEditorGetString = ^TEditorGetString;

  TEditorSetString = packed record
    StringNumber: integer;
    StringText: PChar;
    StringEOL: PChar;
    StringLength: integer;
  end; { TEditorSetString record }
  PEditorSetString = ^TEditorSetString;


const

  EOPT_EXPANDTABS       = 01;
  EOPT_PERSISTENTBLOCKS = 02;
  EOPT_DELREMOVESBLOCKS = 04;
  EOPT_AUTOINDENT       = 08;
  EOPT_SAVEFILEPOSITION = 16;
  EOPT_AUTODETECTTABLE  = 32;
  EOPT_CURSORBEYONDEOL  = 64;

const

  BTYPE_NONE   = 00;
  BTYPE_STREAM = 01;
  BTYPE_COLUMN = 02;

type

  TEditorInfo = packed record
    EditorID: integer;
    FileName: PChar;
    WindowSizeX: integer;
    WindowSizeY: integer;
    TotalLines: integer;
    CurLine: integer;
    CurPos: integer;
    CurTabPos: integer;
    TopScreenLine: integer;
    LeftPos: integer;
    Overtype: integer;
    BlockType: integer;
    BlockStartLine: integer;
    AnsiMode: integer;
    TableNum: integer;
    Options: DWORD;
    TabSize: integer;
    Reserved: packed array[0..7] of DWORD;
  end; { TEditorInfo record }
  PEditorInfo = ^TEditorInfo;

  TEditorSetPosition = packed record
    CurLine: integer;
    CurPos: integer;
    CurTabPos: integer;
    TopScreenLine: integer;
    LeftPos: integer;
    Overtype: integer;
  end; { TEditorSetPosition record }
  PEditorSetPosition = ^TEditorSetPosition;

  TEditorSelect = packed record
    BlockType: integer;
    BlockStartLine: integer;
    BlockStartPos: integer;
    BlockWidth: integer;
    BlockHeight: integer;
  end; { TEditorSelect record }
  PEditorSelect = ^TEditorSelect;

  TEditorConvertText = packed record
    Text: PChar;
    TextLength: integer;
  end; { TEditorConvertText record }
  PEditorConvertText = ^TEditorConvertText;

  TEditorConvertPos = packed record
    StringNumber: integer;
    SrcPos: integer;
    DestPos: integer;
  end; { TEditorConvertPos }
  PEditorConvertPos = ^TEditorConvertPos;

  TEditorColor = packed record
    StringNumber: integer;
    ColorItem: integer;
    StartPos: integer;
    EndPos: integer;
    Color: integer;
  end; { TEditorColor record }
  PEditorColor = ^TEditorColor;

  TEditorSaveFile = packed record
    FileName: packed array[0..Pred(NM)] of char;
    FileEOL: PChar;
  end; { TEditorSaveFile record }
  PEditorSaveFile = ^TEditorSaveFile;

type
//       
  TFarStdUnquote = procedure(
    Str: PChar); stdcall;

//       
  TFarStdExpandEnvironmentStr = function(
    Src: PChar;
    Dst: PChar;
    Size: DWORD): DWORD; stdcall;

const
//   InputBox
  FIB_ENABLEEMPTY      = $0001;
  FIB_PASSWORD         = $0002;
  FIB_EXPANDENV        = $0004;
//      -   
  FIB_NOUSELASTHISTORY = $0008;
//    -   <Ok> & <Cancel>
  FIB_BUTTONS          = $0010;

type
//   
  TFarApiInputBox = function(
    Title: PChar;
    SubTitle: PChar;
    HistoryName: PChar;
    SrcText: PChar;
    DstText: PChar;
    DstLength: integer;
    HelpTopic: PChar;
    Flags: DWORD): integer; stdcall;

// typedef int   (WINAPIV *FARSTDSPRINTF)(char *buffer,const char *format,...);
// typedef int   (WINAPIV *FARSTDSSCANF)(const char *s, const char *format,...);

  TFarStdQSortFunc = function(
    Param1: pointer;
    Param2: pointer): integer; cdecl;

  TFarStdQSort = procedure(
    Base: pointer;
    NElem: size_t;
    Width: size_t;
    fcmp: TFarStdQSortFunc); stdcall;

  TFarStdBSearch = procedure(
    Key: pointer;
    Base: pointer;
    NElem: size_t;
    Width: size_t;
    fcmp: TFarStdQSortFunc); stdcall;

  TFarStdGetFileOwner = function(
    Computer: PChar;
    Name: PChar;
    Owner: PChar): integer; stdcall;

  TFarStdGetNumberOfLinks = function(
    Name: PChar): integer; stdcall;

type

  TFarStdatoi = function(
    S: PChar): integer; stdcall;

{$IFDEF USE_DELPHI4}
  TFarStdAToI64 = function(
    S: PChar): int64; stdcall;

  TFarStdIToA64 = function(
    Value: int64;
    Str: PChar;
    Radix: integer): PChar; stdcall;
{$ENDIF}

  TFarStdIToA = function(
    Value: integer;
    Str: PChar;
    Radix: integer): PChar; stdcall;

  TFarStdLTrim = function(
    Str: PChar): PChar; stdcall;

  TFarStdRTrim = function(
    Str: PChar): PChar; stdcall;

  TFarStdTrim = function(
    Str: PChar): PChar; stdcall;

  TFarStdTruncStr = function(
    Str: PChar;
    MaxLength: integer): PChar; stdcall;

  TFarStdTruncPathStr = function(
    Str: PChar;
    MaxLength: integer): PChar; stdcall;

  TFarStdQuoteSpaceOnly = function(
    Str: PChar): PChar; stdcall;

  TFarStdPointToName = function(
    Path: PChar): PChar; stdcall;

  TFarStdGetPathRoot = procedure(
    Path: PChar;
    Root: PChar); stdcall;

  TFarStdAddEndSlash = function(
    Path: PChar): integer; stdcall;

//    
  TFarStdCopyToClipboard = function(
    Data: PChar): integer; stdcall;

  TFarStdPasteFromClipboard = function: PChar; stdcall;

  TFarStdKeyToKeyName = function(
    Key: integer; KeyName: PChar; Size: integer): BOOL; stdcall;

  TFarStdKeyNameToKey = function(
    Name: PChar): integer; stdcall;

  TFarStdLocalIsLower = function(
    Ch: integer): integer; stdcall;

  TFarStdLocalIsUpper = function(
    Ch: integer): integer; stdcall;

  TFarStdLocalIsAlpha = function(
    Ch: integer): integer; stdcall;

  TFarStdLocalIsAlphaNum = function(
    Ch: integer): integer; stdcall;

  TFarStdLocalUpper = function(
    LowerChar: integer): integer; stdcall;

  TFarStdLocalLower = function(
    UpperChar: integer): integer; stdcall;

  TFarStdLocalUpperBuf = procedure(
    Buf: PChar;
    Length: integer); stdcall;

  TFarStdLocalLowerBuf = procedure(
    Buf: PChar;
    Length: integer); stdcall;

  TFarStdLocalStrUpr = procedure(
    s1: PChar); stdcall;

  TFarStdLocalStrLwr= procedure(
    s1: PChar); stdcall;

  TFarStdLocalStrICmp = function(
    s1: PChar;
    s2: PChar): integer; stdcall;

  TFarStdLocalStrNICmp = function(
    s1: PChar;
    s2: PChar;
    n: integer): integer; stdcall;

  TFarStdInputRecordToKey = function(
    var R: INPUT_RECORD): integer; stdcall;

const
  PN_CMPNAME      = $000000;
  PN_CMPNAMELIST  = $001000;
  PN_GENERATENAME = $002000;
  PN_SKIPPATH     = $100000;

type

  TFarStdProcessName = function(
    Param1: PChar;
    Param2: PChar;
    Flags: DWORD): integer;

const

  XLAT_SWITCHKEYBLAYOUT = $00000001; //   
                                     //   XLAT
  XLAT_SWITCHKEYBBEEP   = $00000002;

type

  TFarStdXLAT = function(
    Line: PChar;
    StartPos: integer;
    EndPos: integer;
    TableSet: PCharTableSet;
    Flags: DWORD): PChar; stdcall;


  TFRSFunction = function(
    var FindData: TWin32FindDataEx;
    FullName: PChar): integer; stdcall;

  TFarRecursiveSearch = procedure(
    InitDir: PChar;
    Mask: PChar;
    Func: TFRSFunction;
    Flags: DWORD); stdcall;

  TFarStdMkTemp = function(
    Dest: PChar;
    Prefix: PChar): PChar; stdcall;

  TFarStdDeleteBuffer = procedure(
    Buffer: PChar); stdcall;

const
  FRS_SETUPDIR = $0001;
  FRS_RECUR    = $0002;

type

  TFarStandardFunctions = packed record
    StructSize: integer;

    atoi: TFarStdAToI;
{$IFDEF USE_DELPHI4}
    atoi64: TFarStdAToI64;
{$ELSE}
    atoi64: pointer;
{$ENDIF}

    itoa: TFarStdIToA;
{$IFDEF USE_DELPHI4}
    itoa64: TFarStdIToA64;
{$ELSE}
    itoa64: pointer;
{$ENDIF}

    sprintf: pointer;
    sscanf:  pointer;

    qsort: TFarStdQSort;
    bsearch: TFarStdBSearch;

    Reserved: packed array[0..9] of DWORD;

    LIsLower:    TFarStdLocalIsLower;
    LIsUpper:    TFarStdLocalIsUpper;
    LIsAlpha:    TFarStdLocalIsAlpha;
    LIsAlphanum: TFarStdLocalIsAlphaNum;
    LUpper:      TFarStdLocalUpper;
    LLower:      TFarStdLocalLower;
    LUpperBuf:   TFarStdLocalUpperBuf;
    LLowerBuf:   TFarStdLocalLowerBuf;
    LStrUpr:     TFarStdLocalStrUpr;
    LStrLwr:     TFarStdLocalStrLwr;
    LStrICmp:    TFarStdLocalStrICmp;
    LStrNICmp:   TFarStdLocalStrNICmp;

    Unquote: TFarStdUnquote;
    ExpandEnvironmentStr: TFarStdExpandEnvironmentStr;
    LTrim: TFarStdLTrim;
    RTrim: TFarStdRTrim;
    Trim: TFarStdTrim;
    TruncStr: TFarStdTruncStr;
    TruncPathStr: TFarStdTruncPathStr;
    QuoteSpaceOnly: TFarStdQuoteSpaceOnly;
    PointToName: TFarStdPointToName;
    GetPathRoot: TFarStdGetPathRoot;
    AddEndSlash: TFarStdAddEndSlash;
    CopyToClipboard: TFarStdCopyToClipboard;
    PasteFromClipboard: TFarStdPasteFromClipboard;
    FarKeyToName: TFarStdKeyToKeyName;
    FarNameToKey: TFarStdKeyNameToKey;
    FarInputRecordToKey: TFarStdInputRecordToKey;
    XLAT: TFarStdXLAT;
    GetFileOwner: TFarStdGetFileOwner;
    GetNumberOfLinks: TFarStdGetNumberOfLinks;
    FarRecurseSearch: TFarRecursiveSearch;
    MkTemp: TFarStdMkTemp;
    DeleteBuffer: TFarStdDeleteBuffer;
    ProcessName: TFarStdProcessName;
  end; { TFarStandardFunctions record }
  PFarStandardFunctions = ^TFarStandardFunctions;

type

  TPluginStartupInfo = packed record
    StructSize: integer;
    ModuleName: packed array[0..Pred(NM)] of char;
    ModuleNumber: integer;
    RootKey: PChar;
    Menu: TFarApiMenu;
    Dialog: TFarApiDialog;
    Message: TFarApiMessage;
    GetMsg: TFarApiGetMsg;
    Control: TFarApiControl;
    SaveScreen: TFarApiSaveScreen;
    RestoreScreen: TFarApiRestoreScreen;
    GetDirList: TFarApiGetDirList;
    GetPluginDirList: TFarApiGetPluginDirList;
    FreeDirList: TFarApiFreeDirList;
    Viewer: TFarApiViewer;
    Editor: TFarApiEditor;
    CmpName: TFarApiCmpName;
    CharTable: TFarApiCharTable;
    Text: TFarApiText;
    EditorControl: TFarApiEditorControl;
//          far.exe
    FSF: PFarStandardFunctions;
//    
    ShowHelp: TFarApiShowHelp;
//  ,      ,   , ...
    AdvControl: TFarApiAdvControl;
//     
    InputBox: TFarApiInputBox;
    DialogEx: TFarApiDialogEx;
    SendDlgMessage: TFarApiSendDlgMessage;
    DefDlgProc: TFarApiDefDlgProc;
    Reserved: DWORD;
    ViewerControl: TFarApiViewerControl;
  end; { TPluginStartupInfo record }
  PPluginStartupInfo = ^TPluginStartupInfo;

const

  PF_PRELOAD        = $0001;
  PF_DISABLEPANELS  = $0002;
  PF_EDITOR         = $0004;
  PF_VIEWER         = $0008;
//         
  PF_FULLCMDLINE    = $0010;

type

  TPluginInfo = packed record
    StructSize: integer;
    Flags: DWORD;
    DiskMenuStrings: PPCharArr;
    DiskMenuNumbers: PIntArr;
    DiskMenuStringsNumber: integer;
    PluginMenuStrings: PPCharArr;
    PluginMenuStringsNumber: integer;
    PluginConfigStrings: PPCharArr;
    PluginConfigStringsNumber: integer;
    CommandPrefix: PChar;
    Reserved: DWORD;
  end; {TPluginInfo record }
  PPluginInfo = ^TPluginInfo;

  TInfoPanelLine = packed record
    Text: packed array[0..79] of char;
    Data: packed array[0..79] of char;
    Separator: integer;
  end; { TInfoPanelLine record }
  PInfoPanelLine = ^TInfoPanelLine;
  TInfoPanelLineArr = packed array[0..Pred(MaxInt div SizeOf(TInfoPanelLine))] of TInfoPanelLine;
  PInfoPanelLineArr = ^TInfoPanelLineArr;

  TPanelMode = packed record
    ColumnTypes: PChar;
    ColumnWidths: PChar;
    ColumnTitles: PPCharArr;
    FullScreen: integer;
    DetailedStatus: integer;
    AlignExtensions: integer;
    CaseConversion: integer;
    StatusColumnTypes: PChar;
    StatusColumnWidths: PChar;
    Reserved: packed array[0..1] of DWORD;
  end; { TPanelMode record }
  PPanelMode = ^TPanelMode;
  TPanelModeArr = packed array[0..Pred(MaxInt div SizeOf(TPanelMode))] of TPanelMode;
  PPanelModeArr = ^TPanelModeArr;

const

  OPIF_USEFILTER               = $0001;
  OPIF_USESORTGROUPS           = $0002;
  OPIF_USEHIGHLIGHTING         = $0004;
  OPIF_ADDDOTS                 = $0008;
  OPIF_RAWSELECTION            = $0010;
  OPIF_REALNAMES               = $0020;
  OPIF_SHOWNAMESONLY           = $0040;
  OPIF_SHOWRIGHTALIGNNAMES     = $0080;
  OPIF_SHOWPRESERVECASE        = $0100;
  OPIF_FINDFOLDERS             = $0200;
  OPIF_COMPAREFATTIME          = $0400;
  OPIF_EXTERNALGET             = $0800;
  OPIF_EXTERNALPUT             = $1000;
  OPIF_EXTERNALDELETE          = $2000;
  OPIF_EXTERNALMKDIR           = $4000;
  OPIF_USEATTRHIGHLIGHTING     = $8000;

const

  SM_DEFAULT        = 00;
  SM_UNSORTED       = 01;
  SM_NAME           = 02;
  SM_EXT            = 03;
  SM_MTIME          = 04;
  SM_CTIME          = 05;
  SM_ATIME          = 06;
  SM_SIZE           = 07;
  SM_DESCR          = 08;
  SM_OWNER          = 09;
  SM_COMPRESSEDSIZE = 10;
  SM_NUMLINKS       = 11;


type

  TKeyBarTitles = packed record
    Titles: packed array[0..11] of PChar;
    CtrlTitles: packed array[0..11] of PChar;
    AltTitles: packed array[0..11] of PChar;
    ShiftTitles: packed array[0..11] of PChar;
// 
    CtrlShiftTitles: packed array[0..11] of PChar;
    AltShiftTitles: packed array[0..11] of PChar;
    CtrlAltTitles: packed array[0..11] of PChar;
  end; { TKeyBarTitles record }
  PKeyBarTitles = ^TKeyBarTitles;

  TOpenPluginInfo = packed record
    StructSize: integer;
    Flags: DWORD;
    HostFile: PChar;
    CurDir: PChar;
    Format: PChar;
    PanelTitle: PChar;
    InfoLines: PInfoPanelLineArr;
    InfoLinesNumber: integer;
    DescrFiles: PPCharArr;
    DescrFilesNumber: integer;
    PanelModesArray: PPanelModeArr;
    PanelModesNumber: integer;
    StartPanelMode: integer;
    StartSortMode: integer;
    StartSortOrder: integer;
    KeyBar: PKeyBarTitles;
    ShortcutData: PChar;
//     + ,  ,   FAR <= 1.65  > 1.65
    Reserved: DWORD;
  end; { TOpenPluginInfo record }
  POpenPluginInfo = ^TOpenPluginInfo;

const

  OPEN_DISKMENU    = 00;
  OPEN_PLUGINSMENU = 01;
  OPEN_FINDLIST    = 02;
  OPEN_SHORTCUT    = 03;
  OPEN_COMMANDLINE = 04;
  OPEN_EDITOR      = 05;
  OPEN_VIEWER      = 06;
  OPEN_FILEPANEL   = 07;

const

  PKF_CONTROL = 01;
  PKF_ALT     = 02;
  PKF_SHIFT   = 04;

const

  FE_CHANGEVIEWMODE = 00;
  FE_REDRAW         = 01;
  FE_IDLE           = 02;
  FE_CLOSE          = 03;
  FE_BREAK          = 04;
  FE_COMMAND        = 05;

const

  OPM_SILENT   = 01;
  OPM_FIND     = 02;
  OPM_VIEW     = 04;
  OPM_EDIT     = 08;
  OPM_TOPLEVEL = 16;
  OPM_DESCR    = 32;

implementation

end.
