unit Reg;

interface

uses
  Windows;

var
  PluginRootKey, FARRootKey: string;

procedure SetRegKey(const PRK: string; hRoot: HKEY; Key, ValueName, ValueData: PChar); overload;
procedure SetRegKey(const PRK: string; hRoot: HKEY; Key, ValueName, ValueData: PChar; DataSize: Integer); overload;
procedure SetRegKey(const PRK: string; hRoot: HKEY; Key, ValueName: PChar; ValueData: DWORD); overload;
function GetRegKey(const PRK: string; hRoot: HKEY; Key, ValueName, ValueData, Default: PChar; DataSize: DWORD): Boolean; overload;
function GetRegKey(const PRK: string; hRoot: HKEY; Key, ValueName: PChar; var ValueData: Integer; Default: DWORD): Boolean; overload;
function GetRegKey(const PRK: string; hRoot: HKEY; Key, ValueName: PChar; Default: DWORD): Integer; overload;
function GetRegKey(const PRK: string; hRoot: HKEY; Key, ValueName: PChar): string; overload;

implementation

function CStr(const s: string): PChar;
begin
  if s = '' then
    Result := ''
  else
    Result := Pointer(s);
end;

function CreateRegKey(const PRK: string; hRoot: HKEY; Key: PChar): HKEY; forward;
function OpenRegKey(const PRK: string; hRoot: HKEY; Key: PChar): HKEY; forward;

procedure SetRegKey(const PRK: string; hRoot: HKEY; Key, ValueName, ValueData: PChar); overload;
var
  hKey: Windows.HKEY;
begin
  hKey := CreateRegKey(PRK, hRoot, Key);
  RegSetValueEx(hKey, ValueName, 0, REG_SZ, ValueData, lstrlen(ValueData) + 1);
  RegCloseKey(hKey);
end;

procedure SetRegKey(const PRK: string; hRoot: HKEY; Key, ValueName, ValueData: PChar; DataSize: Integer); overload;
var
  hKey: Windows.HKEY;
begin
  hKey := CreateRegKey(PRK, hRoot, Key);
  RegSetValueEx(hKey, ValueName, 0, REG_BINARY, ValueData, DataSize);
  RegCloseKey(hKey);
end;

procedure SetRegKey(const PRK: string; hRoot: HKEY; Key, ValueName: PChar; ValueData: DWORD); overload;
var
  hKey: Windows.HKEY;
begin
  hKey := CreateRegKey(PRK, hRoot, Key);
  RegSetValueEx(hKey, ValueName, 0, REG_DWORD, @ValueData, Sizeof(ValueData));
  RegCloseKey(hKey);
end;

function GetRegKey(const PRK: string; hRoot: HKEY; Key, ValueName, ValueData, Default: PChar; DataSize: DWORD): Boolean; overload;
var
  hKey: Windows.HKEY;
  Typ: DWORD;
  ExitCode: Integer;
begin
  hKey := OpenRegKey(PRK, hRoot, Key);
  ExitCode := RegQueryValueEx(hKey, ValueName, nil, @Typ, @ValueData, @DataSize);
  RegCloseKey(hKey);
  if (hKey = 0) or (ExitCode <> ERROR_SUCCESS) then
  begin
    lstrcpy(ValueData, Default);
    Result := FALSE;
  end
  else
    Result := TRUE;
end;

function GetRegKey(const PRK: string; hRoot: HKEY; Key, ValueName: PChar; var ValueData: Integer; Default: DWORD): Boolean; overload;
var
  hKey: Windows.HKEY;
  Typ, Size: DWORD;
  ExitCode: Integer;
begin
  hKey := OpenRegKey(PRK, hRoot, Key);
  Size := Sizeof(ValueData);
  ExitCode := RegQueryValueEx(hKey, ValueName, nil, @Typ, @ValueData, @Size);
  RegCloseKey(hKey);
  if (hKey = 0) or (ExitCode <> ERROR_SUCCESS) then
  begin
    ValueData := Default;
    Result := FALSE;
  end
  else
    Result := TRUE;
end;

function GetRegKey(const PRK: string; hRoot: HKEY; Key, ValueName: PChar): string; overload;
var
  hKey: Windows.HKEY;
  Typ, Size: DWORD;
  ExitCode: Integer;
begin
  hKey := OpenRegKey(PRK, hRoot, Key);
  ExitCode := RegQueryValueEx(hKey, ValueName, nil, @Typ, nil, @Size);
  if (hKey <> 0) and (ExitCode = ERROR_SUCCESS) then
  begin
    SetLength(Result, Size);
    ExitCode := RegQueryValueEx(hKey, ValueName, nil, @Typ, Pointer(Result), @Size);
  end;
  RegCloseKey(hKey);
  if (hKey = 0) or (ExitCode <> ERROR_SUCCESS) then
    Result := '';
end;

function GetRegKey(const PRK: string; hRoot: HKEY; Key, ValueName: PChar; Default: DWORD): Integer; overload;
var
  ValueData: Integer;
begin
  GetRegKey(PRK, hRoot, Key, ValueName, ValueData, Default);
  Result := ValueData;
end;

procedure GetFullKeyName(const PRK: string; FullKeyName: PChar; Key: PChar);
begin
  if PRK <> '' then
    lstrcpy(FullKeyName, CStr(PRK))
  else
    lstrcpy(FullKeyName, CStr(PluginRootKey));
  Inc(FullKeyName, lstrlen(FullKeyName));
  if (Key <> nil) and (Key^ <> #0) then
  begin
    FullKeyName^ := '\';
    Inc(FullKeyName);
    lstrcpy(FullKeyName, Key);
  end;
end;

function CreateRegKey(const PRK: string; hRoot: HKEY; Key: PChar): HKEY;
var
  hKey: Windows.HKEY;
  Disposition: DWORD;
  FullKeyName: array [0..512-1] of Char;
begin
  GetFullKeyName(PRK, FullKeyName, Key);
  RegCreateKeyEx(hRoot, FullKeyName, 0, nil, 0, KEY_WRITE, nil,
    hKey, @Disposition);
  Result := hKey;
end;

function OpenRegKey(const PRK: string; hRoot: HKEY; Key: PChar): HKEY;
var
  hKey: Windows.HKEY;
  FullKeyName: array [0..512-1] of Char;
begin
  GetFullKeyName(PRK, FullKeyName, Key);
  if (RegOpenKeyEx(hRoot, FullKeyName, 0, KEY_QUERY_VALUE, hKey) <> ERROR_SUCCESS) then
    Result := 0
  else
    Result := hKey;
end;

end.

