{$APPTYPE CONSOLE}
{$MINENUMSIZE 4}
library FolderMode;

uses
  Windows,
  plugin in 'plugin.pas',
  Reg in 'Reg.pas';

{$R *.res}

const
  PluginVersion = $0101; // HIWORD      = build
                         // HIBYTE	= major version number.
                         // LOBYTE	= minor version number.

type
  TMessage = (MTitle, MRestoreMode, MStoreSubfolders, MStoreMode, MTakeFromParent, MResetMode,
    MUpdateMode, MTurnOn, MTurnOff, MFoldersHistory, CFoldersHistory, MFolderModePlugin,
    MMyFoldersHistory, CMyFoldersHistory, MTitleDummy);

var
  FARAPI: TPluginStartupInfo;
  FSF: TFarStandardFunctions;

type
  _my_TPanelInfo = packed record
    PanelType: integer;
    Plugin: integer;
    PanelRect: TRect;
    PanelItems: PPluginPanelItemArr;
    ItemsNumber: integer;
    SelectedItems: PPluginPanelItemArr;
    SelectedItemsNumber: integer;
    CurrentItem: integer;
    TopPanelItem: integer;
    Visible: integer;
    Focus: integer;
    ViewMode: integer;
    ColumnTypes: packed array[0..79] of char;
    ColumnWidths: packed array[0..79] of char;
    CurDir: packed array[0..Pred(NM)] of char;
    ShortNames: integer;
    SortMode: integer;
    SortOrder: integer; // additional member, it is absent in TPanelInfo
    Reserved: packed array[0..0] of DWORD; // one less than in TPanelInfo
  end; { TPanelInfo record }

function GetMsg(MsgId: TMessage): PChar;
begin
  Result:= FARAPI.GetMsg(FARAPI.ModuleNumber, Integer(MsgId));
end;

var
  OriginalFarApiControl: TFarApiControl;

function _my_FarApiControl(hPlugin: THandle; Command: Integer; Param: Pointer): Integer; stdcall;
var
  Ch: Char;
  Crd: TCoord;
  k: DWORD;
begin
  Result := OriginalFarApiControl(hPlugin, Command, Param);
  if (Command = FCTL_GETPANELINFO) or (Command = FCTL_GETANOTHERPANELINFO) then
  begin
    Crd.X := TPanelInfo(Param^).PanelRect.Left + 1;
    Crd.Y := TPanelInfo(Param^).PanelRect.Top + 1;
    if ReadConsoleOutputCharacter(GetStdHandle(STD_OUTPUT_HANDLE), @Ch, 1, Crd, k) and (k = 1) then
      _my_TPanelInfo(Param^).SortOrder := Ord(IsCharUpper(Ch))
    else
      _my_TPanelInfo(Param^).SortOrder := 0;
  end;
end;

procedure LoadSettings; forward;

procedure SetStartupInfo(var psi: TPluginStartupInfo); stdcall;
begin
  Move(psi, FARAPI, SizeOf(FARAPI));
  OriginalFarApiControl := FARAPI.Control;
  FARAPI.Control := _my_FarApiControl;
  Move(psi.FSF^, FSF, SizeOf(FSF));
  SetString(FARRootKey, FARAPI.RootKey, lstrlen(FARAPI.RootKey) - 8);
  PluginRootKey := FARAPI.RootKey + '\FolderMode';
  LoadSettings;
end;

var
  PluginMenuStrings: array[0..0] of PChar;

procedure GetPluginInfo(var pi: TPluginInfo); stdcall;
begin
  pi.StructSize:= SizeOf(pi);
  pi.CommandPrefix := nil;
  pi.Flags := PF_EDITOR + PF_VIEWER;

  PluginMenuStrings[0]:= GetMsg(MTitle);
  pi.PluginMenuStrings:= @PluginMenuStrings;
  pi.PluginMenuStringsNumber:= 1;
end;

type
  TLeftRight = (lrLeft, lrRight);

var
  DirList: array of record
    Path: string;
    Flags: DWORD;
    Mode: Integer;
    Sort: Integer;
    Order: Integer;
    Time: Integer;
  end;
  DirCount: Integer;
  TimeTime: Integer;

  DefaultMode, DefaultSort, DefaultOrder: {array [TLeftRight] of }Integer;
  Trace: Boolean = True;
  MyMode: Boolean = False;

const
  flSubDir = 1;
  flDefault = 2;

function IncCapacity(c: Integer): Integer;
begin
  Result := c + c div 6 + 4;
end;

function CStr(const s: string): PChar;
begin
  if s = '' then
    Result := ''
  else
    Result := Pointer(s);
end;

type
  TAllowSubFld = (fGeneral, fAlways, fNone);

function GetFolderMode(Folder: PChar; UpdateAccessTime: Boolean = True; AllowSubFld: TAllowSubFld = fGeneral): Integer;
var
  a, b, c, i, l: Integer;
begin
  l := lstrlen(Folder);
  if Folder[l - 1] = '\' then
    Dec(l); 
  a := 0;
  b := DirCount;
  while a < b do
  begin
    c := (a + b) div 2;
    case CompareString(LOCALE_USER_DEFAULT, NORM_IGNORECASE, Folder, l,
      CStr(DirList[c].Path), -1)
    of
      2:
      begin
        Result := c;
        if UpdateAccessTime then
        begin
          Inc(TimeTime);
          DirList[Result].Time := TimeTime;
        end;
        Exit;
      end;
      1: b := c;
      3: a := c + 1;
    else
      Result := -2;
      Exit;
    end;
  end;
  if AllowSubFld <> fNone then
  begin
    for i := a - 1 downto 0 do
      if (AllowSubFld = fAlways) or (AllowSubFld = fGeneral) and (DirList[i].Flags and flSubDir <> 0) then
      begin
        c := Length(DirList[i].Path);
        if (l > c) and (Folder[c] = '\') and
          (CompareString(LOCALE_USER_DEFAULT, NORM_IGNORECASE, Folder, c, CStr(DirList[i].Path), c) = 2)
        then
        begin
          Result := i;
          if UpdateAccessTime then
          begin
            Inc(TimeTime);
            DirList[Result].Time := TimeTime;
          end;
          Exit;
        end;
      end;
  end;
  Result := -a - 1;
end;

procedure GetDirListSpace(c: Integer = 1);
begin
  if DirCount + c >= Length(DirList) then
    SetLength(DirList, IncCapacity(DirCount + c));
end;

procedure SaveFolderMode(Path: PChar; Mode, Sort, Order, Flags: Integer);
var
  Index, l: Integer;
begin
  if (Path = nil) or (Path^ = #0) then
    Exit;
  Index := GetFolderMode(Path, True, fNone);
  if Index < 0 then
  begin
    GetDirListSpace();
    Index := -Index - 1;
    Finalize(DirList[DirCount]);
    Move(DirList[Index], DirList[Index + 1], (DirCount - Index) * Sizeof(DirList[0]));
    FillChar(DirList[Index], Sizeof(DirList[0]), 0);
    Inc(DirCount);
    l := lstrlen(Path);
    if Path[l - 1] = '\' then
      Dec(l);
    SetString(DirList[Index].Path, Path, l);
  end;
  DirList[Index].Mode := Mode;
  DirList[Index].Sort := Sort;
  DirList[Index].Order := Order;
  DirList[Index].Flags := Flags;
end;

procedure DeleteFolderMode(Index: Integer); overload;
begin
  if (Index >= 0) and (Index < DirCount) then
  begin
    Finalize(DirList[Index]);
    Move(DirList[Index + 1], DirList[Index], (DirCount - Index - 1) * Sizeof(DirList[0]));
    Dec(DirCount);
    FillChar(DirList[DirCount], Sizeof(DirList[0]), 0);
  end;
end;

procedure DeleteFolderMode(Path: PChar); overload;
begin
  if (Path = nil) or (Path^ = #0) then
    Exit;
  DeleteFolderMode(GetFolderMode(Path, False, fNone));
end;

function GetCurrentPanel(var pi: TPanelInfo): TLeftRight;
var
  qi: TPanelInfo;
begin
  FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_GETANOTHERPANELINFO, @qi);
  if (pi.PanelRect.Left < qi.PanelRect.Left) or (pi.PanelRect.Right < qi.PanelRect.Right) then
    Result := lrLeft
  else
    Result := lrRight;
end;

procedure UpdateDir(var pi: _my_TPanelInfo);
var
  r: Integer;
begin
  r := GetFolderMode(pi.CurDir, False);
  if r >= 0 then
  begin
    DirList[r].Mode := pi.ViewMode;
    DirList[r].Sort := pi.SortMode;
    DirList[r].Order := pi.SortOrder;
    MyMode := True;
  end
  else
  begin
    DefaultMode := pi.ViewMode;
    DefaultSort := pi.SortMode;
    DefaultOrder := pi.SortOrder;
    MyMode := False;
  end;
end;

procedure RestoreDir(var pi: _my_TPanelInfo);
var
  r: Integer;
begin
  if Trace then
  begin
    r := GetFolderMode(pi.CurDir);
    if r >= 0 then
    begin
      FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_SETVIEWMODE, @DirList[r].Mode);
      FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_SETSORTMODE, @DirList[r].Sort);
      FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_SETSORTORDER, @DirList[r].Order);
      FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_UPDATEPANEL, Pointer(1));
      FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_REDRAWPANEL, nil);
      MyMode := True;
    end
    else if MyMode then
    begin
      FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_SETVIEWMODE, @DefaultMode);
      FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_SETSORTMODE, @DefaultSort);
      FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_SETSORTORDER, @DefaultOrder);
      FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_UPDATEPANEL, Pointer(1));
      FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_REDRAWPANEL, nil);
    end
    else
    begin
      DefaultMode := pi.ViewMode;
      DefaultSort := pi.SortMode;
      DefaultOrder := pi.SortOrder;
    end;
  end;
end;

procedure LimStrCpy(Dst, Src: PChar; MaxWidth: Integer); overload;
var
  l: Integer;
begin
  l := lstrlen(Src);
  if l <= MaxWidth then
    Move(Src[0], Dst[0], l + 1)
  else
  begin
    Dst[0] := '.';
    Dst[1] := '.';
    Dst[2] := '.';
    Move(Src[l - MaxWidth + 3], Dst[3], MaxWidth + (1 - 3))
  end;
end;

function ConsoleSize(): COORD;
var
  s: TConsoleScreenBufferInfo;
begin
  GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), s);
  Result := s.dwSize;
end;

procedure LimStrCpy(Dst, Src: PChar); overload;
begin
  LimStrCpy(Dst, Src, ConsoleSize().x - 13);
end;

procedure FolderHistory;
var
  s: string;
  t: Integer;
  m: array of TFarMenuItem;
  i: Integer;
  p, q, c: PChar;
  pi: _my_TPanelInfo;
  BreakCode: Integer;
const
  Codes: array [0..1] of Integer = (VK_DELETE, 0);
begin
  FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_GETPANELINFO, @pi);
  repeat
    m := nil;
    s := GetRegKey(FARRootKey, HKEY_CURRENT_USER, PChar('SavedFolderHistory'), PChar('Lines'));
    t := GetRegKey(FARRootKey, HKEY_CURRENT_USER, PChar('SavedFolderHistory'), PChar('Position'), 0);
    p := CStr(s);
    q := p + Length(s);
    i := 0;
    c := p;
    while p < q do
    begin
      //010707 if p^ <> #0 then
      begin
        if i = t then
          c := p;
        Inc(i);
      end;
      Inc(p, lstrlen(p) + 1);
    end;
    SetLength(m, i + 1);
    FillChar(m[0], Sizeof(m[0]) * Length(m), 0);
    p := c;
    if i > 0 then
    begin
      i := 0;
      repeat
        if p^ <> #0 then
        begin
          LimStrCpy(m[i].Text, p);
          Inc(i);
        end;
        Inc(p, lstrlen(p) + 1);
        if p = q then
          p := CStr(s);
      until p = c;
    end;
    m[i].Selected := 1;
    i := FARAPI.Menu(FARAPI.ModuleNumber, -1, -1, ConsoleSize().y - 9,
      FMENU_REVERSEAUTOHIGHLIGHT, GetMsg(CFoldersHistory), GetMsg(MFolderModePlugin),
      nil, @Codes, @BreakCode, @m[0], i + 1);
    if BreakCode = 0 then
    begin
      //Clearing menu
      Continue;
    end;
    if (i >= 0) and (i < Length(m) - 1) then
    begin
      UpdateDir(pi);
      FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_SETPANELDIR, @m[i].Text);
      FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_REDRAWPANEL, nil);
      FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_GETPANELINFO, @pi);
      RestoreDir(pi);
    end;
    Break;
  until False;
end;

function Cmp(Param1, Param2: Pointer): Integer; cdecl;
begin
  Result := DirList[Integer(Param1^)].Time - DirList[Integer(Param2^)].Time;
end;

procedure MyFolderHistory;
var
  m: array of TFarMenuItem;
  j: array of Integer;
  i, k: Integer;
  pi: _my_TPanelInfo;
  BreakCode, Current: Integer;
const
  XCodes: array [0..2] of Integer = (VK_DELETE + PKF_CONTROL * 65536, VK_DELETE, 0);
begin
  Current := DirCount - 1;
  repeat
    FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_GETPANELINFO, @pi);
    if Length(j) < DirCount then
      SetLength(j, DirCount);
    for i := 0 to DirCount - 1 do
      j[i] := i;
    FSF.qsort(@j[0], DirCount, Sizeof(j[0]), Cmp);
    if Length(m) < DirCount then
      SetLength(m, DirCount);
    //Finalize(m[0], Length(m));
    FillChar(m[0], Sizeof(m[0]) * DirCount, 0);
    TimeTime := 0;
    for i := 0 to DirCount - 1 do
    begin
      DirList[j[i]].Time := TimeTime;
      Inc(TimeTime);
      LimStrCpy(m[i].Text, CStr(DirList[j[i]].Path));
      k := Length(DirList[j[i]].Path);
      if m[i].Text[k - 1] = ':' then
      begin
        m[i].Text[k] := '\';
        m[i].Text[k + 1] := #0;
      end;
    end;
    if Current >= 0 then
      m[Current].Selected := 1;
    i := FARAPI.Menu(FARAPI.ModuleNumber, -1, -1, ConsoleSize().y - 9,
      FMENU_REVERSEAUTOHIGHLIGHT, GetMsg(CMyFoldersHistory), 'Del,Ctrl-Del', nil,
      @XCodes, @BreakCode, @m[0], DirCount);
    if BreakCode = 1 then
    begin
      DeleteFolderMode(i);
      Current := i;
      if Current >= DirCount then
        Current := DirCount - 1;
      Continue;
    end;
    if BreakCode = 0 then
    begin
      Finalize(DirList[0], DirCount);
      FillChar(DirList[0], DirCount * Sizeof(DirList[0]), 0);
      DirCount := 0;
      Current := -1;
      Continue;
    end;
    if i >= 0 then
    begin
      UpdateDir(pi);
      if m[i].Text[0] = '.' then
        FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_SETPANELDIR, CStr(DirList[j[i]].Path))
      else
        FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_SETPANELDIR, @m[i].Text);
      FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_REDRAWPANEL, nil);
      FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_GETPANELINFO, @pi);
      RestoreDir(pi);
      Inc(TimeTime);
      DirList[j[i]].Time := TimeTime;
    end;
    Break;
  until False;
end;

function OpenPlugin(OpenFrom: Integer; Item: Integer): THandle; stdcall;
var
  r: Integer;
  m: array [0..11] of TFarMenuItem;
  pi: _my_TPanelInfo;
  t: PChar;
begin
  FillChar(m, Sizeof(m), 0);
  lstrcpy(m[0].Text, GetMsg(MStoreSubfolders));
  lstrcpy(m[1].Text, GetMsg(MStoreMode));
  lstrcpy(m[2].Text, GetMsg(MTakeFromParent));
  lstrcpy(m[3].Text, GetMsg(MResetMode));
  lstrcpy(m[4].Text, GetMsg(MMyFoldersHistory));
  m[5].Separator := 1;
  lstrcpy(m[6].Text, GetMsg(MTurnOn));
  m[6].Checked := Ord(Trace);
  lstrcpy(m[7].Text, GetMsg(MTurnOff));
  m[7].Checked := Ord(not Trace);
  m[8].Separator := 1;
  lstrcpy(m[9].Text, GetMsg(MRestoreMode));
  lstrcpy(m[10].Text, GetMsg(MUpdateMode));
  lstrcpy(m[11].Text, GetMsg(MFoldersHistory));
  if OpenFrom = OPEN_PLUGINSMENU then
    t := GetMsg(MTitle)
  else
    t := GetMsg(MTitleDummy);
  r := FARAPI.Menu(FARAPI.ModuleNumber, -1, -1, 0, FMENU_WRAPMODE, t, nil, nil, nil, nil, @m, Length(m));
  if OpenFrom = OPEN_PLUGINSMENU then
  begin
    if (r >= 0) and (FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_GETPANELINFO, @pi) <> 0) then
    begin
      case r of
        0:
        begin
          SaveFolderMode(pi.CurDir, pi.ViewMode, pi.SortMode, pi.SortOrder, flSubDir);
          MyMode := True;
        end;
        1:
        begin
          SaveFolderMode(pi.CurDir, pi.ViewMode, pi.SortMode, pi.SortOrder, 0);
          MyMode := True;
        end;
        2:
        begin
          DeleteFolderMode(pi.CurDir);
          r := GetFolderMode(pi.CurDir, False, fAlways);
          if r >= 0 then
          begin
            if DirList[r].Flags and flSubDir = 0 then
              SaveFolderMode(pi.CurDir, DirList[r].Mode, DirList[r].Sort, DirList[r].Order, 0);
          end;
          RestoreDir(pi);
        end;
        3:
        begin
          DeleteFolderMode(pi.CurDir);
          if MyMode then
          begin
            FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_SETVIEWMODE, @DefaultMode);
            FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_SETSORTMODE, @DefaultSort);
            FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_SETSORTORDER, @DefaultOrder);
            FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_UPDATEPANEL, Pointer(1));
            FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_REDRAWPANEL, nil);
          end;
        end;
        4: MyFolderHistory;
        6:
        if not Trace then
        begin
          Trace := True;
          DefaultMode := pi.ViewMode;
          DefaultSort := pi.SortMode;
          DefaultOrder := pi.SortOrder;
        end;
        7:
        if Trace then
        begin
          Trace := False;
          if MyMode then
          begin
            FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_SETVIEWMODE, @DefaultMode);
            FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_SETSORTMODE, @DefaultSort);
            FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_SETSORTORDER, @DefaultOrder);
            FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_UPDATEPANEL, Pointer(1));
            FARAPI.Control(INVALID_HANDLE_VALUE, FCTL_REDRAWPANEL, nil);
          end;
        end;
        9: RestoreDir(pi);
        10: UpdateDir(pi);
        11: FolderHistory;
      end;
    end;
  end;
  Result := INVALID_HANDLE_VALUE;
end;

const
  id: Integer = $58457033;

procedure ExitFAR; stdcall;
var
  i, k, l: Integer;
  s: string;
  p: ^Integer;
begin
  k := Sizeof(id);
  for i := 0 to DirCount - 1 do
    Inc(k, Sizeof(Integer) * 6 + Length(DirList[i].Path));
  SetLength(s, k);
  p := Pointer(s);
  p^ := ID;
  Inc(p);
  for i := 0 to DirCount - 1 do
  begin
    l := Length(DirList[i].Path);
    p^ := l;
    Inc(p);
    Move(CStr(DirList[i].Path)^, p^, l);
    Inc(PChar(p), l);
    p^ := DirList[i].Mode;
    Inc(p);
    p^ := DirList[i].Sort;
    Inc(p);
    p^ := DirList[i].Order;
    Inc(p);
    p^ := DirList[i].Flags;
    Inc(p);
    p^ := DirList[i].Time;
    Inc(p);
  end;
  SetRegKey('', HKEY_CURRENT_USER, PChar(''), PChar('PathListVer'), PluginVersion);
  SetRegKey('', HKEY_CURRENT_USER, PChar(''), PChar('PathList'), CStr(s), Length(s));
  SetRegKey('', HKEY_CURRENT_USER, PChar(''), PChar('PathCount'), DirCount);
  SetRegKey('', HKEY_CURRENT_USER, PChar(''), PChar('DefView'), DefaultMode);
  SetRegKey('', HKEY_CURRENT_USER, PChar(''), PChar('DefSort'), DefaultSort);
  SetRegKey('', HKEY_CURRENT_USER, PChar(''), PChar('DefOrder'), DefaultOrder);
  SetRegKey('', HKEY_CURRENT_USER, PChar(''), PChar('Time'), TimeTime);
end;

procedure LoadSettings;
var
  sz, v, i, k, l, n: Integer;
  s: string;
  p: ^Integer;
begin
  DirCount := 0;
  DirList := nil;
  v := GetRegKey('', HKEY_CURRENT_USER, PChar(''), PChar('PathListVer'), 0);
  k := GetRegKey('', HKEY_CURRENT_USER, PChar(''), PChar('PathCount'), 0);
  s := GetRegKey('', HKEY_CURRENT_USER, PChar(''), PChar('PathList'));
  DefaultMode := GetRegKey('', HKEY_CURRENT_USER, PChar(''), PChar('DefView'), 0);
  DefaultSort := GetRegKey('', HKEY_CURRENT_USER, PChar(''), PChar('DefSort'), 0);
  DefaultOrder := GetRegKey('', HKEY_CURRENT_USER, PChar(''), PChar('DefOrder'), 0);
  TimeTime := GetRegKey('', HKEY_CURRENT_USER, PChar(''), PChar('Time'), 0);
  n := Length(s);
  p := Pointer(s);
  sz := 5;
  if Word(v) >= $0101 then
    Inc(sz);
  if (n >= Sizeof(id)) and (p^ = id) then
  begin
    Inc(p);
    SetLength(DirList, k);
    Dec(n, Sizeof(id));
    for i := 0 to k - 1 do
    begin
      l := p^;
      if n < l + Sizeof(Integer) * sz then
      begin
        k := i;
        Break;
      end;
      Inc(p);
      SetString(DirList[i].Path, PChar(p), l);
      Inc(PChar(p), l);
      DirList[i].Mode := p^;
      Inc(p);
      DirList[i].Sort := p^;
      Inc(p);
      if v >= $0101 then
      begin
        DirList[i].Order := p^;
        Inc(p);
      end;
      DirList[i].Flags := p^;
      Inc(p);
      DirList[i].Time := p^;
      Inc(p);
      Dec(n, l + Sizeof(Integer) * sz);
    end;
    DirCount := k;
  end;
end;

exports
  SetStartupInfo,
  GetPluginInfo,
  OpenPlugin,
  ExitFAR;

end.
