#include <windows.h>
#include "fmt.hpp"
#include "plugin.hpp"

typedef DWORD (WINAPI *PLUGINLOADFORMATMODULE)(char *ModuleName);
typedef BOOL (WINAPI *PLUGINISARCHIVE)(char *Name,const unsigned char *Data,int DataSize);
typedef BOOL (WINAPI *PLUGINOPENARCHIVE)(char *Name,int *Type);
typedef int (WINAPI *PLUGINGETARCITEM)(struct PluginPanelItem *Item,struct ArcItemInfo *Info);
typedef BOOL (WINAPI *PLUGINCLOSEARCHIVE)(struct ArcInfo *Info);
typedef BOOL (WINAPI *PLUGINGETFORMATNAME)(int Type,char *FormatName,char *DefaultExt);
typedef BOOL (WINAPI *PLUGINGETDEFAULTCOMMANDS)(int Type,int Command,char *Dest);

static HMODULE hModule;
static PLUGINOPENARCHIVE pOpenArchive;
static PLUGINGETARCITEM pGetArcItem;
static PLUGINCLOSEARCHIVE pCloseArchive;
static PLUGINGETFORMATNAME pGetFormatName;
static char PluginsMask[NM];
static int CurType;
static bool BorderFlag;
static int Border;

HMODULE LoadPlugin(int Type, int *SubType)
{
  HANDLE FindHandle;
  WIN32_FIND_DATA fdata;
  int i;

  if(hModule!=NULL) //debug
  {
    MessageBox(0,"! - fmt  楯","訡 :(",MB_OK);
    FreeLibrary(hModule);
  }

  int Done=((FindHandle=FindFirstFile(PluginsMask,&fdata))==INVALID_HANDLE_VALUE);
  for(i=(Border!=0); i<=Type; )
  {
    if(Done)
    {
      BorderFlag=(i==Type && hModule==NULL);
      return NULL;
    }
    char DefaultExt[NM],FormatName[64];
    char PluginName[NM];
    lstrcpy(PluginName,PluginsMask);
    lstrcpy(strrchr(PluginName,'*'),fdata.cFileName);

    hModule=LoadLibrary(PluginName);
    if(hModule)
    {
      PLUGINLOADFORMATMODULE pLoadFormatModule;
      pLoadFormatModule=(PLUGINLOADFORMATMODULE)GetProcAddress(hModule,"LoadFormatModule");
      if(pLoadFormatModule)
        pLoadFormatModule(PluginName);
      pGetFormatName=(PLUGINGETFORMATNAME)GetProcAddress(hModule,"GetFormatName");
      if(pGetFormatName)
        for(*SubType=0; i<=Type; i++)
          if( !pGetFormatName(*SubType,FormatName,DefaultExt) )
          {
            FreeLibrary(hModule);
            hModule=NULL;
            break;
          }
          else
            if(i<Type)
              (*SubType)++;
    }
    Done=!FindNextFile(FindHandle,&fdata);
  }
  FindClose(FindHandle);
  BorderFlag=(i==Type && hModule==NULL);
  return hModule;
}

DWORD WINAPI _export LoadFormatModule(char *ModuleName)
{
  hModule=NULL;
  lstrcpy(PluginsMask,ModuleName);
  lstrcpy(strrchr(PluginsMask,'.'),".ini");
  Border=GetPrivateProfileInt("Options","Border",0,PluginsMask);
  lstrcpy(strrchr(PluginsMask,'.'),"\\*.fmt");
  return 0;
}

BOOL WINAPI _export IsArchive(char *Name,const unsigned char *Data,int DataSize)
{
  int SubType;
  for (int I=(Border!=0);;I++)
  {
    if (!LoadPlugin(I,&SubType)) //SubType  
      return FALSE;
    PLUGINISARCHIVE pIsArchive;
    pIsArchive=(PLUGINISARCHIVE)GetProcAddress(hModule,"IsArchive");
    pOpenArchive=(PLUGINOPENARCHIVE)GetProcAddress(hModule,"OpenArchive");
    pGetArcItem=(PLUGINGETARCITEM)GetProcAddress(hModule,"GetArcItem");
    pCloseArchive=(PLUGINCLOSEARCHIVE)GetProcAddress(hModule,"CloseArchive");
    if(pIsArchive && pOpenArchive && pGetArcItem)
      if(pIsArchive(Name, Data, DataSize))
      {
        CurType=I;
        return TRUE;
      }
      else
      {
//        FreeLibrary(hModule);
//        hModule=NULL;
      }
    else
    {
      char DefaultExt[NM],FormatName[64];
      while(pGetFormatName(++SubType,FormatName,DefaultExt));
      I+=SubType;
//      FreeLibrary(hModule);
//      hModule=NULL;
    }
    FreeLibrary(hModule);
    hModule=NULL;
  }
  return FALSE;
}

BOOL WINAPI _export OpenArchive(char *Name,int *Type)
{
  int SubType;
  BOOL Ret=pOpenArchive(Name,&SubType);
  CurType+=SubType;
  *Type=CurType;
  if(!Ret)
  {
    FreeLibrary(hModule);
    hModule=NULL;
  }
  return Ret;
}

int WINAPI _export GetArcItem(struct PluginPanelItem *Item,struct ArcItemInfo *Info)
{
  return pGetArcItem(Item, Info);
}

BOOL WINAPI _export CloseArchive(struct ArcInfo *Info)
{
  BOOL Ret=TRUE;
  if(pCloseArchive)
    Ret=pCloseArchive(Info);
  FreeLibrary(hModule);
  hModule=NULL;
  return Ret;
}

BOOL WINAPI _export GetFormatName(int Type,char *FormatName,char *DefaultExt)
{
  BOOL Ret=0;
  int SubType;

/*  char Buf[32];
  wsprintf(Buf,"%d",Type);
  MessageBox(0,Buf,"Type",MB_OK);*/

  if(Border && !Type)
  {
    lstrcpy(FormatName," Dynamic Ŀ");
    return TRUE;
  }

  hModule=LoadPlugin(Type,&SubType);

  if(Border && BorderFlag)
  {
    lstrcpy(FormatName,"");
    return TRUE;
  }
  if(hModule)
  {
    if(Border)
    {
      lstrcpy(FormatName,"                       ");
      Ret=pGetFormatName(SubType, FormatName+2, DefaultExt);
      FormatName[lstrlen(FormatName)]=' ';
      lstrcpy(FormatName+23," ");
    }
    else
      Ret=pGetFormatName(SubType, FormatName, DefaultExt);
    FreeLibrary(hModule);
    hModule=NULL;
  }
  return Ret;
}

BOOL WINAPI _export GetDefaultCommands(int Type,int Command,char *Dest)
{
  BOOL Ret=0;
  int SubType;
  if(Border && !Type)
  { 
    static char *CmdNames[]={
      "Fish.fmt  AKA  \" 롪\" :).",
      "v0.0b0  18.06.2000","",
      "-  ண ஢",
      " MultiArc.   㦠 ",
      "   㣨   fmt-㫨  ",
      " ࠡ FAR.",
      "","","","","","","",
      "쥢  ᠭ,  alarf@mail.ru"};
    if (Command<sizeof(CmdNames)/sizeof(CmdNames[0])){
      lstrcpy(Dest,CmdNames[Command]);
      return TRUE;
    }
  }
  hModule=LoadPlugin(Type,&SubType);
  if(Border && BorderFlag)
    return FALSE;
  if(hModule)
  {
    PLUGINGETDEFAULTCOMMANDS pGetDefaultCommands;
    pGetDefaultCommands=(PLUGINGETDEFAULTCOMMANDS)GetProcAddress(hModule,"GetDefaultCommands");
    if(pGetDefaultCommands)
      Ret=pGetDefaultCommands(SubType, Command, Dest);
    FreeLibrary(hModule);
    hModule=NULL;
  }
  return Ret;
}