/*:VRX         Main
*/
Main:
/*
 * File: convert.cmd
 * Version: 1.01
 * 
 * Convert files.bbs (modified Maximus format) to index.html
 *
 * " --" at the beginning of line interpreted as header line
 * file readme of processed directory inserted as page header
 * file header.inc of below specified location inserted as page header
 * file footer.inc of below specified location inserted as page footer
 * It needs to specify some parameters below
 *
 * Copyright (C) by AVN 1996,97
 *    All rights reserved.
 */
  parse arg filebbs

/* Parameters: */
  picdir     = '/pictures';           /* ⠫  ⨭       */
  icondir    = '/icons';              /* ⠫           */
  incdir     = 'f:\webpages\convert'; /* ⠫  䠩 .inc     */
  TitleLine  = "AVN's File Archive";  /* 䨪  ࠭ */
  Abstract   = TitleLine;             /* ⠨ଠ ࠭     */
  KeyWords   = '';
  Owner      = 'avn@nikoil.ru';
  Review     = '';
  Security   = 'public';
  Background     = picdir'/cma-back.jpg'; /*                           */
  Underconstruct = 0;                 /*  ⨭ construct.gif */
  Generation     = 1;                 /*   䨪樨       */
  if( filebbs = '' ) then
    UseFilesBBSOnly = 0;
  else
    UseFilesBBSOnly = 1;              /* ᯮ짮 ⮫쪮 files.bbs    */
/* ----------- */
  table = 0;
  CALL RxFuncAdd 'FileLoadFuncs', 'FILEREXX', 'FileLoadFuncs'
  CALL FileLoadFuncs

  cr   = '0d'x;
  crlf = '0d0a'x;
  tab  = '09'x;
  if filebbs = '' then filebbs = 'files.bbs'
  handle.1 = FileOpen( filebbs )
  if handle.1 = 0 then do
    if( UseFilesBBSOnly = 1 ) then do
      say "ERROR: Can't open file" filebbs
      say "UseFilesBBSOnly variable is set - terminating"
      exit
    end
    else
      say "WARNING: Can't open file" filebbs
    line.0 = 0;
  end
  else do
    say "handle.1 = "handle.1
    say "Reading source..."
    i = 1;
    do forever
      line.i = FileGets( handle.1 )
      if( line.i = '' & FileErr = 0 ) then leave
      i = i+1;
    end
    line.0 = i;
    say i 'lines read'
    err = FileClose( handle.1 )
  end
  handle.2 = FileOpen( 'index.htm', 'ws--', 'no' );
  if( handle.2 = 0 ) then do
    say "Can't create index.htm"
    exit( 1 );
  end
  say 'WriteHeader...'
  call WriteHeader;
  say 'WriteBody...'
  call WriteBody
  say 'WriteFooter...'
  call WriteFooter;
  err = FileClose( handle.2 )
  exit( 0 );

/*:VRX         AddSpaces
*/
AddSpaces:
  do while tcnt > 0
    str = str' ';
    tcnt = tcnt-1;
  end
return

/*:VRX         BeginTable
*/
BeginTable:
  if( table = 0 ) then do
    err = FilePuts( handle.2, '<TABLE BORDER=1 WIDTH=100%>' );
    table = 1;
  end
  return

/*:VRX         EndTable
*/
EndTable:
  if( table = 1 ) then do
    err = FilePuts( handle.2, '</TABLE>' );
    table = 0;
  end
  return

/*:VRX         GetExt
*/
GetExt:
  parse arg f
  tmp = lastpos( '.', f );
  if( tmp = 0 ) then
    rc = '';
  else
    rc = translate( substr( f, tmp+1 ) );
  return rc

/*:VRX         GetIcon
*/
GetIcon:
  if( UseFilesBBSOnly = 0 ) then do
    if( substr( filename.2, 28, 1 ) = '1' ) then do
      icon    = icondir'/dir.gif';
      iconalt = '&lt;dir&gt;';
      return
    end
  end
  ext = GetExt( filename );
  
  select
    when ext = 'GIF' | ext = 'BMP' | ext = 'JPG' | ext = 'JPEG' |,
         ext = 'TIF' | ext = 'TIFF' | ext = 'ICO' then do
      icon    = icondir'/image.gif';
      iconalt = '&lt;pic&gt;';
    end
    when ext = 'ZIP' | ext = 'ARJ' | ext = 'RAR' | ext = 'AIN' |,
         ext = 'UC2' | ext = 'LZH' | ext = 'ICE' | ext = 'Z' |,
         ext = 'HA'  | ext = 'PAK' | ext = 'ARC' | ext = 'TGZ' then do
      icon    = icondir'/compress.gif';
      iconalt = '&lt;arc&gt;';
    end
    when ext = 'SND' | ext = 'MID' | ext = 'WAV' | ext = 'MOD' |,
         ext = 'PRO' | ext = 'WRK' then do
      icon    = icondir'/sound.gif';
      iconalt = '&lt;snd&gt;';
    end
    when ext = 'AVI' | ext = 'MOV' then do
      icon    = icondir'/video.gif';
      iconalt = '&lt;vid&gt;';
    end
    when ext = 'TAR' then do
      icon    = icondir'/tar.gif';
      iconalt = '&lt;tar&gt;';
    end
    when ext = 'TXT' | ext = 'CMD' | ext = 'BBS' | ext = 'HTM' |,
         ext = 'HTML' | ext = 'INC' | ext = 'C' | ext = 'SH' |,
         ext = 'ASM' | ext = 'PAS' | ext = 'VRP' | ext = 'VRX' |,
         ext = 'DOC' then do
      icon    = icondir'/text.gif';
      iconalt = '&lt;txt&gt;';
    end
    when ext = 'EXE' | ext = 'DLL' | ext = 'COM' | ext = 'INF' |,
         ext = 'BIN' | ext = 'SYS' | ext = 'VRY' then do
      icon    = icondir'/binary.gif';
      iconalt = '&lt;bin&gt;';
    end
    otherwise do
      icon = icondir'/unknown.gif';
      iconalt = '&lt;file&gt;';
    end
  end
return

/*:VRX         PutDescr
*/
/*
 * Parse files.bbs contents and find the string begun with filename
 * Output the rest of this string as description for current file
 * Output all additional strings thats begun from ' '
 */
PutDescr:
  arg file;
  if( line.0 > 0 ) then do /* files.bbs not empty? */
    i = 1;
    do while i <= line.0 /* find the string assotiated with filename */
      if( substr( line.i, 1, 1 ) = ' ' ) then do /* is current string contains only description part? */
        i = i + 1;
        iterate
      end
      descr = '';
      parse var line.i bbsfile descr
      if( compare( translate( filename ), translate( bbsfile ) ) = 0 ) then do
        /* 諨 ப,  ன 뢠 ࠡ뢠 䠩 */
        if( i > 1 ) then do
          /* ᬮਬ   饬 ப, 稭騥  ' --' */
          j = i-1;
          do while( j > 0 )
            if( substr( line.j, 1, 1 ) = ' ' ) then do
              tmpstr = strip( line.j );
              if( substr( tmpstr, 1, 2 ) <> '--' ) then
                leave;
              j = j - 1;
            end
            else
              leave;
          end
          j = j + 1;
          /* 諨 ⠪ ப */
          do while( substr( line.j, 1, 1 ) = ' ' & j <= line.0 )
            tmpstr = strip( line.j );
            if( substr( tmpstr, 1, 2 ) <> '--' ) then do
              say 'FATAL: Program error looking up to " --"'
              exit
            end
            tmpstr = delstr( tmpstr, 1, 2 );
            tmpstr = strip( tmpstr );
            call EndTable;
            err = FilePuts( handle.2, '<h1><center>'tmpstr'</center></h1>');
            j = j + 1;
          end
        end /* End of " --" processing */
        call BeginTable;
        descr = strip( descr );
        err = FilePuts( handle.2, outstr'<td>'descr );
        /* Output subsequenced descriptional lines */
        j = i+1;
        do while( (substr( line.j, 1, 1 ) = ' ') & j <= line.0 )
          tmpstr = strip( line.j );
          if( substr( tmpstr, 1, 2 ) = '--' ) then leave;
          err = FilePuts( handle.2, '<br>'tmpstr );
          i = i + 1;
          j = i + 1;
        end
        err = FilePuts( handle.2, '</td></tr>' );
        return;
      end
      i = i + 1;
    end
  end
  err = FilePuts( handle.2, outstr'<td></td></tr>' );
return
/*:VRX         WriteBody
*/
/*  ⥫ HTML-࠭ */
WriteBody:
  TotalFiles = 0;
  TotalSize = 0;
  if( UseFilesBBSOnly = 0 ) then do
    handle.4 = 0;
    do until handle.4 = 0
      err = FileMatchFile( "filename", "handle.4", ,
                           "*.*", "RDO|DIR", "SIZE|DATE|ATTR" );
      if( err = 0 ) then do
        /* hide HTML page files */
        ext = GetExt( filename );
        if( ext = 'HTM' | ext = 'HTML' ) then
          iterate;
        if( filename = 'files.bbs' | filename = 'files.dmp' |,
            filename = 'files.idx' | filename = 'files.dat' |,
            filename = 'files.bak' | filename = 'readme' ) then
          iterate;

        if( substr( filename.2, 28, 1 ) = '1' ) then do /* Directory ? */
          field2ref = filename'/index.htm';
          parse value stream( field2ref, 'c', 'query exists' ) with status;
          if( status = '' ) then do
            say field2ref 'does not exists - skipping'
            iterate;
          end
        end
        else
          field2ref = filename;
        call GetIcon;
        field1 = '<a href="'field2ref'"><img src="'icon'" alt="'iconalt'" border=no></a>';
        field2 = '<a href="'field2ref'">'filename'</a>';
        field3 = '';
        if( datatype( filename.0 ) = 'NUM' ) then do
          TotalSize = TotalSize + filename.0;
          field3 = filename.0;
        end
        parse var filename.1 month day year hour min sec
        if( length( month ) = 1 ) then month = '0'month;
        if( length( day )   = 1 ) then day   = '0'day;
        field4 = day'/'month'/'year;
        outstr = '<tr><td>'field1'</td><td>'field2'</td><td align=right>'field3'</td><td>'field4'</td>';
        call PutDescr( field2 ); /* '<td>'field5'</td>' */
        TotalFiles = TotalFiles + 1;
      end
    end /* End of loop */
  end /*** End of if UseFilesBBSOnly ***/
  else do
    do i = 1 to line.0
      if( substr( line.i, 1, 1 ) = ' ' ) then iterate;
      else do
        str = strip( line.i );
        parse var str filename comment
        call WriteRow;
      end
    end
  end /* End of else */
return

/*:VRX         WriteFooter
*/
/*   ࠭ */
WriteFooter:
  call EndTable;
  if( UseFilesBBSOnly = 0 ) then do
    err = FilePuts( handle.2, "</b>Total "TotalFiles" files, "TotalSize" bytes</b><br>" );
  end
/*
  else do
    parse value stream( '..\index.htm', 'c', 'query exists' ) with status;
    if( status <> '' ) then
      err = FilePuts( handle.2, '<center><a href="../index.htm"><img src="'icondir'/back.gif" alt="&lt;UP DIR&gt;" border=no></a></center><br>' );
  end
*/
  if( Generation <> 0 ) then do
    err = FilePuts( handle.2, "Modified at" date() "<br>" );
  end
  handle.3 = FileOpen( 'footer.inc' )
  if( handle.3 = 0 ) then
    handle.3 = FileOpen( incdir'/footer.inc' );
  if( handle.3 <> 0 ) then
    do forever
      linetmp = FileGets( handle.3 )
      if( linetmp = '' & FileErr = 0 ) then leave
      err = FilePuts( handle.2, linetmp );
      if( err = 0 ) then leave
    end
  err = FileClose( handle.3 )
return

/*:VRX         WriteHeader
*/
/*   ࠭ */
WriteHeader:
/*
    handle.3 = FileOpen( 'header.inc' )
    if( handle.3 = 0 ) then
      handle.3 = FileOpen( incdir'\header.inc' );
    if( handle.3 <> 0 ) then do
      do forever
        linetmp = FileGets( handle.3 )
        if( linetmp = '' & FileErr = 0 ) then leave
        err = FilePuts( handle.2, linetmp );
        if( err = 0 ) then leave
      end
      err = FileClose( handle.3 )
    end
*/
  err = FilePuts( handle.2, '<!-- DOCTYPE HTML PUBLIC "-//W3O//DTD HTML 2.0//EN" -->');
  err = FilePuts( handle.2, '<!-- --------------------------------------------------------Start Document---- -->');
  err = FilePuts( handle.2, '<html>');
  err = FilePuts( handle.2, '<head>');
  err = FilePuts( handle.2, '<!-- --------------------------------------------------------document identific ation -->');
  err = FilePuts( handle.2, '<TITLE>'TitleLine': Page 'directory()'</TITLE>');
  err = FilePuts( handle.2, '<meta name="abstract" content="'Abstract'">');
  err = FilePuts( handle.2, '<meta name="keywords" content="'KeyWords'">');
  err = FilePuts( handle.2, '<meta name="owner"    content="'Owner'">');
  if( review <> '' ) then
    err = FilePuts( handle.2, '<meta name="review"   content="'Review'">');
  err = FilePuts( handle.2, '<meta name="security" content="'Security'">');
  err = FilePuts( handle.2, '</HEAD>');
  err = FilePuts( handle.2, '<!-- --------------------------------------------------------begin body----   -->');
  if( Background <> '' ) then
    err = FilePuts( handle.2, '<BODY BGCOLOR=FFFFFF BACKGROUND="'Background'">');
  if( Underconstruct <> 0 ) then
    err = FilePuts( handle.2, '<img src="'picdir'/construc.gif" alt="This page is under construction!"><HR>');
  err = FilePuts( handle.2, '<center><img src="'picdir'/avnarch.gif" alt="AVN''s Archive"></center>');
/*  if( UseFilesBBSOnly = 0 ) then do*/
    /* ᮪ 䠩 㤥 ᮧ ⮬᪨   FTP */
    call WriteReadme;
    call BeginTable;
    err = FilePuts( handle.2, '<tr><td></td><td align=center><b>File</b></td><td align=center><b>Size</b></td><td align=center><b>Date</b></td><td align=center><b>Description</b></td></tr>');
    parse value stream( '..\index.htm', 'c', 'query exists' ) with status;
    if( status <> '' ) then do
      /* icon */ field1 = '<a href="../index.htm"><img src="'icondir'/back.gif" alt="&lt;UP DIR&gt;" border=no></a>'
      /* file */ field2 = '';
      /* size */ field3 = '';
      /* date */ field4 = '';
      /* comment */ field5 = 'Back to the parent directory';
      err = FilePuts( handle.2, '<tr><td>'field1'</td><td>'field2'</td><td>'field3'</td><td>'field4'</td><td>'field5'</td></tr>' );
    end
/*  end */
return

/*:VRX         WriteReadme
*/
/* ஢ ᮤন 䠩 readme  dirinfo  HTML-࠭ */
WriteReadme:
  handle.3 = FileOpen( 'readme' )
  if( handle.3 = 0 ) then
    handle.3 = FileOpen( 'dirinfo' )
  if( handle.3 <> 0 ) then do
    do forever
      linetmp = FileGets( handle.3 )
      if( linetmp = '' & FileErr = 0 ) then leave
      err = FilePuts( handle.2, linetmp );
      if( err = 0 ) then leave
    end
    err = FileClose( handle.3 )
  end
return

/*:VRX         WriteRow
*/
/* Argument: filename. */
WriteRow:
  call BeginTable;
  parse var str file comment
  say 'file="'filename'"'
  if( stream( filename, 'c', 'query exists' ) <> '' ) then
    size = stream( file, 'c', 'query size' );
  else
    size = '';
  call geticon;
  icon = '<img src="'icon'" alt="'iconalt'" border=no>';
  field1 = '<a href='file'>'icon'</a>';
  field2 = '<a href='file'>'file'</a>';
  field3 = size;
  if( stream( filename, 'c', 'query exists' ) <> '' ) then do
    datetime = stream( file, 'c', 'query datetime' );
    parse var datetime month'-'day'-'year hour':'min':'sec
    if( length( month ) = 1 ) then month = '0'month;
    if( length( day )   = 1 ) then day   = '0'day;
    field4 = day'/'month'/'year;
  end
  else
    field4 = '';
  field5 = comment;
  outstr = '<tr><td>'field1'</td><td>'field2'</td><td align=right>'field3'</td><td>'field4'</td>'
  call PutDescr( filename );
return

