Attribute VB_Name = "Code"
' *****************************************************
' Fclip.exe
' (c) 1998 David Crowell
' davidc@qtm.net
' http://www.qtm.net/~davidc
'
' *****************************************************
' Fclip is a small utility to remove the first X bytes of a file, or
' group of files, then truncate the length to X bytes.  It is released
' with this sourcecode as freeware.  You may use the program, modify it,
' use some of the routines in your own software, as you wish.
' the only exceptions is that you may not claim this software as your own
' without substantially improving it, and you cannot charge to distribute
' this software.
' ******************************************************
'
'This standard module is the startup object, so you will notice in
' Sub Main() that the forms are loaded explicitly.  My documentation
' for this source code is rather bad, but, hey, you can always get
' your money back  :)
'
' *******************************************************

Option Explicit
Const INIHEAD As String = "fclip 1.0 ini file"   'constants for the ini file
Const INITAIL As String = "end of file"
Const INIFN As String = "fclip.ini"
Const OKAY As Integer = 0
Const FILETOOSHORT As Integer = 1
Const FILENOTTRUNC As Integer = 2
Const LOGFILENAME As String = "fclip.log"
Const TABS As String = vbTab & vbTab & vbTab
Global AboutTop As Integer              'variables for about box position
Global AboutLeft As Integer

Sub Main()
    Load frmAbout
    frmMain.Show
    ReadIni
    btnEn
    frmMain.RefreshFiles
End Sub
    

'This writes setting to the ini file to be recalled when the program is restarted.
Private Sub WriteIni()
    On Error GoTo Handler
    Dim sSavePath As String
    Dim iFN As Integer
    iFN = FreeFile
    sSavePath = CurDir
    ChDrive App.Path
    ChDir App.Path
    Open INIFN For Output As iFN
    Print #iFN, INIHEAD
    Print #iFN, frmMain.Height
    Print #iFN, frmMain.Width
    Print #iFN, frmMain.Top
    Print #iFN, frmMain.Left
    Print #iFN, frmMain.txtStart.Text
    Print #iFN, frmMain.txtStart.Tag
    Print #iFN, frmMain.txtStart.BackColor
    Print #iFN, frmMain.txtLength.Text
    Print #iFN, frmMain.txtLength.Tag
    Print #iFN, frmMain.txtLength.BackColor
    Print #iFN, frmMain.chkSkip.Value
    Print #iFN, frmMain.chkCrop.Value
    Print #iFN, AboutTop
    Print #iFN, AboutLeft
    Print #iFN, frmMain.WindowState
    Print #iFN, sSavePath
    Print #iFN, INITAIL
Cleanup:
    Close iFN
Exit Sub
Handler:
    If Err.Number = 70 Then GoTo Cleanup
    Dim er As Integer
    er = ErrorHandler(Err.Number)
    If er = vbRetry Then Resume
End Sub

'gotta read the settings back in, and validate the ini file
Private Sub ReadIni()
    On Error GoTo Handler
    ChDrive App.Path
    ChDir App.Path
    Dim tIni(17) As String
    Dim iCount As Integer
    Dim iFN As Integer
    iFN = FreeFile
    Open INIFN For Input As iFN
    For iCount = 0 To 17
        Line Input #iFN, tIni(iCount)
    Next iCount
Closing:
    Close iFN
    If tIni(0) <> INIHEAD Then GoTo Foobar
    If tIni(17) <> INITAIL Then GoTo Foobar
    frmMain.Height = tIni(1)
    frmMain.Width = tIni(2)
    frmMain.Top = tIni(3)
    frmMain.Left = tIni(4)
    frmMain.txtStart.Text = tIni(5)
    frmMain.txtStart.Tag = tIni(6)
    frmMain.txtStart.BackColor = tIni(7)
    frmMain.txtLength.Text = tIni(8)
    frmMain.txtLength.Tag = tIni(9)
    frmMain.txtLength.BackColor = tIni(10)
    frmMain.chkSkip.Value = tIni(11)
    frmMain.chkCrop.Value = tIni(12)
    AboutTop = tIni(13)
    AboutLeft = tIni(14)
    frmMain.WindowState = tIni(15)
    SafeDirChg (tIni(16))
Exit Sub
Foobar:                 'if it's no good, then just delete it to avoid the problem
    SafeKill INIFN
Exit Sub
Handler:
    If Err.Number = 53 Then GoTo Cleanup 'file doesn't exist, abort
    If Err.Number = 62 Then GoTo Closing  'read past end of file, must be corrupt
    Dim er As Integer
    er = ErrorHandler(Err.Number)
    If er = vbRetry Then Resume
Cleanup:
    Close iFN
End Sub

'This sub changes the current dir to the one specified in the ini file
'if any error occurs here, it will change the current dir to the app dir
'this isn't the best way to do it, but it would take a really strange
'set of events, to cause any problems, it's not bulletproof, but it'll work.
Private Sub SafeDirChg(tPath As String)
    On Error GoTo nopath
    ChDrive tPath
    ChDir tPath
Exit Sub
nopath:
    ChDrive App.Path
    ChDir App.Path
End Sub

' This is a crappy error handler
Function ErrorHandler(ErrorIn As Integer) As Integer
    Dim sMsg As String
    Dim sTitle As String
    Dim NL As String
    NL = Chr$(13) & Chr$(10)
    
    Select Case ErrorIn

' Any file or disk error will be handled here
' I simply provide a retry or ignore approach.
    Case 57, 68, 71, 72, 52 To 56, 58, 60 To 66, 69, 70, 73 To 76
        sTitle = "Error# " & ErrorIn
        sMsg = Error$(ErrorIn)
        ErrorHandler = MsgBox(sMsg, vbCritical + vbRetryCancel, sTitle)
        
' This section is for any other error that may occur.  I don't know
' what could happen (me make a mistake?), but it will give the
' user the option to close the application, otherwise it will just abort
' the call that caused the error.
    Case Else
        sTitle = "Unexpected Error"
        sMsg = "An unexpected error has occured." & NL
        sMsg = sMsg & "Do you wish to terminate this application?" & NL
        sMsg = sMsg & "Error#: " & ErrorIn & NL
        sMsg = sMsg & "Description:   " & Error$(ErrorIn)
        ErrorHandler = MsgBox(sMsg, vbCritical + vbYesNo, sTitle)
        If ErrorHandler = vbYes Then
            Unload frmMain
            End
        Else
            ErrorHandler = vbCancel
        End If
    End Select
End Function
Sub EndProg()
    WriteIni
    Unload frmAbout
    Unload frmMain
    End
End Sub


' This function will do one file and return an integer result code
Private Function DoFile(sInFile As String, sOutFile As String, _
lStart As Long, lLength As Long) As Integer
    Dim lCount As Long
    Dim lLen As Long
    Dim bytData() As Byte
    Dim iFN1 As Integer
    Dim iFN2 As Integer
    lLen = FileLen(sInFile)
    DoFile = OKAY
    If lStart >= lLen Then
        DoFile = FILETOOSHORT
        Exit Function                           'we abort in this case
    End If
    ReDim bytData((lLen - 1) - lStart)
    If lLen - lStart < lLength Then
        DoFile = FILENOTTRUNC
        lLength = 0                             ' so we know to skip the truncate
    End If                                        ' but will continue anyway
    iFN1 = FreeFile
    Open sInFile For Binary Access Read As iFN1
    iFN2 = FreeFile
    Open sOutFile For Binary Access Write As iFN2
    Get #iFN1, lStart + 1, bytData()
    If lLength > 0 Then ReDim Preserve bytData(lLength - 1)
    Put #iFN2, 1, bytData()
    Close iFN1
    Close iFN2
End Function
Sub btnEn()
    If frmMain.chkCrop.Value = 0 And frmMain.chkSkip.Value = 0 Then
        frmMain.cmdStart.Enabled = False
        frmMain.mnuStart.Item(0).Enabled = False
    Else
        frmMain.cmdStart.Enabled = True
        frmMain.mnuStart.Item(0).Enabled = True
    End If
End Sub

'This starts it all
Sub DoIt()
    Dim iDnCount As Integer
    Dim intCount As Integer
    Dim intTemp As Integer
    Dim lStart As Long
    Dim lLength As Long
    intCount = frmMain.File1.ListCount
    If intCount > 0 Then
        For intTemp = 0 To intCount - 1
            If frmMain.File1.Selected(intTemp) = True Then
                lStart = CLng(frmMain.txtStart.Text)
                lLength = CLng(frmMain.txtLength.Text)
                Process frmMain.File1.List(intTemp), lStart, lLength
                iDnCount = iDnCount + 1
            End If
        Next intTemp
    End If
    If iDnCount = 0 Then
        MsgBox "You haven't selected any files", vbOKOnly, "Duh!"
    Else
        MsgBox "Done", vbOKOnly, "Done!"
    End If
End Sub
Private Sub Process(sFileName As String, lStart As Long, lLength As Long)
    Dim iResult As Integer
    Dim sBakName As String
    Dim iFN As Integer
    Dim sLog As String
    iFN = FreeFile
    Open LOGFILENAME For Append As iFN
    sBakName = sFileName & ".bak"
    SafeKill sBakName
    Name sFileName As sBakName
    iResult = DoFile(sBakName, sFileName, lStart, lLength)
    Select Case iResult
        Case OKAY
            sLog = "File processed succesfully."
        Case FILETOOSHORT
            sLog = "File length less than or equal to start byte value, aborted."
            SafeKill sFileName
            Name sBakName As sFileName
        Case FILENOTTRUNC
            sLog = "File length after first step less than desired truncated"
            sLog = sLog & " length.  File not truncated."
    End Select
    Print #iFN, sFileName & TABS & sLog
    Close iFN
End Sub
Sub SafeKill(sFN As String)
    Dim iResult As Integer
    On Error GoTo Handler
    Kill sFN
Exit Sub
Handler:
    If Err.Number <> 53 Then
        iResult = ErrorHandler(Err.Number)
        If iResult = vbRetry Then Resume
    End If
End Sub
