const
 VideoSeg : word=$b800;
   ColorX : word=$08;
   ColorY : word=$07;
   Color0 : word=16*Blue+LightCyan;          {bytes coincide  $1b}
   Color1 : word=16*Blue+Yellow;             {bytes do not    $1e}
   Color3 : word=16*Blue+LightCyan;          {line address $1b}
   Color4 : word=16*Cyan+Black;              {status bars etc. $30}
   Color5 : word=16*LightGray+Black;         { LightGray messages $70 }
   Color6 : word=16*Cyan+black;              { Dialogues $30 }
   Color7 : word=blue;                       { general background blue $01 }
   Color8 : word=16*LightGray+Yellow;        { cursor1 $7e }
   Color9 : word=16*LightGray+LightCyan;     { cursor2 $7b }
  Color10 : word=16*LightGray+Black;         { scroll bars $71 }
  Color11 : word=16*LightGray+Red;           { byte edited $74 }

type
  symb=record
    chr : char;
    atr : byte;
    end;

  row=0..49;
  col=0..79;

  video=array[1..8000] of byte;

  screen=record
            x : col;
            y : row;
     VideoMem : Video;
   end;

  scrtype=array[row,col] of symb;

var
        scr : ^scrtype;                     {absolute $b800:0;}
ScreenArray : array[1..3] of screen;
 RealScreen : ^Video;
  ScrHeight : Byte;
   ScrWidth : Byte;
OrigScrHeight: Byte;

procedure SaveScr(n:integer);
begin
  ScreenArray[n].VideoMem:=RealScreen^;
  ScreenArray[n].x:=WhereX-1;
  ScreenArray[n].y:=WhereY-1;
end;

procedure RestoreScr(n:integer);
begin
  HidePtr;
  RealScreen^:=ScreenArray[n].VideoMem;
  GotoXY(ScreenArray[n].x+1,ScreenArray[n].y+1);
  ShowPtr;
end;

procedure VideoInt; assembler;
asm
        PUSH    BP
        PUSH    ES
        INT     10H
        POP     ES
        POP     BP
end;

procedure SetScreenSize; assembler;
asm
        MOV     AH,0FH
        CALL    VideoInt
        MOV     DH,AH
        XOR     AH,AH
        PUSH    AX
        MOV     AX,1130H
        XOR     BH,BH
        XOR     DL,DL
        MOV     CL,DH
        PUSH    CX
        CALL    VideoInt
        POP     CX
        MOV     DH,CL
        POP     AX
        OR      DL,DL
        JNE     @@1
        MOV     DL,24
@@1:    INC     DL
        MOV     ScrWidth,DH
        MOV     ScrHeight,DL
end;

procedure CheckVideo;
begin
  SetScreenSize;
  if (MemW[0:$0410] and $30)=$30 then
      begin                               {Hercules}
      VideoSeg:=$b000;
      ColorX:=$08;
      ColorY:=$07;
      Color0:=$07;                {bytes coincide  $1b}
      Color1:=$0f;                {bytes do not    $1e}
      Color3:=$07;                {line address $1b}
      Color4:=$10;                {status bars etc. $30}
      Color5:=$07;                { LightGray messages $70 }
      Color6:=$70;                { Dialogues $30 }
      Color7:=$70;                { general background blue $01 }
      Color8:=$81;                { cursor1 $7e }
      Color9:=$10;                { cursor2 $7b }
      Color10:=$70;               { scroll bars $71 }
      Color11:=$7F;               { byte edited $74 }
    end;
  scr:=ptr(VideoSeg,0);
  RealScreen:=ptr(VideoSeg,0);
end;
