var
  sExitCode : integer;
         sx : col;
         sy : row;

const
  sInHex : boolean=true;
 sxstart : array[boolean] of col=(8,8);
   sxend : array[boolean] of col=(28,67);
 systart : array[boolean] of row=(12,10);

function Byte2Dec(x : string) : byte;
var t : byte;
begin
  if x='' then
    begin
      Byte2Dec:=0;
      exit;
    end;
  if x[1] in ['A'..'F'] then t:=(ord(x[1])-55)*16
   else t:=(ord(x[1])-48)*16;
  if x[2] in ['A'..'F'] then t:=t+(ord(x[2])-55)
   else t:=t+(ord(x[2])-48);
  Byte2Dec:=t;
end;

procedure Char2Hex;
begin
  GotoXY(sxstart[true]+1,systart[true]+1);
  for i:=sxstart[false] to sxend[false] do
    if (scr^[systart[false],i].chr<>#0) or
        (scr^[systart[false],i].atr=$20) or
         (scr^[systart[false],i].atr=$50)
     then write(HexByte(ord(scr^[systart[false],i].chr)),#0);
end;

procedure Hex2Char;
var s : string;
begin
  s:='';
  for i:=sxstart[true] to sxend[true] do
    if scr^[systart[true],i].chr<>#0 then
      s:=s+scr^[systart[true],i].chr;
  if Odd(Length(s)) then Insert('0',s,Length(s));
  for i:=1 to (Length(s) div 2) do
    if Byte2Dec(s[2*i-1]+s[2*i])=0 then
      begin
        scr^[systart[false],sxstart[false]+i-1].chr:=#0;
        scr^[systart[false],sxstart[false]+i-1].atr:=Color6;
      end
     else
      scr^[systart[false],sxstart[false]+i-1].chr:=
        chr(Byte2Dec(s[2*i-1]+s[2*i]));
end;


procedure EditStringForSearch
            (sxs,sxe:col;sys:row;ExitRange:Range;var exc:integer);

     procedure GotoEnd;
     begin
       sx:=sxe;
       sy:=sys;
       while (sx>sxs) and (scr^[sys,sx-1].chr=#0) and
             ( (scr^[sys,sx-1].atr=Color6) or (scr^[sys,sx-1].atr=$47) ) do
         sx:=sx-1;
       if sInHex and ((sx-sxstart[true]) mod 3 = 2) and (sx<sxe) then
         begin
           sx:=sx+1;
           GotoXY(sx+1,sY+1);
         end
        else GotoXY(sx+1,sY+1);
     end;

begin
  GotoEnd;
  exc:=0;
  repeat
    if sInHex and ((sx-sxstart[true]) mod 3 = 2) and (sx<sxe) then
      begin
        sx:=sx+1;
        GotoXY(sX+1,sY+1);
      end;
	 sym:=GetEvent;
	 HidePtr;
	 case sym of
	  ESC : exc:=1;
		BS : if sx > sxs
                      then begin
			     sx:=sx-1;
			     GotoXY(sx+1,sy+1);
   			     scr^[sy,sx].chr:=#0;
                             scr^[sy,sx].atr:=Color6;
                             if sInHex and ((sx-sxstart[true]) mod 3 = 2) then
                              begin
                                sx:=sx-1;
                                GotoXY(sx+1,sy+1);
                                scr^[sy,sx].chr:=#0;
                              end;
			   end;
      CR : exc:=2;
     TAB : exc:=3;
    _TAB : exc:=4;

	  else if ( (sInHex and (sym in HexDigits)) or (not sInHex) ) and (sx < sxe)
		then
		 begin
			if sInHex then scr^[sy,sx].chr:=UpCase(chr(sym))
          else scr^[sy,sx].chr:=chr(sym);
			sx:=sx+1;
			GotoXY(sx+1,sy+1);
		 end;
	 end; { of case }

	 fill(#0,Color6,sxstart[not sInHex],sxend[not sInHex],systart[not sInHex]);
	 if sInHex then Hex2Char else
		Char2Hex;
	 GotoXY(sx+1,sy+1);
    ShowPtr;
  until exc in ExitRange;
end;

{&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&}

type
    SearchBufPtr = ^SearchBufType;
   SearchBufType = array[1..65520] of char;

const
       NoTarget : boolean=true;
  TargetChanged : boolean=true;
        FoundAt : LongInt=-1;
            Len : integer=0;

var
      SearchBuf : SearchBufPtr;
        SearchF : ExtFile;
     SearchFor,
  SearchForSave : array[1..20] of char;
        NumRead : Word;
       NotFound : boolean;
       sAllRead : LongInt;

procedure DoTheSearch; forward;

{$F+}
var CheckSequence : procedure ( Start : LongInt );

procedure CS1( Start : LongInt );  { case-sensitive }
begin
  for j:=0 to Len-1 do
    if SearchBuf^[Start+j]<>SearchFor[j+1] then exit;
  NotFound:=false;
  FoundAt:=sAllRead+Start;
end;

procedure CS2( Start : LongInt );  { not case-sensitive }
begin
  for j:=0 to Len-1 do
    if UpCase(SearchBuf^[Start+j])<>SearchFor[j+1] then exit;
  NotFound:=false;
  FoundAt:=sAllRead+Start;
end;

procedure CS3( Start : LongInt); { find next difference }
begin
  if ord(SearchBuf^[Start])=buf^[InUpperHalf,StartAddr[InUpperHalf]-BufStart[InUpperHalf]+1] then exit;
  NotFound:=false;
  FoundAt:=sAllRead+Start;
end;

{$F-}

procedure Search(SearchType:integer);
begin
  ActiveModule:=7;
  HidePtr;
  SaveScr(2);
  DrawButtons(2);
  case SearchType of
    0 : begin { normal search }
          DrawSearchFrame;
          NoTarget:=true;
          fill(#0,Color6,sxstart[true],sxend[true],systart[true]);;
          fill(#0,Color6,sxstart[false],sxend[false],systart[false]);

          for i:=0 to Len-1 do scr^[systart[false],sxstart[false]+i].chr:=SearchForSave[i+1];
          Char2Hex;

          StdCursor;
          ShowPtr;
          repeat
            EditStringForSearch
              (sxstart[sInHex],sxend[sInHex],systart[sInHex],[1..6],sExitCode);
            if sExitCode in [3,4] then sInHex:=not sInHex;   {tab, shift tab}
          until sExitCode in [1,2];   {esc, cr}

          Len:=0;
          while (scr^[systart[false],sxstart[false]+Len].chr<>#0) or
                 (scr^[systart[false],sxstart[false]+Len].atr in [$20,$50]) and
                  (Len < 19) do
          begin
            Len:=Len+1;
            SearchForSave[Len]:=scr^[systart[false],sxstart[false]+Len-1].chr;
          end;

          if sExitCode=1 then  {esc}
            begin
              NoCursor;
              RestoreScr(2);
              ActiveModule:=0;
              TextAttr:=Color4;
              exit;
            end;

          if sInHex
           then
             begin
               CheckSequence:=CS1;  { case-sensitive }
               SearchFor:=SearchForSave;
             end
           else
             begin
               CheckSequence:=CS2;  { not case-sensitive }
               for i:=1 to Len do SearchFor[i]:=UpCase(SearchForSave[i]);
             end;
          NoCursor;
          RestoreScr(2);
        end; { of normal search }
    1 : begin
          CheckSequence:=CS3;
          Len:=1;
        end;
  end;
  NoTarget:=false;
  TargetChanged:=true;
  DoTheSearch;
  ActiveModule:=0;
  TextAttr:=Color4;
end;

procedure DoTheBartman; { clear-up after myself }
begin
  NotFound:=true;
  ExtClose(SearchF);
  FreeMem(SearchBuf,65520);
  beep;
  RestoreScr(2);
  DisableMouse:=false;
  while keypressed do c:=readkey;
  ActiveModule:=0;
end;

procedure DoTheSearch;
var i : LongInt;

  hr0, min0, sec0, hnd0 : word;
  hr, min, sec, hnd : word;
  Timer0:longint;


begin
  if NoTarget or ( Len=0 ) then begin Error(4,1); exit; end;
  InOutRes:=LongOpenFile(Name[InUpperHalf],SearchF,fmReadOnly);
  if IOResult <> 0 then
    begin
      Error(3,1);
      exit;
      ActiveModule:=0;
    end;
  HidePtr;
  SaveScr(2);
  ShowPtr;
  DisableMouse:=true;
  GetMem(SearchBuf,65520);
  if TargetChanged or ( FoundAt <> Address(InUpperHalf) ) then
    begin
      TargetChanged:=false;
      ExtSeek(SearchF,Address(InUpperHalf));
      sAllRead:=Address(InUpperHalf)-1;
    end
   else
    begin
      ExtSeek(SearchF,Address(InUpperHalf)+1);
      sAllRead:=Address(InUpperHalf);
    end;

  NotFound:=True;
  NumRead:=Len+1;
  DrawStandByFrame;
  while (NumRead > Len) and (NotFound) do
    begin
      ExtBlockread(SearchF,SearchBuf^,65520,NumRead);
      if IOResult <> 0 then
        begin
          DoTheBartman;
          Error(2,1);
          exit;
        end;
      if keypressed then if readkey=#27 then
        begin
          DoTheBartman;
          exit;
        end;
      i:=1;
      while (i<=Numread-Len+1) and (NotFound) do
        begin
          CheckSequence(i);
          i:=i+1;
        end;
      sAllRead:=sAllRead+NumRead-Len+1;
      ExtSeek(SearchF,sAllread+1);
    end;
  if NotFound then
    begin
      DoTheBartman;
      Error(5,1);
      exit;
    end;
  DoTheBartman;
  adr[InUpperHalf]:=FoundAt;
  if Sync then
    begin
      adr[not InUpperHalf]:=adr[InUpperHalf]-
                             Address(InUpperhalf)+Address(not InUpperHalf);
      MakeAdjustments(not InUpperHalf);
    end;
  MakeAdjustments(InUpperHalf);
end;
{
procedure FindNextDiff;
begin
  ActiveModule:=7;
  HidePtr;
  SaveScr(2);
  DrawButtons(2);
  DrawSearchFrame;
  NoTarget:=true;

  NoCursor;
  RestoreScr(2);
  NoTarget:=false;
  TargetChanged:=true;
  DoTheSearch;
  ActiveModule:=0;
  TextAttr:=Color4;
end;
}
