
var
  ReadKeyFunc: Byte;
  PrevKeyCode: Byte;

procedure StartTimer;
var
  hr0, min0, sec0, hnd0 : word;
begin
  GetTime(hr0, min0, sec0, hnd0);
  Timer0:=hnd0+sec0*100+min0*60*100+hr0*3600*100;
end; { of StartTimer }

function TimeElapsed(quant:word):boolean;
var
  hr, min, sec, hnd : word;
begin
  GetTime(hr, min, sec, hnd);
  TimeElapsed:=( hnd+sec*100+min*60*100+hr*3600*100 ) >
               Timer0+quant;
end;

procedure InitReadKeyFunc; assembler;
asm
        MOV     AX,11FFH
        INT     16H
        XOR     BL,BL
        CMP     AX,11FFH
        JE      @@1
        MOV     BL,10H
@@1:    MOV     ReadKeyFunc,BL
end;

function KeyPressed: Boolean; assembler;
asm
        MOV     AH,ReadKeyFunc
        INC     AH
        INT     16H
        MOV     AL,0
        JE      @@1
        INC     AL
@@1:
end;

function ReadKey: Char; assembler;
asm
        XOR     AL,AL
        XCHG    AL,PrevKeyCode
        TEST    AL,AL
        JNE     @@1
        MOV     AH,ReadKeyFunc
        INT     16H
        TEST    AL,AL
        JE      @@2
        CMP     AL,0E0H
        JNE     @@1
@@2:    MOV     PrevKeyCode,AH
        XOR     AL,AL
@@1:
end;

function GetEvent : word;
var
  ch : byte;
begin
  repeat
    asm
      int 28h;
      mov ax, 1680h;
      int 2Fh;
    end;
    if (( KbdStatusFlag and 3 ) <> 0) and ( not ShiftPressed )
         and ( ActiveModule=0 )
     then
      begin
        ShiftPressed:=true;
        DrawButtons(3);
      end
     else
      if ShiftPressed and (( KbdStatusFlag and 3 ) = 0 ) then
        begin
          if ActiveModule=0 then DrawButtons(1);
          ShiftPressed:=false;
        end;
  until  KeyPressed or MouseUsed;

   Getevent:=0;
   if MouseUsed then
    begin
      {GetEvent:=sym;  }
      if UpActivated then
        if ( GetMouseX = ms_x ) and ( GetMouseY = ms_y )
         then
           begin
             if (not TimeElapsed(MouseRepeatDelay)) and (DampMouse) then exit;
             GetEvent:=UP;
             Delay(MouseRepeatRate);
             DampMouse:=true;
             exit;
           end
         else
           begin
             MouseUsed:=false;
             UpActivated:=false;
           end;

      if DownActivated then
        if ( GetMouseX = ms_x ) and ( GetMouseY = ms_y )
         then
           begin
             if (not TimeElapsed(MouseRepeatDelay)) and (DampMouse) then exit;
             GetEvent:=DOWN;
             Delay(MouseRepeatRate);
             DampMouse:=true;
             exit;
           end
         else
           begin
             MouseUsed:=false;
             DownActivated:=false;
           end;

      if PgDnActivated then
        if ( GetMouseX div 8 = 0 ) and ( GetMouseY div 8 > ofs[InUpperHalf] )
             and ( GetMouseY div 8 < ofs[InUpperHalf]+(ScrHeight shr 1)-2 )
         then
           begin
             if (not TimeElapsed(MouseRepeatDelay)) and (DampMouse) then exit;
             GetEvent:=PgDn;
             Delay(MouseRepeatRate);
             DampMouse:=true;
             exit;
           end
         else
           begin
             MouseUsed:=false;
             PgDnActivated:=false;
           end;

      if PgUpActivated then
        if ( GetMouseX div 8 = 0 ) and ( GetMouseY div 8 > ofs[InUpperHalf] )
             and ( GetMouseY div 8 < ofs[InUpperHalf]+(ScrHeight shr 1)-2 )
         then
           begin
             if (not TimeElapsed(MouseRepeatDelay)) and (DampMouse) then exit;
             GetEvent:=PgUp;
             Delay(MouseRepeatRate);
             DampMouse:=true;
             exit;
           end
         else
           begin
             MouseUsed:=false;
             PgUpActivated:=false;
           end;

      if GrabActivated then
        if ( GetMouseX div 8 = 0 ) and ( GetMouseY div 8 > ofs[InUpperHalf] )
             and ( GetMouseY div 8 < ofs[InUpperHalf]+(ScrHeight shr 1)-2 )
         then
           begin
             if GetMouseY div 8 <> ScrollBarPtrSave[InUpperHalf] then
               begin
                 StartAddr[InUpperHalf]:=StartAddr[InUpperHalf]+
                   Chunk[InUpperhalf]*((GetMouseY div 8)-ScrollBarPtrSave[InUpperHalf]);
                 if sync then
                   begin
                     StartAddr[not InUpperHalf]:=StartAddr[not InUpperHalf]+
                       Chunk[InUpperhalf]*((GetMouseY div 8)-ScrollBarPtrSave[InUpperHalf]);
                     StartAddr[not InUpperHalf]:=StartAddr[not InUpperHalf];
                     DisplayPage(not InUpperHalf);
                   end;
                 DisplayPage(InUpperHalf);
                 GetEvent:=1;
                 GrabPtrSave:=GetMouseY;
               end
              else GetEvent:=0;
             exit;
           end
         else
           begin
             MouseUsed:=false;
             GrabActivated:=false;
           end;
      MouseUsed:=false;
      GetEvent:=sym;
      exit;
    end;
  ch:=ord(readkey);      { Mouse not Used }
  if ch=0 then GetEvent:=256+ord(readkey)
   else GetEvent:=ch;
end;

