unit Gadgets;

interface
 function HexWord(w: Word):string;
 function HexByte(w: Byte):string;
 function HexLongInt(w: LongInt):string;
 function NumRes( number:LongInt ):String;
 function PamString:string;
 function Where:string;
 procedure NoCursor;
 procedure StdCursor;
 procedure BigCursor;
 function UpCaseString(s : string) : string;

implementation

function HexWord;
const
  hexChars: array [0..$F] of Char =
    '0123456789ABCDEF';
begin
  HexWord:=hexChars[Hi(w) shr 4]+hexChars[Hi(w) and $F]+
        hexChars[Lo(w) shr 4]+hexChars[Lo(w) and $F];
end;


function HexByte;
const
  hexChars: array [0..$F] of Char =
    '0123456789ABCDEF';
begin
  HexByte:=
        hexChars[w shr 4]+hexChars[w and $F];
end;


function HexLongInt;
const
  hexChars: array [0..$F] of Char =
    '0123456789ABCDEF';
var
       w1 : longint;
        s : string;
begin
  w1:=w shr 16;
  s:=hexChars[Hi(w1) shr 4]+hexChars[Hi(w1) and $F]+
      hexChars[Lo(w1) shr 4]+hexChars[Lo(w1) and $F];
  s:=s+hexChars[Hi(w) shr 4]+hexChars[Hi(w) and $F]+
      hexChars[Lo(w) shr 4]+hexChars[Lo(w) and $F];
  HexLongInt:=s;
end;

procedure NoCursor;
begin
  asm
    mov ah,01h
    mov ch,20h
    int 10h
  end;
end;


procedure StdCursor;
begin
  asm
    mov ah,01h
    mov ch,01eh
    mov cl,01fh
    int 10h
  end;
end;


procedure BigCursor;
begin
  asm
    mov ah,01h
    mov ch,00h
    mov cl,01fh
    int 10h
  end;
end;


function NumRes;
const
   MaxLen=16;
 var
   s:String;
   i,len:integer;
 begin
  str( number,s );
  for i:=1 to MaxLen-Length( s ) do Insert( ' ',s,1 );
  len:=length( s );
  i:=2;
  while i<len do
   begin
    if s[len-i-1]<>' ' then insert( ',',s,len-i )
      else insert( ' ',s,len-i );
    i:=i+3;
   end;
  NumRes:=s;
 end;


function PamString;
const
  PamOfs=$81;
  PamLen=$7f;
  i : integer=0;
  s : string='';
begin
  while (i<=PamLen) and (Mem[PrefixSeg:PamOfs+i]<>$0d) do
    begin
      s:=s+Chr(Mem[PrefixSeg:PamOfs+i]);
      i:=i+1;
    end;
  PamString:=s;
end;


function Where;
 var i,j:integer;
     EnvSeg:word;
     s:string;
begin
 EnvSeg:=MemW[PrefixSeg:$2c];
 i:=0;
 j:=1;
 s:='';
 while
   not(
       (Mem[EnvSeg:i]=0) and
       (Mem[EnvSeg:i+1]=0) and
       (Mem[EnvSeg:i+2]=1) and
       (Mem[EnvSeg:i+3]=0)
      )
 do i:=i+1;
 i:=i+4;
 while Mem[EnvSeg:i+j-1]<>0 do
  begin
   s:=s+chr(Mem[EnvSeg:i+j-1]);
   j:=j+1;
  end;
 Where:=s;
end;

function UpCaseString;
var i : integer;
   s1 : string;
begin
  s1:='';
  for i:=1 to Length(s) do s1:=s1+UpCase(s[i]);
  UpCaseString:=s1;
end;

end.
