const
  HelpFrame : array[1..19] of string[65]=(
     '                                                                 ',
     '   File Comparer & Browser ͻ  ',
     '                      v4.52  2006/08/06                        ',
     '  Ķ  ',
     '   Cursor movement:           F1  - This help                 ',
     '   , , x, x, PgUp, PgDn,    F2  - Save comparison report    ',
     '   Home, End - Move cursor    F3  - Hex Converter             ',
     '   Ctrl-Home, Ctrl-PgUp - Top F4  - Byte Editor (try TAB)     ',
     '   Ctrl-End, Ctrl-PgDn  - End SHIFT-F4 - Match bytes:no undo  ',
     '                              F5  - Go to address             ',
     '   Special:                   F7  - Search (case snstivity:   ',
     '   Space, TAB - Next window    CR in hex - yes, ASCII - no)   ',
     '   Enter - Sync windows       SHIFT-F7 - Search next          ',
     '   ESC   - Quit               F9  - Load new file             ',
     '  Ĵ F10 - Quit                      ',
     '   RIGHT mouse button= SHIFT  Editing changes date - to keep  ',
     '   LEFT / CR in dialog boxes  the old one exit via SHIFT-F10  ',
     '  ͼ  ',
     '                                                                 '
    );
  AskFrame : array[1..6] of string[70]=(
   '                                                                      ',
   '   Compare ͻ  ',
   '   Send comparison report to file:                                  ',
   '                                                                    ',
   '  ͼ  ',
   '                                                                      '
  );

  SearchFrame : array[1..9] of string[70]=(
   '                                                                      ',
   '   Search ͻ  ',
   '   Search                                                           ',
   '    Hex                                                             ',
   '                                                                    ',
   '    ASCII                                                           ',
   '                                                                    ',
   '  ͼ  ',
   '                                                                      '
   );





  ProgressFrame : array[1..9] of string[34]=(
                    '                                  ',
                    '   Compare ͻ  ',
                    '           Comparing            ',
                    '                                ',
                    '              and               ',
                    '                                ',
                    '      ',
                    '  ͼ  ',
                    '                                  '
   );

  HexCvtFrame : array[1..13] of string[29]=(
              '                             ',
              '   Hex Converter ͻ  ',
              '                           ',
              '        Hex                ',
              '        $$$$$$$$$          ',
              '                           ',
              '        Decimal            ',
              '        $$$$$$$$$$$        ',
              '                           ',
              '         [  OK  ]          ',
              '                           ',
              '  ͼ  ',
              '                             '
   );

   ErrorFrame : array[1..6] of string[48]=(
     '                                                ',
     '   Error ͻ  ',
     '                                              ',
     '                     OK                       ',
     '  ͼ  ',
     '                                                ');

   ErrorMsg : array[1..6] of string[30]=(
     '         Unable to create file',
     '            Disk I/O error',
     '          Unable to open file',
     '          No target specified',
     '           Target not found  ',
     '              Null file'
    );

   SearchInProgressFrame : array[1..6] of string[28]=(
     '                            ',
     '   Search ͻ  ',
     '    Searching the file    ',
     '                          ',
     '  ͼ  ',
     '                            '
    );

procedure Help;
var i,j:integer;
begin
  ActiveModule:=1;
  DrawButtons(2);
  HidePtr;
  SaveScr(2);
  for i:=1 to 19 do
   for j:=1 to 65 do
     begin
       scr^[i+(ScrHeight shr 1)-10,j+7].chr:=HelpFrame[i][j];
       scr^[i+(ScrHeight shr 1)-10,j+7].atr:=Color4;
     end;
  for i:=10 to 74 do scr^[(ScrHeight shr 1)+10,i].atr:=ColorX;
  for i:=(ScrHeight shr 1)-8 to (ScrHeight shr 1)+9 do
    begin
      scr^[i,73].atr:=ColorX;
      scr^[i,74].atr:=ColorX;
    end;
  scr^[(ScrHeight shr 1)-4,18].chr:=#27;
  scr^[(ScrHeight shr 1)-4,21].chr:=#26;
  ShowPtr;
  repeat until GetEvent in [27,13];
  RestoreScr(2);
  ActiveModule:=0;
  DrawButtons(1);
end;

procedure DrawHexCvtFrame;
begin
  for i:=1 to 13 do
   for j:=1 to 29 do
     begin
       scr^[i+(ScrHeight shr 1)-7,j+22].chr:=HexCvtFrame[i][j];
       scr^[i+(ScrHeight shr 1)-7,j+22].atr:=Color5;
     end;
  for i:=25 to 51 do scr^[(ScrHeight shr 1)+7,i].atr:=ColorX;
  for i:=(ScrHeight shr 1)-5 to (ScrHeight shr 1)+7 do
    begin
      scr^[i,52].atr:=ColorX;
      scr^[i,53].atr:=ColorX;
    end;
  for i:=33 to 40 do scr^[(ScrHeight shr 1)+3,i].atr:=Color6;
end;

procedure DrawSearchFrame;
begin
  for i:=1 to 9 do
   for j:=1 to 70 do
     begin
       scr^[i+(ScrHeight shr 1)-7,j+2].chr:=SearchFrame[i][j];
       scr^[i+(ScrHeight shr 1)-7,j+2].atr:=Color5;
     end;
  for i:=5 to 72 do scr^[(ScrHeight shr 1)+3,i].atr:=ColorX;
  for i:=(ScrHeight shr 1)-5 to (ScrHeight shr 1)+3 do
    begin
      scr^[i,73].atr:=ColorX;
      scr^[i,74].atr:=ColorX;
    end;
  GotoXY(15,(ScrHeight shr 1)-3);
  TextAttr:=Color5;
  if InUpperHalf then write(Name1)
   else write(Name2);
  write(' for');
  TextAttr:=Color6;
end;

procedure DrawStandByFrame;
var s : string;
begin
  HidePtr;
  for i:=1 to 6 do
   for j:=1 to 28 do
     begin
       scr^[i+(ScrHeight shr 1)-5,j+23].chr:=SearchInProgressFrame[i][j];
       scr^[i+(ScrHeight shr 1)-5,j+23].atr:=Color5;
     end;
  for i:=26 to 53 do scr^[(ScrHeight shr 1)+2,i].atr:=ColorX;
  for i:=(ScrHeight shr 1)-3 to (ScrHeight shr 1)+2 do
    begin
      scr^[i,52].atr:=ColorX;
      scr^[i,53].atr:=ColorX;
    end;
  TextBackground(LightGray);
  if InUpperHalf then s:=Name1 else s:=Name2;
  GotoXY( ( (12-Length(s)) div 2 )+33 ,(ScrHeight shr 1));
  write(s);
  TextBackground(Cyan);
  ShowPtr;
end;
