
{*************************************************}
{                 Joe Forster/STA                 }
{                                                 }
{                  EXTFILES.PAS                   }
{                                                 }
{                Extended file unit               }
{*************************************************}

unit ExtFiles;

{$A+,B-,D+,E-,F+,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}

interface

uses
  DOS;

const
  MaxByte       = $FF;
  MaxStrLen     = $FE;
{File open modes}
  fmReadOnly    = 0;
  fmWriteOnly   = 1;
  fmReadWrite   = 2;
  fmModeMask    = $0F;
  fmExclusive   = $20;
  fmShared      = $40;
{DOS error codes}
  deAccessDenied= 5;
{Directory separator character}
  chDirSep      = '\';

type
{Extended file record}
  ExtFile       = record
    Orig        : file;
    LongName    : string;
  end;
  PExtFile      = ^ExtFile;
{Extended search record}
  ExtSearchRec  = record
    Orig        : SearchRec;
    HandleUsed  : Boolean;
    LongHandle  : Word;
    LongName    : string;
  end;
{Windows-style search record}
  LongSearchRec = record
    Attr        : Longint;
    CreTimeLo   : Longint;
    CreTimeHi   : Longint;
    AccTimeLo   : Longint;
    AccTimeHi   : Longint;
    Time        : Longint;
    TimeHi      : Longint;
    SizeHi      : Longint;
    Size        : Longint;
    Reserved    : array [0..7] of Byte;
    LongName    : array [0..259] of Byte;
    ShortName   : array [0..13] of Byte;
  end;

var
  LongNames     : Boolean;

procedure ExecLFN;
procedure InitLongNames;
function LongParamStr(Index: Byte): string;
procedure LongFSplit(const Path: string; var Dir, Name, Ext: string);
function LongOpenFile(Name: string; var F: ExtFile; Mode: Byte): Integer;
function LongFExpand(Path: string): string;
procedure ExtBlockRead(var F: ExtFile; var Buf; Count: Word; var Result: Word);
procedure ExtBlockWrite(var F: ExtFile; var Buf; Count: Word);
procedure ExtBlockWrite2(var F: ExtFile; var Buf; Count: Word; var Result: Word);
procedure ExtClose(var F: ExtFile);
procedure ExtSeek(var F: ExtFile; Pos: Longint);
function ExtFileSize(var F: ExtFile): Longint;
procedure ExtGetFTime(var F: ExtFile; var Time: Longint);
procedure ExtSetFTime(var F: ExtFile; Time: Longint);

implementation

{Extended DOS functions}
function ExtFExpand(Path: string): string; external;
{$L EXTDOS.OBJ}

{Execute a Windows-style long file name function and return error if the
  function is not supported
  Input : AL: DOS function number
          Other registers: all parameters of the function
  Output: CF: when not zero, an error occured
          AX: error code}
procedure ExecLFN; assembler;
asm
    push ds;
    push ax;
    mov ax, Seg(InOutRes);
    mov ds, ax;
    cmp LongNames, False;
    pop ax;
    pop ds;
    jne @1;
    mov ax, $7100;
    stc;
    jmp @2;
@1: mov ah, $71;
    stc;
    int $21;
    jc @2;
    cmp ax, $7100;
    stc;
    je @2;
    clc;
@2:
end;

{Determine if long file name support is installed}
procedure InitLongNames; assembler;
var
  S,
  T             : string;
asm
    mov LongNames, True;
    push ds;
    push ss;
    pop ds;
    push ss;
    pop es;
    lea si, S;
    mov byte ptr [si], 0;
    lea di, T;
    xor cl, cl;
    mov ch, $80;
    mov al, $60;
    call ExecLFN;
    pop ds;
    mov bl, True;
    jnc @1;
    cmp ax, $7100;
    jne @1;
    mov bl, False;
@1: mov LongNames, bl;
end;

{Get a long file name from the command line
  Input : Index: the number of the command line parameter; 0 not supported;
          when 255, the complete command line is returned
  Output: the command line parameter}
function LongParamStr(Index: Byte): string; assembler;
asm
    push ds;
    mov dl, Index;
    or dl, dl;
    je @12;
    xor dh, dh;
    mov ax, PrefixSeg;
    mov ds, ax;
    mov di, $0080;
    mov cl, [di];
    xor ch, ch;
    inc di;
    xor bx, bx;
    xor ah, ah;
@1: jcxz @3;
@2: mov al, [di];
    or al, al;
    jne @13;
    xor cx, cx;
    jmp @3;
@13:cmp al, '"';
    jne @7;
    xor ah, 1;
    inc di;
    dec cx;
    jmp @3;
@7: cmp al, ' ';
    ja @3;
    inc di;
    loop @2;
@3: mov si, di;
    jcxz @5;
@4: mov al, [di];
    or al, al;
    jne @14;
    xor cx, cx;
    jmp @5;
@14:cmp al, '"';
    jne @8;
    xor ah, 1;
@8: cmp dl, MaxByte;
    je @9;
    cmp al, ' ';
    ja @9;
    or ah, ah;
    je @5;
@9: inc di;
    loop @4;
@5: mov ax, di;
    sub ax, si;
    je @6;
    cmp dl, MaxByte;
    je @6;
    dec dx;
    jnz @1;
@6: les di, @Result;
    mov bx, di;
    inc di;
    xor dl, dl;
    mov cx, ax;
    jcxz @12;
@11:lodsb;
    cmp al, '"';
    je @10;
    stosb;
    inc dl;
@10:loop @11;
@12:mov es:[bx], dl;
    pop ds;
end;

{Split a long file name that contains the path, name and extension of the
  file
  Input : Path: the full file name
          Dir: the string to contain the path
          Name: the string to contain the file name
          Ext: the string to contain the extension}
procedure LongFSplit(const Path: string; var Dir, Name, Ext: string); assembler;
asm
    push ds;
    cld;
    lds si, Path;
    lodsb;
    mov dl, al;
    xor dh, dh;
    mov bx, dx;
    or bx, bx;
    je @2;
@1: cmp byte ptr [si][bx][-1], chDirSep;
    je @2;
    cmp byte ptr [si][bx][-1], ':';
    je @2;
    dec bx;
    jne @1;
@2: mov ax, MaxStrLen;
    les di, Dir;
    call @7;
    mov bx, dx;
    or bx, bx;
    je @4;
@3: dec bx;
    or bx, bx;
    jne @5;
    mov bx, dx;
    jmp @4;
@5: cmp byte ptr [si][bx], '.';
    jne @3;
@4: mov ax, MaxStrLen;
    les di, Name;
    call @7;
    mov bx, dx;
    mov ax, MaxStrLen;
    les di, Ext;
    call @7;
    pop ds;
    jmp @8;
@7: sub dx, bx;
    cmp ax, bx;
    jb @6;
    mov ax, bx;
@6: stosb;
    mov cx, ax;
    add bx, si;
    rep movsb;
    mov si, bx;
    retn;
@8:
end;

{Open a file with long file name
  Input : Name: the name of the file
          F: the file record
          Mode: access mode to open the file with
  Output: when not 0, an error occured}
function LongOpenFile(Name: string; var F: ExtFile; Mode: Byte): Integer;
var
  B             : Byte;
  W             : Word;
  I             : Integer;
begin
  F.LongName := Name;
  B := 0;
  case Mode of
    fmReadOnly: B := fmShared;
    fmReadWrite, fmWriteOnly: B := fmExclusive;
  end;
  FileMode := Mode or B;
  asm
    mov InOutRes, 0;
    push ds;
    mov al, FileMode;
    xor ah, ah;
    push ax;
    push ss;
    pop ds;
    lea si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    xor di, di;
    mov dx, $01;
    mov bl, al;
    and bl, $0F;
    cmp bl, fmWriteOnly;
    jne @1;
    mov dx, $12;
@1: mov bl, al;
    mov al, $6C;
    xor cx, cx;
    call ExecLFN;
    pop bx;
    jnc @2;
    cmp ax, 5;
    jne @4;
    and bl, $0F;
    mov al, $6C;
    xor cx, cx;
    call ExecLFN;
    jnc @2;
@4: pop ds;
    mov InOutRes, ax;
    xor ax, ax;
    jmp @3;
@2: pop ds;
    les di, F;
    mov es:[di].ExtFile.Orig.FileRec.Mode, fmInOut;
    mov es:[di].ExtFile.Orig.FileRec.RecSize, 1;
@3: mov es:[di].ExtFile.Orig.FileRec.Handle, ax;
  end;
  if InOutRes = $7100 then
  begin
    InOutRes := 0;
    case Mode of
      fmReadOnly, fmReadWrite:
      begin
        Assign(F.Orig, Name);
        GetFAttr(F.Orig, W);
        I := DOSError;
        if I = 0 then
        begin
          Reset(F.Orig, 1);
          I := IOResult;
          if I = deAccessDenied then
          begin
            FileMode := FileMode and fmModeMask;
            Reset(F.Orig, 1);
            I := IOResult;
          end;
        end;
      end;
      fmWriteOnly:
      begin
        Assign(F.Orig, Name);
        Rewrite(F.Orig, 1);
        I := IOResult;
        if I = deAccessDenied then
        begin
          FileMode := FileMode and fmModeMask;
          Rewrite(F.Orig, 1);
          I := IOResult;
        end;
      end;
    end;
    F.LongName := Name;
  end
  else
  begin
    if (InOutRes = 0) and (FileMode and fmModeMask <> fmWriteOnly) then
    begin
      InOutRes := 0;
    end;
    I := IOResult;
  end;
  LongOpenFile := I;
end;

{Convert a relative file name to an absolute one
  Input : Path: the relative file name
  Output: the absolute file name}
function LongFExpand(Path: string): string;
begin
  LongFExpand := ExtFExpand(Path);
end;

{Read a block of data from a file
  Input : F: the file to read the data from
          Buf: the buffer to put the data into
          Count: the number of bytes to read
          Result: the integer to contain the number of bytes that have
                  actually been read}
procedure ExtBlockRead(var F: ExtFile; var Buf; Count: Word; var Result: Word);
begin
  BlockRead(F.Orig, Buf, Count, Result);
end;

{Write a block of data into a file
  Input : F: the file to write the data into
          Buf: the buffer to get the data from
          Count: the number of bytes to write}
procedure ExtBlockWrite(var F: ExtFile; var Buf; Count: Word);
var
  W             : Word;
begin
  BlockWrite(F.Orig, Buf, Count, W);
end;

{Write a block of data into a file
  Input : F: the file to write the data into
          Buf: the buffer to get the data from
          Count: the number of bytes to write
          Result: the integer to contain the number of bytes that have
                  actually been read}
procedure ExtBlockWrite2(var F: ExtFile; var Buf; Count: Word; var Result: Word);
begin
  BlockWrite(F.Orig, Buf, Count, Result);
end;

{Close a file
  Input : F: the file to close}
procedure ExtClose(var F: ExtFile);
begin
  Close(F.Orig);
end;

{Seek in a file
  Input : F: the file to seek in
          Pos: the position to seek to}
procedure ExtSeek(var F: ExtFile; Pos: Longint);
begin
  Seek(F.Orig, Pos);
end;

{Determine the size of a file
  Input : F: the file to check
  Output: the size of the file in bytes}
function ExtFileSize(var F: ExtFile): Longint;
begin
  ExtFileSize := FileSize(F.Orig);
end;

{Get the date stamp of a file
  Input : F: the file to get the date stamp of
          Time: the longint to contain the date stamp of the file}
procedure ExtGetFTime(var F: ExtFile; var Time: Longint);
begin
  GetFTime(F.Orig, Time);
end;

{Set the date stamp of a file
  Input : F: the file to set the date stamp of
          Time: the new date stamp of the file}
procedure ExtSetFTime(var F: ExtFile; Time: Longint);
begin
  SetFTime(F.Orig, Time);
end;

end.
