@echo off
goto Start
rem -----------------------------------------------------------------------
rem ACAU.BAT - Archive File Catalog update
rem
rem title   : ACAU
rem version : 2.1
rem date    : Dec 25,1995
rem author  : J R Ferguson
rem language: MS-DOS batch file
rem usage   : See :HELP below
rem -----------------------------------------------------------------------
:Help
echo * ACAU v2.1 - Archive File Catalog update
echo * usage: ACAU filespec [typ [acafile]]
echo * where  filespec = archive file of which members are to be cataloged
echo *                   wildcards * and ? allowed
echo *        typ      = archive type: ARC,ARJ,LBR,LZH,PAK,RAR,ZIP (default ZIP)
echo *        acafile  = archive catalog (default C:\MASTER.ACA)
echo *
echo * ACAU /? displays this help text
goto EXIT
rem -----------------------------------------------------------------------
:Start
if '%1' == ''    goto Help
if '%1' == '?'   goto Help
if '%1' == '/?'  goto Help
chkcmd ACAUPD
if errorlevel 1 goto NotFound
if '%2' == ''    goto ZIP
if '%2' == 'arj' goto ARJ
if '%2' == 'ARJ' goto ARJ
if '%2' == 'arc' goto ARC
if '%2' == 'ARC' goto ARC
if '%2' == 'lbr' goto LBR
if '%2' == 'LBR' goto LBR
if '%2' == 'lzh' goto LZH
if '%2' == 'LZH' goto LZH
if '%2' == 'pak' goto PAK
if '%2' == 'PAK' goto PAK
if '%2' == 'rar' goto RAR
if '%2' == 'RAR' goto RAR
if '%2' == 'zip' goto ZIP
if '%2' == 'ZIP' goto ZIP
goto Help
rem -----------------------------------------------------------------------
:ARJ
chkcmd ARJ
if errorlevel 1 goto NotFound
for %%f in ( %1 ) do call acaupdb ARJ L %%f %3
goto Exit
rem -----------------------------------------------------------------------
:ARC
chkcmd PKUNPAK
if errorlevel 1 goto NotFound
for %%f in ( %1 ) do call acaupdb PKUNPAK -V %%f %3
goto Exit
rem -----------------------------------------------------------------------
:LBR
chkcmd LBRLST
if errorlevel 1 goto NotFound
for %%f in ( %1 ) do call acaupdb LBRLST L %%f %3
goto Exit
rem -----------------------------------------------------------------------
:LZH
chkcmd LHA
if errorlevel 1 goto NotFound
for %%f in ( %1 ) do call acaupdb LHA L %%f %3
goto Exit
rem -----------------------------------------------------------------------
:PAK
chkcmd PAK
if errorlevel 1 goto NotFound
for %%f in ( %1 ) do call acaupdb PAK V %%f %3
goto Exit
rem -----------------------------------------------------------------------
:ZIP
chkcmd PKUNZIP
if errorlevel 1 goto NotFound
for %%f in ( %1 ) do call acaupdb PKUNZIP -V %%f %3
goto Exit
rem -----------------------------------------------------------------------
:RAR
chkcmd RAR
if errorlevel 1 goto UnRAR
for %%f in ( %1 ) do call acaupdb2 RAR L -c- %%f %3
goto Exit
rem -----------------------------------------------------------------------
:UnRAR
chkcmd UNRAR
if errorlevel 1 goto NotFound
for %%f in ( %1 ) do call acaupdb2 UNRAR L -c- %%f %3
goto Exit
rem -----------------------------------------------------------------------
:NotFound
echo This command is needed by ACAU
:Exit