#include <windows.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <htmlhelp.h>
#include "plugin.hpp"

//////////////////////////////////////////////////////////////////////////
#define issym(c) (isalnum(c) || c == '_')
#define MAXFILES 16
#define BUFLEN 1024
#define MAXPATH 256
const char *cfgname = "farhelp.cfg";

enum {
	UNABLE_TO_OPEN_FILE,
	NO_HELP_FILE,
	MEMORY_ERROR,
	UNKNOWN_FILE_TYPE,
};

//////////////////////////////////////////////////////////////////////////
static struct PluginStartupInfo Info;
FARSTDPOINTTONAME PointToName;

void WINAPI _export SetStartupInfo(const struct PluginStartupInfo *info)
{
    Info = *info;
	PointToName = Info.FSF->PointToName;
}

const char *GetMsg(int MsgId)
{
  return(Info.GetMsg(Info.ModuleNumber,MsgId));
}

char *getword(char *s, int l)
{
	int r;

	while (l > 0 && issym(s[l])) l--;
	if (!issym(s[l])) l++;
	r = l;
	while (issym(s[r])) r++;
	s[r] = 0;
	return s+l;
}

char *trim(char *s)
{
	if (s == 0) return 0;

	while (isspace(*s)) s++;
	char *t = s;
	while (*t) t++;
	while (t > s && isspace(*(--t))) *t = 0;

   	return s;
}

void msg(int msgnum, char *add = 0)
{
   	const char *s[3] = {"FarHelp"};
   	int n = 2;
   	s[1] = GetMsg(msgnum);
   	if (add) { s[2] = add; n = 3; }
	Info.Message(Info.ModuleNumber, FMSG_WARNING|FMSG_MB_OK, 0, s, n, 0);
}

void split(char *buf, char **left, char **right)
{
    char *l, *r;
    l = r = trim(buf);
    while (*r && *r != ':') r++;
    *r++ = 0;
    *left = trim(l);
    *right = trim(r);
}

void showhelp(int fmenu)
{
   	char buf[BUFLEN];
	struct FarMenuItem items[MAXFILES];
	char fn[MAXFILES][MAXPATH];
   	struct EditorInfo ei;
	int n = 0, i = 0;
   	char *s, *w;
   	struct EditorGetString egs = {-1,0,0,0,0,0};

	////////////////////////////////////////////////////////////////////
   	Info.EditorControl(ECTL_GETINFO, &ei);

	////////////////////////////////////////////////////////////////////
	strcpy(buf, Info.ModuleName);
	strcpy(PointToName(buf), cfgname);

   	FILE *f = fopen(buf, "rt");
   	if (f == NULL) { msg(UNABLE_TO_OPEN_FILE, cfgname); return; }

   	while (fgets(buf, BUFLEN, f)) {
		if (buf[0] && buf[0] != ' ' && buf[0] != '\t') {
   			if (Info.CmpName(trim(buf), ei.FileName, 1)) {
   				memset(&items, 0, sizeof(items));
   				while (n < MAXFILES && fgets(buf, BUFLEN, f) && (buf[0] == ' ' || buf[0] == '\t')) {
   					char *desc, *filename;
   					split(buf, &desc, &filename);
   					if (*desc == 0) desc = filename;
   					strncpy(fn[n], filename, MAXPATH); fn[n][MAXPATH] = 0;
   					strncpy(items[n].Text, desc, 128); items[n].Text[128] = 0;
   					n++;
   					if (!fmenu) break;
   				}
   				break;      
   			}
   		}
   	}
   	fclose(f);

   	if (n == 0) { msg(NO_HELP_FILE); return; }

	////////////////////////////////////////////////////////////////////
    if (fmenu) {
    	items[0].Selected = 1;
    	i = Info.Menu(Info.ModuleNumber, -1,-1, 0, 0, NULL,NULL,NULL,NULL,NULL, 
    			(const struct FarMenuItem *)&items, n);
    	if (i == -1) return;
    } 
        
	////////////////////////////////////////////////////////////////////
   	Info.EditorControl(ECTL_GETSTRING, &egs);

    s = malloc(egs.StringLength+1);
   	if (s == NULL) { msg(MEMORY_ERROR); return; }

   	memcpy(s, egs.StringText, egs.StringLength);
   	s[egs.StringLength] = 0;
   	w = getword(s, ei.CurPos < egs.StringLength ? ei.CurPos : egs.StringLength-1);

	////////////////////////////////////////////////////////////////////
   	if (Info.CmpName("*.hlp", fn[i], 1))
   		WinHelp(GetDesktopWindow(), fn[i], HELP_PARTIALKEY, (DWORD)w);
   	else
   	if (Info.CmpName("*.chm", fn[i], 1)) {

        HH_AKLINK link;
        memset(&link, 0, sizeof(HH_AKLINK));
        link.cbStruct = sizeof(link);
        link.pszKeywords = w;
        link.fIndexOnFail = TRUE;
		HWND hwnd = HtmlHelp(GetDesktopWindow(), fn[i], HH_DISPLAY_TOPIC, 0);
		if (hwnd) {
			hwnd = HtmlHelp(GetDesktopWindow(), fn[i], HH_KEYWORD_LOOKUP, (DWORD)&link);
			ShowWindow(hwnd, SW_SHOWNORMAL);
		}

/*
		HWND hwnd = HtmlHelp(GetDesktopWindow(), fn[i], HH_DISPLAY_TOPIC, 0);
		if (hwnd) {
			hwnd = HtmlHelp(hwnd, fn[i], HH_DISPLAY_INDEX, (DWORD)w);
			ShowWindow(hwnd, SW_SHOWNORMAL);
		}
*/
	} else
   	if (Info.CmpName("*.txt", fn[i], 1))
   		Info.Editor(fn[i], NULL, 0,0,-1,-1, 0, -1,-1);
	else
		msg(UNKNOWN_FILE_TYPE, fn[i]);
	////////////////////////////////////////////////////////////////////
   	free(s);
}

int WINAPI _export ProcessEditorInput(const INPUT_RECORD *Rec)
{
    if (Rec->EventType == KEY_EVENT) {
		KEY_EVENT_RECORD *k = &Rec->Event.KeyEvent;
     	if (k->bKeyDown) 
        	if (k->wVirtualKeyCode == VK_F1) {
  				if (k->dwControlKeyState & (LEFT_CTRL_PRESSED | RIGHT_CTRL_PRESSED)) {
    				showhelp(0);
    				return 1;
    			} else 
  				if (k->dwControlKeyState & (LEFT_ALT_PRESSED | RIGHT_ALT_PRESSED)) {
  					showhelp(1);
    				return 1;
  				}
    		}
        			
    }
    return 0;
}
