#define WIN32_LEAN_AND_MEAN
#include <atlbase.h>
#include <windows.h>
#include <stdlib.h>
#include <malloc.h>
#pragma warning(push,1)
#include "plugin.hpp"
#pragma warning(pop)
#include "vshelp.tlh"

static BOOL isComInit=FALSE;
FARAPIEDITORCONTROL EditorControl;

static int IsWrdSym( char Symbol )
{
    Symbol&=0xDF; // toupper
    return ( Symbol>='A' && Symbol<='Z' ||
              Symbol>='0' && Symbol<='9' ||
              Symbol=='_' );
}

void WINAPI SetStartupInfo(const struct PluginStartupInfo *Info)
{
    EditorControl=Info->EditorControl;
}

static Help *pHelpPtr=0;

HANDLE WINAPI OpenPlugin(int OpenFrom,int Item)
{
    BSTR pwStr;
    wchar_t* pw;
    size_t len;
    static const wchar_t szCollection[]=L"ms-help://MS.VSCC";

    (void)Item;
    (void)OpenFrom;

    if( !isComInit ){
        CoInitialize(NULL);
        isComInit=TRUE;
    }

    if( !pHelpPtr ){
        if( FAILED(CoCreateInstance(CLSID_DExploreAppObj,0,CLSCTX_LOCAL_SERVER,IID_Help,(void**)&pHelpPtr)) )
            return INVALID_HANDLE_VALUE;
    }

    if( pHelpPtr ){
        pwStr=SysAllocString(szCollection);
        pHelpPtr->SetCollection(pwStr, 0);
        SysFreeString(pwStr);
        pHelpPtr->Index();

        struct EditorInfo ei;
        struct EditorGetString str;
        struct EditorConvertText ect;

        EditorControl(ECTL_GETINFO,&ei);
        str.StringNumber = -1;
        EditorControl( ECTL_GETSTRING, &str );

        if( str.StringLength <= ei.CurPos ) ei.CurPos=str.StringLength-1;
        if( ei.CurPos>=0 ){
            char *Text;

            Text=ect.Text=(char*)alloca(str.StringLength+1);
            if( ect.Text ){
                int beg, end;

                memcpy(Text,str.StringText,str.StringLength);
                ect.TextLength=str.StringLength;
                EditorControl(ECTL_EDITORTOOEM,&ect);

                beg=ei.CurPos;

                if( beg>=ect.TextLength ) beg=ect.TextLength-1;
                while( beg>0 && !IsWrdSym(Text[beg]) ) beg--;
                while( beg>0 && IsWrdSym(Text[beg]) ) beg--;
                while( beg<ect.TextLength && !IsWrdSym(Text[beg]) ) beg++;
                end=beg;
                while( end<ect.TextLength && IsWrdSym(Text[end]) ) end++;
                Text[(end>beg)?end:beg] = '\0';

                len=strlen(&Text[beg]);
                pw=(wchar_t*)alloca((len+1)<<1);
                MultiByteToWideChar(CP_OEMCP,0,&Text[beg],-1,pw,len+1);
                pwStr=SysAllocString(pw);
                pHelpPtr->DisplayTopicFromKeyword(pwStr);
                pHelpPtr->DisplayTopicFromF1Keyword(pwStr);
                SysFreeString(pwStr);
            }
        }
    }

    return(INVALID_HANDLE_VALUE);
}

void WINAPI GetPluginInfo(struct PluginInfo *Info)
{
    static char *PluginMenuStrings[1];
    static const char szPlugName[]="MSDN.NET";

    Info->StructSize=sizeof(*Info);
    Info->Flags=PF_EDITOR|PF_DISABLEPANELS;
    PluginMenuStrings[0]=(char*)szPlugName;

    Info->PluginMenuStrings=PluginMenuStrings;
    Info->PluginMenuStringsNumber=sizeof(PluginMenuStrings)/sizeof(PluginMenuStrings[0]);
}

void WINAPI ExitFAR(void)
{
    if( pHelpPtr ){
        pHelpPtr->Release();
        pHelpPtr=0;
    }
    if( isComInit ){
        CoUninitialize();
        isComInit=FALSE;
    }
}

