#define WIN32_LEAN_AND_MEAN

#ifdef _MSC_VER
#define _export
#endif

#include <windows.h>
#include <string.h>
#include "plugin.hpp"
#include "ExefiltLang.h"

typedef unsigned char uchar;

#define ARRLEN(_) (sizeof(_)/sizeof*(_))

char* GetReg(char* name, char* buf, size_t bufsize, char* dflt);
DWORD GetReg(char* name, DWORD deflt=0);
void SetReg(char* name, char* val, size_t bufsize, DWORD Type);
inline void SetReg(char* name, char* buf) { SetReg(name, buf, strlen(buf)+1, REG_SZ); }
inline void SetReg(char* name, DWORD wrd) { SetReg(name, (char*)&wrd, sizeof wrd, REG_DWORD); }

PluginStartupInfo StartupInfo;
//char PluginRootKey[128];

inline int Control(int Command, void *Param)
{
    return StartupInfo.Control(INVALID_HANDLE_VALUE, Command, Param);
}
inline int EditorControl(int Command, void *Param)
{
    return StartupInfo.EditorControl(Command, Param);
}
inline int Dialog(int X1, int Y1, int X2, int Y2, char *HelpTopic,
  	FarDialogItem *Item, int ItemsNumber)
{
    return StartupInfo.Dialog(StartupInfo.ModuleNumber,X1,Y1,X2,Y2,
		HelpTopic,Item,ItemsNumber);
}
inline int Message(unsigned Flags, char *HelpTopic, char **Items, int ItemsNumber, int ButtonsNumber)
{
    return StartupInfo.Message(StartupInfo.ModuleNumber, Flags, HelpTopic, (const char**)Items, ItemsNumber, ButtonsNumber);
}
inline char *GetMsg(int MsgId)
{
    return StartupInfo.GetMsg(StartupInfo.ModuleNumber,MsgId);
}

BOOL bWinNT;

void WINAPI SetStartupInfo(PluginStartupInfo *Info)
{
  StartupInfo = *Info;
//  wsprintf(PluginRootKey, "%s\\YMS\\ExeFilter", StartupInfo.RootKey);
  OSVERSIONINFO vi; vi.dwOSVersionInfoSize = sizeof vi;
  GetVersionEx(&vi);
  bWinNT = (vi.dwPlatformId==VER_PLATFORM_WIN32_NT);
}

inline void ToOem(char*str) { CharToOem(str,str); }

int WinError(char* msg)
{
  char* lpMsgBuf; BOOL bAllocated = FALSE;
  if(msg)
    lpMsgBuf = msg;
  else {
    FormatMessage( FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
      NULL, GetLastError()&0x3fffffff, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
      (LPTSTR)&lpMsgBuf, 0, NULL );
    bAllocated = TRUE;
    ToOem(lpMsgBuf);
  }
  static char* items[]={0,0,0,0};
  items[0] = GetMsg(MError); items[3] = GetMsg(MOK);

  if(strlen(lpMsgBuf) > 64)
      for(int i=strlen(lpMsgBuf)/2; i<strlen(lpMsgBuf); i++)
	  if(lpMsgBuf[i]==' ') { lpMsgBuf[i] = '\n'; break; }
  items[1] = strtok(lpMsgBuf,"\r\n");
  items[2] = strtok(NULL,"\r\n"); if(!items[2]) items[2] = items[3];
  int rc = Message(FMSG_WARNING,GetMsg(MWinError),items,ARRLEN(items)-(items[2]==items[3]),1);
  if(bAllocated) LocalFree( lpMsgBuf );
  return rc;
}

char* getline(HANDLE hFile, BOOL bPipe)
{
    static char* buf;
    static int bufsize=0, nBytes;
    static bool bWasEndline;

    if(bufsize==0) { buf = new char[bufsize=1024]; nBytes=0;}

    if(hFile==0) {//reset	
	nBytes = 0;
	*buf = 0;
	bWasEndline = false;
	return buf;
    }

    DWORD dwRead;
    int i;

    // Delete previously returned string.
    // ASSUME THAT FILTER'S OUTPUT DOES NOT CONTAIN ZEROES!
    char* p = (char*)memchr(buf,0,nBytes);
    if(p && p<buf+nBytes-1 && p[1]==0) p++;
    if(p) nBytes-=(p+1-buf);
    if(nBytes<0) nBytes=0;
    if(p && nBytes)
	memmove(buf, p+1, nBytes );

    while(1) {
	// If '\r\n' is present, return the new line.
	for(i=0; i<nBytes-1; i++) {
	    if(buf[i]=='\r'&&buf[i+1]=='\n') {
		buf[i]=buf[i+1]=0;
		bWasEndline = true;
		return buf;
	    }
	    if(buf[i]=='\r' || buf[i]=='\n') {
		buf[i]=0;
		bWasEndline = true;
		return buf;
	    } //new line found without reading the file
	}
	// EOL not found->read more to the file.
	if(nBytes>=bufsize-1) { // buffer full => reallocate the buffer
	    char* newbuf = new char [bufsize+=1024];
	    memcpy(newbuf, buf, nBytes);
	    delete buf;
	    buf = newbuf;
	}
	if(bPipe) {
	    if(!PeekNamedPipe(hFile, 0, 0, 0, &dwRead, 0)) return 0;
	}
	else
	    dwRead = bufsize-nBytes;
	if(dwRead==0) goto read0; //no more bytes
	if(dwRead > bufsize-nBytes)
	    dwRead = bufsize-nBytes;

	if(!ReadFile(hFile, buf+nBytes, dwRead, &dwRead, 0)) return 0;
	if(dwRead==0) { //no more bytes
	    read0:
	    if(nBytes==0) {
		if(bWasEndline) {
		    bWasEndline = false;
		    return "";
		}
		return 0;
	    }   
	    if(buf[nBytes-1]=='\r' || buf[nBytes-1]=='\n') {
		bWasEndline = true;
		buf[--nBytes] = 0;
	    }
	    buf[nBytes++] = 0;
	    return buf;
	}
	nBytes+=dwRead;
    }
}

char sTmpFileName[MAX_PATH];

BOOL CreateTempFile(HANDLE &hChildStdoutWr, HANDLE &hChildStdoutRdDup)
{
    char sTemp[MAX_PATH];
    GetTempPath(sizeof sTemp, sTemp);
    GetTempFileName(sTemp, "~EF", 0, sTmpFileName);

    SECURITY_ATTRIBUTES saAttr; 
    saAttr.nLength = sizeof saAttr;
    saAttr.bInheritHandle = TRUE; 
    saAttr.lpSecurityDescriptor = NULL;

    hChildStdoutWr = CreateFile(sTmpFileName, GENERIC_WRITE,
	FILE_SHARE_READ, &saAttr, CREATE_ALWAYS,
	bWinNT ? FILE_ATTRIBUTE_TEMPORARY :
	FILE_ATTRIBUTE_TEMPORARY | FILE_FLAG_DELETE_ON_CLOSE, 0);

    HANDLE hChildStdoutRd = CreateFile(sTmpFileName, GENERIC_READ,
	FILE_SHARE_READ|FILE_SHARE_WRITE, 0, OPEN_EXISTING, FILE_ATTRIBUTE_TEMPORARY, 0);

    BOOL bRet = hChildStdoutRd==INVALID_HANDLE_VALUE ? FALSE :
	DuplicateHandle(GetCurrentProcess(), hChildStdoutRd, GetCurrentProcess(),
	    &hChildStdoutRdDup, 0, 0, DUPLICATE_SAME_ACCESS);

    CloseHandle(hChildStdoutRd);
    return bRet;
}

HANDLE WINAPI OpenPlugin(int iOpenFrom, int)
{
    if(iOpenFrom!=OPEN_EDITOR) return INVALID_HANDLE_VALUE;


    EditorInfo ei;
    EditorControl(ECTL_GETINFO, &ei);
    *sTmpFileName = 0;
    
#define W 74

    static FarDialogItem Items[] = {
    	{ DI_DOUBLEBOX, 3, 1, W-4, 4, /*0, 0, 0, 0, ""*/ },
    	{ DI_TEXT, 5, 2, 0, 0, 0, 0, 0, 0, "Enter filtering command:" },
        { DI_EDIT, 5, 3, W-6, 3, 1, (DWORD)"ExeFilter", DIF_HISTORY, 1, "" },
	{ DI_TEXT, 3, 4, W-4, 4, 0, 0, DIF_SEPARATOR, 0, 0 },	
	{ DI_CHECKBOX, 5, 5, 0, 0, 0, 0, 0, 0, "Feed &all text to the filter" },
    };
    strcpy(Items[1].Data, GetMsg(MEnterCommand));
    strcpy(Items[4].Data, GetMsg(MFeedAllText));

    Items[0].Y2 = ei.BlockType==BTYPE_NONE ? 6 : 4;
    Items[2].Focus = 1;

    if(Dialog(-1,-1,W, ei.BlockType==BTYPE_NONE ? 8 : 6, "Contents", Items, 
	    ei.BlockType==BTYPE_NONE ? ARRLEN(Items) : ARRLEN(Items)-2 ) ==-1)
    	return INVALID_HANDLE_VALUE;

    BOOL bFeedAll = ei.BlockType==BTYPE_NONE && Items[4].Selected;

    HANDLE hChildStdinRd, hChildStdinWrDup, hChildStdoutWr, hChildStdoutRdDup, hChildStdinWr;
// Save the handles to the current std* files. 
    HANDLE hSaveStdout = GetStdHandle(STD_OUTPUT_HANDLE),
           hSaveStdin  = GetStdHandle(STD_INPUT_HANDLE),
           hSaveStderr = GetStdHandle(STD_ERROR_HANDLE);
 
    SECURITY_ATTRIBUTES saAttr; 

// Set the bInheritHandle flag so pipe handles are inherited. 
    saAttr.nLength = sizeof saAttr;
    saAttr.bInheritHandle = TRUE; 
    saAttr.lpSecurityDescriptor = NULL;


// Create a pipe for the child process's STDIN. 
    if (! CreatePipe(&hChildStdinRd, &hChildStdinWr, &saAttr, 0) ||   
// Set a read handle to the pipe to be STDIN. 
	! SetStdHandle(STD_INPUT_HANDLE, hChildStdinRd) ||
// Duplicate the write handle to the pipe so it is not inherited. 
	! DuplicateHandle(GetCurrentProcess(), hChildStdinWr, GetCurrentProcess(),
		   &hChildStdinWrDup, 0, FALSE, DUPLICATE_SAME_ACCESS)) {
	WinError(0);
	return INVALID_HANDLE_VALUE;
    } 
    CloseHandle(hChildStdinWr);

    if(/*bWinNT*/0) {
	HANDLE hChildStdoutRd;
    // Create a pipe for the child process's STDOUT. 
	if (! CreatePipe(&hChildStdoutRd, &hChildStdoutWr, &saAttr, 0) ||
    // Set a write handle to the pipe to be STDOUT. 
	    ! SetStdHandle(STD_OUTPUT_HANDLE, hChildStdoutWr) ||
    // Create noninheritable read handle and close the inheritable read handle.
	    ! DuplicateHandle(GetCurrentProcess(), hChildStdoutRd, GetCurrentProcess(),
			&hChildStdoutRdDup , 0, FALSE, DUPLICATE_SAME_ACCESS) ) {
	    WinError(0);
	    return INVALID_HANDLE_VALUE;
	}
	CloseHandle(hChildStdoutRd);
    }
    else {
	HANDLE hChildStdoutRd;
	if(! CreateTempFile(hChildStdoutWr, hChildStdoutRdDup) ||
	   ! SetStdHandle(STD_OUTPUT_HANDLE, hChildStdoutWr) )
	    WinError(0);
    }
 
    HANDLE hChildStderrRd, hChildStderrWr, hChildStderrRdDup;

// Create a pipe for the child process's STDERR.
    if (! CreatePipe(&hChildStderrRd, &hChildStderrWr, &saAttr, 1024) ||
// Set a write handle to the pipe to be STDERR.
	! SetStdHandle(STD_ERROR_HANDLE, hChildStderrWr) ||
// Create noninheritable read handle and close the inheritable read handle.
	! DuplicateHandle(GetCurrentProcess(), hChildStderrRd, GetCurrentProcess(),
		    &hChildStderrRdDup , 0, FALSE, DUPLICATE_SAME_ACCESS) ) {
	WinError(0);
	return INVALID_HANDLE_VALUE;
    }
    CloseHandle(hChildStderrRd);

// Now create the child process. 

    PROCESS_INFORMATION piProcInfo; 
    STARTUPINFO siStartInfo; 
    memset( &siStartInfo, 0, sizeof siStartInfo );
    memset( &piProcInfo, 0, sizeof piProcInfo );
    siStartInfo.cb = sizeof siStartInfo;
    BOOL bRet = CreateProcess(0, Items[2].Data, 0, 0, 1, 0, 0, 0, &siStartInfo, &piProcInfo);
 
// After process creation, restore the saved STDIN and STDOUT. 
    SetStdHandle(STD_INPUT_HANDLE, hSaveStdin); 
    SetStdHandle(STD_OUTPUT_HANDLE, hSaveStdout); 
    SetStdHandle(STD_ERROR_HANDLE, hSaveStderr);
    if (!bRet) { WinError(0); goto _clh; }
 
// Write to pipe that is the standard input for a child process.    
    DWORD dwWritten;

    DWORD iExitCode;

    if (ei.BlockType!=BTYPE_NONE || bFeedAll) {
      int iCurLine = bFeedAll ? 0 : ei.BlockStartLine;
      int iStartLine = iCurLine;

      Sleep(100); //if error, the process will stop before first WriteFile
      while (1) {
        EditorGetString egs;
        egs.StringNumber = iCurLine;
        if (!EditorControl(ECTL_GETSTRING,&egs))
          break;

	if(iStartLine!=iCurLine)
	    WriteFile(hChildStdinWrDup, "\r\n", 2, &dwWritten, 0);

        if (egs.SelStart==-1 && !bFeedAll)
          break;
        iCurLine++;
	if (egs.SelEnd==-1 || egs.SelEnd>egs.StringLength) {
          egs.SelEnd=egs.StringLength;
          if (egs.SelEnd<egs.SelStart)
            egs.SelEnd=egs.SelStart;
        }
	//Check if process not terminated prematurely
	GetExitCodeProcess(piProcInfo.hProcess, &iExitCode);
	if(bWinNT && iExitCode!=STILL_ACTIVE)
	    break;

        if(!WriteFile(hChildStdinWrDup, egs.StringText + (bFeedAll ? 0:egs.SelStart),
		bFeedAll ? egs.StringLength : egs.SelEnd-egs.SelStart, &dwWritten, 0)) {
	    WinError(0);
	    break;
        }	
      }
    }

    CloseHandle(hChildStdinWrDup); hChildStdinWrDup = 0;

    //Wait for the process to end.
    do {
        WaitForSingleObject(piProcInfo.hProcess, bWinNT ? INFINITE : 3000);
        GetExitCodeProcess(piProcInfo.hProcess, &iExitCode);
    } while(iExitCode==STILL_ACTIVE);

    if(iExitCode) {
        char buf[40];
        wsprintf(buf, GetMsg(MNonZeroRCode), iExitCode);

        DWORD dwRead;
        int nItems = 4;

	char* buferr = 0;
	if(PeekNamedPipe(hChildStderrRdDup, 0, 0, 0, &dwRead, 0) && dwRead > 0) {
	    buferr = new char[dwRead+2];
	    getline(0,0);
	    char *pline, *pbuf=buferr;
	    while(pline=getline(hChildStderrRdDup, 1)) {
		strcpy(pbuf, pline);
		pbuf+=strlen(pbuf)+1;
		nItems++;
	    }
	    *pbuf=0;
	}
#define MAXITEMS 13
	if(nItems>MAXITEMS) nItems = MAXITEMS;
	char** items=new char*[nItems];	
	if(buferr) {
	    char* p=buferr; 
	    for(int i=3; i<nItems; i++) {
		items[i] = p;
		p += strlen(p)+1;
	    }
	}

        items[0] = GetMsg(MError);
        items[1] = buf;
        items[2] = "";
//        items[3] = "Ignore"; items[4] = "Cancel";
	items[nItems-1] = GetMsg(MOK);
	if(nItems==MAXITEMS) items[nItems-2] = ". . . . . . . . .";
    	Message(FMSG_WARNING|FMSG_LEFTALIGN, GetMsg(MError), items, nItems, 1);
	delete items;
	delete buferr;
	goto _clh;
    }

// Read from pipe that is the standard output for child process.
    {
    getline(0,0); //Reset getline().

    int iCurLine = ei.BlockType==BTYPE_NONE ? ei.CurLine : ei.BlockStartLine;

    EditorGetString egs;
    EditorSetString ess;
    EditorSetPosition esp;

    SetLastError(0);
    while(1) {
	char* line = getline(hChildStdoutRdDup, /*bWinNT*/0);
	if(!line) break; // no more lines

        egs.StringNumber = ess.StringNumber = esp.CurLine = iCurLine++;
	esp.CurTabPos = esp.TopScreenLine = esp.LeftPos = esp.Overtype = -1;
	ess.StringText = line; ess.StringLength = strlen(line);
	ess.StringEOL = "";
	
	if (!EditorControl(ECTL_GETSTRING,&egs)) { //If no such string
	    // Set cursor
	    egs.StringNumber--;
	    if(!EditorControl(ECTL_GETSTRING,&egs)) {
		WinError("Internal Error: GETSTRING");
		break;
	    }
	    esp.CurLine--; esp.CurPos = egs.StringLength;
	    EditorControl(ECTL_SETPOSITION, &esp);
	    EditorControl(ECTL_INSERTSTRING, 0);	    
	    EditorControl(ECTL_SETSTRING, &ess);
	}
	else if (egs.SelStart==-1) { // if no selection
	    esp.CurPos = 0;
	    EditorControl(ECTL_SETPOSITION, &esp);
	    EditorControl(ECTL_INSERTSTRING, 0);
	    EditorControl(ECTL_SETSTRING, &ess);
	}
	else { // string contains selection
	    if(egs.SelEnd<0) egs.SelEnd = egs.StringLength;
	    //replace selection with line
	    ess.StringLength = egs.StringLength;
	    if(ess.StringLength < egs.SelEnd) ess.StringLength = egs.SelEnd;
	    ess.StringLength += strlen(line) - (egs.SelEnd-egs.SelStart);
	    ess.StringText = new char[ess.StringLength];
	    char* p = ess.StringText;

	    memcpy(p, egs.StringText, egs.SelStart);
	    if(egs.SelStart > egs.StringLength)
		memset(p+egs.StringLength,' ',egs.SelStart-egs.StringLength);
	    p+=egs.SelStart;
	    memcpy(p, line, strlen(line));
	    p+=strlen(line);
	    if(egs.StringLength > egs.SelEnd)
		memcpy(p, egs.StringText+egs.SelEnd, egs.StringLength-egs.SelEnd);

	    EditorControl(ECTL_SETSTRING, &ess);
	    delete ess.StringText;
	}
        /*if (egs.SelEnd==-1 || egs.SelEnd>egs.StringLength) {
          egs.SelEnd=egs.StringLength;
          if (egs.SelEnd<egs.SelStart)
            egs.SelEnd=egs.SelStart;
        }*/
    }
    if(GetLastError()) WinError(0);
    else {
	//Delete the rest of selected lines
	esp.CurTabPos = esp.TopScreenLine = esp.LeftPos = esp.Overtype = -1;
	esp.CurPos = 0;
	while(1) {
	    esp.CurLine = iCurLine;
	    EditorControl(ECTL_SETPOSITION, &esp);
	    egs.StringNumber = iCurLine;
	    if(!EditorControl(ECTL_GETSTRING,&egs) || egs.SelStart==-1)
		break;
	    if(egs.SelStart==0 && egs.SelEnd==-1)
		EditorControl(ECTL_DELETESTRING, 0); //don't increment iCurLine;
	    else {
		if(egs.SelStart < egs.StringLength && egs.SelStart < egs.SelEnd)
		{
		//delete selected chars in current string
		    if(egs.SelEnd==-1) egs.SelEnd = egs.StringLength;
		    if(egs.SelEnd > egs.StringLength) egs.SelEnd = egs.StringLength;
		    ess.StringNumber = -1;
		    ess.StringText = new char[egs.StringLength - (egs.SelEnd-egs.SelStart)];
		    memcpy(ess.StringText, egs.StringText, egs.SelStart);
		    memcpy(ess.StringText+egs.SelStart, egs.StringText+egs.SelEnd,
			egs.StringLength - egs.SelEnd);
		    ess.StringLength = egs.StringLength - (egs.SelEnd-egs.SelStart);
		    ess.StringEOL = egs.StringEOL;
		    EditorControl(ECTL_SETSTRING,&ess);
		    delete ess.StringText;
		}
		iCurLine++;
	    }	    
	}
    }
    esp.CurLine = ei.BlockStartLine;
    esp.CurPos = 0;
    esp.CurTabPos = -1;
    esp.TopScreenLine = ei.TopScreenLine;
    esp.LeftPos = ei.LeftPos;
    esp.Overtype = -1;
    EditorControl(ECTL_SETPOSITION, &esp);
    EditorSelect es;
    es.BlockType = BTYPE_NONE;
    EditorControl(ECTL_SELECT,  &es);
    }

 _clh:
    CloseHandle(piProcInfo.hThread);
    CloseHandle(piProcInfo.hProcess);
    CloseHandle(hChildStdinWrDup);
    CloseHandle(hChildStdoutRdDup);
    CloseHandle(hChildStderrRdDup);
    CloseHandle(hChildStdinRd);
    CloseHandle(hChildStdoutWr);
    CloseHandle(hChildStderrWr);
    if(bWinNT) DeleteFile(sTmpFileName);
 
    return INVALID_HANDLE_VALUE;
}

void WINAPI GetPluginInfo(PluginInfo *Info)
{
static char* menu = GetMsg(MExternalFilter);
  Info->StructSize = sizeof *Info;
  Info->PluginMenuStrings = &menu;
  Info->PluginMenuStringsNumber = 1;
  Info->Flags = PF_DISABLEPANELS|PF_EDITOR;
}
