HKEY CreateRegKey(HKEY hRoot,char *Key);

void SetRegKey(HKEY hRoot,char *Key,char *ValueName,DWORD ValueData)
{
  HKEY hKey=CreateRegKey(hRoot,Key);
  RegSetValueEx(hKey,ValueName,0,REG_DWORD,(BYTE *)&ValueData,sizeof(ValueData));
  RegCloseKey(hKey);
}


void SetRegKey(HKEY hRoot,char *Key,char *ValueName,char *ValueData)
{
  HKEY hKey=CreateRegKey(hRoot,Key);
  RegSetValueEx(hKey,ValueName,0,REG_SZ,(CONST BYTE *)ValueData,strlen(ValueData)+1);
  RegCloseKey(hKey);
}


int GetRegKey(HKEY hRoot,char *Key,char *ValueName,int &ValueData,DWORD Default)
{
  HKEY hKey=OpenRegKey(hRoot,Key);
  DWORD Type,Size=sizeof(ValueData);
  int ExitCode=RegQueryValueEx(hKey,ValueName,0,&Type,(BYTE *)&ValueData,&Size);
  RegCloseKey(hKey);
  if (hKey==NULL || ExitCode!=ERROR_SUCCESS)
  {
    ValueData=Default;
    return(FALSE);
  }
  return(TRUE);
}


int GetRegKey(HKEY hRoot,char *Key,char *ValueName,DWORD Default)
{
  int ValueData;
  GetRegKey(hRoot,Key,ValueName,ValueData,Default);
  return(ValueData);
}


int GetRegKey(HKEY hRoot,char *Key,char *ValueName,char *ValueData,char *Default,DWORD DataSize)
{
  HKEY hKey=OpenRegKey(hRoot,Key);
  DWORD Type;
  int ExitCode=RegQueryValueEx(hKey,ValueName,0,&Type,(LPBYTE)ValueData,&DataSize);
  RegCloseKey(hKey);
  if (hKey==NULL || ExitCode!=ERROR_SUCCESS)
  {
    strcpy(ValueData,Default);
    return(FALSE);
  }
  return(TRUE);
}

int GetRegKey(HKEY hRoot,char *Key,char *ValueName,char *ValueData,char *Default,DWORD DataSize, char *Path )
{
  HKEY hKey=OpenRegKey(hRoot,Key,Path);
  DWORD Type;
  int ExitCode=RegQueryValueEx(hKey,ValueName,0,&Type,(LPBYTE)ValueData,&DataSize);
  RegCloseKey(hKey);
  if (hKey==NULL || ExitCode!=ERROR_SUCCESS)
  {
    strcpy(ValueData,Default);
    return(FALSE);
  }
  return(TRUE);
}

int GetRegKey(HKEY hRoot,char *Key,char *ValueName,int &ValueData, DWORD Default, char *Path )
{
  HKEY hKey=OpenRegKey(hRoot,Key,Path);
  DWORD Type, Size=sizeof(ValueData);
  int ExitCode=RegQueryValueEx(hKey,ValueName,0,&Type,(BYTE *)&ValueData,&Size);
  RegCloseKey(hKey);
  if (hKey==NULL || ExitCode!=ERROR_SUCCESS)
  {
    ValueData=Default;
    return(FALSE);
  }
  return(TRUE);
}

HKEY CreateRegKey(HKEY hRoot,char *Key)
{
  HKEY hKey;
  DWORD Disposition;
  char FullKeyName[512];
  strcpy(FullKeyName,PluginRootKey);
  if (*Key)
  {
    strcat(FullKeyName,"\\");
    strcat(FullKeyName,Key);
  }
  RegCreateKeyEx(hRoot,FullKeyName,0,NULL,0,KEY_WRITE,NULL,
                 &hKey,&Disposition);
  return(hKey);
}


HKEY OpenRegKey(HKEY hRoot,char *Key)
{
  HKEY hKey;
  char FullKeyName[512];
  strcpy(FullKeyName,PluginRootKey);
  if (*Key)
  {
    strcat(FullKeyName,"\\");
    strcat(FullKeyName,Key);
  }
  if (RegOpenKeyEx(hRoot,FullKeyName,0,KEY_QUERY_VALUE,&hKey)!=ERROR_SUCCESS)
    return(NULL);
  return(hKey);
}

HKEY OpenRegKey(HKEY hRoot,char *Key,char *Path )
{
  HKEY hKey;
  char FullKeyName[512];
  strcpy(FullKeyName,Path);
  if (*Key)
  {
    strcat(FullKeyName,"\\");
    strcat(FullKeyName,Key);
  }
  if (RegOpenKeyEx(hRoot,FullKeyName,0,KEY_QUERY_VALUE,&hKey)!=ERROR_SUCCESS)
    return(NULL);
  return(hKey);
}

//*AV 15.12.99*******************************************************
//  ⠭ ⥩  ஥
//**************************************************************
void SetPathsToRegKeys( const struct PluginStartupInfo *ExtSearchInfo ){
  char *EndRootKey = (char *)strstr( ExtSearchInfo->RootKey, "\\Plugins" );

  if( EndRootKey ){
     int LenEndRootKey = EndRootKey - ExtSearchInfo->RootKey;

     *SearchTextRootKey = '\0';
     strncpy( SearchTextRootKey, ExtSearchInfo->RootKey, LenEndRootKey );
     *(SearchTextRootKey + LenEndRootKey) = '\0';
     strcat( SearchTextRootKey, "\\SavedDialogHistory\\SearchText");

     *ReplaceTextRootKey = '\0';
     strncpy( ReplaceTextRootKey, ExtSearchInfo->RootKey, LenEndRootKey );
     *(ReplaceTextRootKey + LenEndRootKey) = '\0';
     strcat( ReplaceTextRootKey, "\\SavedDialogHistory\\ReplaceText");

     *MaskTextRootKey = '\0';
     strncpy( MaskTextRootKey, ExtSearchInfo->RootKey, LenEndRootKey );
     *(MaskTextRootKey + LenEndRootKey) = '\0';
     strcat( MaskTextRootKey, "\\SavedDialogHistory\\Masks");

     *DelimsTextRootKey = '\0';
     strncpy( DelimsTextRootKey, ExtSearchInfo->RootKey, LenEndRootKey );     
     *(DelimsTextRootKey + LenEndRootKey) = '\0';
     strcat( DelimsTextRootKey, "\\SavedDialogHistory\\DelimsText");
  }

  *ColorerPluginRootKey = '\0';
  strcpy( ColorerPluginRootKey, ExtSearchInfo->RootKey );
  strcat( ColorerPluginRootKey, "\\Colorer" );

  *PluginRootKey = '\0';
  strcpy( PluginRootKey, ExtSearchInfo->RootKey);
  strcat( PluginRootKey, "\\ExtSearch");
}
