#include "math.h"

const char *GetMsg( int MsgId )
{
  return ExtSearchInfo.GetMsg(ExtSearchInfo.ModuleNumber,MsgId);
}


void InitDialogItems(struct InitDialogItem *Init,struct FarDialogItem *Item,
                    int ItemsNumber )
{
InitDialogItems( Init, Item, ItemsNumber, -1, -1 );
}

void InitDialogItems(struct InitDialogItem *Init,struct FarDialogItem *Item,
                    int ItemsNumber, int UpSetRegExp, int Type )
{
  int J;
  for (int I=0;I<ItemsNumber;I++)
  {
    if( UpSetRegExp > 0 ){
       switch( Type ){
          case ReplaceTypeDialog:{
             switch( I ){
                case NRI_CaseSensitive:
                case NRI_ReverseSearch:
                case NRI_WordSearch:
                   J = I + CHECKBOX_MOVE_DN; //  
                break;
                case NRI_SetRegExp:
                   J = I - CHECKBOX_MOVE_UP; //  
                break;
                default: J = I;
             }
          }break;  

          case SearchTypeDialog:{
             switch( I ){
                case NDI_CaseSensitive:
                case NDI_ReverseSearch:
                case NDI_WordSearch:
                   J = I + CHECKBOX_MOVE_DN; //  
                break;
                case NDI_SetRegExp:
                   J = I - CHECKBOX_MOVE_UP; //  
                break;
                default: J = I;
             }
          }break;

          case SearchInFileTypeDialog:{
             switch( I ){
                case NFI_CaseSensitive:
                case NFI_WordSearch:
                   J = I + CHECKBOX_MOVE_DN; //  
                break;
                case NFI_SetRegExp:
                   J = I - CHECKBOX_MOVE_UP + 1; //  
                break;
                default: J = I;
             }
          }break;

          case ReplaceInFileTypeDialog:{
             switch( I ){
                case NRFI_CaseSensitive:
                case NRFI_WordSearch:
                   J = I + CHECKBOX_MOVE_DN; //  
                break;
                case NRFI_SetRegExp:
                   J = I - CHECKBOX_MOVE_UP + 1; //  
                break;
                default: J = I;
             }
          }break;

       }  
    }
    else J = I;

    Item[J].Type=Init[I].Type;

    if( UpSetRegExp ){//६頥 
       Item[J].X1=Init[J].X1;
       Item[J].Y1=Init[J].Y1;
       Item[J].X2=Init[J].X2;
       Item[J].Y2=Init[J].Y2;
    }
    else{
       Item[J].X1=Init[I].X1;
       Item[J].Y1=Init[I].Y1;
       Item[J].X2=Init[I].X2;
       Item[J].Y2=Init[I].Y2;
    }

    Item[J].Focus=Init[I].Focus;
    Item[J].Selected=Init[I].Selected;
    Item[J].Flags=Init[I].Flags;
    Item[J].DefaultButton=Init[I].DefaultButton;
    if ((unsigned int)Init[I].Data<2000)
      strcpy(Item[J].Data,GetMsg((unsigned int)Init[I].Data));
    else
      strcpy(Item[J].Data,Init[I].Data);
  }
}

//। ᨬ    (⭮  ⭮ ᫮ ᨬ '\' ।  )
static int ThisSymbol( char *beg, char *cur ){
   int num = 0;
   while( --cur > beg ){
      if( *cur == '\\' ) num++;
      else break;
   }
   if( num%2 )
      return 1;//⭮ - ᨬ
   else       
      return 0;//⭮ - 
}

LISTSEL *GetListSel( int ID, LISTSEL **lastsel, LISTSEL *cursel ){

   if( cursel && cursel->ID != ID ){
      if( !*lastsel ) *lastsel = cursel;

      LISTSEL *cur = *lastsel;

      if( cur )
         do{
            if( cur->ID == ID )
               return cur;
            cur = cur->prev;
         }while( cur );

      return NULL;   
   }
   return cursel;
}

LISTSEL *AddToListSel( int ID, LISTSEL **lastsel ){
   LISTSEL *newelem = new LISTSEL;

   memset( newelem, 0, sizeof(LISTSEL) );
   newelem->ID = ID;
   //ExtTestMessage( "ID", ID );
   //newelem->ProcSaveSelectForRestore = 0;
   //newelem->ProcResetSelect = 0; 

   if( *lastsel ){
      newelem->prev = *lastsel;
      (*lastsel)->post = newelem;
   }
   else
      newelem->prev = NULL;

   newelem->post = NULL;
   *lastsel = newelem;
   return newelem;
}


void InitListSel( int ID, LISTSEL **lastsel, LISTSEL **cursel ){
   *cursel = GetListSel( ID, lastsel, *cursel );
   if( !*cursel ){
      *cursel = AddToListSel( ID, lastsel );
      //if( *cursel ) ExtTestMessage("Done AddToListSel");
   }
}

void DelFromListSel( int ID, LISTSEL **last, LISTSEL **cur ){
   LISTSEL *item = *last;
   if( item )
      do{
         if( item->ID == ID ){
            // ᫥,   ⢥
            if( !item->post && item->prev ){
               *last = item->prev; 
               (*last)->post = NULL;

            }
            // ⢥ 
            else if( !item->post && !item->prev )
               *last = NULL;            
            // ,   ⢥ 
            else if( item->post && !item->prev ){
               item->post->prev = NULL;
            }
            //   ।
            else{
               item->post->prev = item->prev;
               item->prev->post = item->post;
            }
            *cur  = NULL;
            delete item;
            break;
         }
         item = item->prev;
      }while( item );
}

void DelAllItemsListSel( LISTSEL **last, LISTSEL **cursel ){
   LISTSEL *cur, *next;
   cur = *last;
   if( cur )
      do{
         next = cur->prev;
         delete cur;
         cur = next;
      }while( next );

   *cursel = NULL;
   *last   = NULL;
}

int GetProcSaveSelectForRestore( int ID, LISTSEL **lastsel, LISTSEL **cursel ){
   if( *cursel ){
      if( ID == (*cursel)->ID )
         return (*cursel)->ProcSaveSelectForRestore;
      else{
         if( (*cursel = GetListSel( ID, lastsel, *cursel )) != NULL )         
            return (*cursel)->ProcSaveSelectForRestore;
         else{
            *cursel = AddToListSel( ID, lastsel );
            return (*cursel)->ProcSaveSelectForRestore;
         }
      }
   }
   else
      return 0;
}

int GetProcResetSelect( int ID, LISTSEL **lastsel, LISTSEL **cursel ){
   if( *cursel ){
      if( ID == (*cursel)->ID )
         return (*cursel)->ProcResetSelect;
      else{
         if( (*cursel = GetListSel( ID, lastsel, *cursel )) != NULL )
            return (*cursel)->ProcResetSelect;
         else{
            *cursel = AddToListSel( ID, lastsel );
            return (*cursel)->ProcResetSelect;
         }
      }
   }
   else
      return 0;
}

bool CheckForEsc( void )
{
  int ExitCode=false;
  while (1)
  {
    INPUT_RECORD rec;
    static HANDLE hConInp=GetStdHandle(STD_INPUT_HANDLE);
    DWORD ReadCount;
    PeekConsoleInput(hConInp,&rec,1,&ReadCount);
    if (ReadCount==0)
      break;
    ReadConsoleInput(hConInp,&rec,1,&ReadCount);
    if (rec.EventType==KEY_EVENT)
      if (rec.Event.KeyEvent.wVirtualKeyCode==VK_ESCAPE)
        ExitCode=true;
  }
  return(ExitCode);
}

void ExtTestMessage( char *MessStr ){
 const const char *MsgItems[]={"TestMessage",MessStr,GetMsg(MOk)};
 ExtSearchInfo.Message(ExtSearchInfo.ModuleNumber,FMSG_WARNING,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
}

void ExtTestMessage( char *MessStr, int Num ){
 char StrNum[20];
 const const char *MsgItems[]={"TestMessage",itoa( Num, StrNum, 10),MessStr,GetMsg(MOk)};
 ExtSearchInfo.Message(ExtSearchInfo.ModuleNumber,FMSG_WARNING,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
}

void ExtTestMessage( char *MessStr, int Num, int NumButtons ){
 char StrNum[20];
 const const char *MsgItems[]={"TestMessage",itoa( Num, StrNum, 10),MessStr};
 ExtSearchInfo.Message(ExtSearchInfo.ModuleNumber,FMSG_WARNING,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),NumButtons);
}



//஢ઠ  ᨬ-ࠧ⥫
static CheckDelSymbol( ExtSearchReg *esr, char Symbol ){
   int stat = 1;
   char StrSymb[2] = { Symbol, '\0' };
   //⨬ ᨬ  OEM
   ConvertToOEM( esr, StrSymb, 1 );
   Symbol = StrSymb[0];

   //᫨  -ᨬ  室  祭 ᨬ ப
   if( (strchr( esr->SymbWord1Str, Symbol )  || strchr( esr->SymbWord2Str, Symbol )) )
      stat = 0;                  

   return stat;
}

//墠뢠 楫 ᫮  ⥪饩 樨  ।
static void GetCurWord( ExtSearchReg *esr, char *CurWord, char *StringText, int StringLength, int CurPos, int *BegPos ){

   if( StringLength > CurPos ){
     char *CurText = StringText + CurPos;
  
     if( *CurText && *CurText != ' ' && *CurText != '\n' && *CurText != '\t' && *CurText != '\r' ){
  
        char *EndWord = CurText;
        while( *EndWord && !CheckDelSymbol( esr, *EndWord) ) EndWord++;
     
        char *BegWord = CurText;
        while( *BegWord && (BegWord-StringText) >= 0 && !CheckDelSymbol( esr, *BegWord) ) BegWord--;
        if( BegWord != CurText ) BegWord++;
     
        if( *BegWord != '\0' ){
           if( (EndWord-BegWord) < LenCurWord ){
              strncpy( CurWord, BegWord, (EndWord-BegWord) );
              *(CurWord+(EndWord-BegWord)) = '\0';
           } 
           else{
              strncpy( CurWord, BegWord, LenCurWord-1 );
              *(CurWord+(LenCurWord-1)) = '\0'; 
           }

           if( BegPos ) *BegPos = BegWord - StringText;//AV 02.12.99

           ConvertToOEM( esr, CurWord, LenCurWord );
        }
     }
   }
}

//஢ઠ  ,   ᮪ ⥪ - ⤥쭮 ᫮
static int CheckWord( ExtSearchReg *esr, char *StringText, int CurPos ){

     char *CurText = StringText + CurPos; 

     /*஢塞 ᨬ ࠢ  ᪠ ⥪*/
     int stat;

     if( *(CurText + strlen(esr->SearchStr)) )
        stat = CheckDelSymbol( esr, *(CurText + strlen(esr->SearchStr)) );
     else stat = 1;// ப - ⮦ ࠧ⥫
     
     /*஢塞 ᨬ ᫥  ᪠ ⥪*/
     if( stat ){
         if( CurPos != 0 )
            stat = CheckDelSymbol( esr, *(CurText-1) );
         else stat = 1;//砫 ப - ⮦ ࠧ⥫
     }
     
     return stat;
}

//窠 ⥪  䠩  esr->StringBuff
static bool File2StringBuff( ExtSearchReg *_esr, char *FilePath, char **Buff, unsigned long *len )
{
   int CurHandle;
   bool stat;
   int mode = _esr->IsFilePrj ? O_RDONLY : O_RDONLY | O_BINARY;

   if( (CurHandle = open( FilePath, mode )) >= 0 ){

      *len = filelength( CurHandle );

      if( *len > 0 &&           
            (*Buff == NULL && (*Buff = (char*)malloc( *len + 1 )) != NULL) ||
            (*Buff != NULL && (*Buff = (char*)realloc( *Buff, *len + 1 )) != NULL)
        ){      
       
         if( _esr->Replace ){

           if( (_esr->ReplaceFileBuff = (char*)malloc( *len + 1 )) != NULL &&
               (_esr->TmpReplaceStr   = (char*)realloc( _esr->TmpReplaceStr, *len ) ) != NULL
             ) stat = true;
           else
               stat = false;
         }
         else
            stat = true;      
      }
      else
         stat = false;

      if( stat == true && read( CurHandle, (void*)(*Buff), *len ) != *len )
         stat = false;
      else{
         if( stat == true ){ 
            *(*Buff + *len) = '\0';
            if( _esr->Replace ) memcpy( _esr->ReplaceFileBuff, *Buff, *len );
         }
      }
 
      if( close( CurHandle ) ) stat = false; 

   }else
      stat = false;

   return stat;
}


// ࠭  䠩
inline bool StringBuff2File( ExtSearchReg *_esr ){

   int CurHandle;
   bool stat;

   //뢠  ६ 塞 䠩
   if( (CurHandle = open( _esr->FilePath, O_TRUNC | O_WRONLY | O_BINARY )) >= 0 ){

         if( _esr->LastFileCurPos < _esr->LenCurStr ){//᪮㥬 ᫨ 㦭 ⮪
            int LenRest = _esr->LenCurStr - _esr->LastFileCurPos; // ⪠

            _esr->LenReplaceFileBuff += LenRest;

            if( _esr->LenReplaceFileBuff > _esr->LenCurStr )
               _esr->TmpReplaceStr = (char*)realloc( _esr->TmpReplaceStr, _esr->LenReplaceFileBuff );

            memcpy( _esr->TmpReplaceStr + (_esr->LenReplaceFileBuff-LenRest), _esr->ReplaceFileBuff + _esr->LastFileCurPos, LenRest );
         }

         if( write( CurHandle, (void*)_esr->TmpReplaceStr, _esr->LenReplaceFileBuff ) != _esr->LenReplaceFileBuff )
            stat = false;

      if( close( CurHandle ) ) stat = false; 

   }else
      stat = false;

   return stat;
}

static void SetEditorPosition( ExtSearchReg *esr, int CurLine, int CurPos, int NoCenter, int NoPos, int Reverse ){
   struct EditorSetPosition esp;

   esp.CurLine   = CurLine;
   esp.CurPos    = CurPos;
   esp.CurTabPos = -1;   
   esp.Overtype  = -1;
   esp.LeftPos   = -1;
   esp.TopScreenLine = -1;

   if( !NoPos ){
      // 祭  業஢     室  । ࠭  Y
      int CenterY;
      //祭  業஢  室  । ࠭  X
      int CenterX;
      //ਧ 室  । ࠭
      int OutScreen;
      //⥪  ⭮⥫쭮  ࠭
      int LocCurLine;

      int UpY = (int)floor(esr->ei.WindowSizeY/4.);             /*  ࠭*/
      int DnY = (int)floor( esr->ei.WindowSizeY/4.*3.+ 0.5);    /*  ࠭, 㣫塞   ஭*/
  
      if( Reverse ) CenterY = CurLine - UpY;
      else{         
         CenterY = CurLine - DnY;
         if( NoCenter && CenterY < 0 ) CenterY = CurLine - UpY;// ࢮ ࠭
      }
      if( CenterY < 0 ) CenterY = 0;

      CenterX    = CurPos - (int)(esr->ei.WindowSizeX/2);
      if( CenterX < 0 ) CenterX = 0;

      LocCurLine = CurLine - esr->ei.TopScreenLine;

      if( LocCurLine < 0 || LocCurLine >= esr->ei.WindowSizeY )
         OutScreen = 1;
      else
         OutScreen = 0;

      //ExtTestMessage( "NoCenter", NoCenter );

      //㡥६  業 (⮡ ᠣ  뢠  ⥪)
      if( (NoCenter && LocCurLine >= UpY && LocCurLine <= DnY) || OutScreen  )    
         esp.TopScreenLine = CenterY;                                                                               
      else 
         esp.TopScreenLine = esr->ei.TopScreenLine;

      //AV 15.12.99 諨  ࠭ ࠭  X
      if( (CurPos + esr->LenStrSearchTmp) >= (esr->ei.LeftPos + esr->ei.WindowSizeX) || CurPos < esr->ei.LeftPos )
            esp.LeftPos = CenterX;//AV 15.12.99
   }
   //
   ExtSearchInfo.EditorControl( ECTL_SETPOSITION, (void*)&esp );

}
