//-------------------------------------------------------------------------------------------
//
//  ExtSearch - plugin for FAR (c) Azartsov V.V. 1999-2002
//
//-------------------------------------------------------------------------------------------
#include "ExtSearch.hpp" 

#include "ExtChCase.cpp" //AV 16.11.99

#include "ExtSearchMix.cpp"
#include "ExtSearchReg.cpp"
#include "ExtMenu.cpp" //AV 09.11.99
#include "ExtRegExp.cpp"    
                                                             
#include "ExtClipBoard.cpp" //

#include "sys/stat.h"

#define BEGSIZE_SEARCH_RES 1024 /*砫쭮 ⢮  ⮢  ᪥  䠩*/
#define LEVEL_PROCSENDKEY 25     /*ன - 뫠   ᮮ饭  ᮢ  ᪠  䠩*/

//#include "ExtLstRegExp.cpp"
#define DefBkGrSelect 12 /*梥 䮭 뤥  㬮砭*/
#define DefClrSelect  0  /*梥 ⥪ 뤥  㬮砭*/

#define DefNumTemplFileName 3 /* 蠡   䠩  蠡 室  訡  㬮砭*/
#define DefNumTemplNumStr   4 /* 蠡  ஬ ப   蠡 室  訡  㬮砭*/

#define BottomSearchDialog        17 /*   ᪠  ।*/
#define BottomSearchInFileDialog  19 /*   ᪠  䠩*/
#define BottomReplaceDialog       19 /*   */
#define BottomReplaceInFileDialog 21 /*     䠩*/
#define BottomCfgDialog           27 /*   䨣樨*/
#define BottomChoiceReplaceDialog 10 /*   롮 ਠ */

#define DefSizeX       77 /*ਭ    㬮砭*/
#define DefCfgSizeX    77 /*ਭ   䨣樨  㬮砭*/
#define BeforeLeft     12 /*ﭨ  묨 ࠭栬     ।*/
#define WidthUnderSide 3  /*⮫騭 㯠饩  -  */
#define WidthUnder     2  /*⮫騭 㯠饩  - ᢥ, ᭨*/

//AV 03.11.99 ⮯  help-䠩
static char Help_ExtSearch[]  = "ExtSearch";   //७ 
static char Help_ExtReplace[] = "ExtReplace";  //७   
static char Help_ExtConfig[]  = "ExtConfig";   //䨣 㣨

// ਩  ।㥬 
static char ExtHistoryName[]        = "ExtSearchText";
static char HistoryName[]           = "SearchText";      
static char ExtReplaceHistoryName[] = "ExtReplaceText";
static char ReplaceHistoryName[]    = "ReplaceText";      
static char ExtMaskHistoryName[]    = "ExtMasks";
static char MaskHistoryName[]       = "Masks";      
static char ExtWord1HistoryName[]   = "ExtWord1Text";             
static char ExtWord2HistoryName[]   = "ExtWord2Text";             
static char ExtTemplateHistoryName[]= "ExtTemplateGoToError";
static char ExtPathRootPrjHistoryName[]="ExtPathRootPrj";

static char DefWord1Str[] = "0123456789_ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"; //ᨬ ᫮(⨭) -㬮砭
static char DefWord2Str[] = "񦧨"; //ᨬ ᫮(ਫ) -㬮砭 -㬮砭
static char DefTemplate[] = "/(Warning)|(Error)\\s+?(\\S+?)\\s+?(\\d+?):/"; //蠡  室  訡 -  㬮砭
static char DefTemplate2[] = "/^(\\*\\*\\*\\*\\*)|(\\+\\+\\+\\+\\+)|(\\-\\-\\-\\-\\-)\\s+?(\\S+?)\\s+?(\\d+)/"; //蠡  室  १⮢ ࠢ -  㬮砭


/*static DWORD ESEARCH_RUN_PlatformID = VER_PLATFORM_WIN32_NT;*/

//祭 ப ࠧ⥫  ஥
static void GetWordStr( char *Buff1, char *Buff2, char *Buff3, char *Buff4 ){
  char TmpWordStr[LenSearchStr];
  GetRegKey(HKEY_CURRENT_USER,"","Word1Str", TmpWordStr, DefWord1Str, LenSearchStr);
  if( Buff1 ) strcpy( Buff1, TmpWordStr );   
  GetRegKey(HKEY_CURRENT_USER,"","Word2Str", TmpWordStr, DefWord2Str, LenSearchStr);
  if( Buff2 ) strcpy( Buff2, TmpWordStr );   
  //砥 蠡  室  訡
  char TmpTemplate[LenSearchStr];
  GetRegKey(HKEY_CURRENT_USER,"","TemplateGoToError", TmpTemplate, DefTemplate, LenSearchStr );
  if( Buff3 ) strcpy( Buff3, TmpTemplate );   

  char PathRootPrj[LenSearchStr];
  GetRegKey(HKEY_CURRENT_USER,"","PathRootPrj", PathRootPrj, ".\\", LenSearchStr );
  if( Buff4 ) strcpy( Buff4, PathRootPrj );   

} 

static void SetWordStr( char *Buff1, char *Buff2, char *Buff3, char *Buff4 ){
  if( Buff1 ) SetRegKey(HKEY_CURRENT_USER,"","Word1Str", Buff1    );
  if( Buff2 ) SetRegKey(HKEY_CURRENT_USER,"","Word2Str", Buff2    );
  if( Buff3 ) SetRegKey(HKEY_CURRENT_USER,"","TemplateGoToError", Buff3 );
  if( Buff4 ) SetRegKey(HKEY_CURRENT_USER,"","PathRootPrj", Buff4 );
}

//  ⠡ ᨬ - Windows Russian
//   
static void SetWinRusTable( ExtSearchReg *_esr ){
 char StrAnalise[] = " ,   ";
 int NumTable = ExtSearchInfo.CharTable( FCT_DETECT, StrAnalise, strlen(StrAnalise) );
 if( NumTable != -1 ){
    if( !ExtSearchInfo.CharTable( NumTable, (char*)&_esr->WinRusTable, sizeof(_esr->WinRusTable) ) ){            
       _esr->ExistWinRusTable = 1;
       _esr->NumWinRusTable   = NumTable;
    }
 }
}

//樠樨  室  
static ExtSearchReg *BegInitExtSearchReg( ExtSearchReg *ptr_esr, int OpenFrom, int Item )
{

   ExtSearchReg *_esr;

   if( OpenFrom != OPEN_EDITOR || Item == MP_NUM_GOTO_ERROR_INEDIT || Item == MP_NUM_DEL_EQSTR_INEDIT )
   {
      _esr = (ExtSearchReg*)malloc( sizeof(ExtSearchReg) ); 
      memset( _esr, 0, sizeof(ExtSearchReg) );
      _esr->retest     = new CRegExp;      
      _esr->retest_end = new CRegExp;      
   }
   else
      _esr = ptr_esr;

   if( _esr != NULL )
   {
      _esr->AllProc = 0;
      _esr->NumFindForReplace = 0;
      _esr->NumCount = 0;
      _esr->Position = 0;
      _esr->VirtualSymbols = 0;
      _esr->bKeyDownAfterSelect = 0;
      _esr->SelectFAR = 1;

      _esr->cts   = NULL;
      _esr->MaxNumTable = -1;
      _esr->NoDialog = 0;
      _esr->ExistWinRusTable = 0;
      _esr->NumWinRusTable = -1;

      GetWordStr( _esr->SymbWord1Str, _esr->SymbWord2Str, _esr->TemplateGoToError, _esr->PathRootPrj );//砥 ப ᨬ 室  ᫮

      if( OpenFrom == OPEN_EDITOR ) //\  ..  । FAR
      {
         _esr->SearchInFile = 0;
         ExtSearchInfo.EditorControl( ECTL_GETINFO, &_esr->ei );
         //   ଠ樥  ⥪饩 ஢
         ExtSearchInfo.CharTable( _esr->ei.TableNum, (char*)&_esr->CurTable, sizeof( _esr->CurTable ) );

         //AV 25.02.00 ⥯     dll  室 樠樨  ࠡ  regexp
         int retcode = ConnectToColorerDLL();
         if( !retcode )         SetConnectToColorerDLL =    1;  // 
         else if( retcode < 0 ) SetConnectToColorerDLL =   -1;  //colorer.dll ,  ᠬ colorer 몫祭

      }else{ //\  䠩   FAR
         _esr->SearchInFile = 1;
         struct CharTableSet tmp_table;            
         //塞 ᨢ  ⠡

         //।⥫쭮 ᬮਬ ᪮쪮  ᥣ
         for( int i = 0; ExtSearchInfo.CharTable( i, (char*)&tmp_table, sizeof(struct CharTableSet) ) >= 0; i ++ )
            _esr->MaxNumTable = i;

         _esr->cts = (struct CharTableSet *)malloc( sizeof(struct CharTableSet) * (_esr->MaxNumTable+1) );

         //塞
         for( int i = 0; i <= _esr->MaxNumTable;  i ++ )
         {
            if( ExtSearchInfo.CharTable( i, (char*)&tmp_table, sizeof(struct CharTableSet) ) < 0 )
               break;
            else
               memcpy( _esr->cts+i, &tmp_table, sizeof(struct CharTableSet) ); 
         }

         _esr->FileCurPos   = 0;
         _esr->ChangeBegStr = 0;
      }
   }
   return _esr;
}

//⠭ ⢨  襭 ࠡ 
static void ExitFromPlugin( ExtSearchReg *_esr, int Item )
{
   if( _esr->StringBuff       ){ free(  _esr->StringBuff  );  _esr->StringBuff = NULL; } 
   if( _esr->RXConvertReplace ){ free(  _esr->RXConvertReplace ); _esr->RXConvertReplace = NULL; }
   if( _esr->FindStr          ){ free(  _esr->FindStr );          _esr->FindStr = NULL; }

   //   ஬ ᯥ ० 
   if( Item != MP_NUM_GOTO_ERROR_INEDIT && Item != MP_NUM_DEL_EQSTR_INEDIT )
   {
      if( Sel.FindStr           ) { free(  Sel.FindStr );           Sel.FindStr = NULL; } 
   }

   //⮫쪮 ᫥ ᪠    䠩!
   //   ᯥ ० ࠡ
   if( Item >= MP_NUM_SEARCH_INFILES || Item == MP_NUM_GOTO_ERROR_INEDIT || Item == MP_NUM_DEL_EQSTR_INEDIT  )
   { 
      if( _esr ){
         if( _esr->cts ) { free( _esr->cts ); _esr->cts = NULL; } 
         if( _esr->ReplaceFileBuff  ){ free( _esr->ReplaceFileBuff  ); _esr->ReplaceFileBuff = NULL; } 

         if( _esr->TmpReplaceStr ) { free(  _esr->TmpReplaceStr ); _esr->TmpReplaceStr = NULL; }
         if( _esr->_mi ) { free(  _esr->_mi ); _esr->_mi = NULL; }
         if( _esr->_fi ) { free(  _esr->_fi ); _esr->_fi = NULL; }
         if( _esr->SelItems ) { free( _esr->SelItems ); _esr->SelItems = NULL; };

         delete _esr->retest;
         delete _esr->retest_end;

         free( _esr ); 
      }
   }
}               

//᪮஢ ப  Windows Russia
void ConvertToWinRus( char *str, unsigned long len ){
   //᫨ ⠡ Windows Russia   Far  ⥪ ஢  WinRus, ४㥬  WinRus
   if( esr->ExistWinRusTable && esr->NumWinRusTable != esr->ei.TableNum )
      while( --len > 0 ) *str++ = esr->WinRusTable.EncodeTable[*str];
}

//᪮஢ ப(Windows Russia)  
void ConvertFromWinRus( char *str, unsigned long len ){
   //᫨ ⠡ Windows Russia   Far ४㥬  OEM
   if( esr->ExistWinRusTable )
      while( --len > 0 ) *str++ = esr->WinRusTable.DecodeTable[*str];
}

void ConvertToOEM( ExtSearchReg *esr, char *str, unsigned long len ){
  if( !esr->SearchInFile ){
     EditorConvertText ect;
     ect.Text       = str;
     ect.TextLength = strlen(str);
     //
     ExtSearchInfo.EditorControl( ECTL_EDITORTOOEM, &ect );
  }
  else if( esr->CodeTableSearchInFile >= 0 && esr->cts ){
     struct CharTableSet *cts = (esr->cts+esr->CodeTableSearchInFile);
     while( --len > 0 ) *str++ = cts->DecodeTable[*str];      

  }/*else if( esr->CodeTableSearchInFile == -2 ){
    WideCharToMultiByte(
       CP_OEMCP, // code page 
       0,
       str,
       -1,
       str,
       sizeof(str),
       NULL, NULL 
    );
  }*/ 
}
     
void ConvertFromOEM( ExtSearchReg *esr, char *str ){
  if( !esr->SearchInFile ){
     EditorConvertText ect;
     ect.Text       = str;
     ect.TextLength = strlen(str);
     //
     ExtSearchInfo.EditorControl( ECTL_OEMTOEDITOR, &ect );
  }
  else{   
     if( esr->CodeTableSearchInFile >= 0 && esr->cts ){
        struct CharTableSet *cts = (esr->cts+esr->CodeTableSearchInFile);
        while( *str ) *str++ = cts->EncodeTable[*str]; 
     }
  }
}

void ConvertFromOEM( ExtSearchReg *esr, char *str, unsigned long len ){
  if( !esr->SearchInFile ){
     EditorConvertText ect;
     ect.Text       = str;
     ect.TextLength = strlen(str);
     //
     ExtSearchInfo.EditorControl( ECTL_OEMTOEDITOR, &ect );
  }
  else{   
     if( esr->CodeTableSearchInFile >= 0 && esr->cts ){
        struct CharTableSet *cts = (esr->cts+esr->CodeTableSearchInFile);
        while( *str && len-- > 0 ) *str++ = cts->EncodeTable[*str]; 
     }
  }
}

static void GetInfoSelection( ExtSearchReg *esr, int BlockStartLine, int *EndLine, int *EndPos, int *BegPos, int *Width, int FromSaveSel, struct EditorSelect *save_es ){

   if( !FromSaveSel || !GetProcSaveSelectForRestore( esr->ei.EditorID, &esr->lastsel, &esr->cursel ) ){//-  뤥  ।⢥   Far
      struct EditorGetString str;
      int LastSelEnd = -1; //ᬥ饭 ᫥ ப 뤥
    
      if( EndLine ) *EndLine = BlockStartLine;
    
      for( int i = BlockStartLine; i < esr->ei.TotalLines; i++ ){
         str.StringNumber = i;
         if( ExtSearchInfo.EditorControl( ECTL_GETSTRING, &str ) == true ){
      
            if( str.SelStart == -1 && i != BlockStartLine ) break;
            else if( str.SelStart == -1 && i == (BlockStartLine + 1) ) break;
            else if( str.SelEnd == 0 ) break;//AV 15.12.99  室 ਢ 뤥  Far
      
            if( i == BlockStartLine && BegPos ){
               *BegPos = str.SelStart;
            }  
            // 砫쭮 ᬥ饭  ਭ 
            if( Width && EndPos && i == BlockStartLine && str.SelStart )
                  *Width = -str.SelStart;
       
            if( EndLine ) *EndLine = str.StringNumber;
            if( EndPos  ){
               if( str.SelEnd != -1 ){
                  *EndPos  = str.SelEnd;
                  LastSelEnd = str.SelEnd;          
               }
               else{
                  *EndPos = str.StringLength;//뤥 砥  ᥡ  ப
               }
            }
         }
         else break;
      }
     
      // 筮 ᬥ饭  ਭ 
      if( Width && EndPos ){
         *Width += *EndPos;
    
         if( LastSelEnd == -1 )
           *Width = -1;        
      }
   }else{  //-  뤥 ६  ࠭ ࠭ 
      if( save_es ){
         if( EndLine ) *EndLine = save_es->BlockStartLine + save_es->BlockHeight +  - 1;
         if( EndPos  ) *EndPos  = save_es->BlockWidth + save_es->BlockStartPos;
         if( BegPos  ) *BegPos  = save_es->BlockStartPos;
         if( Width   ) *Width   = save_es->BlockWidth;
      }
   }
}


//࠭ ࠬ ⠭⭮ 뤥
static void SaveStandardSelect ( ExtSearchReg *esr, struct EditorSelect *save_es ){
  
    struct EditorInfo temp_ei;
    ExtSearchInfo.EditorControl( ECTL_GETINFO, &temp_ei );
   
    if( temp_ei.BlockType != BTYPE_NONE ){
       save_es->BlockType      = temp_ei.BlockType;
       save_es->BlockStartLine = temp_ei.BlockStartLine;
      
       int EndLine = 0, EndPos = 0, BegPos = 0, Width = 0;
      
       GetInfoSelection( esr, save_es->BlockStartLine, &EndLine, &EndPos, &BegPos, &Width, 0, NULL );
       save_es->BlockStartPos = BegPos;
       save_es->BlockWidth    = Width;
       save_es->BlockHeight   = EndLine - save_es->BlockStartLine + 1;
    }
    else
       save_es->BlockType = BTYPE_NONE;
}

//஢ઠ 㦭  ࠭ ⥪饥 ⠭⭮ 뤥, ᫨  ᤥ
//  ,  㦭,  ।⢥ ᠬ ࠭
static void SaveStandardSelectForRestore( ExtSearchReg *esr ){
  struct EditorSelect cursel_es;
  SaveStandardSelect( esr, &cursel_es );

  InitListSel( esr->ei.EditorID, &esr->lastsel, &esr->cursel );

  if( cursel_es.BlockType != BTYPE_NONE && memcmp( &esr->cursel->extsel_es, &cursel_es, sizeof(struct EditorSelect) ) ){
     memcpy( &esr->cursel->save_es, &cursel_es, sizeof(struct EditorSelect) );
     if( esr->cursel->save_es.BlockType != BTYPE_NONE ) esr->cursel->ProcSaveSelectForRestore = 1;
  }
}

// ⠭⭮ 뤥
static void ResetStandardSelect ( ExtSearchReg *esr ){
    if( GetProcSaveSelectForRestore( esr->ei.EditorID, &esr->lastsel, &esr->cursel ) == 1 ){
       struct EditorSelect es;
       memset( &es, 0, sizeof(struct EditorSelect) );
       es.BlockType = BTYPE_NONE; 
       ExtSearchInfo.EditorControl( ECTL_SELECT, &es ); /*㡥६ 뤥*/
       ExtSearchInfo.EditorControl( ECTL_REDRAW, NULL );/*㥬  ।*/
       esr->cursel->ProcResetSelect = 1;//⠭ ਧ 
    }
}

//⠭ ⠭⭮ 뤥, ᯮ । ࠬ
// Reset - ਧ, ⮣  㦭  䫠 esr->ProcSaveSelectForRestore 
static void SetStandardSelect ( ExtSearchReg *esr, int Reset ){

    //AV 28.02.00
    ExtSearchInfo.EditorControl( ECTL_GETINFO, &esr->ei );
    esr->cursel = GetListSel( esr->ei.EditorID, &esr->lastsel, esr->cursel );
    //
    if( esr->cursel ){
       struct EditorSelect *es = &esr->cursel->save_es;
   
       if( es->BlockType != BTYPE_NONE && GetProcSaveSelectForRestore( esr->ei.EditorID, &esr->lastsel, &esr->cursel ) == 1 && GetProcResetSelect( esr->ei.EditorID, &esr->lastsel, &esr->cursel ) == 1){
          ExtSearchInfo.EditorControl( ECTL_SELECT, es ); /*⠭ 뤥*/
          if( Reset ) 
             esr->cursel->ProcSaveSelectForRestore = 0;
          esr->cursel->ProcResetSelect = 0;//᭨ ਧ 
       }
    }
}

/* ७ 뤥  (뤥 १ ColorAPI)*/
static int ResetSelect( int ResetScreen ){

   struct EditorColor edc;
   memset( &edc, '\0', sizeof(EditorColor) );
   
   if( ResetScreen && Sel.Set == true && Sel.StartLine != -1 ){
      edc.StringNumber = Sel.StartLine;
      edc.StartPos = Sel.StartPos;
      edc.Color        = 0;
      ExtSearchInfo.EditorControl( ECTL_ADDCOLOR, &edc );

      Sel.Set       = false;
      Sel.StartLine = -1;
      return 1;
   }

   if( !ResetScreen ){
      Sel.Set       = false;
      Sel.StartLine = -1;
   }
   return 0;
}

static void RefreshSelect( void ){

   if( Sel.Set == true && Sel.StartLine != -1 ){
   
      struct EditorColor edc;
      memset( &edc, '\0', sizeof(EditorColor) );
      
      edc.StringNumber = Sel.StartLine;
      edc.ColorItem    = 0;
      edc.StartPos     = Sel.StartPos;
      edc.EndPos       = Sel.StartPos + Sel.Width - 1;
      edc.Color        = Sel.Color;
      ExtSearchInfo.EditorControl( ECTL_ADDCOLOR, &edc );      
   }                                            
}

//*******************************************************************
// ⠭⭠ 楤,  뤥 
//*******************************************************************
static void Select( ExtSearchReg *esr, int SelStartLine, int SelStartPos, int SelWidth ){

  if( SelWidth > 0 ){//AV 21.02.00 ᫨   뤥   
     if( !esr->SelectFAR ){
        ResetSelect( 1 );
     
        Sel.Set = true;
        Sel.StartLine = SelStartLine;
        Sel.StartPos  = SelStartPos;
        Sel.Width     = SelWidth; 
     
        struct EditorGetString str;
        str.StringNumber = Sel.StartLine;
        if( ExtSearchInfo.EditorControl( ECTL_GETSTRING, &str ) ){
           if( !Sel.FindStr ) Sel.FindStr = (char*)malloc( Sel.Width + 1 );
           else               Sel.FindStr = (char*)realloc( Sel.FindStr, Sel.Width + 1 );
           if( Sel.FindStr ){ 
              strncpy( Sel.FindStr, str.StringText + Sel.StartPos, Sel.Width );
              *(Sel.FindStr + Sel.Width) = '\0';                               
           }
        }                                               
     
        esr->bKeyDownAfterSelect = 0; //㫥 
     
        if( SetConnectToColorerDLL ){
           RefreshSelect();
           ExtSearchInfo.EditorControl( ECTL_REDRAW, NULL );/*㥬  ।*/
        }
     }else{//AV 17.01.00 뤥 ।⢠ FAR 
        struct EditorSelect edsl;
        edsl.BlockType = BTYPE_STREAM;
        edsl.BlockStartLine = SelStartLine;
        edsl.BlockStartPos  = SelStartPos;
        edsl.BlockWidth  = SelWidth;
        edsl.BlockHeight = 1;
      
        ExtSearchInfo.EditorControl( ECTL_SELECT, &edsl );

        if( esr->cursel )
           SaveStandardSelect( esr, &esr->cursel->extsel_es );//  뤥 (ᤥ ExtSeach')
        //ExtTestMessage( "Select:ExtStertPos", esr->extsel_es.BlockStartPos  );
     }
  }
}
//।塞  ᪠  砥, ᫨ ⠭ AutoSearchInSelect
static void SetAutoSearchInSelect( ExtSearchReg *esr ){
  //AV 01.12.99
  if( esr->AutoSearchInSelect && esr->FromSearch != 1 ){ // esr->ei.BlockType != BTYPE_NONE
     if( (esr->SetSelect && esr->ei.BlockType != BTYPE_NONE && GetProcSaveSelectForRestore( esr->ei.EditorID, &esr->lastsel, &esr->cursel )) || (!esr->SetSelect && esr->ei.BlockType != BTYPE_NONE) )
        esr->FromSearch = 2; //   뤥  
     else if( !esr->SetSelect && esr->ei.BlockType != BTYPE_NONE )
        esr->FromSearch = 2; //   뤥  
     else            
        esr->FromSearch = 0; //  
  }
}

static void Message_NoFindSel( void ){
   const char *MsgItems[]={ GetMsg(MNoFindSel) ,GetMsg(MOk)};
   ExtSearchInfo.Message(ExtSearchInfo.ModuleNumber, FMSG_WARNING, NULL, MsgItems, sizeof(MsgItems)/sizeof(MsgItems[0]),1);
}

static int PrePosition( ExtSearchReg *esr ){

   int FromSearch = esr->FromSearch, 
       Reverse    = esr->ReverseSearch;

   if( FromSearch == 1 ){//  ᥬ 䠩
      if( Reverse ){
         struct EditorGetString str;
         str.StringNumber = esr->ei.TotalLines-1;// 祭 ᫥ ப
         ExtSearchInfo.EditorControl( ECTL_GETSTRING, &str );
         SetEditorPosition( esr, esr->ei.TotalLines-1, str.StringLength, 0, 0, Reverse );
      }
      else
         SetEditorPosition( esr, 0, 0, 0, 0, Reverse ); //砫 䠩
   }
   else if( FromSearch == 2 ){//  뤥 
      if( esr->ei.BlockStartLine != -1 && (esr->ei.BlockType == BTYPE_STREAM || esr->ei.BlockType ==  BTYPE_COLUMN) ){
         if( Reverse ){
            int EndLineSel, EndPosSel;
            GetInfoSelection( esr, esr->ei.BlockStartLine, &EndLineSel, &EndPosSel, NULL, NULL, 1, &esr->cursel->save_es );
            SetEditorPosition( esr, EndLineSel, EndPosSel, 0, 0, Reverse );
         }else{
            int BegPosSel;
            GetInfoSelection( esr, esr->ei.BlockStartLine, NULL, NULL, &BegPosSel, NULL, 1, &esr->cursel->save_es );
            SetEditorPosition( esr, esr->ei.BlockStartLine, BegPosSel, 0, 0, Reverse );
         }
      }
      //else {
      //   Message_NoFindSel();
      //   return -1;
      //}
   }
   else{ //   ,  뢠 ࠭ ࠭  뤥
      if( esr->SetSelect && esr->cursel ){
         memset( &esr->cursel->save_es, 0, sizeof(struct EditorSelect) );
         esr->cursel->ProcSaveSelectForRestore = 0;
      }
   }


   ExtSearchInfo.EditorControl( ECTL_GETINFO, &esr->ei );
   ExtSearchInfo.EditorControl( ECTL_REDRAW, NULL );/*㥬  ।*/
   return 0;
}

//
static char StrSearchTmp_ProcSearch[LenSearchStr];
static int LenStrSearchTmp;
//
//******************************************************************
// 㭪 ४ ப ᪠
//******************************************************************
static void SetSearchStrTmp( ExtSearchReg *esr, char *_SearchStr ){ 
   strncpy( StrSearchTmp_ProcSearch, _SearchStr, LenSearchStr );

   //if( !esr->CaseSensitive && !esr->SetRegExp )
   //   struprR( StrSearchTmp_ProcSearch, 0 );
   //else if( !esr->CaseSensitive && esr->SetRegExp )
   //   struprR( StrSearchTmp_ProcSearch, 1 );// ⮫쪮 ᪨


   if( !esr->SetRegExp && !esr->CaseSensitive ) struprR( esr, StrSearchTmp_ProcSearch, 1, 0 );
//   else if( !esr->CaseSensitive && esr->SetRegExp )
//      struprR( esr, StrSearchTmp_ProcSearch, 1, 1 );// ⮫쪮 ᪨


   //AV 18.10.99
   ConvertFromOEM( esr, StrSearchTmp_ProcSearch );

   LenStrSearchTmp = strlen(StrSearchTmp_ProcSearch);
}

//ࠡ稪 訡  ࠧ ॣᯮ
static void RegExpProcError( ExtSearchReg *esr ){
   if( esr->SetRegExp ){
      if( esr->ErrRegExpReplace ){
         const char *MsgItems[]={GetMsg(MExtReplaceTitle),GetMsg(MNoCorrectRXReplace),GetMsg(MOk)};
         ExtSearchInfo.Message(ExtSearchInfo.ModuleNumber,FMSG_WARNING,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
      }
      if( esr->ErrRegExpSearch  ){
         const char *MsgItems[]={GetMsg(MExtSearchTitle),GetMsg(MNoCorrectRXSearch),GetMsg(MOk)};
         ExtSearchInfo.Message(ExtSearchInfo.ModuleNumber,FMSG_WARNING,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
      } 
   }
}

//  mem2   mem1  
static char *memmem( char *mem1, size_t size1, char *mem2, size_t size2 ){
   if( size2 > size1 ) return NULL;
   int (*cmpproc)(const void *s1, const void *s2, size_t n) = esr->CaseSensitive ? memcmp : memicmp;

   for( int i = 0; i <= (size1 - size2); i ++ )
      if( (cmpproc( (void*)(mem1 + i), (void*)mem2, size2 )) == 0 ) return (mem1 + i);

   return NULL;
}

#pragma argsused
//**********************************************************************************************
//  ᭮ 楤 堭 ᪠
//**********************************************************************************************
static bool ProcSearch( ExtSearchReg *esr ){

   if( esr->CheckESC && CheckForEsc() == true ) return false;//AV 27.03.00 ஢ઠ  ⨥ Esc

   //ExtTestMessage( "EditorID", esr->ei.EditorID );
             
   if( *esr->SearchStr ){//AV 10.11.99 ᫨ ,  ᪠ :)

      //᪮쪮 ᨬ  ᠬ 塞  ப ।   
      //  砥  ॣᯠ 塞 \r\n, ⮡   뫮 , API   
      int NumAddSymb; 
      int i, end, CurL;


      //AV 31.01.00
      if( esr->SetSelect && (!esr->AllProc || GetProcResetSelect( esr->ei.EditorID, &esr->lastsel, &esr->cursel ) ) )
         SaveStandardSelectForRestore( esr );

      if( !esr->AllProc && (!esr->ContinueSearch || !esr->Replace) ) SetAutoSearchInSelect( esr );/*஢塞 㦭  ᪠  */

      if( esr->SetSelect && GetProcResetSelect( esr->ei.EditorID, &esr->lastsel, &esr->cursel ) )
         SetStandardSelect( esr, 0 );         

      //AV 10.11.99 ᫨ 饬  RegExp',  ன ⠭ ਭ㤨⥫쭮  ६ ᪠
      if( esr->SetRegExp ){
         esr->WordSearch     = false;
         if( esr->Replace ){
            int len = strlen( esr->ConvertReplace );   
            if( !esr->RXConvertReplace ) esr->RXConvertReplace = (char*)malloc( len+1 );
            else esr->RXConvertReplace = (char*)realloc( esr->RXConvertReplace, len+1 ); 
            strcpy( esr->RXConvertReplace, esr->ConvertReplace );//AV 19.11.99 
         }
      }
                                                                        
      //AV 22.10.99 樮஢ 砫 ᪠
      if( !esr->Position ){
         if( PrePosition( esr ) ) return false;// ᬮ ᯮ樮஢
         esr->Position = 1;
      }
   
      int CurLine    = esr->ei.CurLine,
           CurPos    = esr->ei.CurPos,
          TotalLines = esr->ei.TotalLines;
   
      //ᬥ  :  ࢮ , ࢮ ᪥  뤥.   ᥬ 䠩 
      //                     ࢮ ᪥  墠 ᫮
      //ᬥ :  ᫥ ,  ࢮ  ᫥ ᪠  樨 ,
      //                  ᫥ ᪠  뤥.   ᥬ 䠩
   
      if( !esr->ReverseSearch ){
         CurL = CurLine;
         end = TotalLines-1;

         if( !esr->ContinueSearch && !esr->PickUpWord ) /* ᬥ頥*/;
         else{
            if( esr->Replace && esr->ContinueSearch ){
               if( esr->LenStrReplace < 0 ) CurPos += strlen( esr->ReplaceStr );
               else                         CurPos += esr->LenStrReplace;//AV 16.11.99
            }
            else if( !esr->DN_Position && !esr->Replace && (!esr->FromSearch || (esr->FromSearch && esr->ContinueSearch) ) )
               CurPos++;
            //AV 10.12.99  ⮪ ᪥ 㠫 ᨬ \b \B ^
            else if( esr->DN_Position && esr->VirtualSymbols && esr->ContinueSearch )
               CurPos++;
         }

      }
      else{
         CurL = -CurLine;
         end = 0;   

         if( !esr->ContinueSearch && !esr->PickUpWord ) /* ᬥ頥*/;
         else{                               
            if( (!esr->Replace && (!esr->FromSearch || (esr->FromSearch && esr->ContinueSearch))) || 
                (esr->Replace && esr->ContinueSearch)  
              )
               CurPos--; //砫 ப  䠩 ⨣  CurPos < 0      
         }     
      }
   
      if( esr->FromSearch == 2 ){ //  뤥 

         int Save = GetProcSaveSelectForRestore( esr->ei.EditorID, &esr->lastsel, &esr->cursel );

         if( esr->ei.BlockType == BTYPE_NONE && !Save ){//AV 31.01.00
            Message_NoFindSel();
            return false;
         }
        
         if( !esr->ReverseSearch ){
            GetInfoSelection( esr, esr->ei.BlockStartLine, &end, NULL, NULL, NULL, 1, &esr->cursel->save_es );  
         }
         else{                      
            if( !Save )
               end = -esr->ei.BlockStartLine;      
            else
               end = -esr->cursel->save_es.BlockStartLine;
         }     
      }
   
      //    ---   横 ᪠ ---
      //
      //struct EditorGetString str;
      
      // char *StringBuff = NULL;
      // *StringBuff = '\0';
   
      char *BegStr, *FindStr;
      //AV 17.12.99 ࠫ
      //char PrevSymb = 0;
      bool loop = true, find = false;
      int  SelStart, SelLength;

      char *StringText, *BegStrSave, *BegSelStrSave;

      //AV 28.03.00 ⪠ ᪮                 
      struct EditorSetPosition esp; 
      memset( &esp, 0, sizeof(struct EditorSetPosition) );        
      esr->str.StringNumber = -1;// 祭 ⥪饩 ப 
      //
 
      /*横  ப ।㥬 䠩*/
      while( loop && CurL <= end ) {

         NumAddSymb = 0; //᫮   ᯥᨬ  ப 뤠 FAR'

         //AV 16.12.99 訡 ॣ  ப ᪠
         if( esr->SetRegExp && esr->ErrRegExpSearch ) break;

         if( esr->ReverseSearch && CurPos < 0 && !CurLine ) break;//砫 䠩  ᪥ 
   
         //AV 02.11.99 ᫨ 砫 ⭮ ᪠ ⮨  砫 ப, ᬥ⨬ 
         if( esr->ReverseSearch && CurL != 0 && CurPos < 0 && CurL < end ){  
            CurL++; 
            CurPos = 0;                                     
         }
 
         if( esr->ReverseSearch ) i = abs(CurL);
         else         i = CurL;
                                                                
         //AV 12.01.00                                             
                                                                
         //AV 28.03.00 ⪠ ᪮                 
         if( i != esr->ei.CurLine ){
            esp.CurLine = i;                                     
            ExtSearchInfo.EditorControl(ECTL_SETPOSITION,&esp);
         }
         //

         loop = ExtSearchInfo.EditorControl( ECTL_GETSTRING, &esr->str );

         //
         if( loop ) {

            if( esr->StringBuff && esr->LenCurStr < (esr->str.StringLength + LenAddStr + 1) ){
               esr->LenCurStr = esr->str.StringLength + LenAddStr + 1;
               esr->StringBuff = (char*)realloc( (void*)esr->StringBuff, esr->LenCurStr );
            }   
            else if( !esr->StringBuff ){
               esr->LenCurStr = esr->str.StringLength + LenAddStr + 1;               
               esr->StringBuff = (char*)malloc( esr->LenCurStr );    
            }                                                   

            if( !esr->StringBuff ) break;   
            else
               memset( esr->StringBuff, 0, esr->LenCurStr );

            memcpy( esr->StringBuff, esr->str.StringText, esr->str.StringLength );
            if( esr->SetRegExp && i != esr->ei.TotalLines-1 ){   
               strcat( esr->StringBuff, "\r\n" );
               NumAddSymb += 2;
            }
            
            if( esr->SetRegExp ) 
               ConvertToOEM( esr, esr->StringBuff, esr->str.StringLength ); 

            if( !esr->CaseSensitive && !esr->SetRegExp )
               struprR( esr, esr->StringBuff, 0, 0 );

            StringText = esr->StringBuff;
            BegStrSave = esr->StringBuff;
            BegSelStrSave = esr->StringBuff;


            //AV 02.11.99 ᫨  砫 אַ ᪠ ⮨  । ࠢ  ⥪
            if( !esr->ReverseSearch && i == CurLine ){
      
               //ਧ - 祭   ன  । Far -   । ப
               int SetCurBeyondEOL = esr->ei.Options&EOPT_CURSORBEYONDEOL;
               if(  i != (esr->ei.TotalLines-1) && (SetCurBeyondEOL && CurPos >= (esr->str.StringLength+NumAddSymb) || (!SetCurBeyondEOL && CurPos >= esr->str.StringLength)) ){//AV 16.11.99 + "\r\n"
                  CurPos = 0;//AV 25.11.99
                  CurL++;
                  continue;
               }
               else if( i == (esr->ei.TotalLines-1) && CurPos >= esr->str.StringLength )//AV 25.11.99
                  break;
                                                                
               //AV 13.12.99
               if( !esr->SetRegExp && !esr->str.StringLength ){
                  CurPos = 0;//AV 25.11.99
                  CurL++;
                  continue;
               }
            }
            //

            if( i == CurLine ){//।塞  砫 ᪠  ப  ன 稭  
              if( !esr->ReverseSearch ) StringText += CurPos;
            }

            SelLength = 0;

            if( esr->FromSearch == 2 ){//  뤥   
              //AV 24.11.99
              int OffSet = 0;
              if( !esr->ReverseSearch && i == CurLine ) OffSet = CurPos;
              //             
              if( esr->str.SelEnd != -1 )
                 *(StringText+esr->str.SelEnd-OffSet) = '\0';

              if( !OffSet && !esr->ReverseSearch )
                 StringText += esr->str.SelStart;      

              //AV 21.02.00                        
              BegSelStrSave += esr->str.SelStart;
              if( esr->str.SelEnd > 0 ){
                 *(BegSelStrSave + esr->str.SelEnd - esr->str.SelStart) = '\0';
                 SelLength = esr->str.SelEnd - esr->str.SelStart + 1; 
              }
              //
            }     
         }
         else{
            break;
         }
   
         if( !esr->ReverseSearch ) BegStr = StringText;
         else BegStr = StringText + strlen(StringText);
   
         FindStr = BegStr;/*⮡  */
   
         int SetBegStr = 0;//AV 29.11.99

         /*  ⭮ ப*/
         while( FindStr ){
   
            /*  ப  ⭮ ࠢ*/
            if( esr->ReverseSearch ){
               if( SetBegStr ) break;/*諨  砫 ப*/ //BegStr == StringText
               else{/*த  */

                  if( !esr->SetRegExp ) BegStr -= LenStrSearchTmp;
                  else                  BegStr --;//AV 23.11.99

                  if( BegStr < StringText ){
                     BegStr = StringText;               
                     SetBegStr = 1;
                  }
               }
            }

            //    

            unsigned long _curstrlen_, _str_len_;

            //  ᫨ 饬  뤥 
            if( esr->FromSearch == 2 && SelLength > 0 && esr->str.StringLength > SelLength ) _str_len_ = SelLength;
            else
               _str_len_ = esr->str.StringLength;                                                    

            _curstrlen_ = _str_len_-(BegStr-BegStrSave) + NumAddSymb;

            if( (!esr->SetRegExp && (FindStr = memmem( BegStr, _curstrlen_, StrSearchTmp_ProcSearch, strlen(StrSearchTmp_ProcSearch)) ) != NULL) || 
                (esr->SetRegExp && (FindStr = StrStrRegExp( BegStr, esr->FromSearch != 2 ? BegStrSave : BegSelStrSave, BegStr+_curstrlen_, StrSearchTmp_ProcSearch, &LenStrSearchTmp, esr, (i == esr->ei.TotalLines-1 && esr->str.SelEnd > esr->str.StringLength) ) ) != NULL)
              ){

               //⤥쭮 ᫮  ?
               if( esr->WordSearch && !CheckWord( esr, StringText, FindStr - StringText) ){

                  //ப  ௠ ப,  ।
                  if( (esr->str.StringLength-(BegStr-StringText)) > 0 && !esr->ReverseSearch )  BegStr = ++FindStr;                  
                  continue;
               }

               //᫨    ⥪饩 ப, .஢ઠ
               if( i == CurLine && esr->ReverseSearch )
                  if( (FindStr - BegStrSave) > CurPos ){ 
                     continue;//ᬥ⨫  砫  ⭮ ᪠            
                  }
               //AV 24.11.99 ஢ઠ  室   ࠩ 뤥  ⭮ ᪥  뤥
               if( esr->ReverseSearch && esr->FromSearch == 2 && (FindStr - BegStrSave) < esr->str.SelStart ){
                  break; //室  ᫥ ப                                                   
               }

               //ப !!!!!
               SelStart = FindStr - BegStrSave;

               if( esr->PutInClipBoard && !esr->AllProc ){
                  char *InClipBoard = (char*)malloc( LenStrSearchTmp+1 );                   
                  if( InClipBoard ){
                     strncpy( InClipBoard, FindStr, LenStrSearchTmp );
                     *(InClipBoard + LenStrSearchTmp) = '\0';
                     ConvertToWinRus( InClipBoard, LenStrSearchTmp );
                     PutClipBoard( InClipBoard );//  
                     free( InClipBoard );
                  }
               }    

  
               //AV 02.12.99 । 砫쭮 樨 ᫥饣 ᪠
               int NextBegPos;
               if( esr->DN_Position && !esr->ReverseSearch && !esr->Replace )
                  NextBegPos = SelStart + LenStrSearchTmp;
               else         
                  NextBegPos = SelStart;
               //

               if( esr->Replace ) 
                  SetEditorPosition( esr, i, NextBegPos, (!esr->AllProc) ? 1 : 0, (!esr->AllProc) ? 0 : 1, esr->ReverseSearch );
               else
                  SetEditorPosition( esr, i, NextBegPos, 0, (!esr->AllProc) ? 0 : 1, esr->ReverseSearch );

               //AV 31.01.00 ⥯ 뤥 㡨ࠥ  ⠭   砥
               //AV 21.02.00 뢠-뤥塞, ᫨   뫮
               if( esr->SetSelect && (!esr->AllProc || (!GetProcResetSelect( esr->ei.EditorID, &esr->lastsel, &esr->cursel ) && !esr->Replace && !esr->Count )) ){ //&& (esr->FromSearch != 2 || esr->Replace)*/
                  ResetStandardSelect( esr ); 
                  Select( esr, i, SelStart, LenStrSearchTmp );
               }                
 
               if( !esr->FindStr ) esr->FindStr = (char*)malloc( LenStrSearchTmp + 1 );
               else if( LenStrSearchTmp > esr->LenStrSearchTmp ) esr->FindStr = (char*)realloc( esr->FindStr, LenStrSearchTmp + 1 ); 

               memcpy( esr->FindStr, FindStr, LenStrSearchTmp );
                   
               *(esr->FindStr + LenStrSearchTmp) = '\0';

               //AV 12.11.99   ॠ쭮   ॣᯮ
               esr->LenStrSearchTmp = LenStrSearchTmp;

               if( !esr->LenStrSearchTmp ) esr->VirtualSymbols = 1;
               else                        esr->VirtualSymbols = 0;
   
               if( esr->Replace ){
                  esr->NumFindForReplace ++;
   
                  if( !esr->AllProc )
                     ExtSearchInfo.EditorControl( ECTL_REDRAW, NULL );/*㥬  ।*/
               }
   
               find = true;
               loop = false;
               break;
            }

            // 訡  ࠧ ப-  ॣᯠ
            if( esr->SetRegExp && esr->ErrRegExpReplace == 1 ){
               esr->AllProc = 0; // ⬥ ⮪ 
               loop = false;
               break;
            }

            if( esr->ReverseSearch ) FindStr = BegStr;/*⮡  */
         }
         CurL++;      
      }             

      // -  !
      if( !find && !esr->NumFindForReplace && !esr->NumCount && !esr->ErrRegExpReplace && !esr->ErrRegExpSearch )
      {
         if( !esr->NoErrMes )
         {
            int NumMes = (esr->FromSearch == 2) ? MNoFindInSel : MNoFind;
            const char *MsgItems[]={GetMsg(MExtSearchTitle),GetMsg(NumMes),esr->SearchStr,GetMsg(MOk)};
            ExtSearchInfo.Message(ExtSearchInfo.ModuleNumber,FMSG_WARNING,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
         }

         //AV 28.03.00 ⪠ ᪮                 
         //⠭ 砫 
         esp.CurLine=esr->ei.CurLine;
         esp.CurPos=esr->ei.CurPos;
         esp.TopScreenLine=esr->ei.TopScreenLine;
         esp.LeftPos=esr->ei.LeftPos;
         esp.CurTabPos=-1;
         esp.Overtype=-1;
         ExtSearchInfo.EditorControl(ECTL_SETPOSITION,&esp); 
         //    

      }

      RegExpProcError( esr );

      return find;
      
   }
   else return false;

}

//***************************************************************************
//    ⥪  䠩 (⥯   , 殢  㦥  ⠢)
//***************************************************************************
inline void ReplaceTextInFile( ExtSearchReg *_esr, char *_ConvertReplace ){
   //⥪饥  
   int FileCurPos         = _esr->FileCurPos;
   int LenStrReplace      = _esr->LenStrReplace = strlen( _ConvertReplace );
   int LenStrSearchTmp    = _esr->LenStrSearchTmp;    
   int LenBegNoFindStr    = FileCurPos - _esr->LastFileCurPos;
   int LenStartReplaceBuff= _esr->LenReplaceFileBuff;

   //㢥稢      ࠧ 砫쭮 ᪠ + ᪠  
   _esr->LenReplaceFileBuff += (LenStrReplace + LenBegNoFindStr);
   //᫨  ॠ㥬   
   if( _esr->LenReplaceFileBuff > _esr->LenCurStr ) _esr->TmpReplaceStr = (char*)realloc( _esr->TmpReplaceStr, _esr->LenReplaceFileBuff );

   if( LenBegNoFindStr > 0 )//㥬      砫 ᮪( ஬ 祣  諨)
      memcpy( _esr->TmpReplaceStr + LenStartReplaceBuff, _esr->ReplaceFileBuff + _esr->LastFileCurPos, LenBegNoFindStr );

   //㥬 ப      
   memcpy( _esr->TmpReplaceStr + LenStartReplaceBuff + LenBegNoFindStr, _ConvertReplace, _esr->LenStrReplace );

   //᫥   ᫥ 
   _esr->LastFileCurPos = FileCurPos + LenStrSearchTmp;
}

char *Masks[256];//ᨢ  ᪠  ᪠  䠩
// ᨢ  ᪠  ᪠  䠩
static void FillMasks( ExtSearchReg *_esr ){
   char *ptr, *cur = _esr->MaskStr;
   int i = 0;
   while( (ptr = strchr( cur, ',' )) != NULL ){
      Masks[i] = (char*)malloc( (ptr - cur) + 1 );
      memset( Masks[i], 0, (ptr - cur) + 1 );
      strncpy( Masks[i], cur, ptr - cur );
      cur = ptr + 1;
      i++;
   }      
   Masks[i] = (char*)malloc( strlen(cur) + 1 );
   memset( Masks[i], 0, strlen(cur) + 1 );
   strcpy( Masks[i], cur );
   _esr->MaskNumber = i + 1;//- ᮪
}
//᢮  - ᨢ  ᪠  ᪠  䠩
static void FreeMasks( ExtSearchReg *_esr ){
   for( ; _esr->MaskNumber != 0; _esr->MaskNumber-- ){
      free( Masks[_esr->MaskNumber-1] );
      Masks[_esr->MaskNumber-1] = NULL;
   }
}
//஢ઠ ப  ᮢ    ᮪
static bool CheckMasks( ExtSearchReg *_esr, char *FileName ){
   for( int i = 0; i < _esr->MaskNumber; i ++ ){
      if( ExtSearchInfo.CmpName( Masks[i], FileName, false ) == true ) return true;
   }
   return false;
}

//**********************************************************************************************
//  ᭮ 楤 堭 ᪠  䠩
//**********************************************************************************************
static bool ProcFileSearch( ExtSearchReg *_esr ){

   if( _esr->Replace ){
      _esr->LastFileCurPos     = 0;
      _esr->LenReplaceFileBuff = 0;
   }

   if( _esr->CheckESC && CheckForEsc() == true ) return false;//AV 27.03.00 ஢ઠ  ⨥ Esc
  
   if( *_esr->SearchStr ){//AV 10.11.99 ᫨ ,  ᪠ :)

      //AV 10.11.99 ᫨ 饬  RegExp',  ன ⠭ ਭ㤨⥫쭮  ६ ᪠
      if( _esr->SetRegExp ){
         _esr->WordSearch     = false;
         if( _esr->Replace ){
            int len = strlen( _esr->ConvertReplace );   
            if( !_esr->RXConvertReplace ) _esr->RXConvertReplace = (char*)malloc( len+1 );
            else _esr->RXConvertReplace = (char*)realloc( _esr->RXConvertReplace, len+1 ); 
            strcpy( _esr->RXConvertReplace, _esr->ConvertReplace );//AV 19.11.99 
         }
      }                                                                        

      //    ---   横 ᪠ ---
      char *BegStr, *FindStr;
      bool find = false;

      char *StringText, *BegStrSave, *BegRegExpStrSave, *EndRegExpStrSave;
 
      if( !_esr->StringBuff ) return false;   

      if( !_esr->AllProc ){ // ⮫쪮  ࢮ 室
         if( _esr->SetRegExp )
            ConvertToOEM( _esr, _esr->StringBuff, _esr->LenCurStr ); 
      
         if( !_esr->CaseSensitive && !_esr->SetRegExp )
            struprR( _esr, _esr->StringBuff, 2, 0 );
      }

      StringText = BegStrSave = _esr->StringBuff;

      if( _esr->SetRegExp ){
         BegRegExpStrSave = _esr->StringBuff;
         EndRegExpStrSave = BegRegExpStrSave + _esr->LenCurStr;          
      }
      if( _esr->AllProc ){
         StringText += (_esr->FileCurPos + 1);
         if( _esr->SetRegExp )
            SetRegExpSearchStrTmp( _esr, StrSearchTmp_ProcSearch, &_esr->ei, 1 );
      }

      if( _esr->ChangeBegStr && _esr->Replace && _esr->SetRegExp )
          SetRegExpSearchStrTmp( _esr, StrSearchTmp_ProcSearch, &_esr->ei, 2 );
      
      BegStr  = StringText;   
      FindStr = BegStr;/*⮡  */

      bool repeat = false; // ୮ ᪠  ࠡ⪮  砫 ப - ^

      bool FirstReplace = _esr->Replace ? true : false;

      /*  ⥪ 䠩*/
      while( FindStr ){

         //    
         if( (!_esr->SetRegExp && (FindStr = memmem( BegStr, _esr->LenCurStr-(BegStr-StringText), StrSearchTmp_ProcSearch, strlen(StrSearchTmp_ProcSearch) )) != NULL) || 
             (_esr->SetRegExp && (FindStr = StrStrRegExp( BegStr, BegRegExpStrSave, EndRegExpStrSave, StrSearchTmp_ProcSearch, &LenStrSearchTmp, _esr, false ) ) != NULL)
           ){

            //⤥쭮 ᫮  ?
            if( _esr->WordSearch && !CheckWord( _esr, StringText, FindStr - StringText) ){

               BegStr = ++FindStr;                  
               continue;
            }
            //ப !!!!!
            _esr->FileCurPos = FindStr - BegStrSave;
              
            if( !_esr->FindStr ) _esr->FindStr = (char*)malloc( LenStrSearchTmp );
            else if( LenStrSearchTmp > _esr->LenStrSearchTmp ) _esr->FindStr = (char*)realloc( _esr->FindStr, LenStrSearchTmp + 1); 
            strncpy( _esr->FindStr, FindStr, LenStrSearchTmp );
                
            *(_esr->FindStr + LenStrSearchTmp) = '\0';
            //AV 12.11.99   ॠ쭮   ॣᯮ
            _esr->LenStrSearchTmp = LenStrSearchTmp;

            if( !_esr->LenStrSearchTmp ) _esr->VirtualSymbols = 1;
            else                        _esr->VirtualSymbols = 0;

            if( _esr->Replace ){
               _esr->NumFindForReplace ++;
               if( !_esr->SetRegExp ) ReplaceTextInFile( _esr, _esr->ConvertReplace );
               else                  ReplaceTextInFile( _esr, _esr->RXConvertReplace );

               if( _esr->LenStrSearchTmp )
                  BegStr = (FindStr + _esr->LenStrSearchTmp);
               else
                  BegStr =  (FindStr++);

               if( _esr->SetRegExp && FirstReplace == true && *StrSearchTmp_ProcSearch == '^' )
                  SetRegExpSearchStrTmp( _esr, StrSearchTmp_ProcSearch, &_esr->ei, 1 );

               FirstReplace = false;

               find = true;
               continue;
            }

            find = true;
            break;
         }

         //᫨   砫 ப '^' - ਬ ,    "\n\m"
         if( !_esr->Replace && !_esr->AllProc && repeat == false && _esr->SetRegExp && find == false && *StrSearchTmp_ProcSearch == '^' ){
            SetRegExpSearchStrTmp( _esr, StrSearchTmp_ProcSearch, &_esr->ei, 1 );
            FindStr = BegStr;
            repeat  = true;
            continue;
         }      

         // 訡  ࠧ ப-  ॣᯠ
         if( _esr->SetRegExp && _esr->ErrRegExpReplace == 1 ){
            _esr->AllProc = 0; // ⬥ ⮪ 
            break;
         }

      }

      if( _esr->NumFindForReplace )//࠭塞 䠩
         StringBuff2File( _esr );

      return find;
      
   }
   else return false;

}


//***************************************************************************
//  楤 믮 ।⠭ ᪠
//***************************************************************************
static void PreProcessSearch( ExtSearchReg *_esr, int *SizeX, int *AddrHistory, int *AddrReplaceHistory, int *AddrMaskHistory ){

  if( !_esr->SearchInFile ){
     //। ਭ   ᨬ  ࠧ  ।
     if( _esr->ei.WindowSizeX > 80 ) *SizeX = _esr->ei.WindowSizeX - BeforeLeft; 
     else *SizeX = DefSizeX;
  }
  else *SizeX = DefSizeX;
  //

  if( _esr->LinkSystem == false ){ 
     *AddrHistory = (int)ExtHistoryName;
     if( AddrReplaceHistory ) *AddrReplaceHistory = (int)ExtReplaceHistoryName;
     if( AddrMaskHistory    ) *AddrMaskHistory    = (int)ExtMaskHistoryName;
  }
  else{
     *AddrHistory = (int)HistoryName;
     if( AddrReplaceHistory ) *AddrReplaceHistory = (int)ReplaceHistoryName;
     if( AddrMaskHistory    ) *AddrMaskHistory    = (int)MaskHistoryName;
  }

  //墠⨬ ᫮  ஬ ⮨
  if( !_esr->SearchInFile && _esr->PickUpWord ){                 
     int BegPos = -1;
     struct EditorGetString str;
     char CurWord[LenCurWord] = "";
     str.StringNumber = -1;// 祭 ⥪饩 ப
     ExtSearchInfo.EditorControl( ECTL_GETSTRING, &str );
     GetCurWord( _esr, CurWord, (char *)str.StringText, str.StringLength, _esr->ei.CurPos, &BegPos );
     if( *CurWord != '\0' ){

        if( _esr->DN_Position && BegPos != -1 )//AV 02.12.99 ᯮ樮㥬 । 墠祭 ᫮
           SetEditorPosition( _esr, _esr->ei.CurLine, BegPos, 0, 0, _esr->ReverseSearch );

        memset( (void*)_esr->SearchStr, '\0', LenSearchStr );
        strncpy( _esr->SearchStr, CurWord, LenSearchStr-1 );
     }
  }

  //墠⨬  ClipBoard
  if( !_esr->SearchInFile && _esr->PickUpClipBoard ){
     memset( (void*)_esr->SearchStr, '\0', LenSearchStr );
     GetClipBoard( _esr->SearchStr, LenSearchStr-1 );
     ConvertFromWinRus( _esr->SearchStr, LenSearchStr );
  }
}

//***************************************************************************
//  楤 ⠥ registry    ஥
//***************************************************************************
void GetRegExtSearch( ExtSearchReg *_esr ){

  if( !_esr->SearchInFile )
     ExtSearchInfo.EditorControl( ECTL_GETINFO, &_esr->ei );
  else{
     memset( &_esr->ei, 0, sizeof(_esr->ei) );           
     _esr->CodeTableSearchInFile = GetRegKey(HKEY_CURRENT_USER,"","CodeTableSearchInFile", -1 );
     _esr->SearchFromDir = GetRegKey(HKEY_CURRENT_USER,"","SearchFromDir", SIFKind_FromCurDir );
  }

  int BkGrSelect = GetRegKey(HKEY_CURRENT_USER,"","BkGrSelect", DefBkGrSelect );
  int ClrSelect  = GetRegKey(HKEY_CURRENT_USER,"","ClrSelect",  DefClrSelect  );

  Sel.Color = ClrSelect + BkGrSelect * 16;
  Sel.Set   = false;  

  _esr->CaseSensitive = GetRegKey(HKEY_CURRENT_USER,"","CaseSensitive",false);
  _esr->ReverseSearch = GetRegKey(HKEY_CURRENT_USER,"","ReverseSearch",false);
  _esr->WordSearch    = GetRegKey(HKEY_CURRENT_USER,"","WordSearch"   ,false);
  _esr->SetSelect     = GetRegKey(HKEY_CURRENT_USER,"","Select"       ,false);
  _esr->SetRegExp     = GetRegKey(HKEY_CURRENT_USER,"","SetRegExp"    ,false);

  _esr->UpSetRegExp   = GetRegKey(HKEY_CURRENT_USER,"","UpSetRegExp"  ,false);
  _esr->CheckESC      = GetRegKey(HKEY_CURRENT_USER,"","CheckESC"     ,false);
  _esr->NoSaveGlobal  = GetRegKey(HKEY_CURRENT_USER,"","NoSaveGlobal" ,false);
  _esr->DN_Position   = GetRegKey(HKEY_CURRENT_USER,"","DN_Position"  ,false);
  _esr->NoContinueReplace = GetRegKey(HKEY_CURRENT_USER,"","NoContinueReplace",false);
  _esr->CheckEmptyReplace = GetRegKey(HKEY_CURRENT_USER,"","CheckEmptyReplace",false);

  _esr->PickUpClipBoard = 0;

  //AV 17.11.99
  _esr->AutoSearchInSelect = GetRegKey(HKEY_CURRENT_USER,"","AutoSearchInSelect" , false );

  _esr->FromSearch = GetRegKey(HKEY_CURRENT_USER,"","FromSearch"   ,0);
  
  _esr->PickUpWord = GetRegKey(HKEY_CURRENT_USER,"","PickUpWord",true);
  _esr->LinkSystem = GetRegKey(HKEY_CURRENT_USER,"","LinkSystem"   ,true );
  _esr->PutInClipBoard = GetRegKey(HKEY_CURRENT_USER,"","PutInClipBoard", false);

  if( _esr->LinkSystem == false || _esr->NoDialog ){ 
     GetRegKey(HKEY_CURRENT_USER,"","SearchStr",_esr->SearchStr,"",LenSearchStr);
     GetRegKey(HKEY_CURRENT_USER,"","ReplaceStr",_esr->ReplaceStr,"",LenSearchStr);
     GetRegKey(HKEY_CURRENT_USER,"","MaskStr",_esr->MaskStr,"",LenSearchStr);
  }
  else{
     GetRegKey(HKEY_CURRENT_USER,"","SearchStr",_esr->SearchStr,"",LenSearchStr);
     GetRegKey(HKEY_CURRENT_USER,"","ReplaceStr",_esr->ReplaceStr,"",LenSearchStr);
     if( *_esr->SearchStr ) 
        GetRegKey(HKEY_CURRENT_USER,"","Line0",_esr->SearchStr,"",LenSearchStr,SearchTextRootKey);
     if( *_esr->ReplaceStr )
        GetRegKey(HKEY_CURRENT_USER,"","Line0",_esr->ReplaceStr,"",LenSearchStr,ReplaceTextRootKey);

     GetRegKey(HKEY_CURRENT_USER,"","Line0",_esr->MaskStr,"",LenSearchStr,MaskTextRootKey);
  }

  //AV 17.01.00 뤥塞 ⠭묨 ।⢠  ColorAPI
  _esr->SelectFAR =  !GetRegKey( HKEY_CURRENT_USER,"","KindSelect" , 0 ) ? 1 : 0;

  _esr->ErrRegExpReplace = 0;
  _esr->ErrRegExpSearch  = 0;
}

//***************************************************************************
//  楤  registry 
//***************************************************************************
void SetRegExtSearch( ExtSearchReg *_esr ){

  if( !_esr->SearchInFile ){
     int FromSearch;
   
     if( _esr->NoSaveGlobal && _esr->FromSearch == 1 )//ਠ ᪠ - " ᥬ 䠩"  ࠭塞!
        FromSearch = 0;
     else 
        FromSearch = _esr->FromSearch;

     SetRegKey(HKEY_CURRENT_USER,"","FromSearch",FromSearch);

     SetRegKey(HKEY_CURRENT_USER,"","PickUpWord"   , _esr->PickUpWord   );
     SetRegKey(HKEY_CURRENT_USER,"","PutInClipBoard", _esr->PutInClipBoard );
     SetRegKey(HKEY_CURRENT_USER,"","Select"       , _esr->SetSelect    );
  }else{
     SetRegKey(HKEY_CURRENT_USER,"","CodeTableSearchInFile",_esr->CodeTableSearchInFile);
     SetRegKey(HKEY_CURRENT_USER,"","SearchFromDir",_esr->SearchFromDir);
  }


  SetRegKey(HKEY_CURRENT_USER,"","WordSearch"   , _esr->WordSearch   );
  SetRegKey(HKEY_CURRENT_USER,"","CaseSensitive", _esr->CaseSensitive);
  SetRegKey(HKEY_CURRENT_USER,"","ReverseSearch", _esr->ReverseSearch);

  SetRegKey(HKEY_CURRENT_USER,"","LinkSystem"   , _esr->LinkSystem   );

  SetRegKey(HKEY_CURRENT_USER,"","SetRegExp"    , _esr->SetRegExp    );
}      

//***************************************************************************
//AV 09.12.99   ଠ஢ ६  ஢ ப ᪠ 
//***************************************************************************
static void SetSearchStr_Buffers( ExtSearchReg *_esr ){
  //  㭪樨 ᥣ  뢠     ⮩ ।
  SetSearchStrTmp( _esr, _esr->SearchStr );

  if( _esr->SetRegExp )
     SetRegExpSearchStrTmp( _esr, StrSearchTmp_ProcSearch, &_esr->ei, 0 );
  //
}



//***************************************************************************
//  䥩᭠  ᪠
//***************************************************************************
static int RunSearch( ExtSearchReg *_esr, int Mode )
{

  int    SizeX, AddrHistory;
  bool   find = false; 

  GetRegExtSearch( _esr ); 

  if( Mode ){

     _esr->FromSearch = 0;

     if( Mode == 1 || Mode == 3){ 
        _esr->PickUpWord = 1; 
        _esr->WordSearch = 1;
        if( Mode == 3 ) _esr->ReverseSearch = 1; 
        else _esr->ReverseSearch = 0; 
     }
     if( Mode == 2 || Mode == 4 ){
        _esr->PickUpClipBoard = 1;
        if( Mode == 4 ) _esr->ReverseSearch = 1; 
        else _esr->ReverseSearch = 0; 
     }

     _esr->CaseSensitive = 1;
     _esr->SetRegExp = 0;
  }

  //AV 16.12.99 ᬥ饭   
  int OffsetDn = 0, OffsetUp = 0;
  if( _esr->UpSetRegExp ){
     OffsetDn = CHECKBOX_MOVE_DN;
     OffsetUp = CHECKBOX_MOVE_UP;
  }

  PreProcessSearch( _esr, &SizeX, &AddrHistory, NULL, NULL );       


  int ExitCode;
  char StrTmp[LenSearchStr];

  if( !Mode ){
     //樠   ᪠
     struct InitDialogItem InitItems[]={
        {DI_DOUBLEBOX,WidthUnderSide,1,SizeX-WidthUnderSide-1,BottomSearchDialog-WidthUnder,0,0,0,0,(char *)MExtSearchTitle},
        {DI_TEXT,WidthUnderSide+2,2,0,0,0,0,DIF_BOXCOLOR,0,(char *)MStrForSearch},
        {DI_EDIT,WidthUnderSide+2,3,SizeX-WidthUnderSide-3,0,true,AddrHistory,DIF_HISTORY,0, _esr->SearchStr },
        {DI_TEXT,WidthUnderSide+2,4,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,""},
        {DI_CHECKBOX,WidthUnderSide+2,5,0,0,0,0,0,0,(char *)MCaseSensitive},
        {DI_CHECKBOX,WidthUnderSide+2,6,0,0,0,0,0,0,(char *)MWordSearch},
        {DI_CHECKBOX,WidthUnderSide+2,7,0,0,0,0,0,0,(char *)MReverseSearch},
        {DI_CHECKBOX,WidthUnderSide+2,8,0,0,0,0,0,0,(char *)MSetRegExp},
        {DI_CHECKBOX,WidthUnderSide+2+25,5,0,0,0,0,0,0,(char *)MPickUpWord},
        {DI_CHECKBOX,WidthUnderSide+2+25,6,0,0,0,0,0,0,(char *)MSelect},    
        {DI_CHECKBOX,WidthUnderSide+2+25,7,0,0,0,0,0,0,(char *)MLinkSystem},
        {DI_CHECKBOX,WidthUnderSide+2+25,8,0,0,0,0,0,0,(char *)MPutInClipBoard},
   
        {DI_TEXT,WidthUnderSide+2,9,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,""},
        {DI_RADIOBUTTON, WidthUnderSide+2,10,0,0,0,0,DIF_GROUP,0,(char *)MFromCursor},         
        {DI_RADIOBUTTON, WidthUnderSide+2,11,0,0,0,0,0,0,(char *)MGlobal},         
        {DI_RADIOBUTTON, WidthUnderSide+2,12,0,0,0,0,0,0,(char *)MSelText},
        {DI_TEXT,WidthUnderSide+2,13,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,""},
   
        {DI_BUTTON,0,BottomSearchDialog-WidthUnder-1,0,0,0,0,DIF_CENTERGROUP,1,(char *)MSearch},
        {DI_BUTTON,0,BottomSearchDialog-WidthUnder-1,0,0,0,0,DIF_CENTERGROUP,0,(char *)MCount},
        {DI_BUTTON,0,BottomSearchDialog-WidthUnder-1,0,0,0,0,DIF_CENTERGROUP,0,(char *)MCancel}
     };
   
     //믮  ᪠
     struct FarDialogItem DialogItems[sizeof(InitItems)/sizeof(InitItems[0])];
     InitDialogItems(InitItems,DialogItems,sizeof(InitItems)/sizeof(InitItems[0]), _esr->UpSetRegExp, SearchTypeDialog );
   
     DialogItems[NDI_CaseSensitive+OffsetDn].Selected = _esr->CaseSensitive;
     DialogItems[NDI_ReverseSearch+OffsetDn].Selected = _esr->ReverseSearch;
     DialogItems[NDI_WordSearch   +OffsetDn].Selected = _esr->WordSearch;
     DialogItems[NDI_PickUpWord   ].Selected = _esr->PickUpWord;
     DialogItems[NDI_Select       ].Selected = _esr->SetSelect;
     DialogItems[NDI_LinkSystem   ].Selected = _esr->LinkSystem;
     DialogItems[NDI_PutInClipBoard].Selected = _esr->PutInClipBoard;
     DialogItems[NDI_SetRegExp    -OffsetUp].Selected = _esr->SetRegExp;
   
     DialogItems[NDI_FromCursor + _esr->FromSearch].Selected = 1;
   
     ExitCode=ExtSearchInfo.Dialog(ExtSearchInfo.ModuleNumber,-1,-1, SizeX,BottomSearchDialog,Help_ExtSearch,DialogItems,
                              sizeof(DialogItems)/sizeof(DialogItems[0]));
   
     _esr->CaseSensitive = DialogItems[NDI_CaseSensitive+OffsetDn].Selected;
     _esr->ReverseSearch = DialogItems[NDI_ReverseSearch+OffsetDn].Selected;
     _esr->WordSearch    = DialogItems[NDI_WordSearch   +OffsetDn].Selected;
     _esr->SetSelect     = DialogItems[NDI_Select       ].Selected;
     _esr->PickUpWord    = DialogItems[NDI_PickUpWord   ].Selected;
     _esr->LinkSystem    = DialogItems[NDI_LinkSystem   ].Selected;
     _esr->PutInClipBoard= DialogItems[NDI_PutInClipBoard].Selected;
     _esr->SetRegExp     = DialogItems[NDI_SetRegExp    -OffsetUp].Selected;
   
     if( DialogItems[NDI_FromCursor].Selected      ) _esr->FromSearch = 0;
     else if( DialogItems[NDI_Global].Selected     ) _esr->FromSearch = NDI_Global - NDI_FromCursor;
     else if( DialogItems[NDI_SelText].Selected    ) _esr->FromSearch = NDI_SelText - NDI_FromCursor;
     else _esr->FromSearch = 0;

     strncpy( StrTmp, DialogItems[NDI_EditSearch].Data, LenSearchStr );
  }
  else{
     ExitCode = NDI_ButtonSearch;
     strncpy( StrTmp, _esr->SearchStr, LenSearchStr );
  }

  if ( ExitCode == NDI_ButtonSearch || ExitCode == NDI_ButtonCount ){ // ""  ""

     if( !Mode ) SetRegExtSearch( _esr ); 

     _esr->WasReplace = 0; 

     strncpy( _esr->SearchStr, StrTmp, LenSearchStr );
     SetRegKey(HKEY_CURRENT_USER,"","SearchStr"    ,_esr->SearchStr    );

     SetSearchStr_Buffers( _esr );//AV 09.12.99

     _esr->NumFindForReplace = 0;
     _esr->NumCount = 0;
     _esr->AllProc = 0;//AV 10.12.99

     _esr->Replace = 0;
     _esr->ContinueSearch = 0;

     if(ExitCode == NDI_ButtonSearch)
        find = ProcSearch( _esr );  
     else{
        int BegPos  = _esr->ei.CurPos;
        int BegLine = _esr->ei.CurLine;
        CountSearch( _esr );
        SetEditorPosition( _esr, BegLine, BegPos, 0, 0, _esr->ReverseSearch );
     }
  }
  return find; 
}

struct ExtFileInfo{
   char Path[1024];
   char IsDir;
}ExtFileInfo;


static const char *_MExtSearchTitle, *_MProcSearch, *_MProcFinishSearch;
static char _Find[256];

//易⥫쭮 맢 ।  ᯮ짮  MessInfoSearch
static void InitMessInfoSearch( void ){
   *_Find = '\0';
   strcpy( _Find, GetMsg( MFindInfo ) ); strcat( _Find, " %ld  " );
   //strcat( _Find, GetMsg( MProcInfo ) ); strcat( _Find, " %ld" );
   strcat( _Find, GetMsg( MProcSearch ) ); 

   _MExtSearchTitle   = GetMsg(MExtSearchTitle);
   _MProcSearch       = GetMsg(MProcSearch);
   _MProcFinishSearch = GetMsg(MProcFinishSearch);
}

//ଠ樮 ᮮ饭  ६ ᪠  䠩 ( ப   १⠬)
#pragma argsused
static void MessInfoSearch( ExtSearchReg *_esr, int NumFind, int NumProc, int Finish ){
   if( !Finish )
      sprintf( _esr->MenuBottom, _Find, NumFind/*, NumProc*/ );
   else
      sprintf( _esr->MenuBottom, _MProcFinishSearch, NumFind );
}

inline void SetMenuItemFile( struct FarMenuItem *mi, struct ExtFileInfo *fi, char *FilePath, struct ffblk *ff ){
   char fSize[19];
   ftime *t = (ftime *)&ff->ff_ftime;
   unsigned year = t->ft_year;
   if( year < 20 ) year += 80;
   else year -= 20;

   sprintf( mi->Text, "%3s%-49s   %02d.%02d.%02d   %02d:%02d", "   ", ff->ff_name, t->ft_day, t->ft_month, year, t->ft_hour, t->ft_min ); 
   strncpy( fi->Path, FilePath, 1024 ); 
   fi->IsDir = 0;
}

inline void SetMenuItemDir( struct FarMenuItem *mi, struct ExtFileInfo *fi, char *Path ){
   sprintf( mi->Text, "%-70s", Path );  
   strncpy( fi->Path, Path, 1024 ); 
   fi->IsDir = 1;
}

inline void SetMenuItemDelim( struct FarMenuItem *mi, struct ExtFileInfo *fi ){
   memset( (void*)mi->Text, ' ', 70 );  
   strcpy( fi->Path, "" ); 
   fi->IsDir = 2;
}

//஢ઠ:      - ff_name 뤥
static bool IsSelItem( ExtSearchReg *_esr, char *ff_name ){
   struct PluginPanelItem *ppi;
   for( int i = 0; i < _esr->SelItemsNumber; i++ ){
      ppi = (_esr->SelItems + i);
      //if( ppi->FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ){
         if( !strcmpi( ff_name, ppi->FindData.cFileName ) )  return true;
      //}
   }
   return false;
}

static void ProcFiles( ExtSearchReg *_esr, char *Path, int rec )
{
  int    SetDir = 0;                          
  struct ffblk  ff;//ଠ  ⥪饬 "" 䠩
  char   TmpPath[MAXPATH];
  HANDLE hScreen;

  strcpy( TmpPath, Path );
  strcat( TmpPath, "\\" );
  strcat( TmpPath, /*_esr->MaskStr*/"*.*" ); //஢ઠ  ᪨ 믮  CheckMasks

  int loop;

  if( _esr->PressESC == true ) 
      return;
 
  if( _esr->CheckESC && CheckForEsc() == true )
  {
      _esr->PressESC = true;
      return; 
  }    

  if( !rec ){
     hScreen = ExtSearchInfo.SaveScreen( 0, 0, -1, -1 );

     const char *MsgItems[]={ GetMsg(MExtSearchTitle), GetMsg(MExtScanning) };
     ExtSearchInfo.Message(ExtSearchInfo.ModuleNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),0);
  }


     loop = findfirst( TmpPath, &ff, FA_DIREC );
   
     while( !loop ) {
  
       // ய᪠ ᠬ ⠫   㦥 ⠫
       if( !(ff.ff_attrib & FA_LABEL) && strcmp( ff.ff_name, "." ) && strcmp( ff.ff_name, ".." ) ){
   
          if( !(ff.ff_attrib & FA_DIREC) && !_esr->OnlySearchFile ){ 

             //᫨  孥 ஢, ஢ઠ  뤥 䠩
             if( !rec && _esr->SearchFromDir == SIFKind_SelDir && IsSelItem( _esr, ff.ff_name ) == false ){
                loop = findnext( &ff );            
                continue;
             }
   
             _esr->fNumProc++;
             MessInfoSearch( _esr, _esr->fNumFindFiles, _esr->fNumProc, 0 );
   
             if( CheckMasks( _esr, ff.ff_name) ){  
     
                  strcpy( _esr->FilePath, Path );
                  strcat( _esr->FilePath, "\\" );
                  strcat( _esr->FilePath, ff.ff_name );
     
                  //稢 䠩, ⮫쪮 ᫨ ப ᪠  
                  if( *_esr->SearchStr && File2StringBuff( _esr, _esr->FilePath, &_esr->StringBuff, &_esr->LenCurStr ) == false ){
                     loop = findnext( &ff );
                     continue; //ய᪠  䠩, த ࠡ :)
                  }
                    
                  if( (_esr->ExitCode == NFI_ButtonSearch) || (_esr->Replace && _esr->ExitCode == NRFI_ButtonReplace) ){
                     if( !*_esr->SearchStr || ProcFileSearch( _esr ) ){
   
                        _esr->fNumFindFiles++;
                        MessInfoSearch( _esr, _esr->fNumFindFiles, _esr->fNumProc, 0 );
  
                        // ᨢ    १⠬
                        if( !SetDir ){
                           if( _esr->fNumFind > (BEGSIZE_SEARCH_RES * _esr->NumBlocks ) ){

                              while( _esr->InMenu ){ /**/};
                              _esr->_mi = (struct FarMenuItem*)realloc( _esr->_mi, sizeof(struct FarMenuItem) * (_esr->fNumFind+BEGSIZE_SEARCH_RES) );
                              _esr->_fi = (struct ExtFileInfo*)realloc( _esr->_fi, sizeof(struct ExtFileInfo) * (_esr->fNumFind+BEGSIZE_SEARCH_RES) );                        
                              _esr->NumBlocks++;
                              memset( _esr->_mi+_esr->fNumFind, 0, sizeof(struct FarMenuItem) * BEGSIZE_SEARCH_RES );   
                              _esr->Realloc = 0;
                           }
                           struct FarMenuItem *cur_mi = _esr->_mi+_esr->fNumFind; 
                           struct ExtFileInfo *cur_fi = _esr->_fi+_esr->fNumFind;
   
                           if( _esr->fNumFind ){
                              SetMenuItemDelim( cur_mi, cur_fi );
                              SetMenuItemDir( cur_mi+1, cur_fi+1, Path );
                              SetMenuItemFile( cur_mi+2, cur_fi+2, _esr->FilePath, &ff );    
                              (_esr->fNumFind)+=3;        
                           }else{
                              SetMenuItemDir( cur_mi, cur_fi, Path );
                              SetMenuItemFile( cur_mi+1, cur_fi+1, _esr->FilePath, &ff );    
                              (_esr->fNumFind)+=2;        
                           }                        
                           SetDir = 1;
                        }else{ 
                           if( _esr->fNumFind > (BEGSIZE_SEARCH_RES * _esr->NumBlocks ) ){   

                              while( _esr->InMenu ) { /**/ };
                              _esr->_mi = (struct FarMenuItem*)realloc( _esr->_mi, sizeof(struct FarMenuItem) * (_esr->fNumFind+BEGSIZE_SEARCH_RES) );
                              _esr->_fi = (struct ExtFileInfo*)realloc( _esr->_fi, sizeof(struct ExtFileInfo) * (_esr->fNumFind+BEGSIZE_SEARCH_RES) );
                              _esr->NumBlocks++;
                              memset( _esr->_mi+_esr->fNumFind, 0, sizeof(struct FarMenuItem) * BEGSIZE_SEARCH_RES );      
                              _esr->Realloc = 0;
                           }   
                           struct FarMenuItem *cur_mi = _esr->_mi+_esr->fNumFind; 
                           struct ExtFileInfo *cur_fi = _esr->_fi+_esr->fNumFind; 
   
                           SetMenuItemFile( cur_mi, cur_fi, _esr->FilePath, &ff );
                           (_esr->fNumFind)++;
                        }
                     }
                  }
             }     
          }else if( !(ff.ff_attrib & FA_DIREC) && _esr->OnlySearchFile ){
              if( stricmp( _esr->OnlySearchFileName, ff.ff_name ) == 0 ){
                 strcpy( _esr->OnlySearchFileName, Path );
                 strcat( _esr->OnlySearchFileName, "\\" );
                 strcat( _esr->OnlySearchFileName, ff.ff_name );
                 _esr->OnlySearchFileTrue = 1;
                 return; //諨 䠩 - 室
              }
          }
       }

       //᫨    䠩, 뢠 稪    䠩
       if( _esr->Replace )  _esr->NumFindForReplace = 0;

       loop = findnext( &ff );
     }

  loop = findfirst( TmpPath, &ff, FA_DIREC );


  while( !loop ) {

    // ய᪠ ᠬ ⠫   㦥 ⠫
    if( !(ff.ff_attrib & FA_LABEL) && strcmp( ff.ff_name, "." ) && strcmp( ff.ff_name, ".." ) ){

       if( (ff.ff_attrib & FA_DIREC) && (_esr->SearchFromDir != SIFKind_OnlyCurDir) ){
         strcpy( TmpPath, Path );
         strcat( TmpPath, "\\" );
         strcat( TmpPath, ff.ff_name );

         //᫨  孥 ஢, ஢ઠ   ᪠  뤥 ⠫
         if( !rec && _esr->SearchFromDir == SIFKind_SelDir && IsSelItem( _esr, ff.ff_name ) == false ){
            loop = findnext( &ff );            
            continue;
         }

         ProcFiles( _esr, TmpPath, 1 );//४ᨢ 맮
       }
    }

    loop = findnext( &ff );
  }

  if( !_esr->OnlySearchFile )
     //ᮮ饭     襭 ᪠
     if( !rec )
        MessInfoSearch( _esr, _esr->fNumFindFiles, _esr->fNumProc, 1 );


  if( !rec && hScreen )
     ExtSearchInfo.RestoreScreen( hScreen );
}


static int GetNumItemInPanel( char *FileName, int *TopPanelItem ){
  struct PanelInfo pi;
  struct PluginPanelItem *ppi;
  ExtSearchInfo.Control( INVALID_HANDLE_VALUE, FCTL_GETPANELINFO, &pi );
  if( TopPanelItem ) *TopPanelItem = pi.TopPanelItem;

  for( int i = 0; i < pi.ItemsNumber; i++ ){  
     ppi = pi.PanelItems + i;
     if( !(ppi->FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
         && !strcmp( ppi->FindData.cFileName, FileName ) )
          return i;
  }
  return 0;
}

static void PreProcessMenu_Files( ExtSearchReg *_esr, int Replace ){
  SetRegExtSearch( _esr ); 

  SetSearchStr_Buffers( _esr );

  _esr->WasReplace = 0; 

  _esr->NumFindForReplace = 0;
  _esr->NumCount = 0;
  _esr->AllProc = 0;

  _esr->Replace = Replace;
  _esr->ContinueSearch = 0;

  _esr->fNumFind = 0; _esr->fNumProc = 0; _esr->fAllNumCount = 0; _esr->fNumFindFiles = 0;

  //ᮮ饭  ६ ᪠
  InitMessInfoSearch();
  MessInfoSearch( _esr, _esr->fNumFindFiles, _esr->fNumProc, 0 );

  _esr->NumBlocks = 1; //-  , 뤥  १ ᪠

  _esr->_mi = (struct FarMenuItem *)malloc( sizeof(struct FarMenuItem) * BEGSIZE_SEARCH_RES );
  _esr->_fi = (struct ExtFileInfo *)malloc( sizeof(struct ExtFileInfo) * BEGSIZE_SEARCH_RES );

  memset( _esr->_mi, 0, sizeof(struct FarMenuItem) * BEGSIZE_SEARCH_RES );
  memset( _esr->_mi->Text, ' ', 70 );  

  struct PanelInfo   pi;
  ExtSearchInfo.Control( INVALID_HANDLE_VALUE, FCTL_GETPANELINFO, (void*)&pi );
  strncpy( _esr->BegPath, pi.CurDir, MAXPATH-1 );

  //࠭ ଠ  뤥   
  if( _esr->SearchFromDir == SIFKind_SelDir ){
     _esr->SelItemsNumber = pi.SelectedItemsNumber;
     _esr->SelItems = (struct PluginPanelItem *)malloc( sizeof(struct PluginPanelItem) * _esr->SelItemsNumber );
     memcpy( _esr->SelItems, pi.SelectedItems, sizeof(struct PluginPanelItem) * _esr->SelItemsNumber );
  }

}

/***************************************************************************/
/*   楤 ࠡ⪨   ᪥\  䠩 +   䠩*/
/***************************************************************************/
#pragma argsused
static void ProcessMenu_Files( ExtSearchReg *_esr, int Replace ) {

  //믮塞 ४ᨢ 室 䠩  ᪮  ᥭ १⮢
  //    
  FillMasks( _esr );
  ProcFiles( _esr, _esr->BegPath, 0 );
  FreeMasks( _esr );

  int Num = 0, PrevNum = 0;

  int BreakKeys[4], BreakKeysNum = -1;
  BreakKeys[0] = VK_F3;
  BreakKeys[1] = VK_F4;
  BreakKeys[2] = VK_F2;
  BreakKeys[3] = 0;

  char fPath[MAXPATH];
  int  IsDir; 

  while( Num >= 0 ){

      IsDir = 0;

      (_esr->_mi+PrevNum)->Selected = false;
      (_esr->_mi+Num)->Selected = true;
      PrevNum = Num;

      Num = ExtSearchInfo.Menu(
       ExtSearchInfo.ModuleNumber,
       -1, -1, 25,
       FMENU_AUTOHIGHLIGHT,
       GetMsg( MExtSearchTitle ),
       _esr->MenuBottom,
       "Contents",
       BreakKeys,
       &BreakKeysNum,
       _esr->_mi,
       _esr->fNumFind > 25 ? _esr->fNumFind : 25
      );

      if( Num >= 0 && BreakKeysNum != 2 ){ //᫨ - ࠫ    ᮢ

         IsDir  = (_esr->_fi+Num)->IsDir;
         strcpy( fPath, (_esr->_fi+Num)->Path );
         if( IsDir == 2 ) continue; //ࠧ⥫  ᮡ⨥ ᮢ 
         if( BreakKeysNum <= 1 && Num >= _esr->fNumFind ) continue;//஡ᨬ   

      }

      if( Num >= 0 ){

         if( !IsDir && BreakKeysNum != -1 ){

            if( BreakKeysNum == 1 ){  //F4 - ।஢ 

               ExtSearchInfo.Editor(
                fPath,
                 NULL,                                
                 0,
                 0,
                 -1,
                 -1,
                 0,                                     
                 0,
                 1
               );
            }
            else if( BreakKeysNum == 0 ){ //F3 - ᬮ

               ExtSearchInfo.Viewer (
                 fPath,
                 NULL,
                 0,
                 0,
                 -1,
                 -1,
                 VF_NONMODAL|VF_ENABLE_F6
                  ); 
            }
         }
         else if( BreakKeysNum == -1 ){ //Enter - 室  ४                                     

            char Path[MAXPATH], FileName[MAXPATH];
            memset( Path, 0, MAXPATH );
            memset( FileName, 0, MAXPATH );
            if( !IsDir ){
               char *ptr = fPath, *save = NULL;
               while( (ptr = strstr( ptr, "\\" )) != NULL ){
                  save = ptr;
                  ptr++;
               }
               if( save ){
                  strncpy( Path, fPath, save - fPath );
                  strcpy( FileName, save+1 );
               }else{
                  strcpy( Path, fPath );
                  strcpy( FileName, fPath );
               }
            }else strcpy( Path, fPath ); 
               
            _esr->SetDir = 1;

            ExtSearchInfo.Control( INVALID_HANDLE_VALUE, FCTL_SETPANELDIR, Path );
            if( IsDir )   ExtSearchInfo.Control( INVALID_HANDLE_VALUE, FCTL_REDRAWPANEL, NULL );
            else{
               struct PanelRedrawInfo pri;
               pri.CurrentItem  = GetNumItemInPanel( FileName, &pri.TopPanelItem );
               pri.TopPanelItem = 0;
               ExtSearchInfo.Control( INVALID_HANDLE_VALUE, FCTL_REDRAWPANEL, &pri );
               _esr->SetDir = 0;
            }  
            break;
         }
      }
  }          

     
  if( _esr->_mi ){ free( _esr->_mi ); _esr->_mi = NULL; }
  if( _esr->_fi ){ free( _esr->_fi ); _esr->_fi = NULL; }

}

//***************************************************************************
//  䥩᭠  ᪠  䠩
//***************************************************************************
static void RunSearchInFile( ExtSearchReg *_esr )
{

  for( ;; ){
     int SizeX, AddrHistory, AddrMaskHistory;
   
     GetRegExtSearch( _esr ); 
   
     //AV 16.12.99 ᬥ饭   
     int OffsetDn = 0, OffsetUp = 0;
     if( _esr->UpSetRegExp ){
        OffsetDn = CHECKBOX_MOVE_DN;
        OffsetUp = CHECKBOX_MOVE_UP - 1;
     }
   
    PreProcessSearch( _esr, &SizeX, &AddrHistory, NULL, &AddrMaskHistory );       
   
    char TableName[53];
    memset( (void*)TableName, 0, 53 );
    *TableName = '[';
    GetTableName( _esr, _esr->CodeTableSearchInFile, TableName+1, 50 );
    *(TableName+strlen(TableName)) = ']';

     //樠   ᪠
     struct InitDialogItem InitItems[]={
        {DI_DOUBLEBOX,WidthUnderSide,1,SizeX-WidthUnderSide-1,4,0,0,0,0,""},
        {DI_DOUBLEBOX,WidthUnderSide,1,SizeX-WidthUnderSide-1,11,0,0,0,0,""},
        {DI_DOUBLEBOX,WidthUnderSide,1,SizeX-WidthUnderSide-1,BottomSearchInFileDialog-WidthUnder,0,0,0,0,(char *)MExtSearchTitle},
        {DI_TEXT,WidthUnderSide,4,0,0,0,0,DIF_BOXCOLOR,0,""},                 
        {DI_TEXT,SizeX-WidthUnderSide-1,4,0,0,0,0,DIF_BOXCOLOR,0,""},
        {DI_TEXT,WidthUnderSide+2,2,0,0,0,0,DIF_BOXCOLOR,0,(char *)MStrForMask},
        {DI_EDIT,WidthUnderSide+2,3,SizeX-WidthUnderSide-3,0,true,AddrMaskHistory,DIF_HISTORY,0, _esr->MaskStr },
        {DI_TEXT,WidthUnderSide+2,5,0,0,0,0,DIF_BOXCOLOR,0,(char *)MStrForSearch},
        {DI_TEXT,WidthUnderSide+2+12,5,0,0,0,0,DIF_BOXCOLOR,0,(char *)TableName},
        {DI_EDIT,WidthUnderSide+2,6,SizeX-WidthUnderSide-3,0,0,AddrHistory,DIF_HISTORY,0, _esr->SearchStr },
        {DI_TEXT,WidthUnderSide+2,7,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,""},
        {DI_CHECKBOX,WidthUnderSide+2,8,0,0,0,0,0,0,(char *)MCaseSensitive},
        {DI_CHECKBOX,WidthUnderSide+2,9,0,0,0,0,0,0,(char *)MWordSearch},
        {DI_CHECKBOX,WidthUnderSide+2,10,0,0,0,0,0,0,(char *)MSetRegExp},
        {DI_CHECKBOX,WidthUnderSide+2+25,8,0,0,0,0,0,0,(char *)MLinkSystem},
   
        {DI_TEXT,WidthUnderSide,11,0,0,0,0,DIF_BOXCOLOR,0,""},                 
        {DI_TEXT,SizeX-WidthUnderSide-1,11,0,0,0,0,DIF_BOXCOLOR,0,""},
        {DI_RADIOBUTTON, WidthUnderSide+2,12,0,0,0,0,DIF_GROUP,0,(char *)MFromCurDir},         
        {DI_RADIOBUTTON, WidthUnderSide+2,13,0,0,0,0,0,0,(char *)MOnlyCurDir},         
        {DI_RADIOBUTTON, WidthUnderSide+2,14,0,0,0,0,0,0,(char *)MSelDir},
        {DI_TEXT,WidthUnderSide+2,15,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,""},
   
        {DI_BUTTON,0,BottomSearchInFileDialog-WidthUnder-1,0,0,0,0,DIF_CENTERGROUP,1,(char *)MSearch},
        {DI_BUTTON,0,BottomSearchInFileDialog-WidthUnder-1,0,0,0,0,DIF_CENTERGROUP,0,(char *)MTables},
        {DI_BUTTON,0,BottomSearchInFileDialog-WidthUnder-1,0,0,0,0,DIF_CENTERGROUP,0,(char *)MCancel}
     };                                            

     //믮  ᪠
     struct FarDialogItem DialogItems[sizeof(InitItems)/sizeof(InitItems[0])];
     InitDialogItems(InitItems,DialogItems,sizeof(InitItems)/sizeof(InitItems[0]), _esr->UpSetRegExp, SearchInFileTypeDialog );
   
     DialogItems[NFI_CaseSensitive+OffsetDn].Selected = _esr->CaseSensitive;
     DialogItems[NFI_WordSearch   +OffsetDn].Selected = _esr->WordSearch;
     DialogItems[NFI_LinkSystem   ].Selected = _esr->LinkSystem;
     DialogItems[NFI_SetRegExp    -OffsetUp].Selected = _esr->SetRegExp;

     if( _esr->SearchFromDir == SIFKind_FromCurDir )
        DialogItems[NFI_FromCurDir].Selected = true;
     else if( _esr->SearchFromDir == SIFKind_OnlyCurDir )
        DialogItems[NFI_OnlyCurDir].Selected = true;
     else if( _esr->SearchFromDir == SIFKind_SelDir )
        DialogItems[NFI_SelDir].Selected = true;
     else
        DialogItems[NFI_FromCurDir].Selected = true;


     _esr->ExitCode=ExtSearchInfo.Dialog(ExtSearchInfo.ModuleNumber,-1,-1, SizeX,BottomSearchInFileDialog,Help_ExtSearch,DialogItems,
                              sizeof(DialogItems)/sizeof(DialogItems[0]));
    
     _esr->CaseSensitive = DialogItems[NFI_CaseSensitive+OffsetDn].Selected;
     _esr->WordSearch    = DialogItems[NFI_WordSearch   +OffsetDn].Selected;
     _esr->LinkSystem    = DialogItems[NFI_LinkSystem   ].Selected;
     _esr->SetRegExp     = DialogItems[NFI_SetRegExp    -OffsetUp].Selected;   

     if( DialogItems[NFI_FromCurDir].Selected == true ) _esr->SearchFromDir = SIFKind_FromCurDir;
     if( DialogItems[NFI_OnlyCurDir].Selected == true ) _esr->SearchFromDir = SIFKind_OnlyCurDir;
     if( DialogItems[NFI_SelDir].Selected == true )     _esr->SearchFromDir = SIFKind_SelDir;
   
     if ( _esr->ExitCode == NFI_ButtonSearch ){ // "" 

        strncpy( _esr->SearchStr, DialogItems[NFI_EditSearch].Data, LenSearchStr );
        SetRegKey(HKEY_CURRENT_USER,"","SearchStr"    ,_esr->SearchStr    );
       
        strncpy( _esr->MaskStr, DialogItems[NFI_MaskStr].Data, LenSearchStr );
        SetRegKey(HKEY_CURRENT_USER,"","MaskStr"    ,_esr->MaskStr    );

        PreProcessMenu_Files( _esr, 0 );
        ProcessMenu_Files( _esr, 0 );

     }
     else if( _esr->ExitCode == NFI_ButtonTables ){//⠭ ⠡  ன ᪠
        _esr->CodeTableSearchInFile = ChoiceFromCodeTablesMenu( _esr );
        if( _esr->CodeTableSearchInFile >= -1 ) 
           SetRegKey(HKEY_CURRENT_USER,"","CodeTableSearchInFile",_esr->CodeTableSearchInFile);
        continue;
     }
     break; //室  横
  }
}

// ᫥ ᪠  ப ᮤঠ饩 ७ \n
static int GetLenLastStr( char *MultiStr ){   
   char *Pos, *BegStr = MultiStr;
   for(;;){

      if( (Pos = strchr( MultiStr, '\n' )) != NULL ) 
         MultiStr = Pos+1;                         
      else  break;
   }

   return  (strlen(BegStr) - (MultiStr - BegStr));
}

// ப   \r  \n
static int ExtLenStr( char *Str ){   
   char *Pos;

   if( (Pos = strchr( Str, '\r' )) != NULL || (Pos = strchr( Str, '\n' )) != NULL  ){
      *Pos = '\0';
      return strlen( Str );
   }
   else return strlen( Str ); 
}

//ᮤন  ப ਧ  ப  ᪥  ॣᯠ
static RX_ConsistStrEOL( char *Str ){
   if( strstr( Str, "\n" ) != NULL ) 
      return 1;
   else
      return 0;
}
//***************************************************************************
//  
//***************************************************************************
void ReplaceText( ExtSearchReg *_esr, char *_ConvertReplace ){

   int LenStrReplace = strlen( _ConvertReplace );
   int EndAdd = 0;//ਧ    ப( 塞, 稭  \r  \n)

   char *TmpReplaceStr = (char*)malloc( _esr->LenCurStr + LenStrReplace + 1);
   char *TmpReplaceStrPtr = TmpReplaceStr;

   char *TmpAddStr     = (char*)malloc( _esr->LenCurStr + LenStrReplace + 1 );


   *TmpReplaceStr = '\0';
   *TmpAddStr     = '\0';

   EditorGetString edgs;

   edgs.StringNumber = -1;
   ExtSearchInfo.EditorControl( ECTL_GETSTRING, (void*)&edgs );

   strncpy( TmpReplaceStr, edgs.StringText, _esr->ei.CurPos );
   *(TmpReplaceStr + _esr->ei.CurPos) = '\0';
   strcat( TmpReplaceStr, _ConvertReplace );

   //AV 22.12.99 ⥯ ᬥ饭  १  _esr->FindStr
   int OffsetToLastPartStr = _esr->ei.CurPos + strlen( _esr->FindStr ) ; 

   //AV 08.12.99 ᫨ ᬥ饭 ॢᨫ  ப
   if( OffsetToLastPartStr > edgs.StringLength ){
      EndAdd = 1;
      OffsetToLastPartStr = edgs.StringLength;           
   }
      
   strcat( TmpReplaceStr, (edgs.StringText + OffsetToLastPartStr) );
    
   EditorSetString edss;
   edss.StringEOL    = NULL;

   //AV 11.11.99  ᨬ \n  ᪥  ॣᯠ - ᫨ﭨ ப
   if( _esr->SetRegExp ){

      if( RX_ConsistStrEOL( _esr->FindStr ) || EndAdd ){

         edgs.StringNumber = _esr->ei.CurLine+1;
   
         if( _esr->ei.CurLine < (_esr->ei.TotalLines-1) && ExtSearchInfo.EditorControl( ECTL_GETSTRING, (void*)&edgs ) == true ){
            TmpAddStr      = (char*)realloc( TmpAddStr,     edgs.StringLength + 1 );
            TmpReplaceStr  = (char*)realloc( TmpReplaceStr,    _esr->LenCurStr + LenStrReplace + 1 + edgs.StringLength + 10 );
            TmpReplaceStrPtr = TmpReplaceStr;

            strncpy( TmpAddStr, edgs.StringText, edgs.StringLength + 1 );

            if( ExtSearchInfo.EditorControl( ECTL_DELETESTRING, NULL ) == true ){
               edgs.StringNumber =  -1;
               ExtSearchInfo.EditorControl( ECTL_GETSTRING, (void*)&edgs );
               strcat( TmpReplaceStr, TmpAddStr );                            
            }
          }
      }

      //᫨  ப- ᨬ ७, ࠧ ப   ᪮쪮  ⠢塞 
      char *PosNewStr;
      int Del = 0;
      while( *TmpReplaceStr && ( (PosNewStr = strchr(TmpReplaceStr, '\r' )) != NULL || (PosNewStr = strchr(TmpReplaceStr, '\n' )) != NULL ) ){

         //塞 ப  ࠧ  ப
         Del = 1;
         edss.StringNumber = _esr->ei.CurLine++;
         edss.StringLength = ExtLenStr(TmpReplaceStr);
         *(TmpReplaceStr + edss.StringLength) = '\0';
         *PosNewStr = '\0';
         edss.StringText   = TmpReplaceStr;    
         ExtSearchInfo.EditorControl( ECTL_SETSTRING, (void*)&edss );

         TmpReplaceStr = ++PosNewStr; 
         if( *PosNewStr == '\n' ) TmpReplaceStr++;

         edgs.StringNumber =  edss.StringNumber;
         ExtSearchInfo.EditorControl( ECTL_GETSTRING, (void*)&edgs );

         //⠢  ⮩ ப         
         SetEditorPosition( _esr, edss.StringNumber, edgs.StringLength, 0, 1, _esr->ReverseSearch );
         ExtSearchInfo.EditorControl( ECTL_INSERTSTRING, NULL );

      }

      if( Del ){
         // ᫥ ⠢ ᪠ 
         LenStrReplace =  GetLenLastStr( _ConvertReplace );
         _esr->ei.CurPos = 0;
         SetEditorPosition( _esr, _esr->ei.CurLine, _esr->ei.CurPos, 0, 1, _esr->ReverseSearch );
      } 
   }
   edss.StringText   = TmpReplaceStr;    
   edss.StringLength = strlen(TmpReplaceStr);
   edss.StringNumber = _esr->ei.CurLine; 
   edss.StringEOL    = "";

   ExtSearchInfo.EditorControl( ECTL_SETSTRING, (void*)&edss );

   //AV 16.11.99   
   _esr->LenStrReplace = LenStrReplace;

   if( TmpReplaceStrPtr ) free( TmpReplaceStrPtr );
   if( TmpAddStr        ) free( TmpAddStr        );
}

//***************************************************************************
//  롮 ਠ 
//***************************************************************************
static int MakeChoiceForReplace( char *TmpSearchStr, char *TmpReplaceStr, ExtSearchReg *_esr ){

      int SizeX;

      if( !_esr->SearchInFile ){
         //। ਭ   ᨬ  ࠧ  ।
         if( _esr->ei.WindowSizeX > 80 ) SizeX = _esr->ei.WindowSizeX - BeforeLeft; 
         else SizeX = DefSizeX;
      }
      else SizeX = DefSizeX;
      //

     //樠  
     struct InitDialogItem InitItems[]={
        {DI_DOUBLEBOX,WidthUnderSide,1,SizeX-WidthUnderSide-1,BottomChoiceReplaceDialog-WidthUnder,0,0,0,0,(char *)MExtReplaceTitle},
        {DI_TEXT,WidthUnderSide+2,2,0,0,0,0,DIF_BOXCOLOR,0,(char *)MReplace2},
        {DI_EDIT,WidthUnderSide+2,3,SizeX-WidthUnderSide-3,0,0,0,DIF_BOXCOLOR,0,TmpSearchStr },
        {DI_TEXT,WidthUnderSide+2,4,0,0,0,0,DIF_BOXCOLOR,0,(char *)MWith},
        {DI_EDIT,WidthUnderSide+2,5,SizeX-WidthUnderSide-3,0,0,0,DIF_BOXCOLOR,0,TmpReplaceStr },   
        {DI_TEXT,WidthUnderSide+2,6,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,""},  

        {DI_BUTTON,0,BottomChoiceReplaceDialog-WidthUnder-1,0,0,true,0,DIF_CENTERGROUP,1,(char *)MReplace},
        {DI_BUTTON,0,BottomChoiceReplaceDialog-WidthUnder-1,0,0,0,0,DIF_CENTERGROUP,0,(char *)MAll},
        {DI_BUTTON,0,BottomChoiceReplaceDialog-WidthUnder-1,0,0,0,0,DIF_CENTERGROUP,0,(char *)MSkip},
        {DI_BUTTON,0,BottomChoiceReplaceDialog-WidthUnder-1,0,0,0,0,DIF_CENTERGROUP,0,(char *)MCancel}
     };
   
     //믮  ᪠
     struct FarDialogItem DialogItems[sizeof(InitItems)/sizeof(InitItems[0])];
     InitDialogItems(InitItems,DialogItems,sizeof(InitItems)/sizeof(InitItems[0]) );
   
     return ExtSearchInfo.Dialog(ExtSearchInfo.ModuleNumber,-1,-1, SizeX,BottomChoiceReplaceDialog,Help_ExtSearch,DialogItems,
                              sizeof(DialogItems)/sizeof(DialogItems[0]));
}

//***************************************************************************
//  楤 롮 ०  
//***************************************************************************
static int ProcReplace( ExtSearchReg *_esr ){

   _esr->Replace = 1;
   _esr->ContinueSearch = false; 

   _esr->WasReplace = 1; //AV 30.03.00  ० த 

   while( ProcSearch( _esr ) == true ){  
      int Choice = 0, Skip = 0;

      if( !_esr->AllProc ){      

         char TmpSearchStr[LenSearchStr];
         strncpy( TmpSearchStr, _esr->FindStr, LenSearchStr-1 );

         char TmpReplaceStr[LenSearchStr];

         if( !_esr->SetRegExp )
            strncpy( TmpReplaceStr, _esr->ConvertReplace, LenSearchStr-1 );
         else{
            strncpy( TmpReplaceStr, _esr->RXConvertReplace, LenSearchStr-1 );
         }

         ConvertToOEM( _esr, TmpReplaceStr, LenSearchStr );//AV 16.11.99

         Choice = MakeChoiceForReplace( TmpSearchStr, TmpReplaceStr, _esr );

         //⠭ ࠭ ⠭⭮ 뤥
         if( _esr->SetSelect )
            SetStandardSelect( _esr, 1 );
         //

      }
                    
      switch( Choice ){  
  
         case -1: //Cancel
           return -1;

         case NCRI_ButtonReplace:  //Replace
           break;
   
         case NCRI_ButtonAll:{  //All
           if( !_esr->AllProc ){
              const char *MsgItems[]={ GetMsg(MExtReplaceTitle), GetMsg(MProcReplace) };
              ExtSearchInfo.Message(ExtSearchInfo.ModuleNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),0);
           }
           _esr->AllProc = 1;                                                                        
         }
         break;
   
         case NCRI_ButtonSkip:  //Skip
           Skip = 1;
           _esr->NumFindForReplace--;
           //AV 07.08.00 ..   뫮  ᫥騩  稭   ।饣  ᫮ 
           _esr->LenStrReplace = _esr->LenStrSearchTmp; 
           break;
   
         case NCRI_ButtonCancel:  //Cancel
           return -1;             
      }
      
      ExtSearchInfo.EditorControl( ECTL_GETINFO, &_esr->ei );
      if( !Skip ){
         _esr->SetSelect = true;
         if( !_esr->SetRegExp ) ReplaceText( _esr, _esr->ConvertReplace );
         else                  ReplaceText( _esr, _esr->RXConvertReplace );

         ExtSearchInfo.EditorControl( ECTL_GETINFO, &_esr->ei );                                                         
         _esr->ei_save = _esr->ei; //  ⠭ 樨 ᫥ 
      }

      _esr->ContinueSearch = true; 
  }

  if( _esr->NumFindForReplace ){
     struct EditorSetPosition esp;    

     _esr->ei = _esr->ei_save;

     //⠭  ᫥ , ..    㦥 堫
     esp.CurLine=_esr->ei.CurLine;
     esp.CurPos=_esr->ei.CurPos;
     esp.TopScreenLine=_esr->ei.TopScreenLine;
     esp.LeftPos=_esr->ei.LeftPos;
     esp.CurTabPos=-1;
     esp.Overtype=-1;
     ExtSearchInfo.EditorControl(ECTL_SETPOSITION,&esp); 

     if( _esr->SetSelect && _esr->LenStrReplace ){
        if( _esr->FromSearch != 2 ){
           SetEditorPosition( _esr, _esr->ei.CurLine, _esr->ei.CurPos, 1, 0, _esr->ReverseSearch );
           Select( _esr, _esr->ei.CurLine, _esr->ei.CurPos, _esr->LenStrReplace );
        }else if( _esr->FromSearch == 2 )  
           SetStandardSelect( _esr, 1 );//⠭ ࠭ ⠭⭮ 뤥
     }

     if( _esr->AllProc ){

        char StrMade[80];
   
        sprintf( StrMade, "%s %ld", GetMsg(MReplacesMade), _esr->NumFindForReplace );
   
        const char *MsgItems[]={ GetMsg(MExtReplaceTitle), StrMade, GetMsg(MOk) };

        ExtSearchInfo.EditorControl( ECTL_REDRAW, NULL );//㥬  ।
   
        ExtSearchInfo.Message(ExtSearchInfo.ModuleNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
     }
  }


  return -1;
}
//***************************************************************************
//  䥩᭠  ᪠  
//***************************************************************************
static void RunSearchAndReplace( ExtSearchReg *_esr )
{

  int SizeX, AddrHistory, AddrReplaceHistory;


  GetRegExtSearch( _esr );

  //AV 16.12.99 ᬥ饭   
  int OffsetDn = 0, OffsetUp = 0;
  if( _esr->UpSetRegExp ){
     OffsetDn = CHECKBOX_MOVE_DN;
     OffsetUp = CHECKBOX_MOVE_UP;
  }  

  PreProcessSearch( _esr, &SizeX, &AddrHistory, &AddrReplaceHistory, NULL );       

  //樠   ᪠
  struct InitDialogItem InitItems[]={
     {DI_DOUBLEBOX,WidthUnderSide,1,SizeX-WidthUnderSide-1,BottomReplaceDialog-WidthUnder,0,0,0,0,(char *)MExtReplaceTitle},
     {DI_TEXT,WidthUnderSide+2,2,0,0,0,0,DIF_BOXCOLOR,0,(char *)MStrForSearch},
     {DI_EDIT,WidthUnderSide+2,3,SizeX-WidthUnderSide-3,0,true,AddrHistory,DIF_HISTORY,0, _esr->SearchStr },
     {DI_TEXT,WidthUnderSide+2,4,0,0,0,0,DIF_BOXCOLOR,0,(char *)MStrForReplace},
     {DI_EDIT,WidthUnderSide+2,5,SizeX-WidthUnderSide-3,0,0,AddrReplaceHistory,DIF_HISTORY,0, _esr->ReplaceStr },
     {DI_TEXT,WidthUnderSide,6,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,""},
     {DI_CHECKBOX,WidthUnderSide+2,7,0,0,0,0,0,0,(char *)MCaseSensitive},
     {DI_CHECKBOX,WidthUnderSide+2,8,0,0,0,0,0,0,(char *)MWordSearch},
     {DI_CHECKBOX,WidthUnderSide+2,9,0,0,0,0,0,0,(char *)MReverseSearch},
     {DI_CHECKBOX,WidthUnderSide+2,10,0,0,0,0,0,0,(char *)MSetRegExp},
     {DI_CHECKBOX,WidthUnderSide+2+25,7,0,0,0,0,0,0,(char *)MPickUpWord},
     {DI_CHECKBOX,WidthUnderSide+2+25,8,0,0,0,0,0,0,(char *)MSelect},    
     {DI_CHECKBOX,WidthUnderSide+2+25,9,0,0,0,0,0,0,(char *)MLinkSystem},
     {DI_CHECKBOX,WidthUnderSide+2+25,10,0,0,0,0,0,0,(char *)MPutInClipBoard},
     {DI_TEXT,WidthUnderSide+2,11,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,""},
     {DI_RADIOBUTTON, WidthUnderSide+2,12,0,0,0,0,DIF_GROUP,0,(char *)MFromCursor},         
     {DI_RADIOBUTTON, WidthUnderSide+2,13,0,0,0,0,0,0,(char *)MGlobal},         
     {DI_RADIOBUTTON, WidthUnderSide+2,14,0,0,0,0, 0,0,(char *)MSelText},
     {DI_TEXT,WidthUnderSide+2,15,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,""},

      {DI_BUTTON,0,BottomReplaceDialog-WidthUnder-1,0,0,0,0,DIF_CENTERGROUP,1,(char *)MReplace},
      {DI_BUTTON,0,BottomReplaceDialog-WidthUnder-1,0,0,0,0,DIF_CENTERGROUP,0,(char *)MCancel}
   };
 
   //믮  ᪠
   struct FarDialogItem DialogItems[sizeof(InitItems)/sizeof(InitItems[0])];
   InitDialogItems(InitItems,DialogItems,sizeof(InitItems)/sizeof(InitItems[0]), _esr->UpSetRegExp, ReplaceTypeDialog );
 
   DialogItems[NRI_CaseSensitive+OffsetDn].Selected = _esr->CaseSensitive;
   DialogItems[NRI_ReverseSearch+OffsetDn].Selected = _esr->ReverseSearch;
   DialogItems[NRI_WordSearch   +OffsetDn].Selected = _esr->WordSearch;
   DialogItems[NRI_PickUpWord   ].Selected = _esr->PickUpWord;
   DialogItems[NRI_Select       ].Selected = _esr->SetSelect;
   DialogItems[NRI_LinkSystem   ].Selected = _esr->LinkSystem;
   DialogItems[NRI_SetRegExp    -OffsetUp].Selected = _esr->SetRegExp;
   DialogItems[NRI_PutInClipBoard].Selected = _esr->PutInClipBoard;
 
   DialogItems[NRI_FromCursor + _esr->FromSearch].Selected = 1;
 
   int ExitCode;

   for(;;){
      ExitCode=ExtSearchInfo.Dialog(ExtSearchInfo.ModuleNumber,-1,-1, SizeX,BottomReplaceDialog,Help_ExtReplace,DialogItems,
                            sizeof(DialogItems)/sizeof(DialogItems[0]));
      if( _esr->CheckEmptyReplace == true && DialogItems[NRI_EditReplace].Focus != true && DialogItems[NRI_ButtonReplace].Focus != true && ExitCode == NRI_ButtonReplace && !*DialogItems[NRI_EditReplace].Data ){
         DialogItems[NRI_EditSearch].Focus  = false;
         DialogItems[NRI_EditReplace].Focus = true;
         continue;
      }
      break;
   }
 
   _esr->CaseSensitive = DialogItems[NRI_CaseSensitive+OffsetDn].Selected;
   _esr->ReverseSearch = DialogItems[NRI_ReverseSearch+OffsetDn].Selected;
   _esr->WordSearch    = DialogItems[NRI_WordSearch   +OffsetDn].Selected;
   _esr->SetSelect     = DialogItems[NRI_Select       ].Selected;
   _esr->PickUpWord    = DialogItems[NRI_PickUpWord   ].Selected;
   _esr->LinkSystem    = DialogItems[NRI_LinkSystem   ].Selected;
   _esr->SetRegExp     = DialogItems[NRI_SetRegExp    -OffsetUp].Selected;
   _esr->PutInClipBoard= DialogItems[NRI_PutInClipBoard].Selected;
 
   if( DialogItems[NRI_FromCursor].Selected      ) _esr->FromSearch = 0;
   else if( DialogItems[NRI_Global].Selected     ) _esr->FromSearch = NRI_Global - NRI_FromCursor;
   else if( DialogItems[NRI_SelText].Selected    ) _esr->FromSearch = NRI_SelText - NRI_FromCursor;
   else _esr->FromSearch = 0;

   if ( ExitCode == NRI_ButtonReplace ){ // ""

      SetRegExtSearch( _esr ); 
 
      strncpy( _esr->SearchStr, DialogItems[NRI_EditSearch].Data, LenSearchStr );
      SetRegKey(HKEY_CURRENT_USER,"","SearchStr"    ,_esr->SearchStr    );
      strncpy( _esr->ReplaceStr, DialogItems[NRI_EditReplace].Data, LenSearchStr );
      SetRegKey(HKEY_CURRENT_USER,"","ReplaceStr"    ,_esr->ReplaceStr    );
      _esr->LenStrReplace = -1;
    
      //AV 02.11.99
      strcpy( _esr->ConvertReplace, _esr->ReplaceStr );
      ConvertFromOEM( _esr, _esr->ConvertReplace ); 
      //
 
      SetSearchStr_Buffers( _esr );//AV 09.12.99
 
      //
      _esr->AllProc = 0;
      _esr->NumFindForReplace = 0;
      _esr->NumCount = 0;
 
      ProcReplace( _esr );
 
   }
}


//***************************************************************************
//  䥩᭠    䠩
//***************************************************************************
static void RunReplaceInFile( ExtSearchReg *_esr )
{

  for( ;; ){
     int SizeX, AddrHistory, AddrMaskHistory, AddrReplaceHistory;
   
     GetRegExtSearch( _esr ); 
   
     //AV 16.12.99 ᬥ饭   
     int OffsetDn = 0, OffsetUp = 0;
     if( _esr->UpSetRegExp ){
        OffsetDn = CHECKBOX_MOVE_DN;
        OffsetUp = CHECKBOX_MOVE_UP - 1;
     }
   
    PreProcessSearch( _esr, &SizeX, &AddrHistory, &AddrReplaceHistory, &AddrMaskHistory );       
   
    char TableName[53];
    memset( (void*)TableName, 0, 53 );
    *TableName = '[';
    GetTableName( _esr, _esr->CodeTableSearchInFile, TableName+1, 50 );
    *(TableName+strlen(TableName)) = ']';

     //樠   ᪠
     struct InitDialogItem InitItems[]={
        {DI_DOUBLEBOX,WidthUnderSide,1,SizeX-WidthUnderSide-1,4,0,0,0,0,""},
        {DI_DOUBLEBOX,WidthUnderSide,1,SizeX-WidthUnderSide-1,13,0,0,0,0,""},
        {DI_DOUBLEBOX,WidthUnderSide,1,SizeX-WidthUnderSide-1,BottomReplaceInFileDialog-WidthUnder,0,0,0,0,(char *)MExtReplaceTitle},
        {DI_TEXT,WidthUnderSide,4,0,0,0,0,DIF_BOXCOLOR,0,""},                 
        {DI_TEXT,SizeX-WidthUnderSide-1,4,0,0,0,0,DIF_BOXCOLOR,0,""},
        {DI_TEXT,WidthUnderSide+2,2,0,0,0,0,DIF_BOXCOLOR,0,(char *)MStrForMask},
        {DI_EDIT,WidthUnderSide+2,3,SizeX-WidthUnderSide-3,0,true,AddrMaskHistory,DIF_HISTORY,0, _esr->MaskStr },
        {DI_TEXT,WidthUnderSide+2,5,0,0,0,0,DIF_BOXCOLOR,0,(char *)MStrForSearch},
        {DI_TEXT,WidthUnderSide+2+12,5,0,0,0,0,DIF_BOXCOLOR,0,(char *)TableName},
        {DI_EDIT,WidthUnderSide+2,6,SizeX-WidthUnderSide-3,0,0,AddrHistory,DIF_HISTORY,0, _esr->SearchStr },
        {DI_TEXT,WidthUnderSide+2,7,0,0,0,0,DIF_BOXCOLOR,0,(char *)MStrForReplace},
        {DI_EDIT,WidthUnderSide+2,8,SizeX-WidthUnderSide-3,0,0,AddrReplaceHistory,DIF_HISTORY,0, _esr->ReplaceStr },
        {DI_TEXT,WidthUnderSide+2,9,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,""},
        {DI_CHECKBOX,WidthUnderSide+2,10,0,0,0,0,0,0,(char *)MCaseSensitive},
        {DI_CHECKBOX,WidthUnderSide+2,11,0,0,0,0,0,0,(char *)MWordSearch},
        {DI_CHECKBOX,WidthUnderSide+2,12,0,0,0,0,0,0,(char *)MSetRegExp},
        {DI_CHECKBOX,WidthUnderSide+2+25,10,0,0,0,0,0,0,(char *)MLinkSystem},
   
        {DI_TEXT,WidthUnderSide,13,0,0,0,0,DIF_BOXCOLOR,0,""},                 
        {DI_TEXT,SizeX-WidthUnderSide-1,13,0,0,0,0,DIF_BOXCOLOR,0,""},
        {DI_RADIOBUTTON, WidthUnderSide+2,14,0,0,0,0,DIF_GROUP,0,(char *)MFromCurDir},         
        {DI_RADIOBUTTON, WidthUnderSide+2,15,0,0,0,0,0,0,(char *)MOnlyCurDir},         
        {DI_RADIOBUTTON, WidthUnderSide+2,16,0,0,0,0,0,0,(char *)MSelDir},
        {DI_TEXT,WidthUnderSide+2,17,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,""},
   
        {DI_BUTTON,0,BottomReplaceInFileDialog-WidthUnder-1,0,0,0,0,DIF_CENTERGROUP,1,(char *)MReplace},
        {DI_BUTTON,0,BottomReplaceInFileDialog-WidthUnder-1,0,0,0,0,DIF_CENTERGROUP,0,(char *)MTables},
        {DI_BUTTON,0,BottomReplaceInFileDialog-WidthUnder-1,0,0,0,0,DIF_CENTERGROUP,0,(char *)MCancel}
     };                                            

     //믮  ᪠
     struct FarDialogItem DialogItems[sizeof(InitItems)/sizeof(InitItems[0])];
     InitDialogItems(InitItems,DialogItems,sizeof(InitItems)/sizeof(InitItems[0]), _esr->UpSetRegExp, ReplaceInFileTypeDialog );
   
     DialogItems[NRFI_CaseSensitive+OffsetDn].Selected = _esr->CaseSensitive;
     DialogItems[NRFI_WordSearch   +OffsetDn].Selected = _esr->WordSearch;
     DialogItems[NRFI_LinkSystem   ].Selected = _esr->LinkSystem;
     DialogItems[NRFI_SetRegExp    -OffsetUp].Selected = _esr->SetRegExp;

     if( _esr->SearchFromDir == SIFKind_FromCurDir )
        DialogItems[NRFI_FromCurDir].Selected = true;
     else if( _esr->SearchFromDir == SIFKind_OnlyCurDir )
        DialogItems[NRFI_OnlyCurDir].Selected = true;
     else if( _esr->SearchFromDir == SIFKind_SelDir )
        DialogItems[NRFI_SelDir].Selected = true;
     else
        DialogItems[NRFI_FromCurDir].Selected = true;

     _esr->ExitCode=ExtSearchInfo.Dialog(ExtSearchInfo.ModuleNumber,-1,-1, SizeX,BottomReplaceInFileDialog,Help_ExtSearch,DialogItems,
                              sizeof(DialogItems)/sizeof(DialogItems[0]));
    
     _esr->CaseSensitive = DialogItems[NRFI_CaseSensitive+OffsetDn].Selected;
     _esr->WordSearch    = DialogItems[NRFI_WordSearch   +OffsetDn].Selected;
     _esr->LinkSystem    = DialogItems[NRFI_LinkSystem   ].Selected;
     _esr->SetRegExp     = DialogItems[NRFI_SetRegExp    -OffsetUp].Selected;   

     if( DialogItems[NRFI_FromCurDir].Selected == true ) _esr->SearchFromDir = SIFKind_FromCurDir;
     if( DialogItems[NRFI_OnlyCurDir].Selected == true ) _esr->SearchFromDir = SIFKind_OnlyCurDir;
     if( DialogItems[NRFI_SelDir].Selected == true )     _esr->SearchFromDir = SIFKind_SelDir;
   
     if ( _esr->ExitCode == NRFI_ButtonReplace ){ // "" 

        strncpy( _esr->SearchStr, DialogItems[NRFI_EditSearch].Data, LenSearchStr );
        SetRegKey(HKEY_CURRENT_USER,"","SearchStr"    ,_esr->SearchStr    );

        strncpy( _esr->ReplaceStr, DialogItems[NRFI_EditReplace].Data, LenSearchStr );
        SetRegKey(HKEY_CURRENT_USER,"","ReplaceStr"    ,_esr->ReplaceStr    );
       
        strncpy( _esr->MaskStr, DialogItems[NRFI_MaskStr].Data, LenSearchStr );
        SetRegKey(HKEY_CURRENT_USER,"","MaskStr"    ,_esr->MaskStr    );

        _esr->LenStrReplace = -1;
      
        //AV 02.11.99
        strcpy( _esr->ConvertReplace, _esr->ReplaceStr );
        ConvertFromOEM( _esr, _esr->ConvertReplace ); 
        //
        PreProcessMenu_Files( _esr, 1 );
        ProcessMenu_Files( _esr, 1 );

     }
     else if( _esr->ExitCode == NRFI_ButtonTables ){//⠭ ⠡  ன ᪠
        _esr->CodeTableSearchInFile = ChoiceFromCodeTablesMenu( _esr );
        if( _esr->CodeTableSearchInFile >= -1 ) 
           SetRegKey(HKEY_CURRENT_USER,"","CodeTableSearchInFile",_esr->CodeTableSearchInFile);
        continue;
     }
     break; //室  横
  }
}


             
static void ContinueSearch( ExtSearchReg *_esr )
{
  ExtSearchInfo.EditorControl( ECTL_GETINFO, &_esr->ei );
                   
   GetRegExtSearch( _esr ); 
                          
   _esr->NumFindForReplace = 0;
   _esr->NumCount = 0; 

   _esr->Replace = 0;
   _esr->ContinueSearch = 1;

   //AV 31.01.00
   _esr->ContinuePressDownKey  = 1;

   SetSearchStr_Buffers( _esr );//AV 09.12.99
 
   if( !_esr->WasReplace || _esr->NoContinueReplace )
      ProcSearch( _esr );  
   else
      ProcReplace( _esr );
}

static void ReverseSearch( ExtSearchReg *_esr )
{
  ExtSearchInfo.EditorControl( ECTL_GETINFO, &_esr->ei );
                                                               
  GetRegExtSearch( _esr ); 
 
  //AV 02.11.99 ᫨ ⥪ ⠭ "᪠ ।",  饬   
  _esr->ReverseSearch = (_esr->ReverseSearch == false) ? true : false;
 
  _esr->NumFindForReplace = 0;
  _esr->NumCount = 0;
 
  _esr->Replace = 0;
  _esr->ContinueSearch = 1; 

  //AV 31.01.00
  _esr->ContinuePressDownKey  = 1;
 
  SetSearchStr_Buffers( _esr );//AV 09.12.99
 
  if( !_esr->WasReplace || _esr->NoContinueReplace )
     ProcSearch( _esr ); 
  else 
     ProcReplace( _esr );  

}

//AV 01.12.99*********************************************************
//    ⮬ 
//AV 06.12.99 ࠫ ४
//********************************************************************
void CountSearch( ExtSearchReg *_esr ){

   _esr->Count = 1;

   bool (*Proc)( ExtSearchReg *_esr ) = !_esr->SearchInFile ? ProcSearch : ProcFileSearch;
   HANDLE hScreen = NULL;

   while( Proc( _esr ) == true ){

      if( !_esr->AllProc ){//AV 10.12.99 
         _esr->AllProc = 1;

         if( _esr->SearchInFile )
            hScreen = ExtSearchInfo.SaveScreen( 0, 0, -1, -1 );

         const char *MsgItems[]={ GetMsg(MExtSearchTitle), GetMsg(MProcCount) };
         ExtSearchInfo.Message(ExtSearchInfo.ModuleNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),0);
      }

      _esr->NumCount++;

      if( !_esr->SearchInFile )
         ExtSearchInfo.EditorControl( ECTL_GETINFO, &_esr->ei );

      _esr->ContinueSearch = true; 
   }

   if( _esr->SearchInFile && hScreen ) ExtSearchInfo.RestoreScreen( hScreen );

   if( _esr->NumCount ){

      if( !_esr->SearchInFile ){
         char StrMade[80];
    
         sprintf( StrMade, "%s %ld", GetMsg(MCountMade), _esr->NumCount );
      
         const char *MsgItems[]={ GetMsg(MExtSearchTitle), StrMade, GetMsg(MOk) };
      
         if( !_esr->SearchInFile )
            ExtSearchInfo.EditorControl( ECTL_REDRAW, NULL );//㥬  ।
      
         ExtSearchInfo.Message(ExtSearchInfo.ModuleNumber,0,NULL,MsgItems,sizeof(MsgItems)/sizeof(MsgItems[0]),1);
      }
   }

   _esr->Count = 0;
}

//஢  । ⠡
static void ConvertToTable( char *str, struct CharTableSet *table ){
   //᫨ ⠡ Windows Russia   Far  ⥪ ஢  WinRus, ४㥬  WinRus
    while( *str != 0 ) *str++ = table->EncodeTable[*str];
}

//  ⥬     
static int FindNumItems( struct PanelInfo *pi, char *FileName )
{
   PluginPanelItem *cur;
   for( int i = 0; i < pi->ItemsNumber; i++ )
   {
      cur = (pi->PanelItems + i);  
      if( !strcmp( cur->FindData.cFileName, FileName ) )
         return i;
   }
   return -1;
}

//********************************************************************
// ४஢ 堢   䠩
//********************************************************************
static void RecodeNameFiles( ExtSearchReg *_esr )
{
 struct PanelInfo pi;
 PluginPanelItem *cur;
 char *ReCodeFileNames[256];
 char FileName[MAX_PATH] = "";

 ExtSearchInfo.Control( INVALID_HANDLE_VALUE, FCTL_GETPANELINFO, &pi );
 cur = pi.PanelItems + pi.CurrentItem;  
 strcpy(FileName,cur->FindData.cFileName);    

 //ᨢ ⠡ ४஢ ࠥ   
 int i;
 for( i = 0; i <= _esr->MaxNumTable; i++ ){            
    ReCodeFileNames[i] = (char *)malloc(MAX_PATH);
    strcpy( ReCodeFileNames[i], FileName );
    ConvertToTable( ReCodeFileNames[i], &_esr->cts[i] );
 }
 if( i > 0 )
 {  
    struct FarMenuItem *MenuItems;
    MenuItems = (struct FarMenuItem *)malloc( sizeof(struct FarMenuItem) * i );
    memset( (void *)MenuItems, 0, sizeof(struct FarMenuItem) * i );
    for( int j = i-1; j >= 0; j--  )
       memcpy( (void *)((MenuItems+j)->Text), ReCodeFileNames[j], 70 );  

    int ret = ExtSearchInfo.Menu(
       ExtSearchInfo.ModuleNumber,
       -1, -1, 0,
       NULL,
       GetMsg( MExtRecodeTitle ),
       NULL,
       NULL,
       NULL,
       NULL,
       MenuItems, 
       i
    );

    if( ret >= 0 ){ //- ࠫ
       rename( cur->FindData.cFileName, ReCodeFileNames[ret] );
       ExtSearchInfo.Control( INVALID_HANDLE_VALUE, FCTL_UPDATEPANEL, NULL );
       ExtSearchInfo.Control( INVALID_HANDLE_VALUE, FCTL_GETPANELINFO, (void*)&pi );
       /*饬   䠩  */   
       int FindItem = FindNumItems( &pi, ReCodeFileNames[ret] );
       if( FindItem >= 0 ){
          struct PanelRedrawInfo pri;
          pri.CurrentItem   = FindItem;
          pri.TopPanelItem  = 0;
          /*move selection*/
          ExtSearchInfo.Control( INVALID_HANDLE_VALUE, FCTL_REDRAWPANEL, (void*)&pri );      
       }
    }
    //᢮ 
    for( i--; i >= 0; i-- )
      free( ReCodeFileNames[i] );
    free( MenuItems );
 }
  
}

//********************************************************************
//  室  訡, ᠭ  ⥪饩 ப 
//********************************************************************
static void GoToError( void )
{
   struct EditorGetString egs;
   egs.StringNumber = -1; // ⥪ ப
   ExtSearchInfo.EditorControl( ECTL_GETSTRING, &egs );

   if( egs.StringText ){

      int  NumTemplFileName   = GetRegKey(HKEY_CURRENT_USER,"","NumTemplFileName" , DefNumTemplFileName );
      int  NumTemplNumStr     = GetRegKey(HKEY_CURRENT_USER,"","NumTemplNumStr" , DefNumTemplNumStr );

      char TemplateGoToError[LenSearchStr];
      GetRegKey(HKEY_CURRENT_USER,"","TemplateGoToError", TemplateGoToError, DefTemplate, LenSearchStr );

      char *str = (char *)egs.StringText;
      SMatches match;
      PRegExp retest = new CRegExp;      
      retest->SetExpr( TemplateGoToError );
         
         char Number[18] = "";
         char FileName[1024] = "";

         //஢塞  室  䠩 訡
         bool retparse = retest->Parse( str, str, str + strlen(str), &match, NULL, -1 ); 
           
         if( retparse == true )
            if((match.s[0] < 0 || match.e[0] < 0) ||
               (match.s[NumTemplFileName] < 0 || match.e[NumTemplFileName] < 0) ||
               (match.s[NumTemplNumStr] < 0 || match.e[NumTemplNumStr] < 0 )  
            ) retparse = false;

         if( retparse == false ) //⠥ ⮣ ஢  室  १⮢ ࠢ
         { 
            retest->SetExpr( DefTemplate2 );
            if( retest->Parse( str, str, str + strlen(str), &match, NULL, -1 ) )
            {
               if(   match.s[0] >= 0 && match.e[0] >= 0 &&
                     match.s[4] >= 0 && match.e[4] >= 0 && match.s[5] >= 0 && match.e[5] >= 0 )  
               { 
                  retparse = true;
                  strncpy( FileName, str+match.s[4], match.e[4]-match.s[4] );
                  strncpy( Number, str+match.s[5], match.e[5]-match.s[5] );

               }
            }  
         }else {
            strncpy( FileName, str+match.s[NumTemplFileName], match.e[NumTemplFileName]-match.s[NumTemplFileName] );
            strncpy( Number, str+match.s[NumTemplNumStr], match.e[NumTemplNumStr]-match.s[NumTemplNumStr] );
         }

         if( retparse == true )
         {
            char PathFileName[1024] = "";
            char CurPath[1024]; 

            //᫨ ⥩  ,   直 砩 稬   䠩  訡
            //  饬   ॡ㥬 䠩
            if( !strrchr(FileName,':') ){ /*᫨   */
               struct EditorInfo ei;
               ExtSearchInfo.EditorControl(ECTL_GETINFO,&ei);
               char *PosEndPath;

               if( (PosEndPath = (char *)strrchr(ei.FileName,'\\')) != NULL ){

                 int Num = PosEndPath - ei.FileName;
                 lstrcpyn( CurPath, ei.FileName, Num+1 );
                 *(CurPath + Num + 1) = '\0';
                 strcpy( PathFileName, CurPath );
                 lstrcat( PathFileName, "\\" );
               }
            }

            lstrcat( PathFileName, FileName );

            HANDLE f;
            WIN32_FIND_DATA fd;
            if( (f = FindFirstFile( PathFileName, &fd )) == INVALID_HANDLE_VALUE )
            {
                ExtSearchReg *esr_f = (ExtSearchReg *)malloc( sizeof(ExtSearchReg) );
                if( esr_f ){
                   memset( esr_f, '\0', sizeof(ExtSearchReg) );
                   esr_f->OnlySearchFile = 1;
                   strcpy( esr_f->OnlySearchFileName, FileName );     
                   ProcFiles( esr_f, CurPath, 0 ); // 䠩 稭  ⥪饣 ⠫    ⠫

                   if( esr_f->OnlySearchFileTrue )
                     strcpy( PathFileName, esr_f->OnlySearchFileName );
            
                   ExitFromPlugin( esr_f, -1 ); // 直 砩 믮 騥 ⢨  室  
                   free( esr_f );
                }
            }
            else FindClose( f );

            delete retest;
            retest = NULL;

            int NumStr = atoi( Number );

            if( *FileName != '\0' && NumStr > 0 )
            {
               ExtSearchInfo.Editor(
                 PathFileName,
                 NULL,                                
                 0,
                 0,
                 -1,
                 -1,
                 0,                                     
                 NumStr,
                 1
               );
            }
         }


      if( retest ) delete retest;
   }
}

#pragma argsused
//********************************************************************
//  㤠  ப
//********************************************************************
static void DeleteEqString( ExtSearchReg *_esr ){

   struct EditorGetString egs;
   struct EditorSetPosition esp;

   struct EditorInfo ei;
   ExtSearchInfo.EditorControl(ECTL_GETINFO,&ei);

   int isEndOfFile   = 0;
   int CurStr        = 0;
   unsigned long LenStr = 32000, LenCurStr;
   unsigned long TotalLines = ei.TotalLines;

   char *Str = (char*)malloc( LenStr );

   memset( &egs, '\0', sizeof(struct EditorGetString) );
   memset( &esp, '\0', sizeof(struct EditorSetPosition) );

   egs.StringNumber = -1;
   esp.CurLine = CurStr; 
                                    
   ExtSearchInfo.EditorControl(ECTL_SETPOSITION,&esp);

   while( ExtSearchInfo.EditorControl( ECTL_GETSTRING, &egs ) == TRUE ){

      LenCurStr = egs.StringLength;
      if( LenCurStr > LenStr ){
         Str = (char*)realloc( Str, LenCurStr );
         if( Str ) LenStr = LenCurStr;
         else break;
      }

      strcpy( Str, egs.StringText );

      for( ;  TotalLines > CurStr; )
      {
         esp.CurLine = CurStr + 1;                                     
         if( ExtSearchInfo.EditorControl(ECTL_SETPOSITION,&esp) == TRUE )
         {

            egs.StringNumber = -1;
            if( ExtSearchInfo.EditorControl( ECTL_GETSTRING, &egs ) == TRUE )
            {
               if( LenCurStr != egs.StringLength )
               {
                  CurStr++;
                  break;
               }else
               {
                  if( !memcmp( egs.StringText, Str, LenCurStr ) )
                  {
                     if( ExtSearchInfo.EditorControl( ECTL_DELETESTRING, NULL ) == TRUE )
                     {
                        TotalLines--;
                        continue;
                     }
                     else{       
                        isEndOfFile = 1;
                        break;
                     }

                  }else{
                     CurStr++;
                     break;
                  }   
               }
            }
            else{ 
               isEndOfFile = 1;
               break;
            }
         }else{
            isEndOfFile = 1;
            break;
         }
      }

      if( isEndOfFile ) break;
      else{
         esp.CurLine = CurStr;          
         if( ExtSearchInfo.EditorControl(ECTL_SETPOSITION,&esp) == FALSE )
            break;
         else
            egs.StringNumber = -1;
      }

   }
   free( Str );
}


//********************************************************************
//  楤 䨣樨 
//********************************************************************
static void ExtSearchConfiguration( ExtSearchReg *_esr ){

  int  AddrWord1History       = (int)ExtWord1HistoryName;
  int  AddrWord2History       = (int)ExtWord2HistoryName;
  int  AddrGoToErrorHistory   = (int)ExtTemplateHistoryName;
  int  AddrPathRootPrjHistory = (int)ExtPathRootPrjHistoryName;

  int  AutoSearchInSelect = GetRegKey(HKEY_CURRENT_USER,"","AutoSearchInSelect" , false );
  int  DN_Position        = GetRegKey(HKEY_CURRENT_USER,"","DN_Position" , false );
  int  UpSetRegExp        = GetRegKey(HKEY_CURRENT_USER,"","UpSetRegExp" , false );
  int  BkGrSelect         = GetRegKey(HKEY_CURRENT_USER,"","BkGrSelect" , DefBkGrSelect );
  int  ClrSelect          = GetRegKey(HKEY_CURRENT_USER,"","ClrSelect" , DefClrSelect );
  int  KindSelect         = GetRegKey(HKEY_CURRENT_USER,"","KindSelect" , 0 );
  int  CheckESC           = GetRegKey(HKEY_CURRENT_USER,"","CheckESC" , false );
  int  NoSaveGlobal       = GetRegKey(HKEY_CURRENT_USER,"","NoSaveGlobal", false );
  int  NoContinueReplace  = GetRegKey(HKEY_CURRENT_USER,"","NoContinueReplace", false );  
  int  CheckEmptyReplace  = GetRegKey(HKEY_CURRENT_USER,"","CheckEmptyReplace", false );  
  int  NumTemplFileName   = GetRegKey(HKEY_CURRENT_USER,"","NumTemplFileName" , DefNumTemplFileName );
  int  NumTemplNumStr     = GetRegKey(HKEY_CURRENT_USER,"","NumTemplNumStr" , DefNumTemplNumStr );
  int  PreLoadPrj         = GetRegKey(HKEY_CURRENT_USER,"","PreLoadPrj", 0 );

  char StrBkGrSelect[LenSearchStr], StrClrSelect[LenSearchStr];
  char StrNumTemplFileName[LenSearchStr], StrNumTemplNumStr[LenSearchStr];

  itoa( BkGrSelect, StrBkGrSelect, 10  );
  itoa( ClrSelect, StrClrSelect, 10  );

  itoa( NumTemplFileName, StrNumTemplFileName, 10  );
  itoa( NumTemplNumStr, StrNumTemplNumStr, 10  );

  //砥 ப ᨬ 室  ᫮ 
  GetWordStr( _esr->SymbWord1Str, _esr->SymbWord2Str, _esr->TemplateGoToError, _esr->PathRootPrj );

  //AV 01.12.99 䮪   NCI_ButtonCansel

  //樠   㮭䨣樨 
  struct InitDialogItem InitItems[]={
     {DI_DOUBLEBOX,WidthUnderSide,1,DefCfgSizeX-WidthUnderSide-1,BottomCfgDialog-WidthUnder,0,0,0,0,(char *)MExtSearchTitle},
     {DI_CHECKBOX,WidthUnderSide+2,2,0,0,0,0,0,0,(char *)MAutoSearchInSelect},
     {DI_CHECKBOX,WidthUnderSide+2,3,0,0,0,0,0,0,(char *)MDN_Position},
     {DI_CHECKBOX,WidthUnderSide+2,4,0,0,0,0,0,0,(char *)MUpSetRegExp},
     {DI_CHECKBOX,WidthUnderSide+2,5,0,0,0,0,0,0,(char *)MCheckESC},
     {DI_CHECKBOX,WidthUnderSide+2,6,0,0,0,0,0,0,(char *)MNoSaveGlobal},
     {DI_CHECKBOX,WidthUnderSide+2,7,0,0,0,0,0,0,(char *)MNoContinueReplace},
     {DI_CHECKBOX,WidthUnderSide+2,8,0,0,0,0,0,0,(char *)MCheckEmptyReplace},
     {DI_TEXT,   WidthUnderSide,9,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,""},
     {DI_TEXT,   WidthUnderSide+2,10,0,0,0,0,DIF_BOXCOLOR,0,(char *)MTextSel},
     {DI_RADIOBUTTON, WidthUnderSide+2,11,0,0,0,0,DIF_GROUP,0,(char *)MSelStandard},         
     {DI_RADIOBUTTON, WidthUnderSide+30,11,0,0,0,0,0,0,(char *)MSelColorAPI},         
     {DI_FIXEDIT,WidthUnderSide+2,12,WidthUnderSide+2+1,0,0,0,0,0,StrBkGrSelect},
     {DI_FIXEDIT,WidthUnderSide+5,12,WidthUnderSide+5+1,0,0,0,0,0,StrClrSelect },
     {DI_TEXT,   WidthUnderSide+6+2,12,0,0,0,0,DIF_BOXCOLOR,0,(char *)MStrAttrSelect},
     {DI_TEXT,   WidthUnderSide,13,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,""},
     {DI_TEXT,WidthUnderSide+2,14,0,0,0,0,DIF_BOXCOLOR,0,(char *)MStrWord1},
     {DI_EDIT,WidthUnderSide+2,15,DefCfgSizeX-WidthUnderSide-3,0,0,AddrWord1History,DIF_HISTORY|DIF_LEFTTEXT,0, _esr->SymbWord1Str },
     {DI_TEXT,WidthUnderSide+2,16,0,0,0,0,DIF_BOXCOLOR,0,(char *)MStrWord2},
     {DI_EDIT,WidthUnderSide+2,17,DefCfgSizeX-WidthUnderSide-3,0,0,AddrWord2History,DIF_HISTORY|DIF_LEFTTEXT,0, _esr->SymbWord2Str },
     {DI_TEXT,   WidthUnderSide,18,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,""},
     {DI_TEXT,WidthUnderSide+2,19,0,0,0,0,DIF_BOXCOLOR,0,(char *)MStrTemplateGoToError},
     {DI_TEXT,WidthUnderSide+30,19,0,0,0,0,DIF_BOXCOLOR,0,(char *)MStrNumTemplFileName},
     {DI_FIXEDIT,WidthUnderSide+36,19,WidthUnderSide+36+2,0,0,0,0,0,StrNumTemplFileName},
     {DI_TEXT,WidthUnderSide+40,19,0,0,0,0,DIF_BOXCOLOR,0,(char *)MStrNumTemplNumStr},
     {DI_FIXEDIT,WidthUnderSide+47,19,WidthUnderSide+47+2,0,0,0,0,0,StrNumTemplNumStr },
     {DI_EDIT,WidthUnderSide+2,20,DefCfgSizeX-WidthUnderSide-3,0,0,AddrGoToErrorHistory,DIF_HISTORY|DIF_LEFTTEXT,0, _esr->TemplateGoToError },
     {DI_TEXT,WidthUnderSide+2,21,0,0,0,0,DIF_BOXCOLOR,0,(char *)MStrPathRootPrjName},
     {DI_CHECKBOX,WidthUnderSide+2+40,21,0,0,0,0,0,0,(char *)MStrPreLoadPrj},
     {DI_EDIT,WidthUnderSide+2,22,DefCfgSizeX-WidthUnderSide-3,0,0,AddrPathRootPrjHistory,DIF_HISTORY|DIF_LEFTTEXT,0, _esr->PathRootPrj },
     {DI_TEXT,   WidthUnderSide,23,0,0,0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,""},
     {DI_BUTTON,0,BottomCfgDialog-WidthUnder-1,0,0,0,0,DIF_CENTERGROUP,1,(char *)MOk},
     {DI_BUTTON,0,BottomCfgDialog-WidthUnder-1,0,0,true,0,DIF_CENTERGROUP,0,(char *)MCancel}
  };

  //믮  ᪠
  struct FarDialogItem DialogItems[sizeof(InitItems)/sizeof(InitItems[0])];
  InitDialogItems(InitItems,DialogItems,sizeof(InitItems)/sizeof(InitItems[0]), -1, ConfigTypeDialog );

  DialogItems[NCI_AutoSearchInSelect].Selected = AutoSearchInSelect;
  DialogItems[NCI_DN_Position].Selected = DN_Position;
  DialogItems[NCI_UpSetRegExp].Selected = UpSetRegExp;
  DialogItems[NCI_CheckESC].Selected    = CheckESC;
  DialogItems[NCI_NoSaveGlobal].Selected  = NoSaveGlobal;
  DialogItems[NCI_NoContinueReplace].Selected  = NoContinueReplace;
  DialogItems[NCI_CheckEmptyReplace].Selected  = CheckEmptyReplace;
  DialogItems[NCI_PreLoadPrj].Selected  = PreLoadPrj;

  if( !KindSelect )
     DialogItems[NCI_SelStandard].Selected = 1;
  else
     DialogItems[NCI_SelColorAPI].Selected = 1;

  int ExitCode=ExtSearchInfo.Dialog(ExtSearchInfo.ModuleNumber,-1,-1, DefCfgSizeX, BottomCfgDialog,Help_ExtConfig,DialogItems,
                           sizeof(DialogItems)/sizeof(DialogItems[0]));

  if ( ExitCode == NCI_ButtonOk ){ // "Ok"              

     strncpy( StrBkGrSelect, DialogItems[NCI_BkGrSelect].Data, LenSearchStr );
     strncpy( StrClrSelect,  DialogItems[NCI_ClrSelect].Data,  LenSearchStr );
     BkGrSelect = atoi( StrBkGrSelect );
     ClrSelect  = atoi( StrClrSelect  );                      

     strncpy( StrNumTemplFileName, DialogItems[NCI_NumTemplFileName].Data, LenSearchStr );
     strncpy( StrNumTemplNumStr,   DialogItems[NCI_NumTemplNumStr].Data,   LenSearchStr );
     NumTemplFileName = atoi( StrNumTemplFileName );
     NumTemplNumStr   = atoi( StrNumTemplNumStr   );

     if( NumTemplFileName >= 0 && NumTemplNumStr >= 0 ){
        SetRegKey( HKEY_CURRENT_USER,"","NumTemplFileName", NumTemplFileName );
        SetRegKey( HKEY_CURRENT_USER,"","NumTemplNumStr",   NumTemplNumStr  );
     }

     if( BkGrSelect >= 0 && BkGrSelect <= 15 && ClrSelect >= 0 && ClrSelect <= 15 ){
        SetRegKey( HKEY_CURRENT_USER,"","BkGrSelect", BkGrSelect );
        SetRegKey( HKEY_CURRENT_USER,"","ClrSelect",  ClrSelect  );
     }

     strncpy( _esr->SymbWord1Str, DialogItems[NCI_SymbWord1Str].Data, LenSearchStr );
     strncpy( _esr->SymbWord2Str, DialogItems[NCI_SymbWord2Str].Data, LenSearchStr );
     strncpy( _esr->PathRootPrj, DialogItems[NCI_PathRootPrj].Data, LenSearchStr );
     strncpy( _esr->TemplateGoToError, DialogItems[NCI_TemplateGoToError].Data, LenSearchStr );

     SetWordStr( _esr->SymbWord1Str, _esr->SymbWord2Str, _esr->TemplateGoToError, _esr->PathRootPrj );

     AutoSearchInSelect = DialogItems[NCI_AutoSearchInSelect].Selected;
     SetRegKey(HKEY_CURRENT_USER,"","AutoSearchInSelect"    , AutoSearchInSelect );
     DN_Position = DialogItems[NCI_DN_Position].Selected;
     SetRegKey(HKEY_CURRENT_USER,"","DN_Position"    , DN_Position );
     UpSetRegExp = DialogItems[NCI_UpSetRegExp].Selected;
     SetRegKey(HKEY_CURRENT_USER,"","UpSetRegExp"    , UpSetRegExp );
     KindSelect = DialogItems[NCI_SelStandard].Selected ? 0 : 1;
     SetRegKey(HKEY_CURRENT_USER,"","KindSelect"    , KindSelect );
     CheckESC   = DialogItems[NCI_CheckESC].Selected;
     SetRegKey(HKEY_CURRENT_USER,"","CheckESC"     ,  CheckESC   );
     NoSaveGlobal = DialogItems[NCI_NoSaveGlobal].Selected;
     SetRegKey(HKEY_CURRENT_USER,"","NoSaveGlobal"     ,  NoSaveGlobal );
     NoContinueReplace = DialogItems[NCI_NoContinueReplace].Selected;
     SetRegKey(HKEY_CURRENT_USER,"","NoContinueReplace",  NoContinueReplace );
     CheckEmptyReplace = DialogItems[NCI_CheckEmptyReplace].Selected;
     SetRegKey(HKEY_CURRENT_USER,"","CheckEmptyReplace",  CheckEmptyReplace );
     PreLoadPrj = DialogItems[NCI_PreLoadPrj].Selected;
     SetRegKey(HKEY_CURRENT_USER,"","PreLoadPrj",  PreLoadPrj );
  }

}

//********************************************************************
//    
//********************************************************************

void WINAPI _export SetStartupInfo(const struct PluginStartupInfo *ExtSearchInfo)
{

  ::ExtSearchInfo=*ExtSearchInfo;

  if( !esr ){
     SetPathsToRegKeys( ExtSearchInfo );  

        if( (esr = (ExtSearchReg*)malloc( sizeof(ExtSearchReg) )) != NULL ){
           memset(esr, 0, sizeof(ExtSearchReg) );
           //AV 06.12.99 -   ࠡ  ॣ묨 ࠦﬨ
           esr->retest     = new CRegExp;      
           esr->retest_end = new CRegExp;      

           SetWinRusTable( esr );//AV 03.12.99 ।塞  RusWin 㦥   

        }
  }
}
#pragma argsused
HANDLE WINAPI _export OpenPlugin(int OpenFrom,int Item)
{

  ExtSearchReg *_esr; 

  try {

     if( esr && Item == 0 ){

        Item = ChoiceFromMenu( OpenFrom );//AV 09.11.99 롮 ࠭ ࠡ  

        if( Item >= 0 ){

             if( (_esr = BegInitExtSearchReg( esr, OpenFrom, Item )) == NULL )
                return(INVALID_HANDLE_VALUE);
        }
        else 
           return esr;

        switch( Item ){
      
           case MP_NUM_SEARCH_INEDIT:
              _esr->Position = 0;
              _esr->VirtualSymbols = 0;//AV 10.12.99
              RunSearch( _esr, 0 );
              break;
           case MP_NUM_SEARCH_REPLACE_INEDIT:
              _esr->Position = 0;
              _esr->VirtualSymbols = 0;//AV 10.12.99
              RunSearchAndReplace( _esr );
              break;
           case MP_NUM_CONTINUE_SEARCH_INEDIT:
              _esr->Position = 1; // 㦥 ᯮ樮஢
              ContinueSearch( _esr );
              break;

           case MP_NUM_REVERSE_SEARCH_INEDIT:
              _esr->Position = 1; // 㦥 ᯮ樮஢
              ReverseSearch( _esr );
              break;

           case MP_NUM_WORD_SEARCH_INEDIT:
              _esr->Position = 1; // 㦥 ᯮ樮஢
              _esr->NoDialog = 1;
              RunSearch( _esr, 1 );
              break;

           case MP_NUM_CLIPBOARD_SEARCH_INEDIT:
              _esr->Position = 1; // 㦥 ᯮ樮஢
              _esr->NoDialog = 1;
              RunSearch( _esr, 2 );
              break;

           case MP_NUM_REVERSE_WORD_SEARCH_INEDIT:
              _esr->Position = 1; // 㦥 ᯮ樮஢
              _esr->NoDialog = 1;
              RunSearch( _esr, 3 );
              break;

           case MP_NUM_REVERSE_CLIPBOARD_SEARCH_INEDIT:
              _esr->Position = 1; // 㦥 ᯮ樮஢
              _esr->NoDialog = 1;
              RunSearch( _esr, 4 );
              break;

           case MP_NUM_GOTO_ERROR_INEDIT: //室  訡, ᠭ  饩 ப
              GoToError();
              return(INVALID_HANDLE_VALUE);

           case MP_NUM_DEL_EQSTR_INEDIT: //㤠  ப
              DeleteEqString( _esr );
              return(INVALID_HANDLE_VALUE);

           case MP_NUM_SEARCH_INFILES: //  䠩
              _esr->Position = 1;
              _esr->VirtualSymbols = 0;
              _esr->SetDir = 0;
              RunSearchInFile( _esr );
              break;   

           case MP_NUM_REPLACE_INFILES: //  䠩
              _esr->Position = 1;
              _esr->VirtualSymbols = 0;
              _esr->SetDir = 0;
              RunReplaceInFile( _esr );
              break;

           case MP_NUM_RECODE_INFILES: //४஢  䠩
              RecodeNameFiles( _esr );
              break;

           case -1: break;//室   롮 ਠ ࠡ 
      
        }

        ExitFromPlugin( _esr, Item );
     }                      
  }

  //ࠡ⠥ exception 
 __except(1) {
   MessageBeep( 0xFFFFFFFF );
   MessageBox( NULL, "An unhandled exception occured. Program terminated.", "ExtSearch - Fatal error", MB_OK | MB_ICONSTOP );
  } 

  return(INVALID_HANDLE_VALUE);
}

void WINAPI _export ExitFAR( void )
{
   delete esr->retest;
   delete esr->retest_end;

   DelAllItemsListSel( &esr->lastsel, &esr->cursel );

   if( esr )  free(  esr );
   /*HeapDestroy( heapNEW );*/
}

void WINAPI _export GetPluginInfo(struct PluginInfo *ExtSearchInfo)
{
  ExtSearchInfo->StructSize=sizeof(*ExtSearchInfo);
  ExtSearchInfo->Flags=PF_EDITOR/* | PF_PRELOAD*/; //뢠  । + 易⥫쭠 㧪    FAR;
  ExtSearchInfo->DiskMenuStringsNumber=0;
  static const char *PluginMenuStrings[1];//AV 09.11.99 [4]
  PluginMenuStrings[0]=GetMsg(MExtSearchTitle);
  ExtSearchInfo->PluginMenuStrings=PluginMenuStrings;
  ExtSearchInfo->PluginMenuStringsNumber=sizeof(PluginMenuStrings)/sizeof(PluginMenuStrings[0]);

  static const char *PluginCfgStrings[1];
  PluginCfgStrings[0]=GetMsg(MExtSearchTitle);
  ExtSearchInfo->PluginConfigStrings=PluginCfgStrings;
  ExtSearchInfo->PluginConfigStringsNumber=sizeof(PluginCfgStrings)/sizeof(PluginCfgStrings[0]);
}

int WINAPI _export Configure(int ItemNumber)
{
  switch(ItemNumber)
  {
    case 0:{
       ExtSearchConfiguration( esr );
    }break;

  }
  return(FALSE);
}


#pragma argsused
int WINAPI _export ProcessEditorEvent( int Event,  void *Param ){

   switch( Event ){

      //case EE_READ:
         //ExtSearchInfo.EditorControl( ECTL_REDRAW, NULL );//㥬  ।
      //break;          

      case EE_REDRAW: 
         if( !esr->SelectFAR && SetConnectToColorerDLL > 0 ) RefreshSelect();//ᮢ, .. ࠡ⠥ Colorer
          
         break;
      case EE_CLOSE:{
         //㤠塞  ᯨ᪠ 
         DelFromListSel( *(int*)Param, &esr->lastsel, &esr->cursel );
         ResetSelect( 0 ); //㤠   
      }
      break;        

   }
   return 0;
}


//#define K_ENTER   13
//#define K_PGUP    33
//#define K_PGDN    34
//#define K_END     35
//#define K_HOME    36
//#define K_LEFT    37
//#define K_UP      38
//#define K_RIGHT   39 
//#define K_DOWN    40 
#define K_INSERT    45
#define K_CTRL      17

int WINAPI _export ProcessEditorInput(const INPUT_RECORD *Rec)
{
  if( esr->SetSelect )   
     if( Rec->EventType == KEY_EVENT &&       
         Rec->Event.KeyEvent.wVirtualKeyCode
       ){
         if( Rec->Event.KeyEvent.bKeyDown == true ){
            if( Rec->Event.KeyEvent.dwControlKeyState == LEFT_CTRL_PRESSED ||
                Rec->Event.KeyEvent.dwControlKeyState == RIGHT_CTRL_PRESSED
              ){
               //⮫쪮  ⮩  Ctrl  ᫨ 뤥 १ ColorAPI
               if( !esr->SelectFAR && !esr->bKeyDownAfterSelect && Rec->Event.KeyEvent.wVirtualKeyCode == K_INSERT && Sel.FindStr && *Sel.FindStr ){
                  //ExtTestMessage( Sel.FindStr );
                  char InClipBoard[LenSearchStr];//AV 23.12.99
                  strncpy( InClipBoard, Sel.FindStr, LenSearchStr-1 );
                  ConvertToOEM( esr, InClipBoard, LenSearchStr );
                  ConvertToWinRus(InClipBoard, LenSearchStr );
                  PutClipBoard(InClipBoard);      
                  return 1; // ⮣ ⮡  CtrlIns   ࠡ⠫
               }


            }
   
            //Rec->Event.KeyEvent.wVirtualKeyCode != K_CTRL  
               if( Rec->Event.KeyEvent.dwControlKeyState != LEFT_CTRL_PRESSED &&
                   Rec->Event.KeyEvent.dwControlKeyState != RIGHT_CTRL_PRESSED &&
                   Rec->Event.KeyEvent.dwControlKeyState != SHIFT_PRESSED  
                 ){// 뢠  ⨨ Ctrl  Shift
      
                  esr->bKeyDownAfterSelect = 1;//, 뫠     ᫥ ᫥ 뤥
                  if( !esr->SelectFAR && SetConnectToColorerDLL <= 0 ){ 
                     //ResetSelect(1);
                     ExtSearchInfo.EditorControl( ECTL_REDRAW, NULL );//㥬  ।
                  }
                  //⠭ ࠭ ⠭⭮ 뤥
                  SetStandardSelect( esr, 1 );                                  
               }
            }
            else
               if( esr->SetSelect && !esr->SelectFAR ) ResetSelect(1);    
         }

     if( esr->AutoSearchInSelect && Rec->EventType == KEY_EVENT && Rec->Event.KeyEvent.wVirtualKeyCode && Rec->Event.KeyEvent.bKeyDown == true )
        if( Rec->Event.KeyEvent.dwControlKeyState == LEFT_CTRL_PRESSED ||
            Rec->Event.KeyEvent.dwControlKeyState == RIGHT_CTRL_PRESSED
          )
            //ࠡ  뤥  Ctrl+U
            if( Rec->Event.KeyEvent.wVirtualKeyCode == 'U' && esr->cursel ){
               esr->cursel->ProcSaveSelectForRestore = 0;
               esr->cursel->ProcResetSelect = 0;//᭨ ਧ 
            }


  return 0;
}
             
