#ifndef __MCMPL_H__
#define __MCMPL_H__

#include "cmpl.hpp"

class TMenuCompletion: public TCompletion
{
  protected: //menu completion params
    int SingleVariantInMenu;
    int NotFoundSound;
    int SortListCount;
    char ShortCuts[80];
    int ShortCutsLen;
  protected:
    bool ShowMenu(string &Selected);
  protected: //options
    void GetOptions(void);
    void SetOptions(void);
    int GetItemCount(void);
    int DialogWidth(void);
    int DialogHeight(void);
    long DialogProc(HANDLE hDlg,int Msg,int Param1,long Param2);
    void InitItems(FarDialogItem *DialogItems);
    void StoreItems(FarDialogItem *DialogItems);
  public:
    TMenuCompletion(const char *RegRoot);
    ~TMenuCompletion();
    bool CompleteWord(void);
};

#define MCMPL_FIRST_TEXT (CMPL_DIALOG_ITEMS+3)
#define MCMPL_DIALOG_ITEMS (IAsteriskSymbol+1)

enum
{
  ISingleVariantInMenu=CMPL_DIALOG_ITEMS,       // SingleVariantInMenu
  INotFoundSound,                               // NotFoundSound
  ISortListCount=MCMPL_FIRST_TEXT,              // SortListCount
  IAsteriskSymbol=MCMPL_FIRST_TEXT+2,           // AsteriskSymbol
};

#endif
