#include "../plugin.hpp"
#include "mcmpl.hpp"
#include "EditCmpl.hpp"
#include "language.hpp"

TMenuCompletion::TMenuCompletion(const char *RegRoot): TCompletion(RegRoot)
{
  SingleVariantInMenu=FALSE;
  NotFoundSound=TRUE;
  SortListCount=10;
  strcpy(ShortCuts,"0123456789abcdefghijklmnopqrstuvwxyz");
  ShortCutsLen=strlen(ShortCuts);
  strcpy(ConfigHelpTopic,"Config");
  GetOptions();
}

TMenuCompletion::~TMenuCompletion()
{
}

bool TMenuCompletion::CompleteWord(void)
{
  bool result=false;
  if(GetPreWord()&&WordsToFindCnt)
  {
    if(DoSearch())
    {
      bool Insert=true;
      string NewWord=WordList.get_top()->get_data()->get_data();
      if(PartialCompletion&&(WordList.get_partial().length()>Word.length()))
      {
        NewWord=WordList.get_partial();
      }
      else if(SingleVariantInMenu||WordList.count()>1)
      {
        Insert=ShowMenu(NewWord);
      }
      if(Insert)
      {
        PutWord(NewWord);
        SetCurPos(WordPos+NewWord.length());
        result=true;
      }
    }
    else if(NotFoundSound) MessageBeep(MB_ICONASTERISK);
  }
  Cleanup();
  return result;
}

struct MenuAdaptor
{
  int ref;
  const string *data;
};

static void ForEach(void *data,int &pos,avl_word_data &node)
{
  MenuAdaptor *menudata=(MenuAdaptor *)data;
  menudata[pos].ref=node.get_ref();
  menudata[pos].data=&node.get_data();
  pos++;
}

int __cdecl fcmp(const void *first,const void *second)
{
  return (((const MenuAdaptor *)second)->ref)-(((const MenuAdaptor *)first)->ref);
}

#define ADD_MENU_X 10
#define ADD_MENU_Y 4
bool TMenuCompletion::ShowMenu(string &Selected)
{
  int result=false;
  MenuAdaptor *menudata=(MenuAdaptor *)HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,WordList.count()*sizeof(MenuAdaptor));
  if(menudata)
  {
    int pos=0;
    WordList.iterate((void *)menudata,pos,ForEach);
    if(WordList.count()<=SortListCount) FSF.qsort(menudata,WordList.count(),sizeof(*menudata),fcmp);
    FarMenuItem *Menu=(FarMenuItem *)HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,WordList.count()*sizeof(FarMenuItem));
    if(Menu)
    {
      char BottomMsg[MENU_WIDTH];
      FSF.sprintf(BottomMsg,GetMsg(MHave),WordList.count());

      EditorInfo ei;
      Info.EditorControl(ECTL_GETINFO,&ei);

      size_t MenuWidth=MAX(WordList.get_max_len(),strlen(GetMsg(MChooseWord))+1);
      MenuWidth=MAX(MenuWidth,strlen(BottomMsg)+1);
      MenuWidth=MIN(MenuWidth,MENU_WIDTH);
      int CoorX=ei.CurPos-ei.LeftPos;
      int CoorY=ei.CurLine-ei.TopScreenLine;
      int MenuX=MAX(0,CoorX+1-((signed)(Word.length()))-(signed)MenuWidth-ADD_MENU_X);
      MenuX=(ei.WindowSizeX-CoorX)>(CoorX+2-((signed)(Word.length())))?CoorX+3:MenuX;
      int MenuY=(ei.WindowSizeY-CoorY-1)>CoorY+1?((ei.WindowSizeY-CoorY-1)>(WordList.count()+ADD_MENU_Y)?CoorY+3:(ei.WindowSizeY+3-WordList.count()-ADD_MENU_Y)):(CoorY+2-WordList.count()-ADD_MENU_Y);
      MenuY=MAX(MenuY,2);
      for(int i=0;i<WordList.count();i++)
      {
        FSF.sprintf(Menu[i].Text,"&%c %.120s",(i<ShortCutsLen)?ShortCuts[i]:' ',(const char *)(const unsigned char *)*menudata[i].data);
      }
      int MenuCode=Info.Menu(Info.ModuleNumber,MenuX,MenuY,0,FMENU_WRAPMODE,GetMsg(MChooseWord),BottomMsg,"List",NULL,NULL,Menu,WordList.count());
      if(MenuCode>-1)
      {
        result=true;
        Selected=*menudata[MenuCode].data;
      }
      HeapFree(GetProcessHeap(),0,Menu);
    }
    HeapFree(GetProcessHeap(),0,menudata);
  }
  return result;
}

void TMenuCompletion::GetOptions(void)
{
  TCompletion::GetOptions();
  SingleVariantInMenu=GetRegKey("SingleVariantInMenu",SingleVariantInMenu);
  NotFoundSound=GetRegKey("NotFoundSound",NotFoundSound);
  SortListCount=GetRegKey("SortListCount",SortListCount);
  AsteriskSymbol=GetRegKey("AsteriskSymbol",AsteriskSymbol);
  GetRegKey("ShortCuts",ShortCuts,sizeof(ShortCuts));
}

void TMenuCompletion::SetOptions(void)
{
  TCompletion::SetOptions();
  SetRegKey("SingleVariantInMenu",SingleVariantInMenu);
  SetRegKey("NotFoundSound",NotFoundSound);
  SetRegKey("SortListCount",SortListCount);
  SetRegKey("AsteriskSymbol",AsteriskSymbol);
  SetRegKey("ShortCuts",ShortCuts);
}

int TMenuCompletion::GetItemCount(void)
{
  return MCMPL_DIALOG_ITEMS;
}

int TMenuCompletion::DialogWidth(void)
{
  return 42;
}

int TMenuCompletion::DialogHeight(void)
{
  return 21;
}

long TMenuCompletion::DialogProc(HANDLE hDlg,int Msg,int Param1,long Param2)
{
  return Info.DefDlgProc(hDlg,Msg,Param1,Param2);
}

void TMenuCompletion::InitItems(FarDialogItem *DialogItems)
{
  TCompletion::InitItems(DialogItems);
  int Msgs[]=
  {
    MSingleVariantInMenu,
    MNotFoundSound,
    MSortListCount,MSortListCount,
    MAsteriskSymbol,MAsteriskSymbol,
  };
  int DialogElements[][4]=
  {
    {DI_CHECKBOX,  3, 14,  0  }, // SingleVariantInMenu
    {DI_CHECKBOX,  3, 15,  0  }, // NotFoundSound
    {DI_TEXT,      6, 16,  0  }, //
    {DI_FIXEDIT,   3, 16,  4  }, // SortListCount
    {DI_TEXT,      6, 17,  0  }, //
    {DI_FIXEDIT,   3, 17,  3  }, // AsteriskSymbol
  };

  for(unsigned int i=0;i<(sizeof(Msgs)/sizeof(Msgs[0]));i++)
  {
    DialogItems[i+CMPL_DIALOG_ITEMS].Type=DialogElements[i][0];
    DialogItems[i+CMPL_DIALOG_ITEMS].X1=DialogElements[i][1];
    DialogItems[i+CMPL_DIALOG_ITEMS].Y1=DialogElements[i][2];
    DialogItems[i+CMPL_DIALOG_ITEMS].X2=DialogElements[i][3];
    DialogItems[i+CMPL_DIALOG_ITEMS].Y2=DialogElements[i][4];
    DialogItems[i+CMPL_DIALOG_ITEMS].Focus=0;
    DialogItems[i+CMPL_DIALOG_ITEMS].Selected=0;
    DialogItems[i+CMPL_DIALOG_ITEMS].Flags=0;
    DialogItems[i+CMPL_DIALOG_ITEMS].DefaultButton=0;
    strcpy(DialogItems[i+CMPL_DIALOG_ITEMS].Data,GetMsg(Msgs[i])); //   - 
  }

  DialogItems[ISingleVariantInMenu].Selected=SingleVariantInMenu;
  DialogItems[INotFoundSound].Selected=NotFoundSound;

  //  㤥  ப 
  FSF.itoa(SortListCount,DialogItems[ISortListCount].Data,10);
  DialogItems[IAsteriskSymbol].Data[0]=AsteriskSymbol;
  DialogItems[IAsteriskSymbol].Data[1]=0;

  strcpy(DialogItems[ICfg].Data,GetMsg(MMenuCfg)); // 
}

void TMenuCompletion::StoreItems(FarDialogItem *DialogItems)
{
  TCompletion::StoreItems(DialogItems);
  SingleVariantInMenu=DialogItems[ISingleVariantInMenu].Selected;
  NotFoundSound=DialogItems[INotFoundSound].Selected;
  AsteriskSymbol=DialogItems[IAsteriskSymbol].Data[0];
  SortListCount=FSF.atoi(DialogItems[ISortListCount].Data);
}
