#include "../plugin.hpp"
#include "EditCmpl.hpp"
#include "MatPat.h"
#include "cmpl.hpp"
#include "string.hpp"
#include "language.hpp"

TCompletion::TCompletion(const char *RegRoot)
{
  Stop=FALSE;

  WorkInsideWord=true;
  BrowseDownward=true;
  CaseSensitive=false;
  ConsiderDigitAsChar=true;
  PartialCompletion=false;
  AddTrailingSpace=false;

  MinPreWordLen=1;
  MinWordLen=2;
  BrowseLineCnt=1000;
  WordsToFindCnt=20;

  AdditionalLetters[0]='_';
  AdditionalLetters[1]=0;

  AsteriskSymbol=0;

  strcpy(RegKey,RegRoot);
  strcat(RegKey,"\\EditCompletion");

  ConfigHelpTopic[0]=0;
}

TCompletion::~TCompletion()
{

}

void TCompletion::Cleanup(void)
{
  WordList.clear();
  Word.clear();
}

int TCompletion::GetPreWord(void)
{
  EditorInfo ei;
  EditorGetString gs;
  EditorConvertText ct;

  Info.EditorControl(ECTL_GETINFO,&ei);
  if(ei.CurState&ECSTATE_LOCKED) return 0;
  avl_window_data *Window=windows->query(ei.EditorID);
  if(!Window) return 0;

  Window->row=ei.CurLine;
  Window->col=ei.CurPos;

  Word.clear();

  gs.StringNumber=-1; // current string
  Info.EditorControl(ECTL_GETSTRING,&gs);
  //  砫    ப ᪠ 祣!!!
  if(ei.CurPos>0&&ei.CurPos<=gs.StringLength)
  {
    string Line((const unsigned char *)gs.StringText,gs.StringLength);
    ct.TextLength=Line.length();
    ct.Text=(char *)Line.get();
    Info.EditorControl(ECTL_EDITORTOOEM,&ct);
    WordPos=ei.CurPos;

    // ᫨ WorkInsideWord==FALSE,   ஬    㪢
    if(!IsAlpha(Line[WordPos])||WorkInsideWord)
    {
      // 饬 砫 ᫮
      while((WordPos&&IsAlpha(Line[WordPos-1]))||(WordPos&&AsteriskSymbol&&Line[WordPos-1]==AsteriskSymbol)) WordPos--;
      if(WordPos<ei.CurPos)
      {
        //࠭  뫠 ஢ઠ  㪢  砫 ᫮    ॢ襭  ᫮  ப
        Word(Line+WordPos,ei.CurPos-WordPos);
      }
    }
  }
  if(Word.length()<(size_t)MinPreWordLen) Word.clear();
  return Word.length();
}

int TCompletion::DoSearch(void)
{
  if(!Word.length()) return 0;
  EditorGetString gs;
  EditorInfo ei;
  EditorSetPosition sp;
  EditorConvertText ct;

  int Line2Browse[2]; // 쪮 ப 㤥 ᬠਢ ।  

  WordList.clear();
  Info.EditorControl(ECTL_GETINFO,&ei); //SEELATER use stored data for currsor position and check eid
  gs.StringNumber=-1; // current string
  Info.EditorControl(ECTL_GETSTRING,&gs);

  string Line((const unsigned char *)gs.StringText,gs.StringLength);
  if(Line.length()==(size_t)gs.StringLength)
  {
    ct.TextLength=Line.length();
    ct.Text=(char *)Line.get();
    Info.EditorControl(ECTL_EDITORTOOEM,&ct);
    // ᬠਢ 砫 ⥪饩 ப
    AddWords(Line,ei.CurPos,0);
    //  ⥯ -  ( Word)
    if(BrowseDownward) AddWords(Line.get()+ei.CurPos,gs.StringLength-ei.CurPos,1);
  }
  Line2Browse[0]=MIN(ei.CurLine,BrowseLineCnt); // ᢥ
  Line2Browse[1]=MIN(ei.TotalLines-ei.CurLine-1,BrowseLineCnt); // ᭨
  int LinesCount=MAX(Line2Browse[0], Line2Browse[1]); //  ᪠ ᭮ 横
  gs.StringNumber=-1; // ⥪. ப
  sp.CurPos=-1;
  sp.CurTabPos=-1;
  sp.TopScreenLine=-1;
  sp.LeftPos=-1;
  sp.Overtype=-1;
  for(int i=1;(i<=LinesCount)&&(WordList.count()<WordsToFindCnt);i++)
  {
    for(int j=0;j<1+BrowseDownward;j++)
    {
      if(Line2Browse[j]<i) continue;
      sp.CurLine=ei.CurLine+(j?i:-i); //塞 ⥪. ப
      Info.EditorControl(ECTL_SETPOSITION,&sp);
      Info.EditorControl(ECTL_GETSTRING,&gs);
      Line((const unsigned char *)gs.StringText,gs.StringLength);
      ct.TextLength=Line.length();
      ct.Text=(char *)Line.get();
      Info.EditorControl(ECTL_EDITORTOOEM,&ct);
      AddWords(Line,Line.length(),j);
      if(WordList.count()>=WordsToFindCnt) break;
    }
    if(Stop) break;
  }
  sp.CurLine=ei.CurLine;
  sp.CurPos=ei.CurPos;
  sp.TopScreenLine=ei.TopScreenLine;
  sp.LeftPos=ei.LeftPos;
  Info.EditorControl(ECTL_SETPOSITION,&sp);
  return WordList.count();
}

void TCompletion::AddWords(const unsigned char *Line,int Len,int Direction)
{
  bool IsInsideWord=false;
  unsigned char CurChar;
  string TmpWord;
  TmpWord.hash(Word.length());
  for(int i=0;i<Len;i++)
  {
    CurChar=Line[(Direction>0)?i:(Len-i-1)];
    if(IsInsideWord)
    {
      if(!IsAlpha(CurChar))
      {
        IsInsideWord=false;
        if(TmpWord.length())
        {
          if(Direction<=0) TmpWord.reverse();
          AddWord(TmpWord);
          TmpWord.clear();
        }
      }
      else
      {
        TmpWord+=CurChar;
      }
    }
    else if(IsAlpha(CurChar))
    {
      IsInsideWord=true;
      TmpWord+=CurChar;
    }
  }
  if(TmpWord.length())
  {
    if(Direction<=0) TmpWord.reverse();
    AddWord(TmpWord);
  }
}

//  ⭮ ஢ઠ  ᮢ
// ந 
void TCompletion::AddWord(const string &NewWord)
{
  if(NewWord.length()&&(int)WordList.count()<WordsToFindCnt&&NewWord.length()>Word.length()&&(int)NewWord.length()>=MinWordLen)
  {
    if(AsteriskSymbol&&strchr((const char *)(const unsigned char *)Word,(int)AsteriskSymbol))
    {
      string TmpWord(Word),TmpNewWord(NewWord);
      if(!CaseSensitive)
      {
        FSF.LUpperBuf((char *)TmpWord.get(),TmpWord.length());
        FSF.LUpperBuf((char *)TmpNewWord.get(),TmpNewWord.length());
      }
      if(MatchPattern(TmpNewWord.get(),TmpWord.get(),AsteriskSymbol)) InsertWordIntoList(NewWord);
    }
    else
    {
      if(CaseSensitive)
      {
        if(!strncmp((const char *)(const unsigned char *)NewWord,(const char *)(const unsigned char *)Word,Word.length())) InsertWordIntoList(NewWord);
      }
      else
      {
        if(!FSF.LStrnicmp((const char *)(const unsigned char *)NewWord,(const char *)(const unsigned char *)Word,Word.length())) InsertWordIntoList(NewWord);
      }
    }
  }
}

void TCompletion::InsertWordIntoList(const string &NewWord)
{
  avl_word_data *Add=new avl_word_data(NewWord);
  Add=WordList.insert(Add);
  if(Add) Add->inc_ref();
}

bool TCompletion::IsAlpha(unsigned int c)
{
  bool ret=false;
  if(c)
  {
    if(ConsiderDigitAsChar)
      ret=FSF.LIsAlphanum(c);
    else
      ret=FSF.LIsAlpha(c);
    if(!ret)
      if(strchr(AdditionalLetters,c))
        ret=true;
  }
  return ret;
}

avl_window_data *TCompletion::GetLocalData(void)
{
  EditorInfo ei;
  Info.EditorControl(ECTL_GETINFO,&ei);
  return windows->query(ei.EditorID);
}

string TCompletion::PutWord(string NewWord)
{
  //SEELATER check editor before insert
  EditorInfo ei; EditorGetString gs; int OldPos;
  string OverwritedText;
  Info.EditorControl(ECTL_GETINFO,&ei);
  OldPos=ei.CurPos;
  if(AddTrailingSpace) NewWord+=' ';
  SetCurPos(WordPos);

  if(!ei.Overtype)
  {
    for(int i=WordPos;i<ei.CurPos;i++) Info.EditorControl(ECTL_DELETECHAR,NULL);
    //workaround
    Info.EditorControl(ECTL_GETINFO,&ei);
    if(ei.BlockType==BTYPE_STREAM&&ei.BlockStartLine==ei.CurLine)
    {
      gs.StringNumber=-1;
      Info.EditorControl(ECTL_GETSTRING,&gs);
      if(gs.SelStart==-1)
      {
        EditorSelect es={BTYPE_NONE,0,0,0,0};
        Info.EditorControl(ECTL_SELECT,&es);
      }
    }
  }
  else
  {
    gs.StringNumber=-1;
    Info.EditorControl(ECTL_GETSTRING,&gs);
    if(gs.StringLength>ei.CurPos) OverwritedText((const unsigned char *)&gs.StringText[ei.CurPos],MIN(NewWord.length()-ei.CurPos+WordPos,(size_t)(gs.StringLength-ei.CurPos)));
  }

  Info.EditorControl(ECTL_INSERTTEXT,(void *)NewWord.get());
  SetCurPos(OldPos);
  return OverwritedText;
}

void TCompletion::SetCurPos(int NewPos,int NewRow)
{
  struct EditorSetPosition sp;
  sp.CurLine=NewRow;
  sp.CurPos=NewPos;
  sp.CurTabPos=-1;
  sp.TopScreenLine=-1;
  sp.LeftPos=-1;
  sp.Overtype=-1;
  Info.EditorControl(ECTL_SETPOSITION,&sp);
}

DWORD TCompletion::GetRegKey(const char *ValueName,DWORD Default)
{
  DWORD result=Default;
  HKEY hKey; DWORD Type; DWORD DataSize=0;
  if((RegOpenKeyEx(HKEY_CURRENT_USER,RegKey,0,KEY_QUERY_VALUE,&hKey))==ERROR_SUCCESS)
  {
    DataSize=sizeof(result);
    RegQueryValueEx(hKey,ValueName,0,&Type,(LPBYTE)&result,&DataSize);
    RegCloseKey(hKey);
  }
  return result;
}

void TCompletion::SetRegKey(const char *ValueName,DWORD Value)
{
  HKEY hKey;
  DWORD Disposition;
  if((RegCreateKeyEx(HKEY_CURRENT_USER,RegKey,0,NULL,0,KEY_WRITE,NULL,&hKey,&Disposition))==ERROR_SUCCESS)
  {
    RegSetValueEx(hKey,ValueName,0,REG_DWORD,(LPBYTE)&Value,sizeof(Value));
    RegCloseKey(hKey);
  }
}

void TCompletion::GetRegKey(const char *ValueName,char *buffer,DWORD size)
{
  HKEY hKey; DWORD Type;
  if((RegOpenKeyEx(HKEY_CURRENT_USER,RegKey,0,KEY_QUERY_VALUE,&hKey))==ERROR_SUCCESS)
  {
    RegQueryValueEx(hKey,ValueName,0,&Type,(LPBYTE)buffer,&size);
    RegCloseKey(hKey);
  }
}

void TCompletion::SetRegKey(const char *ValueName,char *buffer)
{
  HKEY hKey;
  DWORD Disposition;
  if((RegCreateKeyEx(HKEY_CURRENT_USER,RegKey,0,NULL,0,KEY_WRITE,NULL,&hKey,&Disposition))==ERROR_SUCCESS)
  {
    RegSetValueEx(hKey,ValueName,0,REG_SZ,(LPBYTE)buffer,strlen(buffer)+1);
    RegCloseKey(hKey);
  }
}

int TCompletion::GetRegKey(const char *ValueName,const char *Default)
{
  int result=-1;
  Key Key; HKEY hKey; DWORD Type; DWORD DataSize=0;
  if((RegOpenKeyEx(HKEY_CURRENT_USER,RegKey,0,KEY_QUERY_VALUE,&hKey))==ERROR_SUCCESS)
  {
    DataSize=sizeof(Key);
    LONG res=RegQueryValueEx(hKey,ValueName,0,&Type,(LPBYTE)&Key,&DataSize);
    if(res!=ERROR_SUCCESS||(Type!=REG_DWORD&&Type!=REG_SZ))
    {
      Type=REG_SZ;
      strcpy(Key.KeyName,Default);
    }
    if(Type==REG_DWORD) result=Key.KeyCode;
    if(Type==REG_SZ) result=FSF.FarNameToKey(Key.KeyName);
    RegCloseKey(hKey);
  }
  return result;
}

void TCompletion::GetOptions(void)
{
  WorkInsideWord=GetRegKey("WorkInsideWord",WorkInsideWord);
  CaseSensitive=GetRegKey("CaseSensitive",CaseSensitive);
  BrowseDownward=GetRegKey("BrowseDownward",BrowseDownward);
  MinPreWordLen=GetRegKey("MinPreWordLen",MinPreWordLen);
  MinWordLen=GetRegKey("MinWordLen",MinWordLen);
  BrowseLineCnt=GetRegKey("BrowseLineCnt",BrowseLineCnt);
  WordsToFindCnt=GetRegKey("WordsToFindCnt",WordsToFindCnt);
  ConsiderDigitAsChar=GetRegKey("ConsiderDigitAsChar",ConsiderDigitAsChar);
  PartialCompletion=GetRegKey("PartialCompletion",PartialCompletion);
  AddTrailingSpace=GetRegKey("AddTrailingSpace",AddTrailingSpace);
  GetRegKey("AdditionalLetters",AdditionalLetters,sizeof(AdditionalLetters));
}

void TCompletion::SetOptions(void)
{
  SetRegKey("WorkInsideWord",WorkInsideWord);
  SetRegKey("CaseSensitive",CaseSensitive);
  SetRegKey("BrowseDownward",BrowseDownward);
  SetRegKey("BrowseLineCnt",BrowseLineCnt);
  SetRegKey("MinPreWordLen",MinPreWordLen);
  SetRegKey("MinWordLen",MinWordLen);
  SetRegKey("WordsToFindCnt",WordsToFindCnt);
  SetRegKey("ConsiderDigitAsChar",ConsiderDigitAsChar);
  SetRegKey("PartialCompletion",PartialCompletion);
  SetRegKey("AddTrailingSpace",AddTrailingSpace);
  SetRegKey("AdditionalLetters",AdditionalLetters);
}

void TCompletion::InitItems(FarDialogItem *DialogItems)
{
  int Msgs[]=
  {
    MOk,MOk,MCancel,MOk,
    MWorkInsideWord,
    MCaseSensitive,
    MConsiderDigitAsChar,
    MAdditionalLetters,MAdditionalLetters,
    MBrowseDownward,
    MBrowseLineCnt,MBrowseLineCnt,
    MWordsToFindCnt,MWordsToFindCnt,
    MMinWordLen,MMinWordLen,
    MPartialCompletion,
    MAddTrailingSpace,
  };
  int DialogElements[][4]=
  {
    {DI_DOUBLEBOX, 1,  0,  0               },
    {DI_BUTTON,    0,  0,  0               },
    {DI_BUTTON,    0,  0,  0               },
    {DI_BUTTON,    0,  0,  0               },
    {DI_CHECKBOX,  3,  2,  0               }, // WorkInsideWord
    {DI_CHECKBOX,  3,  3,  0               }, // CaseSensitive
    {DI_CHECKBOX,  3,  4,  0               }, // ConsiderDigitAsChar
    {DI_TEXT,      3,  5,  0               }, //
    {DI_EDIT,      3,  6,  DialogWidth()-4 },  // AdditionalLetters
    {DI_CHECKBOX,  3,  7,  0               }, // BrowseDownward
    {DI_TEXT,      8,  8,  0               }, //
    {DI_FIXEDIT,   3,  8,  6               }, // BrowseLineCnt
    {DI_TEXT,      6,  9,  0               }, //
    {DI_FIXEDIT,   3,  9,  4               }, // WordsToFindCnt
    {DI_TEXT,      6, 10,  0               }, //
    {DI_FIXEDIT,   3, 10,  4               }, // MinWordLen
    {DI_CHECKBOX,  3, 11,  0               }, // PartialCompletion
    {DI_CHECKBOX,  3, 12,  0               }, // AddTrailingSpace
  };
  for(unsigned int i=0;i<(sizeof(Msgs)/sizeof(Msgs[0]));i++)
  {
    DialogItems[i].Type=DialogElements[i][0];
    DialogItems[i].X1=DialogElements[i][1];
    DialogItems[i].Y1=DialogElements[i][2];
    DialogItems[i].X2=DialogElements[i][3];
    DialogItems[i].Y2=DialogElements[i][4];
    DialogItems[i].Focus=0;
    DialogItems[i].Selected=0;
    DialogItems[i].Flags=0;
    DialogItems[i].DefaultButton=0;
    strcpy(DialogItems[i].Data,GetMsg(Msgs[i])); //   - 
  }

  DialogItems[ICfg].X2=DialogWidth()-2;
  DialogItems[ICfg].Y2=DialogHeight()-1;

  // ࠭
  DialogItems[IWorkInsideWord].Focus=1;
  // 
  DialogItems[IOk].Flags=DIF_CENTERGROUP;
  DialogItems[IOk].DefaultButton=TRUE;
  DialogItems[ICancel].Flags=DIF_CENTERGROUP;
  DialogItems[IAdditional].Flags=DIF_HIDDEN;

  DialogItems[IOk].Y1=DialogHeight()-2;
  DialogItems[ICancel].Y1=DialogHeight()-2;

  DialogItems[IWorkInsideWord].Selected=WorkInsideWord;
  DialogItems[ICaseSensitive].Selected=CaseSensitive;
  DialogItems[IBrowseDownward].Selected=BrowseDownward;
  DialogItems[IConsiderDigitAsChar].Selected=ConsiderDigitAsChar;
  DialogItems[IPartialCompletion].Selected=PartialCompletion;
  DialogItems[IAddTrailingSpace].Selected=AddTrailingSpace;

  //  㤥  ப 
  FSF.itoa(BrowseLineCnt,DialogItems[IBrowseLineCnt].Data,10);
  FSF.itoa(WordsToFindCnt,DialogItems[IWordsToFindCnt].Data,10);
  FSF.itoa(MinWordLen,DialogItems[IMinWordLen].Data,10);
  FSF.sprintf(DialogItems[IAdditionalLetters].Data,"%s",AdditionalLetters);
}

void TCompletion::StoreItems(FarDialogItem *DialogItems)
{
  WorkInsideWord=DialogItems[IWorkInsideWord].Selected;
  CaseSensitive=DialogItems[ICaseSensitive].Selected;
  BrowseDownward=DialogItems[IBrowseDownward].Selected;
  ConsiderDigitAsChar=DialogItems[IConsiderDigitAsChar].Selected;
  PartialCompletion=DialogItems[IPartialCompletion].Selected;
  AddTrailingSpace=DialogItems[IAddTrailingSpace].Selected;
  BrowseLineCnt=FSF.atoi(DialogItems[IBrowseLineCnt].Data);
  WordsToFindCnt=FSF.atoi(DialogItems[IWordsToFindCnt].Data);
  MinWordLen=FSF.atoi(DialogItems[IMinWordLen].Data);
  FSF.sprintf(AdditionalLetters,"%s",DialogItems[IAdditionalLetters].Data);
}

long WINAPI ConfigDialogProc(HANDLE hDlg,int Msg,int Param1,long Param2)
{
  TCompletion *sender;
  if(Msg==DN_INITDIALOG)
  {
    Info.SendDlgMessage(hDlg,DM_SETDLGDATA,0,Param2);
    sender=(TCompletion *)Param2;
    Info.SendDlgMessage(hDlg,DM_SETTEXTLENGTH,IAdditionalLetters,sizeof(sender->AdditionalLetters)-1);
  }
  else sender=(TCompletion *)Info.SendDlgMessage(hDlg,DM_GETDLGDATA,0,0);
  return sender->DialogProc(hDlg,Msg,Param1,Param2);
}

void TCompletion::ShowDialog()
{
  FarDialogItem *DialogItems=(FarDialogItem *)HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,GetItemCount()*sizeof(FarDialogItem));
  if(DialogItems)
  {
    InitItems(DialogItems);
    if(Info.DialogEx(Info.ModuleNumber,-1,-1,DialogWidth(),DialogHeight(),ConfigHelpTopic,DialogItems,GetItemCount(),0,0,ConfigDialogProc,(DWORD)this)==IOk)
    {
      StoreItems(DialogItems);
      SetOptions();
    }
    HeapFree(GetProcessHeap(),0,DialogItems);
  }
}
