#ifndef __AVL_WINDOWS_HPP__
#define __AVL_WINDOWS_HPP__

#include "avl.hpp"
#include "string.hpp"

class avl_window_data
{
  private:
    int eid; //editor
  public:
    int row; //cursor pos
    int col;
    bool Active; //autotext added
    size_t AddedLen; //autotext len
    bool On; //Autocomplete at next redraw
    string Rewrited;
    string Inserted;
    avl_window_data(int value);
    void clear(void);
  friend class avl_window_tree;
};

class avl_window_tree: public avl_tree<avl_window_data>
{
  public:
    avl_window_tree();
    ~avl_window_tree();
    long compare(avl_node<avl_window_data> *first,avl_window_data *second);
    avl_window_data *query(int value);
};

#endif
