#ifndef __ACMPL_H__
#define __ACMPL_H__

#include "cmpl.hpp"
#include "string.hpp"

class TAutoCompletion: public TCompletion
{
  private:
    bool CheckText(int Pos,int Row,avl_window_data *Window);
    int Dialog_Color;
  protected:
    bool AcceptFromMenu;
    int AcceptKey;
    int DeleteKey;
    int Color;
    char AcceptChars[256];
  protected:
    void DeleteVariant(avl_window_data *Window);
    bool AcceptVariant(avl_window_data *Window);
    bool PutVariant(avl_window_data *Window);
    void Colorize(int NewColor,avl_window_data *Window);
  protected: //options
    void GetOptions(void);
    void SetOptions(void);
    int GetItemCount(void);
    int DialogWidth(void);
    int DialogHeight(void);
    long DialogProc(HANDLE hDlg,int Msg,int Param1,long Param2);
    void InitItems(FarDialogItem *DialogItems);
    void StoreItems(FarDialogItem *DialogItems);
  public:
    TAutoCompletion(const char *RegRoot);
    ~TAutoCompletion();
    int ProcessEditorInput(const INPUT_RECORD *Rec);
    int ProcessEditorEvent(int Event,void *Param);
    bool CompleteWord(void);
  friend DWORD WINAPI SearchThread(LPVOID lpvThreadParm);
};

#define ACMPL_DIALOG_ITEMS (IDeleteKeyCfg+1)

enum
{
  IAcceptFromMenu=CMPL_DIALOG_ITEMS,
  IMinPreWordLenLabel,
  IMinPreWordLen,
  IAcceptCharsLabel,
  IAcceptChars,
  IAcceptKeyLabel,
  IAcceptKey,
  IAcceptKeyCfg,
  IDeleteKeyLabel,
  IDeleteKey,
  IDeleteKeyCfg,
};

extern bool SelectColor(int *fg,int *bg);

#endif
