#include "MatPat.h"
#include <string.h>

bool MatchPattern(unsigned char *raw,unsigned char *pat,unsigned char asterisk)
{
  int i,slraw;
  if((*pat=='\0')&&(*raw=='\0'))                            /*  if it is end of both   */
    return true;                                            /*  strings,then match     */
  if(*pat=='\0')                                            /*  if it is end of only   */
    return false;                                           /*  pat then mismatch      */
  if(*pat==asterisk)                                        /* if pattern is a '*'     */
  {
    if(*(pat+1)=='\0')                                      /*    if it is end of pat  */
      return true;                                          /*    then match           */
    for(i=0,slraw=strlen((char *)raw);i<=slraw;i++)         /*    else hunt for match  */
      if((*(raw+i)==*(pat+1))||(*(pat+1)=='?'))             /*         or wild card    */
        if(MatchPattern(raw+i+1,pat+2,asterisk)==true)      /*      if found,match     */
          return true;                                      /*        rest of pat      */
  }
  else
  {
    if(*raw=='\0')                                          /*  if end of raw then     */
      return false;                                         /*     mismatch            */
    if((*pat=='?')||(*pat==*raw))                           /*  if chars match then    */
      if(MatchPattern(raw+1,pat+1,asterisk)==1)             /*  try & match rest of it */
        return true;
  }
  return false;                                             /*  no match found         */
}
